// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllLogTargetFrontendOKCode is the HTTP code returned for type GetAllLogTargetFrontendOK
const GetAllLogTargetFrontendOKCode int = 200

/*
GetAllLogTargetFrontendOK Successful operation

swagger:response getAllLogTargetFrontendOK
*/
type GetAllLogTargetFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewGetAllLogTargetFrontendOK creates GetAllLogTargetFrontendOK with default headers values
func NewGetAllLogTargetFrontendOK() *GetAllLogTargetFrontendOK {

	return &GetAllLogTargetFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all log target frontend o k response
func (o *GetAllLogTargetFrontendOK) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target frontend o k response
func (o *GetAllLogTargetFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target frontend o k response
func (o *GetAllLogTargetFrontendOK) WithPayload(payload models.LogTargets) *GetAllLogTargetFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target frontend o k response
func (o *GetAllLogTargetFrontendOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllLogTargetFrontendDefault General Error

swagger:response getAllLogTargetFrontendDefault
*/
type GetAllLogTargetFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllLogTargetFrontendDefault creates GetAllLogTargetFrontendDefault with default headers values
func NewGetAllLogTargetFrontendDefault(code int) *GetAllLogTargetFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllLogTargetFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all log target frontend default response
func (o *GetAllLogTargetFrontendDefault) WithStatusCode(code int) *GetAllLogTargetFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all log target frontend default response
func (o *GetAllLogTargetFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all log target frontend default response
func (o *GetAllLogTargetFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target frontend default response
func (o *GetAllLogTargetFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target frontend default response
func (o *GetAllLogTargetFrontendDefault) WithPayload(payload *models.Error) *GetAllLogTargetFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target frontend default response
func (o *GetAllLogTargetFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
