// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllLogTargetFrontendOKCode is the HTTP code returned for type ReplaceAllLogTargetFrontendOK
const ReplaceAllLogTargetFrontendOKCode int = 200

/*
ReplaceAllLogTargetFrontendOK All Log Target lines replaced

swagger:response replaceAllLogTargetFrontendOK
*/
type ReplaceAllLogTargetFrontendOK struct {

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetFrontendOK creates ReplaceAllLogTargetFrontendOK with default headers values
func NewReplaceAllLogTargetFrontendOK() *ReplaceAllLogTargetFrontendOK {

	return &ReplaceAllLogTargetFrontendOK{}
}

// WithPayload adds the payload to the replace all log target frontend o k response
func (o *ReplaceAllLogTargetFrontendOK) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target frontend o k response
func (o *ReplaceAllLogTargetFrontendOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetFrontendAcceptedCode is the HTTP code returned for type ReplaceAllLogTargetFrontendAccepted
const ReplaceAllLogTargetFrontendAcceptedCode int = 202

/*
ReplaceAllLogTargetFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceAllLogTargetFrontendAccepted
*/
type ReplaceAllLogTargetFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetFrontendAccepted creates ReplaceAllLogTargetFrontendAccepted with default headers values
func NewReplaceAllLogTargetFrontendAccepted() *ReplaceAllLogTargetFrontendAccepted {

	return &ReplaceAllLogTargetFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace all log target frontend accepted response
func (o *ReplaceAllLogTargetFrontendAccepted) WithReloadID(reloadID string) *ReplaceAllLogTargetFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all log target frontend accepted response
func (o *ReplaceAllLogTargetFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all log target frontend accepted response
func (o *ReplaceAllLogTargetFrontendAccepted) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target frontend accepted response
func (o *ReplaceAllLogTargetFrontendAccepted) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetFrontendBadRequestCode is the HTTP code returned for type ReplaceAllLogTargetFrontendBadRequest
const ReplaceAllLogTargetFrontendBadRequestCode int = 400

/*
ReplaceAllLogTargetFrontendBadRequest Bad request

swagger:response replaceAllLogTargetFrontendBadRequest
*/
type ReplaceAllLogTargetFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetFrontendBadRequest creates ReplaceAllLogTargetFrontendBadRequest with default headers values
func NewReplaceAllLogTargetFrontendBadRequest() *ReplaceAllLogTargetFrontendBadRequest {

	return &ReplaceAllLogTargetFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target frontend bad request response
func (o *ReplaceAllLogTargetFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target frontend bad request response
func (o *ReplaceAllLogTargetFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target frontend bad request response
func (o *ReplaceAllLogTargetFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceAllLogTargetFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target frontend bad request response
func (o *ReplaceAllLogTargetFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllLogTargetFrontendDefault General Error

swagger:response replaceAllLogTargetFrontendDefault
*/
type ReplaceAllLogTargetFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetFrontendDefault creates ReplaceAllLogTargetFrontendDefault with default headers values
func NewReplaceAllLogTargetFrontendDefault(code int) *ReplaceAllLogTargetFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllLogTargetFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all log target frontend default response
func (o *ReplaceAllLogTargetFrontendDefault) WithStatusCode(code int) *ReplaceAllLogTargetFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all log target frontend default response
func (o *ReplaceAllLogTargetFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target frontend default response
func (o *ReplaceAllLogTargetFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target frontend default response
func (o *ReplaceAllLogTargetFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target frontend default response
func (o *ReplaceAllLogTargetFrontendDefault) WithPayload(payload *models.Error) *ReplaceAllLogTargetFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target frontend default response
func (o *ReplaceAllLogTargetFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
