// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package peer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetPeerSectionsOKCode is the HTTP code returned for type GetPeerSectionsOK
const GetPeerSectionsOKCode int = 200

/*
GetPeerSectionsOK Successful operation

swagger:response getPeerSectionsOK
*/
type GetPeerSectionsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.PeerSections `json:"body,omitempty"`
}

// NewGetPeerSectionsOK creates GetPeerSectionsOK with default headers values
func NewGetPeerSectionsOK() *GetPeerSectionsOK {

	return &GetPeerSectionsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get peer sections o k response
func (o *GetPeerSectionsOK) WithConfigurationVersion(configurationVersion string) *GetPeerSectionsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get peer sections o k response
func (o *GetPeerSectionsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get peer sections o k response
func (o *GetPeerSectionsOK) WithPayload(payload models.PeerSections) *GetPeerSectionsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get peer sections o k response
func (o *GetPeerSectionsOK) SetPayload(payload models.PeerSections) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetPeerSectionsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.PeerSections{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetPeerSectionsDefault General Error

swagger:response getPeerSectionsDefault
*/
type GetPeerSectionsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetPeerSectionsDefault creates GetPeerSectionsDefault with default headers values
func NewGetPeerSectionsDefault(code int) *GetPeerSectionsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetPeerSectionsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get peer sections default response
func (o *GetPeerSectionsDefault) WithStatusCode(code int) *GetPeerSectionsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get peer sections default response
func (o *GetPeerSectionsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get peer sections default response
func (o *GetPeerSectionsDefault) WithConfigurationVersion(configurationVersion string) *GetPeerSectionsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get peer sections default response
func (o *GetPeerSectionsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get peer sections default response
func (o *GetPeerSectionsDefault) WithPayload(payload *models.Error) *GetPeerSectionsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get peer sections default response
func (o *GetPeerSectionsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetPeerSectionsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
