// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteRuntimeServerNoContentCode is the HTTP code returned for type DeleteRuntimeServerNoContent
const DeleteRuntimeServerNoContentCode int = 204

/*
DeleteRuntimeServerNoContent Server deleted

swagger:response deleteRuntimeServerNoContent
*/
type DeleteRuntimeServerNoContent struct {
}

// NewDeleteRuntimeServerNoContent creates DeleteRuntimeServerNoContent with default headers values
func NewDeleteRuntimeServerNoContent() *DeleteRuntimeServerNoContent {

	return &DeleteRuntimeServerNoContent{}
}

// WriteResponse to the client
func (o *DeleteRuntimeServerNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteRuntimeServerBadRequestCode is the HTTP code returned for type DeleteRuntimeServerBadRequest
const DeleteRuntimeServerBadRequestCode int = 400

/*
DeleteRuntimeServerBadRequest Bad request

swagger:response deleteRuntimeServerBadRequest
*/
type DeleteRuntimeServerBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteRuntimeServerBadRequest creates DeleteRuntimeServerBadRequest with default headers values
func NewDeleteRuntimeServerBadRequest() *DeleteRuntimeServerBadRequest {

	return &DeleteRuntimeServerBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the delete runtime server bad request response
func (o *DeleteRuntimeServerBadRequest) WithConfigurationVersion(configurationVersion string) *DeleteRuntimeServerBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete runtime server bad request response
func (o *DeleteRuntimeServerBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete runtime server bad request response
func (o *DeleteRuntimeServerBadRequest) WithPayload(payload *models.Error) *DeleteRuntimeServerBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete runtime server bad request response
func (o *DeleteRuntimeServerBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteRuntimeServerBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DeleteRuntimeServerNotFoundCode is the HTTP code returned for type DeleteRuntimeServerNotFound
const DeleteRuntimeServerNotFoundCode int = 404

/*
DeleteRuntimeServerNotFound The specified resource was not found

swagger:response deleteRuntimeServerNotFound
*/
type DeleteRuntimeServerNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteRuntimeServerNotFound creates DeleteRuntimeServerNotFound with default headers values
func NewDeleteRuntimeServerNotFound() *DeleteRuntimeServerNotFound {

	return &DeleteRuntimeServerNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete runtime server not found response
func (o *DeleteRuntimeServerNotFound) WithConfigurationVersion(configurationVersion string) *DeleteRuntimeServerNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete runtime server not found response
func (o *DeleteRuntimeServerNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete runtime server not found response
func (o *DeleteRuntimeServerNotFound) WithPayload(payload *models.Error) *DeleteRuntimeServerNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete runtime server not found response
func (o *DeleteRuntimeServerNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteRuntimeServerNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteRuntimeServerDefault General Error

swagger:response deleteRuntimeServerDefault
*/
type DeleteRuntimeServerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteRuntimeServerDefault creates DeleteRuntimeServerDefault with default headers values
func NewDeleteRuntimeServerDefault(code int) *DeleteRuntimeServerDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteRuntimeServerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete runtime server default response
func (o *DeleteRuntimeServerDefault) WithStatusCode(code int) *DeleteRuntimeServerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete runtime server default response
func (o *DeleteRuntimeServerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete runtime server default response
func (o *DeleteRuntimeServerDefault) WithConfigurationVersion(configurationVersion string) *DeleteRuntimeServerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete runtime server default response
func (o *DeleteRuntimeServerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete runtime server default response
func (o *DeleteRuntimeServerDefault) WithPayload(payload *models.Error) *DeleteRuntimeServerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete runtime server default response
func (o *DeleteRuntimeServerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteRuntimeServerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
