// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server_template

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetServerTemplatesOKCode is the HTTP code returned for type GetServerTemplatesOK
const GetServerTemplatesOKCode int = 200

/*
GetServerTemplatesOK Successful operation

swagger:response getServerTemplatesOK
*/
type GetServerTemplatesOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.ServerTemplates `json:"body,omitempty"`
}

// NewGetServerTemplatesOK creates GetServerTemplatesOK with default headers values
func NewGetServerTemplatesOK() *GetServerTemplatesOK {

	return &GetServerTemplatesOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get server templates o k response
func (o *GetServerTemplatesOK) WithConfigurationVersion(configurationVersion string) *GetServerTemplatesOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server templates o k response
func (o *GetServerTemplatesOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server templates o k response
func (o *GetServerTemplatesOK) WithPayload(payload models.ServerTemplates) *GetServerTemplatesOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server templates o k response
func (o *GetServerTemplatesOK) SetPayload(payload models.ServerTemplates) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerTemplatesOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.ServerTemplates{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetServerTemplatesDefault General Error

swagger:response getServerTemplatesDefault
*/
type GetServerTemplatesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetServerTemplatesDefault creates GetServerTemplatesDefault with default headers values
func NewGetServerTemplatesDefault(code int) *GetServerTemplatesDefault {
	if code <= 0 {
		code = 500
	}

	return &GetServerTemplatesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get server templates default response
func (o *GetServerTemplatesDefault) WithStatusCode(code int) *GetServerTemplatesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get server templates default response
func (o *GetServerTemplatesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get server templates default response
func (o *GetServerTemplatesDefault) WithConfigurationVersion(configurationVersion string) *GetServerTemplatesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server templates default response
func (o *GetServerTemplatesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server templates default response
func (o *GetServerTemplatesDefault) WithPayload(payload *models.Error) *GetServerTemplatesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server templates default response
func (o *GetServerTemplatesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerTemplatesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
