/*
 * ipt.h
 *
 * Copyright (C) 2002 Thomas Graf <tgr@reeler.org>
 *
 * This file belongs to the nstats package, see COPYING for more information.
 *
 */

#ifndef IPT_H_
#define IPT_H_


#include "../config.h"

#ifndef HAVE_IPTABLES
#    error "This file should NOT be included if HAVE_IPTABLES is not defined"
#endif


#include "libiptc/libiptc.h"

struct iptc_s
{
    char name[13];

    struct ipt_s {

        char name[13];

        unsigned long bytes_old;
        unsigned long r_bytes;
        time_t bt;

        struct ipt_entry e;

        struct ipt_s *next, *prev;
    } *filters;

    struct iptc_s *next, *prev;

} *ipt_chains;

void calc_ipt(void);

int ipt_handle_input(int);

#endif
