/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.tools.ant.BaseJpfTask;

public final class CheckTask
extends BaseJpfTask {
    private boolean usePathResolver;

    public void setUsePathResolver(boolean bl) {
        this.usePathResolver = bl;
    }

    public void execute() {
        this.initRegistry(this.usePathResolver);
        this.log("Checking plug-ins integrity...");
        IntegrityCheckReport integrityCheckReport = this.getRegistry().checkIntegrity(this.getPathResolver());
        this.log("... integrity check done. Errors: " + integrityCheckReport.countErrors() + ". Warnings: " + integrityCheckReport.countWarnings() + ".");
        if (this.getVerbose()) {
            this.log(CheckTask.integrityCheckReport2str(integrityCheckReport));
        }
        if (integrityCheckReport.countErrors() > 0) {
            throw new BuildException("plug-ins set integrity check failed, errors count - " + integrityCheckReport.countErrors());
        }
    }

    private static String integrityCheckReport2str(IntegrityCheckReport integrityCheckReport) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Integrity check report:\r\n");
        stringBuffer.append("-------------- REPORT BEGIN -----------------\r\n");
        Iterator iterator = integrityCheckReport.getItems().iterator();
        while (iterator.hasNext()) {
            IntegrityCheckReport.ReportItem reportItem = (IntegrityCheckReport.ReportItem)iterator.next();
            stringBuffer.append("severity=").append(reportItem.getSeverity()).append("; code=").append(reportItem.getCode()).append("; message=").append(reportItem.getMessage()).append("; source=").append(reportItem.getSource()).append("\r\n");
        }
        stringBuffer.append("-------------- REPORT END -----------------");
        return stringBuffer.toString();
    }
}

