# Contributing to Transifex Client

:tada: Thank you for your interest in contributing to this project! :tada:

## Table Of Contents

* [Code of Conduct](#code-of-conduct)
* [I just have a question](#i-just-have-a-question)
* [Contributor License Agreement](#contributor-license-agreement)
* [How to Contribute](#how-to-contribute)
  * [Reporting Bugs](#reporting-bugs)
  * [Suggesting Improvements](#suggesting-improvements)
  * [Creating Patches](#creating-patches)

# Code of Conduct

Please read this project's [Code of Conduct](/CODE_OF_CONDUCT.md) for the detailed standards on how to engage in this community.


# How to Contribute

There are several ways to contribute to this project and they are all equally welcome. You can report a bug, suggest an improvement or submit an improvement yourself, be it a change in the code or in the documentation.

## Reporting Bugs

Bugs in this project are tracked as [GitHub issues](https://guides.github.com/features/issues/). Before submitting a new issue, make sure you check the [list of exiting issues](https://github.com/transifex/cli/issues), as it might already be there.

When creating an issue, make sure you include the following:
* A clear and descriptive title.
* The exact steps to allow others to reproduce the issue.
* The behavior you observed and the reason you find this problematic.
* The behavior you expected instead and the reason for this.
* Any material that would better showcase the issue, such as screenshots or animated GIFs.
* The version(s) of this library you have seen this erroneous behavior in
* Make sure you DO NOT INCLUDE any sensitive information, such as a token, a secret or a private URL to a Transifex project or resource

## Suggesting Improvements

Improvement suggestions in this project are tracked as [GitHub issues](https://guides.github.com/features/issues/). Before submitting a new suggestion, make sure you check the [list of exiting issues](https://github.com/transifex/cli/issues), as it might already be there.

When creating an improvement issue, make sure you include the following:
* A clear and descriptive title.
* The exact steps to allow others to reproduce the issue.
* The current behavior/functionality, what you would prefer to see instead and why.
* An explanation on why this improvement would benefit most users of this library and not just your use case
* Any material that could better showcase the current and the expected behavior, such as screenshots or animated GIFs.
* Make sure you DO NOT INCLUDE any sensitive information, such as a token, a secret or a private URL to a Transifex project or resource

## Creating Patches

### Contributor License Agreement

Before contributing with suggested changes, you must sign our [Contributor License Agreement](https://docs.transifex.com/legal/contributing).

If you want to submit a patch that either fixes a bug or introduces a new feature, you need to have the following in mind:
* The Pull Request (PR) handles one thing, i.e. fixes a certain bug or introduces a specific new functionality, instead of combining many at once.
* Each commit should include one logical change each and should ideally be few in number per PR.
* All [status checks](https://help.github.com/articles/about-status-checks), including the execution of the test suit, must pass.
* The Rebase workflow is followed: each branch must be rebased over `origin/master` before being allowed to get merged.

In order for a PR to be merged, at least one maintainer of this project must first review and approve it. The reviewer(s) may request changes before moving on.
