/*  ethers.c
 *
 * Copyright (c) 2010 SeaD <sead at deep.perm.ru>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *  $Id: ethers.c,v 1.14 2010/07/12 03:46:36 sead Exp $
 *
 */

#include "ipguard.h"

#define STR_SIZE        128
#define ADDR_LEN        64

void ethers_init(void) {
    FILE *eth_fp;
    char str[STR_SIZE];
    char mac[ADDR_LEN], ip[ADDR_LEN];
    register int n, m;

    if (!(eth_fp = fopen(ethers_name, "r"))) {
        snprintf(s, 128, "fopen(%s):", ethers_name);
        log_str(WARNING, s, strerror(errno));
        return;
    }

    while (fgets(str, STR_SIZE, eth_fp)) {
        if (debug > 2) fprintf(stderr, "ETHERS: %s", str);
        for (n = 0; n < STR_SIZE; n++)
            if ((str[n] == '\n') || (str[n] == '\r') || (str[n] == '#')) {
                str[n] = '\0'; break;
            }
        for (mac[0] = ip[0] = '\0', n = 0; n < STR_SIZE; n++)
            if ((str[n] != ' ') && (str[n] != '\t')) break;
        if ((str[n] == '+') || (str[n] == '\0')) continue;
        for (m = 0; (m < ADDR_LEN) && (n < STR_SIZE); m++, n++) {
            if ((str[n] == ' ') || (str[n] == '\t') || (str[n] == '\0')) {
                mac[m] = '\0'; break;
            }
            mac[m] = str[n];
        }
        for (; n < STR_SIZE; n++) if ((str[n] != ' ') && (str[n] != '\t')) break;
        for (m = 0; (m < ADDR_LEN) && (n < STR_SIZE); m++, n++) {
            if ((str[n] == ' ') || (str[n] == '\t') || (str[n] == '\0')) {
                ip[m] = '\0'; break;
            }
            ip[m] = str[n];
        }

        if (ip[0] == '\0') { if (verbose) log_str(NOTICE, "Incorrect MAC-IP pair:", str); continue; }
        if (strchr(mac, '.')) { strncpy(str, mac, ADDR_LEN); strncpy(mac, ip, ADDR_LEN); strncpy(ip, str, ADDR_LEN); }
        if (!strchr(mac, ':')) { if (verbose) log_str(NOTICE, "Wrong MAC address", ip); continue; }
        if (!strchr(ip, '.')) { if (verbose) log_str(NOTICE, "Wrong IP address", ip); continue; }

        pair_add(mac, ip);
    }

    if (fclose(eth_fp)) {
        snprintf(s, 128, "fclose(%s):", ethers_name);
        log_str(ERROR, s, strerror(errno));
        exit_ipguard(EXIT_FAILURE);
    }
}

void ethers_reinit(void) {
    pair_destroy(); pair_init(); ethers_init();
    log_str(NOTICE, "MAC-IP file rescanned:", ethers_name);
}
