/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef TILES_H
#define TILES_H

typedef struct tiles_s tiles_t;

/*
 * The number of zoom levels
 * 128 64 32 16 8 4 2
 */
#define ZOOMLEVELS 7

typedef struct tile_s {
    void *image[4][ZOOMLEVELS];
    int sizex[4][ZOOMLEVELS];
    int sizey[4][ZOOMLEVELS];
    int extray[4][ZOOMLEVELS];
    char *filename;
    int color_r;
    int color_g;
    int color_b;
    int ispattern;
    int width;
    int height;
} tile_t;

typedef void *tiles_loadimage_func_t(char *filename, int request_width, int request_height, int *extra, void *rock);

#include "game.h"
#include "map.h"
#include "heightmap.h"
#include "function.h"

int tiles_init(tiles_t **tiles, char *specfile, tiles_loadimage_func_t *loadfunc, void *rock);

int tiles_get_flat(tiles_t *tiles, mapobj_t objtype, surrounding_t *surounding, tile_t **tile);

int tiles_get_slope(tiles_t *tiles, mapobj_t objtype, int slope, tile_t **tile);

int tiles_get(tiles_t *tiles, mapobj_t objtype, surrounding_t *surounding, heightsquare_t *heightsquare, tile_t **tile);

void tiles_getsize(tiles_t *tiles, mapobj_t objtype, int *sizex, int *sizey);

int tiles_cost(tiles_t *tiles, mapobj_t objtype);

int tiles_getrevenue(tiles_t *tiles, mapobj_t objtype, func_getvariable_cb *cb, void *rock);

int tiles_getupkeep(tiles_t *tiles, mapobj_t objtype, func_getvariable_cb *cb, void *rock);

int tiles_getrent(tiles_t *tiles, mapobj_t objtype);

int tiles_gethouse(tiles_t *tiles, mapobj_t objtype);

labor_t *tiles_getemploy(tiles_t *tiles, mapobj_t objtype);
int tiles_getnumemploy(tiles_t *tiles, mapobj_t objtype);

int tiles_getlandvalue(tiles_t *tiles, mapobj_t objtype, func_getvariable_cb *cb, void *rock);

int tiles_get_demolish_cost(tiles_t *tiles, mapobj_t objtype);

int tiles_get_maxstudents(tiles_t *tiles, mapobj_t objtype);

int tiles_get_maxpatrons(tiles_t *tiles, mapobj_t objtype);

int tiles_getproduction(tiles_t *tiles, mapobj_t objtype, func_getvariable_cb *cb, void *rock);

int tiles_getrange(tiles_t *tiles, mapobj_t objtype);

float tiles_getpatronperc(tiles_t *tiles, mapobj_t objtype);

int tiles_getpoweruse(tiles_t *tiles, mapobj_t objtype);
int tiles_getwateruse(tiles_t *tiles, mapobj_t objtype);
int tiles_getcapacity(tiles_t *tiles, mapobj_t objtype);

void *tile_image(tiles_t *tiles, tile_t *tile, int rotation, int zoom);

#endif /* TILES_H */
