/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef CONNECTIONS_H
#define CONNECTIONS_H

#include "player.h"

typedef struct connection_s connection_t;

typedef void connection_enumerate_func(connection_t *conn, player_t *player, void *rock);

/* enumerate over all the connections calling 'func' on each one */
void connections_enumerate(connection_enumerate_func *func, void *rock);

/* send 'msg' to all connections */
void connections_send_to_all(char *msg, ...);

void connection_write(connection_t *conn, int flush, char *msg, ...);

void connection_setfd(connection_t *conn, player_t *player, void *rock);

void connections_flush_all(void);

int connections_add(int newsock);

void connection_checkfd(connection_t *conn, player_t *player, void *rock);

void connection_close(connection_t *conn);

int connection_setplayer(connection_t *conn, const char *name);

player_t *connection_getplayer(connection_t *conn);

connection_t *connections_getconnection(player_t *player);

int connections_setlogging(const char *file);

int connection_txn_start(connection_t *conn);

int connection_txn_add(connection_t *conn, void *op);

typedef void connection_txn_enumerate_func(void *op, void *rock);

int connection_txn_enumerate(connection_t *conn, connection_txn_enumerate_func *func, void *rock);

int connection_txn_clear(connection_t *conn);

int connection_txn_active(connection_t *conn);

#endif /* CONNECTIONS_H */
