/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ditaa.core;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.ListIterator;
import org.stathissideris.ditaa.core.ProcessingOptions;
import org.stathissideris.ditaa.core.RenderingOptions;

public class ConversionOptions {
    public final ProcessingOptions processingOptions;
    public final RenderingOptions renderingOptions;

    public ConversionOptions() {
        this(new ProcessingOptions(), new RenderingOptions());
    }

    public ConversionOptions(ProcessingOptions processingOptions, RenderingOptions renderingOptions) {
        this.processingOptions = processingOptions;
        this.renderingOptions = renderingOptions;
    }

    public static ConversionOptions parseCommandLineOptions(String[] args) throws UnsupportedEncodingException {
        return ConversionOptions.parseCommandLineOptions(Arrays.asList(args).listIterator());
    }

    public static ConversionOptions parseCommandLineOptions(ListIterator<String> args) throws UnsupportedEncodingException {
        ConversionOptions options = new ConversionOptions();
        while (args.hasNext()) {
            String arg = args.next();
            if (arg.equals("-v") || arg.equals("--verbose")) {
                options.processingOptions.setVerbose(true);
                continue;
            }
            if (arg.equals("-o") || arg.equals("--overwrite")) {
                options.processingOptions.setOverwriteFiles(true);
                continue;
            }
            if (arg.equals("-S") || arg.equals("--no-shadows")) {
                options.renderingOptions.setDropShadows(false);
                continue;
            }
            if (arg.equals("-A") || arg.equals("--no-antialias")) {
                options.renderingOptions.setAntialias(false);
                continue;
            }
            if (arg.equals("-W") || arg.equals("--fixed-slope")) {
                options.renderingOptions.setFixedSlope(true);
                continue;
            }
            if (arg.equals("-d") || arg.equals("--debug")) {
                options.setDebug(true);
                continue;
            }
            if (arg.equals("-r") || arg.equals("--round-corners")) {
                options.processingOptions.setAllCornersAreRound(true);
                continue;
            }
            if (arg.equals("-E") || arg.equals("--no-separation")) {
                options.processingOptions.setPerformSeparationOfCommonEdges(false);
                continue;
            }
            if (arg.equals("-T") || arg.equals("--transparent")) {
                options.renderingOptions.setBackgroundColor(new Color(0, 0, 0, 0));
                continue;
            }
            if (arg.equals("-e") || arg.equals("--encoding")) {
                options.processingOptions.setCharacterEncoding(Charset.forName(args.next()));
                continue;
            }
            if (arg.equals("-s") || arg.equals("--scale")) {
                Float scale = Float.valueOf(Float.parseFloat(args.next()));
                options.renderingOptions.setScale(scale.floatValue());
                continue;
            }
            if (arg.equals("-t") || arg.equals("--tabs")) {
                int tabSize = Integer.parseInt(args.next());
                if (tabSize < 0) {
                    tabSize = 0;
                }
                options.processingOptions.setTabSize(tabSize);
                continue;
            }
            if (arg.equals("-b") || arg.equals("--background")) {
                Color background = ConversionOptions.parseColor(args.next());
                options.renderingOptions.setBackgroundColor(background);
                continue;
            }
            if (arg.equals("-f") || arg.equals("--font")) {
                options.renderingOptions.setFontName(args.next());
                continue;
            }
            if (arg.equals("-F") || arg.equals("--font-size")) {
                Integer size = Integer.parseInt(args.next());
                options.renderingOptions.setFontSize(size);
                continue;
            }
            if (arg.equals("--svg")) {
                options.renderingOptions.setImageType(RenderingOptions.ImageType.SVG);
                continue;
            }
            if (arg.equals("--svg-font-url")) {
                options.renderingOptions.setFontURL(args.next());
                continue;
            }
            if (arg.equals("--bullet-characters")) {
                options.processingOptions.setBulletCharacters(args.next());
                continue;
            }
            args.previous();
            break;
        }
        return options;
    }

    public void setDebug(boolean value) {
        this.processingOptions.setPrintDebugOutput(value);
        this.renderingOptions.setRenderDebugLines(value);
    }

    public static Color parseColor(String hexString) {
        if (hexString.length() == 6) {
            return new Color(Integer.parseInt(hexString, 16));
        }
        if (hexString.length() == 8) {
            return new Color(Integer.parseInt(hexString.substring(0, 2), 16), Integer.parseInt(hexString.substring(2, 4), 16), Integer.parseInt(hexString.substring(4, 6), 16), Integer.parseInt(hexString.substring(6, 8), 16));
        }
        throw new IllegalArgumentException("Cannot interpret \"" + hexString + "\" as background colour. It needs to be a 6- or 8-digit hex number, depending on whether you have transparency or not (same as HTML).");
    }
}

