---
title: "PikPak"
description: "Rclone docs for PikPak"
versionIntroduced: "v1.62"
---

# {{< icon "fa fa-cloud" >}} PikPak

PikPak is [a private cloud drive](https://mypikpak.com/).

Paths are specified as `remote:path`, and may be as deep as required, e.g. `remote:directory/subdirectory`.

## Configuration

Here is an example of making a remote for PikPak.

First run:

     rclone config

This will guide you through an interactive setup process:

```
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n

Enter name for new remote.
name> remote

Option Storage.
Type of storage to configure.
Choose a number from below, or type in your own value.
XX / PikPak
   \ (pikpak)
Storage> XX

Option user.
Pikpak username.
Enter a value.
user> USERNAME

Option pass.
Pikpak password.
Choose an alternative below.
y) Yes, type in my own password
g) Generate random password
y/g> y
Enter the password:
password:
Confirm the password:
password:

Edit advanced config?
y) Yes
n) No (default)
y/n> 

Configuration complete.
Options:
- type: pikpak
- user: USERNAME
- pass: *** ENCRYPTED ***
- token: {"access_token":"eyJ...","token_type":"Bearer","refresh_token":"os...","expiry":"2023-01-26T18:54:32.170582647+09:00"}
Keep this "remote" remote?
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> y
```

### Modification times and hashes

PikPak keeps modification times on objects, and updates them when uploading objects,
but it does not support changing only the modification time

The MD5 hash algorithm is supported.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/pikpak/pikpak.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to pikpak (PikPak).

#### --pikpak-user

Pikpak username.

Properties:

- Config:      user
- Env Var:     RCLONE_PIKPAK_USER
- Type:        string
- Required:    true

#### --pikpak-pass

Pikpak password.

**NB** Input to this must be obscured - see [rclone obscure](/commands/rclone_obscure/).

Properties:

- Config:      pass
- Env Var:     RCLONE_PIKPAK_PASS
- Type:        string
- Required:    true

### Advanced options

Here are the Advanced options specific to pikpak (PikPak).

#### --pikpak-device-id

Device ID used for authorization.

Properties:

- Config:      device_id
- Env Var:     RCLONE_PIKPAK_DEVICE_ID
- Type:        string
- Required:    false

#### --pikpak-user-agent

HTTP user agent for pikpak.

Defaults to "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:129.0) Gecko/20100101 Firefox/129.0" or "--pikpak-user-agent" provided on command line.

Properties:

- Config:      user_agent
- Env Var:     RCLONE_PIKPAK_USER_AGENT
- Type:        string
- Default:     "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:129.0) Gecko/20100101 Firefox/129.0"

#### --pikpak-root-folder-id

ID of the root folder.
Leave blank normally.

Fill in for rclone to use a non root folder as its starting point.


Properties:

- Config:      root_folder_id
- Env Var:     RCLONE_PIKPAK_ROOT_FOLDER_ID
- Type:        string
- Required:    false

#### --pikpak-use-trash

Send files to the trash instead of deleting permanently.

Defaults to true, namely sending files to the trash.
Use `--pikpak-use-trash=false` to delete files permanently instead.

Properties:

- Config:      use_trash
- Env Var:     RCLONE_PIKPAK_USE_TRASH
- Type:        bool
- Default:     true

#### --pikpak-trashed-only

Only show files that are in the trash.

This will show trashed files in their original directory structure.

Properties:

- Config:      trashed_only
- Env Var:     RCLONE_PIKPAK_TRASHED_ONLY
- Type:        bool
- Default:     false

#### --pikpak-no-media-link

Use original file links instead of media links.

This avoids issues caused by invalid media links, but may reduce download speeds.

Properties:

- Config:      no_media_link
- Env Var:     RCLONE_PIKPAK_NO_MEDIA_LINK
- Type:        bool
- Default:     false

#### --pikpak-hash-memory-limit

Files bigger than this will be cached on disk to calculate hash if required.

Properties:

- Config:      hash_memory_limit
- Env Var:     RCLONE_PIKPAK_HASH_MEMORY_LIMIT
- Type:        SizeSuffix
- Default:     10Mi

#### --pikpak-chunk-size

Chunk size for multipart uploads.
	
Large files will be uploaded in chunks of this size.

Note that this is stored in memory and there may be up to
"--transfers" * "--pikpak-upload-concurrency" chunks stored at once
in memory.

If you are transferring large files over high-speed links and you have
enough memory, then increasing this will speed up the transfers.

Rclone will automatically increase the chunk size when uploading a
large file of known size to stay below the 10,000 chunks limit.

Increasing the chunk size decreases the accuracy of the progress
statistics displayed with "-P" flag.

Properties:

- Config:      chunk_size
- Env Var:     RCLONE_PIKPAK_CHUNK_SIZE
- Type:        SizeSuffix
- Default:     5Mi

#### --pikpak-upload-concurrency

Concurrency for multipart uploads.

This is the number of chunks of the same file that are uploaded
concurrently for multipart uploads.

Note that chunks are stored in memory and there may be up to
"--transfers" * "--pikpak-upload-concurrency" chunks stored at once
in memory.

If you are uploading small numbers of large files over high-speed links
and these uploads do not fully utilize your bandwidth, then increasing
this may help to speed up the transfers.

Properties:

- Config:      upload_concurrency
- Env Var:     RCLONE_PIKPAK_UPLOAD_CONCURRENCY
- Type:        int
- Default:     5

#### --pikpak-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_PIKPAK_ENCODING
- Type:        Encoding
- Default:     Slash,LtGt,DoubleQuote,Colon,Question,Asterisk,Pipe,BackSlash,Ctl,LeftSpace,RightSpace,RightPeriod,InvalidUtf8,Dot

#### --pikpak-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_PIKPAK_DESCRIPTION
- Type:        string
- Required:    false

## Backend commands

Here are the commands specific to the pikpak backend.

Run them with

    rclone backend COMMAND remote:

The help below will explain what arguments each command takes.

See the [backend](/commands/rclone_backend/) command for more
info on how to pass options and arguments.

These can be run on a running backend using the rc command
[backend/command](/rc/#backend-command).

### addurl

Add offline download task for url

    rclone backend addurl remote: [options] [<arguments>+]

This command adds offline download task for url.

Usage:

    rclone backend addurl pikpak:dirpath url

Downloads will be stored in 'dirpath'. If 'dirpath' is invalid, 
download will fallback to default 'My Pack' folder.


### decompress

Request decompress of a file/files in a folder

    rclone backend decompress remote: [options] [<arguments>+]

This command requests decompress of file/files in a folder.

Usage:

    rclone backend decompress pikpak:dirpath {filename} -o password=password
    rclone backend decompress pikpak:dirpath {filename} -o delete-src-file

An optional argument 'filename' can be specified for a file located in 
'pikpak:dirpath'. You may want to pass '-o password=password' for a 
password-protected files. Also, pass '-o delete-src-file' to delete 
source files after decompression finished.

Result:

    {
        "Decompressed": 17,
        "SourceDeleted": 0,
        "Errors": 0
    }


{{< rem autogenerated options stop >}}

## Limitations

### Hashes may be empty

PikPak supports MD5 hash, but sometimes given empty especially for user-uploaded files.

### Deleted files still visible with trashed-only

Deleted files will still be visible with `--pikpak-trashed-only` even after the
trash emptied. This goes away after few days.
