// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 6
// REQUIRES: aarch64-registered-target
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2p2 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -p mem2reg,instcombine,tailcallelim | FileCheck %s
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2p2 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -p mem2reg,instcombine,tailcallelim | FileCheck %s -check-prefix=CPP-CHECK
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2p2 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -p mem2reg,instcombine,tailcallelim | FileCheck %s
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2p2 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -p mem2reg,instcombine,tailcallelim | FileCheck %s -check-prefix=CPP-CHECK
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2p2 -S -disable-O0-optnone -Werror -Wall -o /dev/null %s
#include <arm_sme.h>

#ifdef SVE_OVERLOADED_FORMS
// A simple used,unused... macro, long enough to represent any SVE builtin.
#define SVE_ACLE_FUNC(A1,A2_UNUSED) A1
#else
#define SVE_ACLE_FUNC(A1,A2) A1##A2
#endif

// CHECK-LABEL: define dso_local { <vscale x 8 x half>, <vscale x 8 x half> } @test_svmul_single_f16_x2(
// CHECK-SAME: <vscale x 8 x half> [[ZDN_COERCE0:%.*]], <vscale x 8 x half> [[ZDN_COERCE1:%.*]], <vscale x 8 x half> [[ZM:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 8 x half>, <vscale x 8 x half> } @llvm.aarch64.sve.fmul.single.x2.nxv8f16(<vscale x 8 x half> [[ZDN_COERCE0]], <vscale x 8 x half> [[ZDN_COERCE1]], <vscale x 8 x half> [[ZM]])
// CHECK-NEXT:    ret { <vscale x 8 x half>, <vscale x 8 x half> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 8 x half>, <vscale x 8 x half> } @_Z24test_svmul_single_f16_x213svfloat16x2_tu13__SVFloat16_t(
// CPP-CHECK-SAME: <vscale x 8 x half> [[ZDN_COERCE0:%.*]], <vscale x 8 x half> [[ZDN_COERCE1:%.*]], <vscale x 8 x half> [[ZM:%.*]]) #[[ATTR0:[0-9]+]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 8 x half>, <vscale x 8 x half> } @llvm.aarch64.sve.fmul.single.x2.nxv8f16(<vscale x 8 x half> [[ZDN_COERCE0]], <vscale x 8 x half> [[ZDN_COERCE1]], <vscale x 8 x half> [[ZM]])
// CPP-CHECK-NEXT:    ret { <vscale x 8 x half>, <vscale x 8 x half> } [[TMP0]]
//
svfloat16x2_t test_svmul_single_f16_x2(svfloat16x2_t zdn, svfloat16_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_single_f16_x2)(zdn, zm);
}
// CHECK-LABEL: define dso_local { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } @test_svmul_single_f16_x4(
// CHECK-SAME: <vscale x 8 x half> [[ZDN_COERCE0:%.*]], <vscale x 8 x half> [[ZDN_COERCE1:%.*]], <vscale x 8 x half> [[ZDN_COERCE2:%.*]], <vscale x 8 x half> [[ZDN_COERCE3:%.*]], <vscale x 8 x half> [[ZM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } @llvm.aarch64.sve.fmul.single.x4.nxv8f16(<vscale x 8 x half> [[ZDN_COERCE0]], <vscale x 8 x half> [[ZDN_COERCE1]], <vscale x 8 x half> [[ZDN_COERCE2]], <vscale x 8 x half> [[ZDN_COERCE3]], <vscale x 8 x half> [[ZM]])
// CHECK-NEXT:    ret { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } @_Z24test_svmul_single_f16_x413svfloat16x4_tu13__SVFloat16_t(
// CPP-CHECK-SAME: <vscale x 8 x half> [[ZDN_COERCE0:%.*]], <vscale x 8 x half> [[ZDN_COERCE1:%.*]], <vscale x 8 x half> [[ZDN_COERCE2:%.*]], <vscale x 8 x half> [[ZDN_COERCE3:%.*]], <vscale x 8 x half> [[ZM:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } @llvm.aarch64.sve.fmul.single.x4.nxv8f16(<vscale x 8 x half> [[ZDN_COERCE0]], <vscale x 8 x half> [[ZDN_COERCE1]], <vscale x 8 x half> [[ZDN_COERCE2]], <vscale x 8 x half> [[ZDN_COERCE3]], <vscale x 8 x half> [[ZM]])
// CPP-CHECK-NEXT:    ret { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } [[TMP0]]
//
svfloat16x4_t test_svmul_single_f16_x4(svfloat16x4_t zdn, svfloat16_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_single_f16_x4)(zdn, zm);
}
// CHECK-LABEL: define dso_local { <vscale x 8 x half>, <vscale x 8 x half> } @test_svmul_f16_x2(
// CHECK-SAME: <vscale x 8 x half> [[ZDN_COERCE0:%.*]], <vscale x 8 x half> [[ZDN_COERCE1:%.*]], <vscale x 8 x half> [[ZM_COERCE0:%.*]], <vscale x 8 x half> [[ZM_COERCE1:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 8 x half>, <vscale x 8 x half> } @llvm.aarch64.sve.fmul.x2.nxv8f16(<vscale x 8 x half> [[ZDN_COERCE0]], <vscale x 8 x half> [[ZDN_COERCE1]], <vscale x 8 x half> [[ZM_COERCE0]], <vscale x 8 x half> [[ZM_COERCE1]])
// CHECK-NEXT:    ret { <vscale x 8 x half>, <vscale x 8 x half> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 8 x half>, <vscale x 8 x half> } @_Z17test_svmul_f16_x213svfloat16x2_tS_(
// CPP-CHECK-SAME: <vscale x 8 x half> [[ZDN_COERCE0:%.*]], <vscale x 8 x half> [[ZDN_COERCE1:%.*]], <vscale x 8 x half> [[ZM_COERCE0:%.*]], <vscale x 8 x half> [[ZM_COERCE1:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 8 x half>, <vscale x 8 x half> } @llvm.aarch64.sve.fmul.x2.nxv8f16(<vscale x 8 x half> [[ZDN_COERCE0]], <vscale x 8 x half> [[ZDN_COERCE1]], <vscale x 8 x half> [[ZM_COERCE0]], <vscale x 8 x half> [[ZM_COERCE1]])
// CPP-CHECK-NEXT:    ret { <vscale x 8 x half>, <vscale x 8 x half> } [[TMP0]]
//
svfloat16x2_t test_svmul_f16_x2(svfloat16x2_t zdn, svfloat16x2_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_f16_x2)(zdn, zm);
}
// CHECK-LABEL: define dso_local { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } @test_svmul_f16_x4(
// CHECK-SAME: <vscale x 8 x half> [[ZDN_COERCE0:%.*]], <vscale x 8 x half> [[ZDN_COERCE1:%.*]], <vscale x 8 x half> [[ZDN_COERCE2:%.*]], <vscale x 8 x half> [[ZDN_COERCE3:%.*]], <vscale x 8 x half> [[ZM_COERCE0:%.*]], <vscale x 8 x half> [[ZM_COERCE1:%.*]], <vscale x 8 x half> [[ZM_COERCE2:%.*]], <vscale x 8 x half> [[ZM_COERCE3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } @llvm.aarch64.sve.fmul.x4.nxv8f16(<vscale x 8 x half> [[ZDN_COERCE0]], <vscale x 8 x half> [[ZDN_COERCE1]], <vscale x 8 x half> [[ZDN_COERCE2]], <vscale x 8 x half> [[ZDN_COERCE3]], <vscale x 8 x half> [[ZM_COERCE0]], <vscale x 8 x half> [[ZM_COERCE1]], <vscale x 8 x half> [[ZM_COERCE2]], <vscale x 8 x half> [[ZM_COERCE3]])
// CHECK-NEXT:    ret { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } @_Z17test_svmul_f16_x413svfloat16x4_tS_(
// CPP-CHECK-SAME: <vscale x 8 x half> [[ZDN_COERCE0:%.*]], <vscale x 8 x half> [[ZDN_COERCE1:%.*]], <vscale x 8 x half> [[ZDN_COERCE2:%.*]], <vscale x 8 x half> [[ZDN_COERCE3:%.*]], <vscale x 8 x half> [[ZM_COERCE0:%.*]], <vscale x 8 x half> [[ZM_COERCE1:%.*]], <vscale x 8 x half> [[ZM_COERCE2:%.*]], <vscale x 8 x half> [[ZM_COERCE3:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } @llvm.aarch64.sve.fmul.x4.nxv8f16(<vscale x 8 x half> [[ZDN_COERCE0]], <vscale x 8 x half> [[ZDN_COERCE1]], <vscale x 8 x half> [[ZDN_COERCE2]], <vscale x 8 x half> [[ZDN_COERCE3]], <vscale x 8 x half> [[ZM_COERCE0]], <vscale x 8 x half> [[ZM_COERCE1]], <vscale x 8 x half> [[ZM_COERCE2]], <vscale x 8 x half> [[ZM_COERCE3]])
// CPP-CHECK-NEXT:    ret { <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half> } [[TMP0]]
//
svfloat16x4_t test_svmul_f16_x4(svfloat16x4_t zdn, svfloat16x4_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_f16_x4)(zdn, zm);
}

// CHECK-LABEL: define dso_local { <vscale x 4 x float>, <vscale x 4 x float> } @test_svmul_single_f32_x2(
// CHECK-SAME: <vscale x 4 x float> [[ZDN_COERCE0:%.*]], <vscale x 4 x float> [[ZDN_COERCE1:%.*]], <vscale x 4 x float> [[ZM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.fmul.single.x2.nxv4f32(<vscale x 4 x float> [[ZDN_COERCE0]], <vscale x 4 x float> [[ZDN_COERCE1]], <vscale x 4 x float> [[ZM]])
// CHECK-NEXT:    ret { <vscale x 4 x float>, <vscale x 4 x float> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 4 x float>, <vscale x 4 x float> } @_Z24test_svmul_single_f32_x213svfloat32x2_tu13__SVFloat32_t(
// CPP-CHECK-SAME: <vscale x 4 x float> [[ZDN_COERCE0:%.*]], <vscale x 4 x float> [[ZDN_COERCE1:%.*]], <vscale x 4 x float> [[ZM:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.fmul.single.x2.nxv4f32(<vscale x 4 x float> [[ZDN_COERCE0]], <vscale x 4 x float> [[ZDN_COERCE1]], <vscale x 4 x float> [[ZM]])
// CPP-CHECK-NEXT:    ret { <vscale x 4 x float>, <vscale x 4 x float> } [[TMP0]]
//
svfloat32x2_t test_svmul_single_f32_x2(svfloat32x2_t zdn, svfloat32_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_single_f32_x2)(zdn, zm);
}
// CHECK-LABEL: define dso_local { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } @test_svmul_single_f32_x4(
// CHECK-SAME: <vscale x 4 x float> [[ZDN_COERCE0:%.*]], <vscale x 4 x float> [[ZDN_COERCE1:%.*]], <vscale x 4 x float> [[ZDN_COERCE2:%.*]], <vscale x 4 x float> [[ZDN_COERCE3:%.*]], <vscale x 4 x float> [[ZM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.fmul.single.x4.nxv4f32(<vscale x 4 x float> [[ZDN_COERCE0]], <vscale x 4 x float> [[ZDN_COERCE1]], <vscale x 4 x float> [[ZDN_COERCE2]], <vscale x 4 x float> [[ZDN_COERCE3]], <vscale x 4 x float> [[ZM]])
// CHECK-NEXT:    ret { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } @_Z24test_svmul_single_f32_x413svfloat32x4_tu13__SVFloat32_t(
// CPP-CHECK-SAME: <vscale x 4 x float> [[ZDN_COERCE0:%.*]], <vscale x 4 x float> [[ZDN_COERCE1:%.*]], <vscale x 4 x float> [[ZDN_COERCE2:%.*]], <vscale x 4 x float> [[ZDN_COERCE3:%.*]], <vscale x 4 x float> [[ZM:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.fmul.single.x4.nxv4f32(<vscale x 4 x float> [[ZDN_COERCE0]], <vscale x 4 x float> [[ZDN_COERCE1]], <vscale x 4 x float> [[ZDN_COERCE2]], <vscale x 4 x float> [[ZDN_COERCE3]], <vscale x 4 x float> [[ZM]])
// CPP-CHECK-NEXT:    ret { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } [[TMP0]]
//
svfloat32x4_t test_svmul_single_f32_x4(svfloat32x4_t zdn, svfloat32_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_single_f32_x4)(zdn, zm);
}
// CHECK-LABEL: define dso_local { <vscale x 4 x float>, <vscale x 4 x float> } @test_svmul_f32_x2(
// CHECK-SAME: <vscale x 4 x float> [[ZDN_COERCE0:%.*]], <vscale x 4 x float> [[ZDN_COERCE1:%.*]], <vscale x 4 x float> [[ZM_COERCE0:%.*]], <vscale x 4 x float> [[ZM_COERCE1:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.fmul.x2.nxv4f32(<vscale x 4 x float> [[ZDN_COERCE0]], <vscale x 4 x float> [[ZDN_COERCE1]], <vscale x 4 x float> [[ZM_COERCE0]], <vscale x 4 x float> [[ZM_COERCE1]])
// CHECK-NEXT:    ret { <vscale x 4 x float>, <vscale x 4 x float> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 4 x float>, <vscale x 4 x float> } @_Z17test_svmul_f32_x213svfloat32x2_tS_(
// CPP-CHECK-SAME: <vscale x 4 x float> [[ZDN_COERCE0:%.*]], <vscale x 4 x float> [[ZDN_COERCE1:%.*]], <vscale x 4 x float> [[ZM_COERCE0:%.*]], <vscale x 4 x float> [[ZM_COERCE1:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.fmul.x2.nxv4f32(<vscale x 4 x float> [[ZDN_COERCE0]], <vscale x 4 x float> [[ZDN_COERCE1]], <vscale x 4 x float> [[ZM_COERCE0]], <vscale x 4 x float> [[ZM_COERCE1]])
// CPP-CHECK-NEXT:    ret { <vscale x 4 x float>, <vscale x 4 x float> } [[TMP0]]
//
svfloat32x2_t test_svmul_f32_x2(svfloat32x2_t zdn, svfloat32x2_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_f32_x2)(zdn, zm);
}
// CHECK-LABEL: define dso_local { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } @test_svmul_f32_x4(
// CHECK-SAME: <vscale x 4 x float> [[ZDN_COERCE0:%.*]], <vscale x 4 x float> [[ZDN_COERCE1:%.*]], <vscale x 4 x float> [[ZDN_COERCE2:%.*]], <vscale x 4 x float> [[ZDN_COERCE3:%.*]], <vscale x 4 x float> [[ZM_COERCE0:%.*]], <vscale x 4 x float> [[ZM_COERCE1:%.*]], <vscale x 4 x float> [[ZM_COERCE2:%.*]], <vscale x 4 x float> [[ZM_COERCE3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.fmul.x4.nxv4f32(<vscale x 4 x float> [[ZDN_COERCE0]], <vscale x 4 x float> [[ZDN_COERCE1]], <vscale x 4 x float> [[ZDN_COERCE2]], <vscale x 4 x float> [[ZDN_COERCE3]], <vscale x 4 x float> [[ZM_COERCE0]], <vscale x 4 x float> [[ZM_COERCE1]], <vscale x 4 x float> [[ZM_COERCE2]], <vscale x 4 x float> [[ZM_COERCE3]])
// CHECK-NEXT:    ret { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } @_Z17test_svmul_f32_x413svfloat32x4_tS_(
// CPP-CHECK-SAME: <vscale x 4 x float> [[ZDN_COERCE0:%.*]], <vscale x 4 x float> [[ZDN_COERCE1:%.*]], <vscale x 4 x float> [[ZDN_COERCE2:%.*]], <vscale x 4 x float> [[ZDN_COERCE3:%.*]], <vscale x 4 x float> [[ZM_COERCE0:%.*]], <vscale x 4 x float> [[ZM_COERCE1:%.*]], <vscale x 4 x float> [[ZM_COERCE2:%.*]], <vscale x 4 x float> [[ZM_COERCE3:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.fmul.x4.nxv4f32(<vscale x 4 x float> [[ZDN_COERCE0]], <vscale x 4 x float> [[ZDN_COERCE1]], <vscale x 4 x float> [[ZDN_COERCE2]], <vscale x 4 x float> [[ZDN_COERCE3]], <vscale x 4 x float> [[ZM_COERCE0]], <vscale x 4 x float> [[ZM_COERCE1]], <vscale x 4 x float> [[ZM_COERCE2]], <vscale x 4 x float> [[ZM_COERCE3]])
// CPP-CHECK-NEXT:    ret { <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float> } [[TMP0]]
//
svfloat32x4_t test_svmul_f32_x4(svfloat32x4_t zdn, svfloat32x4_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_f32_x4)(zdn, zm);
}

// CHECK-LABEL: define dso_local { <vscale x 2 x double>, <vscale x 2 x double> } @test_svmul_single_f64_x2(
// CHECK-SAME: <vscale x 2 x double> [[ZDN_COERCE0:%.*]], <vscale x 2 x double> [[ZDN_COERCE1:%.*]], <vscale x 2 x double> [[ZM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.aarch64.sve.fmul.single.x2.nxv2f64(<vscale x 2 x double> [[ZDN_COERCE0]], <vscale x 2 x double> [[ZDN_COERCE1]], <vscale x 2 x double> [[ZM]])
// CHECK-NEXT:    ret { <vscale x 2 x double>, <vscale x 2 x double> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 2 x double>, <vscale x 2 x double> } @_Z24test_svmul_single_f64_x213svfloat64x2_tu13__SVFloat64_t(
// CPP-CHECK-SAME: <vscale x 2 x double> [[ZDN_COERCE0:%.*]], <vscale x 2 x double> [[ZDN_COERCE1:%.*]], <vscale x 2 x double> [[ZM:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.aarch64.sve.fmul.single.x2.nxv2f64(<vscale x 2 x double> [[ZDN_COERCE0]], <vscale x 2 x double> [[ZDN_COERCE1]], <vscale x 2 x double> [[ZM]])
// CPP-CHECK-NEXT:    ret { <vscale x 2 x double>, <vscale x 2 x double> } [[TMP0]]
//
svfloat64x2_t test_svmul_single_f64_x2(svfloat64x2_t zdn, svfloat64_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_single_f64_x2)(zdn, zm);
}
// CHECK-LABEL: define dso_local { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } @test_svmul_single_f64_x4(
// CHECK-SAME: <vscale x 2 x double> [[ZDN_COERCE0:%.*]], <vscale x 2 x double> [[ZDN_COERCE1:%.*]], <vscale x 2 x double> [[ZDN_COERCE2:%.*]], <vscale x 2 x double> [[ZDN_COERCE3:%.*]], <vscale x 2 x double> [[ZM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } @llvm.aarch64.sve.fmul.single.x4.nxv2f64(<vscale x 2 x double> [[ZDN_COERCE0]], <vscale x 2 x double> [[ZDN_COERCE1]], <vscale x 2 x double> [[ZDN_COERCE2]], <vscale x 2 x double> [[ZDN_COERCE3]], <vscale x 2 x double> [[ZM]])
// CHECK-NEXT:    ret { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } @_Z24test_svmul_single_f64_x413svfloat64x4_tu13__SVFloat64_t(
// CPP-CHECK-SAME: <vscale x 2 x double> [[ZDN_COERCE0:%.*]], <vscale x 2 x double> [[ZDN_COERCE1:%.*]], <vscale x 2 x double> [[ZDN_COERCE2:%.*]], <vscale x 2 x double> [[ZDN_COERCE3:%.*]], <vscale x 2 x double> [[ZM:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } @llvm.aarch64.sve.fmul.single.x4.nxv2f64(<vscale x 2 x double> [[ZDN_COERCE0]], <vscale x 2 x double> [[ZDN_COERCE1]], <vscale x 2 x double> [[ZDN_COERCE2]], <vscale x 2 x double> [[ZDN_COERCE3]], <vscale x 2 x double> [[ZM]])
// CPP-CHECK-NEXT:    ret { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } [[TMP0]]
//
svfloat64x4_t test_svmul_single_f64_x4(svfloat64x4_t zdn, svfloat64_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_single_f64_x4)(zdn, zm);
}
// CHECK-LABEL: define dso_local { <vscale x 2 x double>, <vscale x 2 x double> } @test_svmul_f64_x2(
// CHECK-SAME: <vscale x 2 x double> [[ZDN_COERCE0:%.*]], <vscale x 2 x double> [[ZDN_COERCE1:%.*]], <vscale x 2 x double> [[ZM_COERCE0:%.*]], <vscale x 2 x double> [[ZM_COERCE1:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.aarch64.sve.fmul.x2.nxv2f64(<vscale x 2 x double> [[ZDN_COERCE0]], <vscale x 2 x double> [[ZDN_COERCE1]], <vscale x 2 x double> [[ZM_COERCE0]], <vscale x 2 x double> [[ZM_COERCE1]])
// CHECK-NEXT:    ret { <vscale x 2 x double>, <vscale x 2 x double> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 2 x double>, <vscale x 2 x double> } @_Z17test_svmul_f64_x213svfloat64x2_tS_(
// CPP-CHECK-SAME: <vscale x 2 x double> [[ZDN_COERCE0:%.*]], <vscale x 2 x double> [[ZDN_COERCE1:%.*]], <vscale x 2 x double> [[ZM_COERCE0:%.*]], <vscale x 2 x double> [[ZM_COERCE1:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.aarch64.sve.fmul.x2.nxv2f64(<vscale x 2 x double> [[ZDN_COERCE0]], <vscale x 2 x double> [[ZDN_COERCE1]], <vscale x 2 x double> [[ZM_COERCE0]], <vscale x 2 x double> [[ZM_COERCE1]])
// CPP-CHECK-NEXT:    ret { <vscale x 2 x double>, <vscale x 2 x double> } [[TMP0]]
//
svfloat64x2_t test_svmul_f64_x2(svfloat64x2_t zdn, svfloat64x2_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_f64_x2)(zdn, zm);
}
// CHECK-LABEL: define dso_local { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } @test_svmul_f64_x4(
// CHECK-SAME: <vscale x 2 x double> [[ZDN_COERCE0:%.*]], <vscale x 2 x double> [[ZDN_COERCE1:%.*]], <vscale x 2 x double> [[ZDN_COERCE2:%.*]], <vscale x 2 x double> [[ZDN_COERCE3:%.*]], <vscale x 2 x double> [[ZM_COERCE0:%.*]], <vscale x 2 x double> [[ZM_COERCE1:%.*]], <vscale x 2 x double> [[ZM_COERCE2:%.*]], <vscale x 2 x double> [[ZM_COERCE3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } @llvm.aarch64.sve.fmul.x4.nxv2f64(<vscale x 2 x double> [[ZDN_COERCE0]], <vscale x 2 x double> [[ZDN_COERCE1]], <vscale x 2 x double> [[ZDN_COERCE2]], <vscale x 2 x double> [[ZDN_COERCE3]], <vscale x 2 x double> [[ZM_COERCE0]], <vscale x 2 x double> [[ZM_COERCE1]], <vscale x 2 x double> [[ZM_COERCE2]], <vscale x 2 x double> [[ZM_COERCE3]])
// CHECK-NEXT:    ret { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } [[TMP0]]
//
// CPP-CHECK-LABEL: define dso_local { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } @_Z17test_svmul_f64_x413svfloat64x4_tS_(
// CPP-CHECK-SAME: <vscale x 2 x double> [[ZDN_COERCE0:%.*]], <vscale x 2 x double> [[ZDN_COERCE1:%.*]], <vscale x 2 x double> [[ZDN_COERCE2:%.*]], <vscale x 2 x double> [[ZDN_COERCE3:%.*]], <vscale x 2 x double> [[ZM_COERCE0:%.*]], <vscale x 2 x double> [[ZM_COERCE1:%.*]], <vscale x 2 x double> [[ZM_COERCE2:%.*]], <vscale x 2 x double> [[ZM_COERCE3:%.*]]) #[[ATTR0]] {
// CPP-CHECK-NEXT:  [[ENTRY:.*:]]
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = tail call { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } @llvm.aarch64.sve.fmul.x4.nxv2f64(<vscale x 2 x double> [[ZDN_COERCE0]], <vscale x 2 x double> [[ZDN_COERCE1]], <vscale x 2 x double> [[ZDN_COERCE2]], <vscale x 2 x double> [[ZDN_COERCE3]], <vscale x 2 x double> [[ZM_COERCE0]], <vscale x 2 x double> [[ZM_COERCE1]], <vscale x 2 x double> [[ZM_COERCE2]], <vscale x 2 x double> [[ZM_COERCE3]])
// CPP-CHECK-NEXT:    ret { <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double> } [[TMP0]]
//
svfloat64x4_t test_svmul_f64_x4(svfloat64x4_t zdn, svfloat64x4_t zm) __arm_streaming{
  return SVE_ACLE_FUNC(svmul,_f64_x4)(zdn, zm);
}
