# Part of the StreamDVD project

package StreamDVD::Chapter;

use strict;
use vars qw($VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Exporter);
@EXPORT = qw(

);


$VERSION = '0.1';


sub new {                                                  # create new chapter object
   my $class = shift;
   my $self = bless {}, $class;
   my ($num, $length, $cell) = @_;
   $self->num($num) if(defined $num);
   $self->length($length) if(defined $length);
   $self->cell($cell) if(defined $cell);
   return $self;
}



sub num {                                                  # get/set chapter number
   my $self = shift;
   my ($value) = @_;
   $self->{NUM} = $value if(defined $value);
   return $self->{NUM};
}



sub length {                                               # get/set chapter length
   my $self = shift;
   my ($value) = @_;
   $self->{LENGTH} = $value if(defined $value);
   return $self->{LENGTH};
}



sub cell {                                                 # get/set chapter cell
   my $self = shift;
   my ($value) = @_;
   $self->{CELL} = $value if(defined $value);
   return $self->{CELL};
}


1;





package StreamDVD::Title;

use strict;
use vars qw($VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Exporter);
@EXPORT = qw(

);


$VERSION = '0.1';

use StreamDVD::Streams;

sub new {                                                  # create new title object
   my $class = shift;
   my $self = bless {}, $class;
   $self->{AUDIO} = [];
   $self->{SUB} = [];
   $self->{CHAPTER} = [];
   return $self;
}



sub titlenum {                                             # get/set this titles title number on dvd
   my $self = shift;
   my ($value) = @_;
   $self->{TITLE} = $value if(defined $value);
   return $self->{TITLE};
}



sub audio {                                                # get audio track values
   my $self = shift;
   my ($num) = @_;
   if( (defined $num) && (defined $self->{AUDIO}->[$num]) ) {
      return $self->{AUDIO}->[$num]; }
   return 0;
}



sub audio_add {                                            # add audio track
   my $self = shift;
   my ($value) = @_;
   push (@{$self->{AUDIO}}, $value) if(defined $value);
   
   return $self->audio_count();
}



sub audio_remove {                                         # remove audio track
   my $self = shift;
   my ($value) = @_;
   if( (defined $value) && (defined $self->{AUDIO}->[$value]) ) {
      splice(@{$self->{AUDIO}}, $value, 1); }
   return $self->audio_count();
}



sub audio_count {                                          # get number of audio tracks
   my $self = shift;
   return ($#{$self->{AUDIO}} + 1);
}



sub subtitle {                                             # get subtitle language
   my $self = shift;
   my ($value) = @_;
   if( (defined $value) && (defined $self->{SUB}->[$value]) ) {
      return $self->{SUB}->[$value]; }
   return 0;
}



sub subtitle_add {                                         # add new subtitle (language)
   my $self = shift;
   my ($value) = @_;
   push (@{$self->{SUB}}, $value) if(defined $value);
   return $self->subtitle_count();
}



sub subtitle_remove {                                      # remove subtitle
   my $self = shift;
   my ($value) = @_;
   if( (defined $value) && (defined $self->{SUB}->[$value]) ) {
      splice(@{$self->{SUB}}, $value, 1); }
   return $self->subtitle_count();
}



sub subtitle_count {                                       # get number of audio tracks
   my $self = shift;
   return ($#{$self->{SUB}} + 1);
}



sub chapter {                                              # get chapter object
   my $self = shift;
   my ($num) = @_;
   if( (defined $num) && (defined $self->{CHAPTER}->[$num]) ) {
      return $self->{CHAPTER}->[$num]; }
   return 0;
}



sub chapter_add {                                          # add new chapter
   my $self = shift;
   my ($value) = @_;
   push (@{$self->{CHAPTER}}, $value) if(defined $value);
   return $self->chapter_count();
}



sub chapter_remove {                                       # remove chapter
   my $self = shift;
   my ($num) = @_;
   if( (defined $num) && (defined $self->{CHAPTER}->[$num]) ) {
      splice(@{$self->{CHAPTER}}, $num, 1); }
   return $self->chapter_count();
}



sub chapter_count {                                        # get number of chapters
   my $self = shift;
   return ($#{$self->{CHAPTER}} + 1);
}



sub fps {                                                  # get/set frames per second (PAL=25, ...)
   my $self = shift;
   my ($value) = @_;
   $self->{FPS} = $value if(defined $value);
   return $self->{FPS};
}



sub format {                                               # get/set video format (MPEG-2, ...)
   my $self = shift;
   my ($value) = @_;
   $self->{FORMAT} = $value if(defined $value);
   return $self->{FORMAT};
}



sub length {                                               # get/set video length in seconds
   my $self = shift;
   my ($value) = @_;
   $self->{SECONDS} = $value if(defined $value);
   return $self->{SECONDS};
}



sub aspect {                                               # get/set acpect ratio, i.e. 16:9
   my $self = shift;
   my ($value) = @_;
   $self->{ASPECT} = $value if(defined $value);
   return $self->{ASPECT};
}



sub resolution {                                           # get/set video resolution, i.e. 720x576
   my $self = shift;
   my ($value) = @_;
   $self->{RESOLUTION} = $value if(defined $value);
   return $self->{RESOLUTION};
}



sub angle_count {                                          # get/set number of angles
   my $self = shift;
   my ($value) = @_;
   $self->{ANGLE_COUNT} = $value if(defined $value);
   return $self->{ANGLE_COUNT};
}



sub vobsize {                                              # get/set size of complete vob in bytes
   my $self = shift;
   my ($value) = @_;
   $self->{VOBSIZE} = $value if(defined $value);
   return $self->{VOBSIZE};
}




1;

