/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.scm;

import java.awt.Dimension;
import java.awt.Graphics;
import org.me4se.scm.ScmComponent;
import org.me4se.scm.ScmContainer;
import org.me4se.scm.ScmScrollBar;

public class ScmScrollPane
extends ScmContainer {
    ScmComponent contentPane;
    ScmScrollBar verticalBar;

    public boolean scrollRequest(int x, int y, int w, int h) {
        if (y < 0) {
            this.contentPane.y -= y;
            this.repaint();
            return true;
        }
        if (y + h > this.h) {
            this.contentPane.y += this.h - y - h;
            this.repaint();
            return true;
        }
        return false;
    }

    public void setVerticalBar(ScmScrollBar verticalBar) {
        if (this.verticalBar != null) {
            super.remove(verticalBar);
        }
        this.verticalBar = verticalBar;
        if (verticalBar != null) {
            super.add(verticalBar, this.getComponentCount());
        }
    }

    public void add(ScmComponent c, int index) {
        if (this.contentPane != null) {
            throw new RuntimeException("Only one component allowed");
        }
        this.contentPane = c;
        super.add(c, index);
    }

    public void remove(int index) {
        if (this.getComponent(index) == this.contentPane) {
            this.contentPane = null;
        }
        super.remove(index);
    }

    public void paint(Graphics g) {
        if (this.verticalBar != null && this.contentPane != null) {
            this.verticalBar.setValue(-this.contentPane.y);
            this.verticalBar.setMaximum(this.contentPane.h);
            this.verticalBar.setVisibleAmount(this.h);
        }
        super.paint(g);
    }

    public void doLayout() {
        int w = this.w;
        this.contentPane.h = this.contentPane.getMinimumSize().height;
        if (this.verticalBar != null) {
            if (this.contentPane.h > this.h) {
                Dimension d = this.verticalBar.getMinimumSize();
                this.verticalBar.setBounds(w -= d.width, 0, d.width, this.h);
            } else {
                this.verticalBar.setBounds(w, 0, 0, this.h);
            }
        }
        this.contentPane.w = w;
        this.contentPane.doLayout();
    }
}

