/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.decorations;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.controls.decorations.Painter;
import org.jkiss.dbeaver.ui.controls.decorations.SnowflakeAtlas;
import org.jkiss.dbeaver.ui.controls.decorations.SnowflakeIcons;

final class SnowflakePainter
implements Painter {
    private static final double DENSITY = 1.0E-4;
    private static final Point2D.Double SWING = new Point2D.Double(0.1, 1.0);
    private static final Point2D.Double SPEED = new Point2D.Double(40.0, 100.0);
    private static final Point2D.Double AMPLITUDE = new Point2D.Double(25.0, 50.0);
    private final List<Particle> particles = new ArrayList<Particle>();
    private final Random random = new Random();
    private final SnowflakeAtlas atlas;

    public SnowflakePainter(@NotNull Display display) {
        this.atlas = SnowflakeAtlas.generate(display, List.of(SnowflakeIcons.FLAKE_1, SnowflakeIcons.FLAKE_2, SnowflakeIcons.FLAKE_3, SnowflakeIcons.FLAKE_4, SnowflakeIcons.FLAKE_5, SnowflakeIcons.FLAKE_6, SnowflakeIcons.FLAKE_7, SnowflakeIcons.FLAKE_8, SnowflakeIcons.FLAKE_9, SnowflakeIcons.FLAKE_10, SnowflakeIcons.FLAKE_11, SnowflakeIcons.FLAKE_12), new RGB(204.0f, 0.7f, 0.8f), 40, 8, 4);
    }

    @Override
    public void paint(@NotNull GC gc) {
        for (Particle particle : this.particles) {
            this.paint(gc, particle);
        }
    }

    private void paint(@NotNull GC gc, @NotNull Particle particle) {
        Rectangle clip = this.atlas.getClip(particle.type, particle.mip);
        gc.drawImage(this.atlas.image(), clip.x, clip.y, clip.width, clip.height, (int)particle.position.x, (int)particle.position.y, clip.width, clip.height);
    }

    @Override
    public void update(int width, int height, double dt) {
        int limit = SnowflakePainter.computeMaxSnowflakes(width, height);
        Iterator<Particle> it = this.particles.iterator();
        while (it.hasNext()) {
            Particle particle = it.next();
            particle.update(dt);
            int size = this.atlas.getSize(particle.mip);
            if (!(particle.position.y - (double)size > (double)height)) continue;
            if (this.particles.size() <= limit) {
                double origin = this.random.nextDouble(width);
                particle.origin.setLocation(origin, particle.origin.y);
                particle.position.setLocation(origin, -size);
                particle.swing = this.random.nextDouble(100.0);
                continue;
            }
            it.remove();
        }
    }

    @Override
    public void reset(int width, int height) {
        int limit = SnowflakePainter.computeMaxSnowflakes(width, height);
        int i = this.particles.size();
        while (i < limit) {
            this.particles.add(new Particle(new Point2D.Double(this.random.nextDouble(width), -this.random.nextDouble(height)), new Point2D.Double(this.random.nextDouble(SnowflakePainter.SWING.x, SnowflakePainter.SWING.y), this.random.nextDouble(SnowflakePainter.SPEED.x, SnowflakePainter.SPEED.y)), this.random.nextInt(0, this.atlas.count()), this.random.nextInt(0, this.atlas.mips()), this.random.nextDouble(SnowflakePainter.AMPLITUDE.x, SnowflakePainter.AMPLITUDE.y), this.random.nextDouble(100.0)));
            ++i;
        }
    }

    public void dispose() {
        this.particles.clear();
        this.atlas.dispose();
    }

    private static int computeMaxSnowflakes(int width, int height) {
        return (int)Math.max(1.0, (double)(width * height) * 1.0E-4);
    }

    private static class Particle {
        private final Point2D.Double origin;
        private final Point2D.Double position;
        private final Point2D.Double velocity;
        private final int type;
        private final int mip;
        private final double amplitude;
        private double swing;

        Particle(@NotNull Point2D.Double origin, @NotNull Point2D.Double velocity, int type, int mip, double amplitude, double swing) {
            this.origin = origin;
            this.position = (Point2D.Double)origin.clone();
            this.velocity = velocity;
            this.type = type;
            this.mip = mip;
            this.amplitude = amplitude;
            this.swing = swing;
        }

        void update(double deltaTime) {
            this.swing += this.velocity.x * deltaTime;
            this.position.setLocation(this.origin.x + this.amplitude * Math.sin(this.swing), this.position.y + this.velocity.y * deltaTime);
        }
    }
}

