/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.transform.TransformChain;
import org.gradle.api.internal.artifacts.transform.TransformStep;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.ImmutableAttributes;

public class DefaultVariantDefinition
implements VariantDefinition {
    private final DefaultVariantDefinition previous;
    private final ImmutableAttributes attributes;
    private final TransformChain transformChain;
    private final TransformStep transformStep;

    public DefaultVariantDefinition(@Nullable DefaultVariantDefinition previous, ImmutableAttributes attributes, TransformStep transformStep) {
        this.previous = previous;
        this.attributes = attributes;
        this.transformChain = new TransformChain(previous == null ? null : previous.getTransformChain(), transformStep);
        this.transformStep = transformStep;
    }

    @Override
    public ImmutableAttributes getTargetAttributes() {
        return this.attributes;
    }

    @Override
    public TransformChain getTransformChain() {
        return this.transformChain;
    }

    @Override
    public TransformStep getTransformStep() {
        return this.transformStep;
    }

    @Override
    @Nullable
    public VariantDefinition getPrevious() {
        return this.previous;
    }

    private int getDepth() {
        return this.previous == null ? 1 : this.previous.getDepth() + 1;
    }

    public String toString() {
        if (this.previous != null) {
            return this.previous + " <- (" + this.getDepth() + ") " + this.transformStep;
        }
        return "(" + this.getDepth() + ") " + this.transformStep;
    }
}

