/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Properties;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.internal.GUtil;

public class LegacyCacheCleanupEnablement {
    public static final String CACHE_CLEANUP_PROPERTY = "org.gradle.cache.cleanup";
    private final GradleUserHomeDirProvider userHomeDirProvider;

    public LegacyCacheCleanupEnablement(GradleUserHomeDirProvider userHomeDirProvider) {
        this.userHomeDirProvider = userHomeDirProvider;
    }

    public boolean isDisabledByProperty() {
        Properties properties;
        String cleanup;
        File gradleUserHomeDirectory = this.userHomeDirProvider.getGradleUserHomeDirectory();
        File gradleProperties = new File(gradleUserHomeDirectory, "gradle.properties");
        if (gradleProperties.isFile() && (cleanup = (properties = GUtil.loadProperties((File)gradleProperties)).getProperty(CACHE_CLEANUP_PROPERTY)) != null) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateAction((String)"Disabling Gradle user home cache cleanup with the 'org.gradle.cache.cleanup' property").willBeRemovedInGradle9().withUpgradeGuideSection(8, "disabling_user_home_cache_cleanup")).nagUser();
            return cleanup.equals("false");
        }
        return false;
    }
}

