/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.util.ExceptionUtil;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class AbstractError {
    protected final String textNamespace;
    protected final Map<String, String> descriptiveTexts;
    protected final List<XmlElement> extensions;

    protected AbstractError(Map<String, String> descriptiveTexts) {
        this(descriptiveTexts, null);
    }

    protected AbstractError(Map<String, String> descriptiveTexts, List<XmlElement> extensions) {
        this(descriptiveTexts, null, extensions);
    }

    protected AbstractError(Map<String, String> descriptiveTexts, String textNamespace, List<XmlElement> extensions) {
        this.descriptiveTexts = descriptiveTexts != null ? descriptiveTexts : Collections.emptyMap();
        this.textNamespace = textNamespace;
        this.extensions = extensions != null ? extensions : Collections.emptyList();
    }

    public String getDescriptiveText() {
        String[] tags;
        if (this.descriptiveTexts.isEmpty()) {
            return null;
        }
        Locale l = Locale.getDefault();
        for (String tag : tags = new String[]{l.getLanguage() + "-" + l.getCountry() + "-" + l.getVariant(), l.getLanguage() + "-" + l.getCountry(), l.getLanguage(), "en", ""}) {
            String descriptiveText = this.getDescriptiveText(tag);
            if (descriptiveText == null) continue;
            return descriptiveText;
        }
        return this.descriptiveTexts.values().iterator().next();
    }

    public String getDescriptiveText(String xmllang) {
        Objects.requireNonNull(xmllang, "xmllang must not be null");
        return this.descriptiveTexts.get(xmllang);
    }

    public <PE extends XmlElement> PE getExtension(String elementName, String namespace) {
        return PacketUtil.extensionElementFrom(this.extensions, elementName, namespace);
    }

    protected void addDescriptiveTextsAndExtensions(XmlStringBuilder xml) {
        for (Map.Entry<String, String> entry : this.descriptiveTexts.entrySet()) {
            String xmllang = entry.getKey();
            String text = entry.getValue();
            xml.halfOpenElement("text").xmlnsAttribute(this.textNamespace).optXmlLangAttribute(xmllang).rightAngleBracket();
            xml.escape(text);
            xml.closeElement("text");
        }
        xml.append(this.extensions);
    }

    public static abstract class Builder<B extends Builder<B>> {
        protected String textNamespace;
        protected Map<String, String> descriptiveTexts;
        protected List<XmlElement> extensions;

        public B setDescriptiveTexts(Map<String, String> descriptiveTexts) {
            if (descriptiveTexts == null) {
                this.descriptiveTexts = null;
                return this.getThis();
            }
            for (String key : descriptiveTexts.keySet()) {
                if (key != null) continue;
                throw new IllegalArgumentException("descriptiveTexts cannot contain null key");
            }
            if (this.descriptiveTexts == null) {
                this.descriptiveTexts = descriptiveTexts;
            } else {
                this.descriptiveTexts.putAll(descriptiveTexts);
            }
            return this.getThis();
        }

        public B setDescriptiveEnText(String descriptiveEnText) {
            if (this.descriptiveTexts == null) {
                this.descriptiveTexts = new HashMap<String, String>();
            }
            this.descriptiveTexts.put("en", descriptiveEnText);
            return this.getThis();
        }

        public B setDescriptiveEnText(String descriptiveEnText, Exception exception) {
            StringBuilder sb = new StringBuilder(512);
            sb.append(descriptiveEnText).append('\n');
            String stacktrace = ExceptionUtil.getStackTrace(exception);
            sb.append(stacktrace);
            return this.setDescriptiveEnText(sb.toString());
        }

        public B setTextNamespace(String textNamespace) {
            this.textNamespace = textNamespace;
            return this.getThis();
        }

        public B setExtensions(List<XmlElement> extensions) {
            if (this.extensions == null) {
                this.extensions = extensions;
            } else {
                this.extensions.addAll(extensions);
            }
            return this.getThis();
        }

        public B addExtension(XmlElement extension) {
            if (this.extensions == null) {
                this.extensions = new ArrayList<XmlElement>();
            }
            this.extensions.add(extension);
            return this.getThis();
        }

        protected abstract B getThis();
    }
}

