/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnsserverlookup;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.minidns.dnsserverlookup.AbstractDnsServerLookupMechanism;
import org.minidns.dnsserverlookup.DnsServerLookupMechanism;
import org.minidns.util.PlatformDetection;

public class AndroidUsingReflection
extends AbstractDnsServerLookupMechanism {
    public static final DnsServerLookupMechanism INSTANCE = new AndroidUsingReflection();
    public static final int PRIORITY = 1000;
    private final Method systemPropertiesGet;

    protected AndroidUsingReflection() {
        super(AndroidUsingReflection.class.getSimpleName(), 1000);
        Method systemPropertiesGet = null;
        if (PlatformDetection.isAndroid()) {
            try {
                Class<?> SystemProperties2 = Class.forName("android.os.SystemProperties");
                systemPropertiesGet = SystemProperties2.getMethod("get", String.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                LOGGER.log(Level.FINE, "Can not get method handle for android.os.SystemProperties.get(String).", e);
            }
        }
        this.systemPropertiesGet = systemPropertiesGet;
    }

    @Override
    public List<String> getDnsServerAddresses() {
        ArrayList<String> servers = new ArrayList<String>(5);
        for (String propKey : new String[]{"net.dns1", "net.dns2", "net.dns3", "net.dns4"}) {
            InetAddress ip;
            String value;
            try {
                value = (String)this.systemPropertiesGet.invoke(null, propKey);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.log(Level.WARNING, "Exception in findDNSByReflection", e);
                return null;
            }
            if (value == null || value.length() == 0 || servers.contains(value)) continue;
            try {
                ip = InetAddress.getByName(value);
            }
            catch (UnknownHostException e) {
                LOGGER.log(Level.WARNING, "Exception in findDNSByReflection", e);
                continue;
            }
            if (ip == null || (value = ip.getHostAddress()) == null || value.length() == 0 || servers.contains(value)) continue;
            servers.add(value);
        }
        if (servers.size() > 0) {
            return servers;
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return this.systemPropertiesGet != null;
    }
}

