/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldUShort
extends JBBPAbstractField
implements JBBPNumericField {
    private static final long serialVersionUID = 8028734964961601006L;
    private final short value;

    public JBBPFieldUShort(JBBPNamedFieldInfo name, short value) {
        super(name);
        this.value = value;
    }

    public static long reverseBits(short value) {
        int b0 = JBBPUtils.reverseBitsInByte((byte)value) & 0xFF;
        int b1 = JBBPUtils.reverseBitsInByte((byte)(value >> 8)) & 0xFF;
        return (long)(b0 << 8 | b1) & 0xFFFFL;
    }

    @Override
    public double getAsDouble() {
        return this.value & 0xFFFF;
    }

    @Override
    public float getAsFloat() {
        return this.value & 0xFFFF;
    }

    @Override
    public int getAsInt() {
        return this.value & 0xFFFF;
    }

    @Override
    public long getAsLong() {
        return this.getAsInt();
    }

    @Override
    public boolean getAsBool() {
        return this.value != 0;
    }

    @Override
    public long getAsInvertedBitOrder() {
        return JBBPFieldUShort.reverseBits(this.value);
    }

    @Override
    public String getTypeAsString() {
        return "ushort";
    }
}

