// Code generated by go-swagger; DO NOT EDIT.

package activation_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-billing/preview/2020-11-05/models"
)

// NewActivationServiceActivateParams creates a new ActivationServiceActivateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewActivationServiceActivateParams() *ActivationServiceActivateParams {
	return &ActivationServiceActivateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewActivationServiceActivateParamsWithTimeout creates a new ActivationServiceActivateParams object
// with the ability to set a timeout on a request.
func NewActivationServiceActivateParamsWithTimeout(timeout time.Duration) *ActivationServiceActivateParams {
	return &ActivationServiceActivateParams{
		timeout: timeout,
	}
}

// NewActivationServiceActivateParamsWithContext creates a new ActivationServiceActivateParams object
// with the ability to set a context for a request.
func NewActivationServiceActivateParamsWithContext(ctx context.Context) *ActivationServiceActivateParams {
	return &ActivationServiceActivateParams{
		Context: ctx,
	}
}

// NewActivationServiceActivateParamsWithHTTPClient creates a new ActivationServiceActivateParams object
// with the ability to set a custom HTTPClient for a request.
func NewActivationServiceActivateParamsWithHTTPClient(client *http.Client) *ActivationServiceActivateParams {
	return &ActivationServiceActivateParams{
		HTTPClient: client,
	}
}

/*
ActivationServiceActivateParams contains all the parameters to send to the API endpoint

	for the activation service activate operation.

	Typically these are written to a http.Request.
*/
type ActivationServiceActivateParams struct {

	/* ActivationCode.

	   activation_code is the activation code being redeemed.
	*/
	ActivationCode string

	// Body.
	Body *models.ActivationServiceActivateBody

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the activation service activate params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActivationServiceActivateParams) WithDefaults() *ActivationServiceActivateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the activation service activate params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ActivationServiceActivateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the activation service activate params
func (o *ActivationServiceActivateParams) WithTimeout(timeout time.Duration) *ActivationServiceActivateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the activation service activate params
func (o *ActivationServiceActivateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the activation service activate params
func (o *ActivationServiceActivateParams) WithContext(ctx context.Context) *ActivationServiceActivateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the activation service activate params
func (o *ActivationServiceActivateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the activation service activate params
func (o *ActivationServiceActivateParams) WithHTTPClient(client *http.Client) *ActivationServiceActivateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the activation service activate params
func (o *ActivationServiceActivateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActivationCode adds the activationCode to the activation service activate params
func (o *ActivationServiceActivateParams) WithActivationCode(activationCode string) *ActivationServiceActivateParams {
	o.SetActivationCode(activationCode)
	return o
}

// SetActivationCode adds the activationCode to the activation service activate params
func (o *ActivationServiceActivateParams) SetActivationCode(activationCode string) {
	o.ActivationCode = activationCode
}

// WithBody adds the body to the activation service activate params
func (o *ActivationServiceActivateParams) WithBody(body *models.ActivationServiceActivateBody) *ActivationServiceActivateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the activation service activate params
func (o *ActivationServiceActivateParams) SetBody(body *models.ActivationServiceActivateBody) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *ActivationServiceActivateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param activation_code
	if err := r.SetPathParam("activation_code", o.ActivationCode); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
