// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LogService20210330SearchRequest log service 20210330 search request
//
// swagger:model log_service_20210330SearchRequest
type LogService20210330SearchRequest struct {

	// end defines the latest point in time from which to retrieve log entries.
	// Defaults to now.
	// Format: date-time
	End strfmt.DateTime `json:"end,omitempty"`

	// Specifies a page token to use to retrieve the next page.
	NextPageToken string `json:"next_page_token,omitempty"`

	// Specifies the list of per field ordering that should be used for sorting.
	OrderBy []string `json:"order_by"`

	// organization_id is the organization id where the query would be ran.
	OrganizationID string `json:"organization_id,omitempty"`

	// The max number of results per page that should be returned.
	PageSize int64 `json:"page_size,omitempty"`

	// query is the LogQL query that will be sent to loki to retrieve results.
	Query string `json:"query,omitempty"`

	// start defines the earliest point in time from which to retrieve log
	// entries. Defaults to now - 5 minutes
	// Format: date-time
	Start strfmt.DateTime `json:"start,omitempty"`
}

// Validate validates this log service 20210330 search request
func (m *LogService20210330SearchRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEnd(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStart(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330SearchRequest) validateEnd(formats strfmt.Registry) error {
	if swag.IsZero(m.End) { // not required
		return nil
	}

	if err := validate.FormatOf("end", "body", "date-time", m.End.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *LogService20210330SearchRequest) validateStart(formats strfmt.Registry) error {
	if swag.IsZero(m.Start) { // not required
		return nil
	}

	if err := validate.FormatOf("start", "body", "date-time", m.Start.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this log service 20210330 search request based on context it is used
func (m *LogService20210330SearchRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330SearchRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330SearchRequest) UnmarshalBinary(b []byte) error {
	var res LogService20210330SearchRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
