// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// DownloadBoxReader is a Reader for the DownloadBox structure.
type DownloadBoxReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DownloadBoxReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDownloadBoxOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDownloadBoxDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDownloadBoxOK creates a DownloadBoxOK with default headers values
func NewDownloadBoxOK() *DownloadBoxOK {
	return &DownloadBoxOK{}
}

/*
DownloadBoxOK describes a response with status code 200, with default header values.

A successful response.
*/
type DownloadBoxOK struct {
	Payload *models.HashicorpCloudVagrant20220930DownloadBoxResponse
}

// IsSuccess returns true when this download box o k response has a 2xx status code
func (o *DownloadBoxOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this download box o k response has a 3xx status code
func (o *DownloadBoxOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this download box o k response has a 4xx status code
func (o *DownloadBoxOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this download box o k response has a 5xx status code
func (o *DownloadBoxOK) IsServerError() bool {
	return false
}

// IsCode returns true when this download box o k response a status code equal to that given
func (o *DownloadBoxOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the download box o k response
func (o *DownloadBoxOK) Code() int {
	return 200
}

func (o *DownloadBoxOK) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/download][%d] downloadBoxOK  %+v", 200, o.Payload)
}

func (o *DownloadBoxOK) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/download][%d] downloadBoxOK  %+v", 200, o.Payload)
}

func (o *DownloadBoxOK) GetPayload() *models.HashicorpCloudVagrant20220930DownloadBoxResponse {
	return o.Payload
}

func (o *DownloadBoxOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930DownloadBoxResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadBoxDefault creates a DownloadBoxDefault with default headers values
func NewDownloadBoxDefault(code int) *DownloadBoxDefault {
	return &DownloadBoxDefault{
		_statusCode: code,
	}
}

/*
DownloadBoxDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DownloadBoxDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this download box default response has a 2xx status code
func (o *DownloadBoxDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this download box default response has a 3xx status code
func (o *DownloadBoxDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this download box default response has a 4xx status code
func (o *DownloadBoxDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this download box default response has a 5xx status code
func (o *DownloadBoxDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this download box default response a status code equal to that given
func (o *DownloadBoxDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the download box default response
func (o *DownloadBoxDefault) Code() int {
	return o._statusCode
}

func (o *DownloadBoxDefault) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/download][%d] DownloadBox default  %+v", o._statusCode, o.Payload)
}

func (o *DownloadBoxDefault) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}/download][%d] DownloadBox default  %+v", o._statusCode, o.Payload)
}

func (o *DownloadBoxDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *DownloadBoxDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
