// Code generated by go-swagger; DO NOT EDIT.

package activation_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-billing/preview/2020-11-05/models"
)

// ActivationServiceActivateReader is a Reader for the ActivationServiceActivate structure.
type ActivationServiceActivateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ActivationServiceActivateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewActivationServiceActivateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewActivationServiceActivateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewActivationServiceActivateOK creates a ActivationServiceActivateOK with default headers values
func NewActivationServiceActivateOK() *ActivationServiceActivateOK {
	return &ActivationServiceActivateOK{}
}

/*
ActivationServiceActivateOK describes a response with status code 200, with default header values.

A successful response.
*/
type ActivationServiceActivateOK struct {
	Payload models.Billing20201105ActivateResponse
}

// IsSuccess returns true when this activation service activate o k response has a 2xx status code
func (o *ActivationServiceActivateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this activation service activate o k response has a 3xx status code
func (o *ActivationServiceActivateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this activation service activate o k response has a 4xx status code
func (o *ActivationServiceActivateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this activation service activate o k response has a 5xx status code
func (o *ActivationServiceActivateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this activation service activate o k response a status code equal to that given
func (o *ActivationServiceActivateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the activation service activate o k response
func (o *ActivationServiceActivateOK) Code() int {
	return 200
}

func (o *ActivationServiceActivateOK) Error() string {
	return fmt.Sprintf("[POST /billing/2020-11-05/activations/{activation_code}][%d] activationServiceActivateOK  %+v", 200, o.Payload)
}

func (o *ActivationServiceActivateOK) String() string {
	return fmt.Sprintf("[POST /billing/2020-11-05/activations/{activation_code}][%d] activationServiceActivateOK  %+v", 200, o.Payload)
}

func (o *ActivationServiceActivateOK) GetPayload() models.Billing20201105ActivateResponse {
	return o.Payload
}

func (o *ActivationServiceActivateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewActivationServiceActivateDefault creates a ActivationServiceActivateDefault with default headers values
func NewActivationServiceActivateDefault(code int) *ActivationServiceActivateDefault {
	return &ActivationServiceActivateDefault{
		_statusCode: code,
	}
}

/*
ActivationServiceActivateDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ActivationServiceActivateDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this activation service activate default response has a 2xx status code
func (o *ActivationServiceActivateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this activation service activate default response has a 3xx status code
func (o *ActivationServiceActivateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this activation service activate default response has a 4xx status code
func (o *ActivationServiceActivateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this activation service activate default response has a 5xx status code
func (o *ActivationServiceActivateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this activation service activate default response a status code equal to that given
func (o *ActivationServiceActivateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the activation service activate default response
func (o *ActivationServiceActivateDefault) Code() int {
	return o._statusCode
}

func (o *ActivationServiceActivateDefault) Error() string {
	return fmt.Sprintf("[POST /billing/2020-11-05/activations/{activation_code}][%d] ActivationService_Activate default  %+v", o._statusCode, o.Payload)
}

func (o *ActivationServiceActivateDefault) String() string {
	return fmt.Sprintf("[POST /billing/2020-11-05/activations/{activation_code}][%d] ActivationService_Activate default  %+v", o._statusCode, o.Payload)
}

func (o *ActivationServiceActivateDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ActivationServiceActivateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
