// Code generated by go-swagger; DO NOT EDIT.

package invitations_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// InvitationsServiceCreateOrganizationInvitationsReader is a Reader for the InvitationsServiceCreateOrganizationInvitations structure.
type InvitationsServiceCreateOrganizationInvitationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *InvitationsServiceCreateOrganizationInvitationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewInvitationsServiceCreateOrganizationInvitationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewInvitationsServiceCreateOrganizationInvitationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewInvitationsServiceCreateOrganizationInvitationsOK creates a InvitationsServiceCreateOrganizationInvitationsOK with default headers values
func NewInvitationsServiceCreateOrganizationInvitationsOK() *InvitationsServiceCreateOrganizationInvitationsOK {
	return &InvitationsServiceCreateOrganizationInvitationsOK{}
}

/*
InvitationsServiceCreateOrganizationInvitationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type InvitationsServiceCreateOrganizationInvitationsOK struct {
	Payload models.HashicorpCloudIamCreateOrganizationInvitationsResponse
}

// IsSuccess returns true when this invitations service create organization invitations o k response has a 2xx status code
func (o *InvitationsServiceCreateOrganizationInvitationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this invitations service create organization invitations o k response has a 3xx status code
func (o *InvitationsServiceCreateOrganizationInvitationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this invitations service create organization invitations o k response has a 4xx status code
func (o *InvitationsServiceCreateOrganizationInvitationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this invitations service create organization invitations o k response has a 5xx status code
func (o *InvitationsServiceCreateOrganizationInvitationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this invitations service create organization invitations o k response a status code equal to that given
func (o *InvitationsServiceCreateOrganizationInvitationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the invitations service create organization invitations o k response
func (o *InvitationsServiceCreateOrganizationInvitationsOK) Code() int {
	return 200
}

func (o *InvitationsServiceCreateOrganizationInvitationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/invitations][%d] invitationsServiceCreateOrganizationInvitationsOK %s", 200, payload)
}

func (o *InvitationsServiceCreateOrganizationInvitationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/invitations][%d] invitationsServiceCreateOrganizationInvitationsOK %s", 200, payload)
}

func (o *InvitationsServiceCreateOrganizationInvitationsOK) GetPayload() models.HashicorpCloudIamCreateOrganizationInvitationsResponse {
	return o.Payload
}

func (o *InvitationsServiceCreateOrganizationInvitationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInvitationsServiceCreateOrganizationInvitationsDefault creates a InvitationsServiceCreateOrganizationInvitationsDefault with default headers values
func NewInvitationsServiceCreateOrganizationInvitationsDefault(code int) *InvitationsServiceCreateOrganizationInvitationsDefault {
	return &InvitationsServiceCreateOrganizationInvitationsDefault{
		_statusCode: code,
	}
}

/*
InvitationsServiceCreateOrganizationInvitationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type InvitationsServiceCreateOrganizationInvitationsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this invitations service create organization invitations default response has a 2xx status code
func (o *InvitationsServiceCreateOrganizationInvitationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this invitations service create organization invitations default response has a 3xx status code
func (o *InvitationsServiceCreateOrganizationInvitationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this invitations service create organization invitations default response has a 4xx status code
func (o *InvitationsServiceCreateOrganizationInvitationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this invitations service create organization invitations default response has a 5xx status code
func (o *InvitationsServiceCreateOrganizationInvitationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this invitations service create organization invitations default response a status code equal to that given
func (o *InvitationsServiceCreateOrganizationInvitationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the invitations service create organization invitations default response
func (o *InvitationsServiceCreateOrganizationInvitationsDefault) Code() int {
	return o._statusCode
}

func (o *InvitationsServiceCreateOrganizationInvitationsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/invitations][%d] InvitationsService_CreateOrganizationInvitations default %s", o._statusCode, payload)
}

func (o *InvitationsServiceCreateOrganizationInvitationsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/invitations][%d] InvitationsService_CreateOrganizationInvitations default %s", o._statusCode, payload)
}

func (o *InvitationsServiceCreateOrganizationInvitationsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *InvitationsServiceCreateOrganizationInvitationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
InvitationsServiceCreateOrganizationInvitationsBody CreateOrganizationInvitationsRequest is a request to create an organization invitation.
// Inviting multiple people at the same time is supported.
swagger:model InvitationsServiceCreateOrganizationInvitationsBody
*/
type InvitationsServiceCreateOrganizationInvitationsBody struct {

	// invitations is a list of the data for the invitations that should be created.
	Invitations []*models.HashicorpCloudIamNewOrganizationInvitation `json:"invitations"`
}

// Validate validates this invitations service create organization invitations body
func (o *InvitationsServiceCreateOrganizationInvitationsBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateInvitations(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *InvitationsServiceCreateOrganizationInvitationsBody) validateInvitations(formats strfmt.Registry) error {
	if swag.IsZero(o.Invitations) { // not required
		return nil
	}

	for i := 0; i < len(o.Invitations); i++ {
		if swag.IsZero(o.Invitations[i]) { // not required
			continue
		}

		if o.Invitations[i] != nil {
			if err := o.Invitations[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("body" + "." + "invitations" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("body" + "." + "invitations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this invitations service create organization invitations body based on the context it is used
func (o *InvitationsServiceCreateOrganizationInvitationsBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateInvitations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *InvitationsServiceCreateOrganizationInvitationsBody) contextValidateInvitations(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Invitations); i++ {

		if o.Invitations[i] != nil {

			if swag.IsZero(o.Invitations[i]) { // not required
				return nil
			}

			if err := o.Invitations[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("body" + "." + "invitations" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("body" + "." + "invitations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *InvitationsServiceCreateOrganizationInvitationsBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *InvitationsServiceCreateOrganizationInvitationsBody) UnmarshalBinary(b []byte) error {
	var res InvitationsServiceCreateOrganizationInvitationsBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
