// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeleteAppParams creates a new DeleteAppParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteAppParams() *DeleteAppParams {
	return &DeleteAppParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteAppParamsWithTimeout creates a new DeleteAppParams object
// with the ability to set a timeout on a request.
func NewDeleteAppParamsWithTimeout(timeout time.Duration) *DeleteAppParams {
	return &DeleteAppParams{
		timeout: timeout,
	}
}

// NewDeleteAppParamsWithContext creates a new DeleteAppParams object
// with the ability to set a context for a request.
func NewDeleteAppParamsWithContext(ctx context.Context) *DeleteAppParams {
	return &DeleteAppParams{
		Context: ctx,
	}
}

// NewDeleteAppParamsWithHTTPClient creates a new DeleteAppParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteAppParamsWithHTTPClient(client *http.Client) *DeleteAppParams {
	return &DeleteAppParams{
		HTTPClient: client,
	}
}

/*
DeleteAppParams contains all the parameters to send to the API endpoint

	for the delete app operation.

	Typically these are written to a http.Request.
*/
type DeleteAppParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	// Name.
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete app params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteAppParams) WithDefaults() *DeleteAppParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete app params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteAppParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete app params
func (o *DeleteAppParams) WithTimeout(timeout time.Duration) *DeleteAppParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete app params
func (o *DeleteAppParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete app params
func (o *DeleteAppParams) WithContext(ctx context.Context) *DeleteAppParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete app params
func (o *DeleteAppParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete app params
func (o *DeleteAppParams) WithHTTPClient(client *http.Client) *DeleteAppParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete app params
func (o *DeleteAppParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the delete app params
func (o *DeleteAppParams) WithLocationOrganizationID(locationOrganizationID string) *DeleteAppParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the delete app params
func (o *DeleteAppParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the delete app params
func (o *DeleteAppParams) WithLocationProjectID(locationProjectID string) *DeleteAppParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the delete app params
func (o *DeleteAppParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the delete app params
func (o *DeleteAppParams) WithLocationRegionProvider(locationRegionProvider *string) *DeleteAppParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the delete app params
func (o *DeleteAppParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the delete app params
func (o *DeleteAppParams) WithLocationRegionRegion(locationRegionRegion *string) *DeleteAppParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the delete app params
func (o *DeleteAppParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithName adds the name to the delete app params
func (o *DeleteAppParams) WithName(name string) *DeleteAppParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the delete app params
func (o *DeleteAppParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteAppParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
