// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// UpdateAppDynamicSecretReader is a Reader for the UpdateAppDynamicSecret structure.
type UpdateAppDynamicSecretReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateAppDynamicSecretReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateAppDynamicSecretOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateAppDynamicSecretDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateAppDynamicSecretOK creates a UpdateAppDynamicSecretOK with default headers values
func NewUpdateAppDynamicSecretOK() *UpdateAppDynamicSecretOK {
	return &UpdateAppDynamicSecretOK{}
}

/*
UpdateAppDynamicSecretOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateAppDynamicSecretOK struct {
	Payload *models.Secrets20231128UpdateAppDynamicSecretResponse
}

// IsSuccess returns true when this update app dynamic secret o k response has a 2xx status code
func (o *UpdateAppDynamicSecretOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update app dynamic secret o k response has a 3xx status code
func (o *UpdateAppDynamicSecretOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update app dynamic secret o k response has a 4xx status code
func (o *UpdateAppDynamicSecretOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update app dynamic secret o k response has a 5xx status code
func (o *UpdateAppDynamicSecretOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update app dynamic secret o k response a status code equal to that given
func (o *UpdateAppDynamicSecretOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update app dynamic secret o k response
func (o *UpdateAppDynamicSecretOK) Code() int {
	return 200
}

func (o *UpdateAppDynamicSecretOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic/{name}][%d] updateAppDynamicSecretOK %s", 200, payload)
}

func (o *UpdateAppDynamicSecretOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic/{name}][%d] updateAppDynamicSecretOK %s", 200, payload)
}

func (o *UpdateAppDynamicSecretOK) GetPayload() *models.Secrets20231128UpdateAppDynamicSecretResponse {
	return o.Payload
}

func (o *UpdateAppDynamicSecretOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128UpdateAppDynamicSecretResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateAppDynamicSecretDefault creates a UpdateAppDynamicSecretDefault with default headers values
func NewUpdateAppDynamicSecretDefault(code int) *UpdateAppDynamicSecretDefault {
	return &UpdateAppDynamicSecretDefault{
		_statusCode: code,
	}
}

/*
UpdateAppDynamicSecretDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateAppDynamicSecretDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this update app dynamic secret default response has a 2xx status code
func (o *UpdateAppDynamicSecretDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update app dynamic secret default response has a 3xx status code
func (o *UpdateAppDynamicSecretDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update app dynamic secret default response has a 4xx status code
func (o *UpdateAppDynamicSecretDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update app dynamic secret default response has a 5xx status code
func (o *UpdateAppDynamicSecretDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update app dynamic secret default response a status code equal to that given
func (o *UpdateAppDynamicSecretDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update app dynamic secret default response
func (o *UpdateAppDynamicSecretDefault) Code() int {
	return o._statusCode
}

func (o *UpdateAppDynamicSecretDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic/{name}][%d] UpdateAppDynamicSecret default %s", o._statusCode, payload)
}

func (o *UpdateAppDynamicSecretDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic/{name}][%d] UpdateAppDynamicSecret default %s", o._statusCode, payload)
}

func (o *UpdateAppDynamicSecretDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *UpdateAppDynamicSecretDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
