// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceGetApplicationTemplate3Reader is a Reader for the WaypointServiceGetApplicationTemplate3 structure.
type WaypointServiceGetApplicationTemplate3Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceGetApplicationTemplate3Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceGetApplicationTemplate3OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceGetApplicationTemplate3Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceGetApplicationTemplate3OK creates a WaypointServiceGetApplicationTemplate3OK with default headers values
func NewWaypointServiceGetApplicationTemplate3OK() *WaypointServiceGetApplicationTemplate3OK {
	return &WaypointServiceGetApplicationTemplate3OK{}
}

/*
WaypointServiceGetApplicationTemplate3OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceGetApplicationTemplate3OK struct {
	Payload *models.HashicorpCloudWaypointGetApplicationTemplateResponse
}

// IsSuccess returns true when this waypoint service get application template3 o k response has a 2xx status code
func (o *WaypointServiceGetApplicationTemplate3OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service get application template3 o k response has a 3xx status code
func (o *WaypointServiceGetApplicationTemplate3OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service get application template3 o k response has a 4xx status code
func (o *WaypointServiceGetApplicationTemplate3OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service get application template3 o k response has a 5xx status code
func (o *WaypointServiceGetApplicationTemplate3OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service get application template3 o k response a status code equal to that given
func (o *WaypointServiceGetApplicationTemplate3OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service get application template3 o k response
func (o *WaypointServiceGetApplicationTemplate3OK) Code() int {
	return 200
}

func (o *WaypointServiceGetApplicationTemplate3OK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/templates/{application_template.id}][%d] waypointServiceGetApplicationTemplate3OK %s", 200, payload)
}

func (o *WaypointServiceGetApplicationTemplate3OK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/templates/{application_template.id}][%d] waypointServiceGetApplicationTemplate3OK %s", 200, payload)
}

func (o *WaypointServiceGetApplicationTemplate3OK) GetPayload() *models.HashicorpCloudWaypointGetApplicationTemplateResponse {
	return o.Payload
}

func (o *WaypointServiceGetApplicationTemplate3OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointGetApplicationTemplateResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceGetApplicationTemplate3Default creates a WaypointServiceGetApplicationTemplate3Default with default headers values
func NewWaypointServiceGetApplicationTemplate3Default(code int) *WaypointServiceGetApplicationTemplate3Default {
	return &WaypointServiceGetApplicationTemplate3Default{
		_statusCode: code,
	}
}

/*
WaypointServiceGetApplicationTemplate3Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceGetApplicationTemplate3Default struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service get application template3 default response has a 2xx status code
func (o *WaypointServiceGetApplicationTemplate3Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service get application template3 default response has a 3xx status code
func (o *WaypointServiceGetApplicationTemplate3Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service get application template3 default response has a 4xx status code
func (o *WaypointServiceGetApplicationTemplate3Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service get application template3 default response has a 5xx status code
func (o *WaypointServiceGetApplicationTemplate3Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service get application template3 default response a status code equal to that given
func (o *WaypointServiceGetApplicationTemplate3Default) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service get application template3 default response
func (o *WaypointServiceGetApplicationTemplate3Default) Code() int {
	return o._statusCode
}

func (o *WaypointServiceGetApplicationTemplate3Default) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/templates/{application_template.id}][%d] WaypointService_GetApplicationTemplate3 default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetApplicationTemplate3Default) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/templates/{application_template.id}][%d] WaypointService_GetApplicationTemplate3 default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetApplicationTemplate3Default) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceGetApplicationTemplate3Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
