// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceCreateNamespaceReader is a Reader for the WaypointServiceCreateNamespace structure.
type WaypointServiceCreateNamespaceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceCreateNamespaceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceCreateNamespaceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceCreateNamespaceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceCreateNamespaceOK creates a WaypointServiceCreateNamespaceOK with default headers values
func NewWaypointServiceCreateNamespaceOK() *WaypointServiceCreateNamespaceOK {
	return &WaypointServiceCreateNamespaceOK{}
}

/*
WaypointServiceCreateNamespaceOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceCreateNamespaceOK struct {
	Payload *models.HashicorpCloudWaypointCreateNamespaceResponse
}

// IsSuccess returns true when this waypoint service create namespace o k response has a 2xx status code
func (o *WaypointServiceCreateNamespaceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service create namespace o k response has a 3xx status code
func (o *WaypointServiceCreateNamespaceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service create namespace o k response has a 4xx status code
func (o *WaypointServiceCreateNamespaceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service create namespace o k response has a 5xx status code
func (o *WaypointServiceCreateNamespaceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service create namespace o k response a status code equal to that given
func (o *WaypointServiceCreateNamespaceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service create namespace o k response
func (o *WaypointServiceCreateNamespaceOK) Code() int {
	return 200
}

func (o *WaypointServiceCreateNamespaceOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{location.organization_id}/projects/{location.project_id}/namespaces][%d] waypointServiceCreateNamespaceOK %s", 200, payload)
}

func (o *WaypointServiceCreateNamespaceOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{location.organization_id}/projects/{location.project_id}/namespaces][%d] waypointServiceCreateNamespaceOK %s", 200, payload)
}

func (o *WaypointServiceCreateNamespaceOK) GetPayload() *models.HashicorpCloudWaypointCreateNamespaceResponse {
	return o.Payload
}

func (o *WaypointServiceCreateNamespaceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointCreateNamespaceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceCreateNamespaceDefault creates a WaypointServiceCreateNamespaceDefault with default headers values
func NewWaypointServiceCreateNamespaceDefault(code int) *WaypointServiceCreateNamespaceDefault {
	return &WaypointServiceCreateNamespaceDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceCreateNamespaceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceCreateNamespaceDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service create namespace default response has a 2xx status code
func (o *WaypointServiceCreateNamespaceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service create namespace default response has a 3xx status code
func (o *WaypointServiceCreateNamespaceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service create namespace default response has a 4xx status code
func (o *WaypointServiceCreateNamespaceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service create namespace default response has a 5xx status code
func (o *WaypointServiceCreateNamespaceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service create namespace default response a status code equal to that given
func (o *WaypointServiceCreateNamespaceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service create namespace default response
func (o *WaypointServiceCreateNamespaceDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceCreateNamespaceDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{location.organization_id}/projects/{location.project_id}/namespaces][%d] WaypointService_CreateNamespace default %s", o._statusCode, payload)
}

func (o *WaypointServiceCreateNamespaceDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{location.organization_id}/projects/{location.project_id}/namespaces][%d] WaypointService_CreateNamespace default %s", o._statusCode, payload)
}

func (o *WaypointServiceCreateNamespaceDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceCreateNamespaceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
