#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 588
#define LARGE_STATE_COUNT 14
#define SYMBOL_COUNT 114
#define ALIAS_COUNT 0
#define TOKEN_COUNT 60
#define EXTERNAL_TOKEN_COUNT 4
#define FIELD_COUNT 8
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 18

enum {
  anon_sym_and = 1,
  anon_sym_or = 2,
  anon_sym_PIPE_PIPE = 3,
  anon_sym_AMP_AMP = 4,
  sym_stream_redirect = 5,
  sym_direction = 6,
  anon_sym_PIPE = 7,
  anon_sym_SEMI = 8,
  anon_sym_AMP = 9,
  anon_sym_LF = 10,
  anon_sym_CR = 11,
  anon_sym_CR_LF = 12,
  anon_sym_BANG = 13,
  anon_sym_not = 14,
  anon_sym_DOLLAR = 15,
  anon_sym_LPAREN = 16,
  anon_sym_RPAREN = 17,
  anon_sym_function = 18,
  anon_sym_end = 19,
  sym_integer = 20,
  sym_float = 21,
  anon_sym_return = 22,
  anon_sym_switch = 23,
  anon_sym_case = 24,
  sym_break = 25,
  sym_continue = 26,
  anon_sym_for = 27,
  anon_sym_in = 28,
  anon_sym_while = 29,
  anon_sym_if = 30,
  anon_sym_else = 31,
  anon_sym_begin = 32,
  aux_sym_test_command_token1 = 33,
  anon_sym_RBRACK = 34,
  anon_sym_test = 35,
  anon_sym_EQ = 36,
  anon_sym_BANG_EQ = 37,
  aux_sym_test_option_token1 = 38,
  sym_comment = 39,
  sym_variable_name = 40,
  anon_sym_DOT_DOT = 41,
  anon_sym_LBRACK = 42,
  anon_sym_LBRACE = 43,
  anon_sym_COMMA = 44,
  anon_sym_RBRACE = 45,
  anon_sym_DQUOTE = 46,
  aux_sym_double_quote_string_token1 = 47,
  anon_sym_SQUOTE = 48,
  aux_sym_single_quote_string_token1 = 49,
  sym_escape_sequence = 50,
  sym__special_character = 51,
  sym_home_dir_expansion = 52,
  sym_glob = 53,
  sym_word = 54,
  sym_brace_word = 55,
  sym__concat = 56,
  sym__concat_oct = 57,
  sym__brace_concat = 58,
  sym__concat_list = 59,
  sym_program = 60,
  sym_conditional_execution = 61,
  sym_redirected_statement = 62,
  sym_file_redirect = 63,
  sym_pipe = 64,
  sym__terminated_statement = 65,
  sym__terminated_opt_statement = 66,
  sym_negated_statement = 67,
  sym_command_substitution_dollar = 68,
  sym_command_substitution_fish = 69,
  sym_command_substitution = 70,
  sym_function_definition = 71,
  sym_return = 72,
  sym_switch_statement = 73,
  sym_case_clause = 74,
  sym_for_statement = 75,
  sym_while_statement = 76,
  sym_if_statement = 77,
  sym_else_if_clause = 78,
  sym_else_clause = 79,
  sym_begin_statement = 80,
  sym_test_command = 81,
  sym__test_expression = 82,
  sym_test_option = 83,
  sym_variable_expansion = 84,
  sym_index = 85,
  sym_range = 86,
  sym_list_element_access = 87,
  sym_brace_expansion = 88,
  sym_double_quote_string = 89,
  sym_single_quote_string = 90,
  sym_command = 91,
  sym_concatenation = 92,
  sym__expression = 93,
  sym_brace_concatenation = 94,
  sym__brace_expression = 95,
  sym__base_brace_expression = 96,
  aux_sym_program_repeat1 = 97,
  aux_sym_function_definition_repeat1 = 98,
  aux_sym_function_definition_repeat2 = 99,
  aux_sym_switch_statement_repeat1 = 100,
  aux_sym_case_clause_repeat1 = 101,
  aux_sym_for_statement_repeat1 = 102,
  aux_sym_while_statement_repeat1 = 103,
  aux_sym_if_statement_repeat1 = 104,
  aux_sym_test_command_repeat1 = 105,
  aux_sym_variable_expansion_repeat1 = 106,
  aux_sym_list_element_access_repeat1 = 107,
  aux_sym_brace_expansion_repeat1 = 108,
  aux_sym_double_quote_string_repeat1 = 109,
  aux_sym_single_quote_string_repeat1 = 110,
  aux_sym_command_repeat1 = 111,
  aux_sym_concatenation_repeat1 = 112,
  aux_sym_brace_concatenation_repeat1 = 113,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [sym_stream_redirect] = "stream_redirect",
  [sym_direction] = "direction",
  [anon_sym_PIPE] = "|",
  [anon_sym_SEMI] = ";",
  [anon_sym_AMP] = "&",
  [anon_sym_LF] = "\n",
  [anon_sym_CR] = "\r",
  [anon_sym_CR_LF] = "\r\n",
  [anon_sym_BANG] = "!",
  [anon_sym_not] = "not",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_function] = "function",
  [anon_sym_end] = "end",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_return] = "return",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [sym_break] = "break",
  [sym_continue] = "continue",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_begin] = "begin",
  [aux_sym_test_command_token1] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_test] = "test",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG_EQ] = "!=",
  [aux_sym_test_option_token1] = "test_option_token1",
  [sym_comment] = "comment",
  [sym_variable_name] = "variable_name",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_LBRACK] = "[",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_double_quote_string_token1] = "double_quote_string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_single_quote_string_token1] = "single_quote_string_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym__special_character] = "_special_character",
  [sym_home_dir_expansion] = "home_dir_expansion",
  [sym_glob] = "glob",
  [sym_word] = "word",
  [sym_brace_word] = "word",
  [sym__concat] = "_concat",
  [sym__concat_oct] = "_concat_oct",
  [sym__brace_concat] = "_brace_concat",
  [sym__concat_list] = "_concat_list",
  [sym_program] = "program",
  [sym_conditional_execution] = "conditional_execution",
  [sym_redirected_statement] = "redirected_statement",
  [sym_file_redirect] = "file_redirect",
  [sym_pipe] = "pipe",
  [sym__terminated_statement] = "_terminated_statement",
  [sym__terminated_opt_statement] = "_terminated_opt_statement",
  [sym_negated_statement] = "negated_statement",
  [sym_command_substitution_dollar] = "command_substitution_dollar",
  [sym_command_substitution_fish] = "command_substitution_fish",
  [sym_command_substitution] = "command_substitution",
  [sym_function_definition] = "function_definition",
  [sym_return] = "return",
  [sym_switch_statement] = "switch_statement",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_if_clause] = "else_if_clause",
  [sym_else_clause] = "else_clause",
  [sym_begin_statement] = "begin_statement",
  [sym_test_command] = "test_command",
  [sym__test_expression] = "_test_expression",
  [sym_test_option] = "test_option",
  [sym_variable_expansion] = "variable_expansion",
  [sym_index] = "index",
  [sym_range] = "range",
  [sym_list_element_access] = "list_element_access",
  [sym_brace_expansion] = "brace_expansion",
  [sym_double_quote_string] = "double_quote_string",
  [sym_single_quote_string] = "single_quote_string",
  [sym_command] = "command",
  [sym_concatenation] = "concatenation",
  [sym__expression] = "_expression",
  [sym_brace_concatenation] = "concatenation",
  [sym__brace_expression] = "_brace_expression",
  [sym__base_brace_expression] = "_base_brace_expression",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_function_definition_repeat2] = "function_definition_repeat2",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_while_statement_repeat1] = "while_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_test_command_repeat1] = "test_command_repeat1",
  [aux_sym_variable_expansion_repeat1] = "variable_expansion_repeat1",
  [aux_sym_list_element_access_repeat1] = "list_element_access_repeat1",
  [aux_sym_brace_expansion_repeat1] = "brace_expansion_repeat1",
  [aux_sym_double_quote_string_repeat1] = "double_quote_string_repeat1",
  [aux_sym_single_quote_string_repeat1] = "single_quote_string_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_brace_concatenation_repeat1] = "brace_concatenation_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [sym_stream_redirect] = sym_stream_redirect,
  [sym_direction] = sym_direction,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR] = anon_sym_CR,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_end] = anon_sym_end,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [sym_break] = sym_break,
  [sym_continue] = sym_continue,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_begin] = anon_sym_begin,
  [aux_sym_test_command_token1] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_test] = anon_sym_test,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [aux_sym_test_option_token1] = aux_sym_test_option_token1,
  [sym_comment] = sym_comment,
  [sym_variable_name] = sym_variable_name,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_double_quote_string_token1] = aux_sym_double_quote_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_single_quote_string_token1] = aux_sym_single_quote_string_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__special_character] = sym__special_character,
  [sym_home_dir_expansion] = sym_home_dir_expansion,
  [sym_glob] = sym_glob,
  [sym_word] = sym_word,
  [sym_brace_word] = sym_word,
  [sym__concat] = sym__concat,
  [sym__concat_oct] = sym__concat_oct,
  [sym__brace_concat] = sym__brace_concat,
  [sym__concat_list] = sym__concat_list,
  [sym_program] = sym_program,
  [sym_conditional_execution] = sym_conditional_execution,
  [sym_redirected_statement] = sym_redirected_statement,
  [sym_file_redirect] = sym_file_redirect,
  [sym_pipe] = sym_pipe,
  [sym__terminated_statement] = sym__terminated_statement,
  [sym__terminated_opt_statement] = sym__terminated_opt_statement,
  [sym_negated_statement] = sym_negated_statement,
  [sym_command_substitution_dollar] = sym_command_substitution_dollar,
  [sym_command_substitution_fish] = sym_command_substitution_fish,
  [sym_command_substitution] = sym_command_substitution,
  [sym_function_definition] = sym_function_definition,
  [sym_return] = sym_return,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_if_clause] = sym_else_if_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_begin_statement] = sym_begin_statement,
  [sym_test_command] = sym_test_command,
  [sym__test_expression] = sym__test_expression,
  [sym_test_option] = sym_test_option,
  [sym_variable_expansion] = sym_variable_expansion,
  [sym_index] = sym_index,
  [sym_range] = sym_range,
  [sym_list_element_access] = sym_list_element_access,
  [sym_brace_expansion] = sym_brace_expansion,
  [sym_double_quote_string] = sym_double_quote_string,
  [sym_single_quote_string] = sym_single_quote_string,
  [sym_command] = sym_command,
  [sym_concatenation] = sym_concatenation,
  [sym__expression] = sym__expression,
  [sym_brace_concatenation] = sym_concatenation,
  [sym__brace_expression] = sym__brace_expression,
  [sym__base_brace_expression] = sym__base_brace_expression,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_function_definition_repeat2] = aux_sym_function_definition_repeat2,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_while_statement_repeat1] = aux_sym_while_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_test_command_repeat1] = aux_sym_test_command_repeat1,
  [aux_sym_variable_expansion_repeat1] = aux_sym_variable_expansion_repeat1,
  [aux_sym_list_element_access_repeat1] = aux_sym_list_element_access_repeat1,
  [aux_sym_brace_expansion_repeat1] = aux_sym_brace_expansion_repeat1,
  [aux_sym_double_quote_string_repeat1] = aux_sym_double_quote_string_repeat1,
  [aux_sym_single_quote_string_repeat1] = aux_sym_single_quote_string_repeat1,
  [aux_sym_command_repeat1] = aux_sym_command_repeat1,
  [aux_sym_concatenation_repeat1] = aux_sym_concatenation_repeat1,
  [aux_sym_brace_concatenation_repeat1] = aux_sym_brace_concatenation_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_stream_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_direction] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_continue] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_test_command_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_test] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_test_option_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_double_quote_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_single_quote_string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__special_character] = {
    .visible = false,
    .named = true,
  },
  [sym_home_dir_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_glob] = {
    .visible = true,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_word] = {
    .visible = true,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym__concat_oct] = {
    .visible = false,
    .named = true,
  },
  [sym__brace_concat] = {
    .visible = false,
    .named = true,
  },
  [sym__concat_list] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_execution] = {
    .visible = true,
    .named = true,
  },
  [sym_redirected_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe] = {
    .visible = true,
    .named = true,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__terminated_opt_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_negated_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution_dollar] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution_fish] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_begin_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_test_command] = {
    .visible = true,
    .named = true,
  },
  [sym__test_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_test_option] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_index] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_list_element_access] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_double_quote_string] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quote_string] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_brace_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym__brace_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__base_brace_expression] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_while_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_test_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_element_access_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_brace_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quote_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_quote_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_brace_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_argument = 1,
  field_condition = 2,
  field_destination = 3,
  field_name = 4,
  field_operator = 5,
  field_option = 6,
  field_value = 7,
  field_variable = 8,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_condition] = "condition",
  [field_destination] = "destination",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_option] = "option",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 2},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 1},
  [9] = {.index = 9, .length = 2},
  [10] = {.index = 11, .length = 1},
  [11] = {.index = 12, .length = 2},
  [12] = {.index = 14, .length = 1},
  [13] = {.index = 15, .length = 1},
  [14] = {.index = 16, .length = 2},
  [15] = {.index = 18, .length = 2},
  [16] = {.index = 20, .length = 1},
  [17] = {.index = 21, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_argument, 0},
  [2] =
    {field_argument, 1, .inherited = true},
  [3] =
    {field_argument, 1, .inherited = true},
    {field_name, 0},
  [5] =
    {field_option, 0},
  [6] =
    {field_destination, 1},
    {field_operator, 0},
  [8] =
    {field_condition, 1},
  [9] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [11] =
    {field_name, 1},
  [12] =
    {field_option, 0, .inherited = true},
    {field_option, 1, .inherited = true},
  [14] =
    {field_value, 1},
  [15] =
    {field_value, 0},
  [16] =
    {field_name, 1},
    {field_option, 2, .inherited = true},
  [18] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [20] =
    {field_condition, 2},
  [21] =
    {field_value, 3, .inherited = true},
    {field_variable, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_word,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_word_character_set_1(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= '*' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= '^' || (c >= '{' && c <= '~')))));
}

static inline bool sym_word_character_set_2(int32_t c) {
  return (c < '"'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= '$' || (c < '['
      ? (c < ';'
        ? (c >= '&' && c <= '*')
        : c <= ';')
      : (c <= '^' || (c >= '{' && c <= '~')))));
}

static inline bool sym_word_character_set_3(int32_t c) {
  return (c < '"'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= '$' || (c < '['
      ? (c < ';'
        ? (c >= '&' && c <= '*')
        : c <= '>')
      : (c <= '^' || (c >= '{' && c <= '~')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(86);
      if (lookahead == '!') ADVANCE(108);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '&') ADVANCE(103);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == ')') ADVANCE(114);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+') ADVANCE(80);
      if (lookahead == ',') ADVANCE(163);
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '.') ADVANCE(18);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '[') ADVANCE(161);
      if (lookahead == '\\') SKIP(85)
      if (lookahead == ']') ADVANCE(150);
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'b') ADVANCE(29);
      if (lookahead == 'c') ADVANCE(23);
      if (lookahead == 'e') ADVANCE(49);
      if (lookahead == 'f') ADVANCE(58);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead == 'o') ADVANCE(60);
      if (lookahead == 'r') ADVANCE(36);
      if (lookahead == 's') ADVANCE(74);
      if (lookahead == 't') ADVANCE(35);
      if (lookahead == 'w') ADVANCE(41);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(164);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(119);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '\r') ADVANCE(106);
      if (lookahead == '!') ADVANCE(109);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(247);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '[') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == ']') ADVANCE(188);
      if (lookahead == 'a') ADVANCE(219);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 'f') ADVANCE(229);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(231);
      if (lookahead == 'r') ADVANCE(206);
      if (lookahead == 's') ADVANCE(245);
      if (lookahead == 't') ADVANCE(200);
      if (lookahead == 'w') ADVANCE(210);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(1)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '\r') ADVANCE(106);
      if (lookahead == '!') ADVANCE(109);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(247);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '[') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == ']') ADVANCE(188);
      if (lookahead == 'a') ADVANCE(219);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(224);
      if (lookahead == 'f') ADVANCE(229);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(231);
      if (lookahead == 'r') ADVANCE(206);
      if (lookahead == 's') ADVANCE(245);
      if (lookahead == 't') ADVANCE(200);
      if (lookahead == 'w') ADVANCE(210);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '\r') ADVANCE(106);
      if (lookahead == '!') ADVANCE(192);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '&') ADVANCE(103);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == ')') ADVANCE(114);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+') ADVANCE(247);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(154);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      if (lookahead != 0 &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '\r') ADVANCE(106);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '&') ADVANCE(103);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == ')') ADVANCE(114);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(247);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      if (lookahead != 0 &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '\r') ADVANCE(106);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(247);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(5)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(105);
      if (lookahead == '\r') ADVANCE(107);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '&') ADVANCE(103);
      if (lookahead == ')') ADVANCE(114);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '\\') SKIP(77)
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(6)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(19);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(105);
      if (lookahead == '\r') ADVANCE(107);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '\\') SKIP(78)
      if (lookahead == 'i') ADVANCE(37);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(7)
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(109);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(247);
      if (lookahead == '[') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == ']') ADVANCE(188);
      if (lookahead == 'a') ADVANCE(219);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(224);
      if (lookahead == 'f') ADVANCE(229);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(231);
      if (lookahead == 'r') ADVANCE(206);
      if (lookahead == 's') ADVANCE(245);
      if (lookahead == 't') ADVANCE(200);
      if (lookahead == 'w') ADVANCE(210);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(109);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(247);
      if (lookahead == '[') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == ']') ADVANCE(188);
      if (lookahead == 'a') ADVANCE(219);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(229);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(231);
      if (lookahead == 'r') ADVANCE(206);
      if (lookahead == 's') ADVANCE(245);
      if (lookahead == 't') ADVANCE(200);
      if (lookahead == 'w') ADVANCE(210);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(109);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(247);
      if (lookahead == '[') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == ']') ADVANCE(188);
      if (lookahead == 'a') ADVANCE(219);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(194);
      if (lookahead == 'e') ADVANCE(224);
      if (lookahead == 'f') ADVANCE(229);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(231);
      if (lookahead == 'r') ADVANCE(206);
      if (lookahead == 's') ADVANCE(245);
      if (lookahead == 't') ADVANCE(200);
      if (lookahead == 'w') ADVANCE(210);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(192);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+') ADVANCE(247);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '=') ADVANCE(154);
      if (lookahead == '[') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == ']') ADVANCE(150);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || '>' < lookahead) &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(247);
      if (lookahead == '[' ||
          lookahead == ']') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(18);
      if (lookahead == '[') ADVANCE(161);
      if (lookahead == '\\') SKIP(76)
      if (lookahead == ']') ADVANCE(150);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(124);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(250);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(252);
      if (lookahead == ',') ADVANCE(163);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '}') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(123);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(254);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(166);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(167);
      if (lookahead != 0) ADVANCE(168);
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == '\\') SKIP(79)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(159);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(170);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(171);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 18:
      if (lookahead == '.') ADVANCE(160);
      END_STATE();
    case 19:
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '>') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(19);
      END_STATE();
    case 20:
      if (lookahead == 'U') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(180);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'u') ADVANCE(182);
      if (lookahead == 'x') ADVANCE(180);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 21:
      if (lookahead == 'U') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(180);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'u') ADVANCE(182);
      if (lookahead == 'x') ADVANCE(180);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 22:
      if (lookahead == 'U') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(180);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'u') ADVANCE(182);
      if (lookahead == 'x') ADVANCE(180);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(63);
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(47);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(40);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(70);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(87);
      END_STATE();
    case 28:
      if (lookahead == 'd') ADVANCE(117);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 37:
      if (lookahead == 'f') ADVANCE(143);
      END_STATE();
    case 38:
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'n') ADVANCE(140);
      END_STATE();
    case 39:
      if (lookahead == 'g') ADVANCE(44);
      END_STATE();
    case 40:
      if (lookahead == 'h') ADVANCE(130);
      END_STATE();
    case 41:
      if (lookahead == 'h') ADVANCE(42);
      END_STATE();
    case 42:
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 43:
      if (lookahead == 'i') ADVANCE(59);
      END_STATE();
    case 44:
      if (lookahead == 'i') ADVANCE(52);
      END_STATE();
    case 45:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 47:
      if (lookahead == 'k') ADVANCE(134);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(33);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(64);
      if (lookahead == 'n') ADVANCE(28);
      END_STATE();
    case 50:
      if (lookahead == 'n') ADVANCE(27);
      END_STATE();
    case 51:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 52:
      if (lookahead == 'n') ADVANCE(147);
      END_STATE();
    case 53:
      if (lookahead == 'n') ADVANCE(128);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 55:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 56:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 57:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(61);
      if (lookahead == 'u') ADVANCE(51);
      END_STATE();
    case 59:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 60:
      if (lookahead == 'r') ADVANCE(89);
      END_STATE();
    case 61:
      if (lookahead == 'r') ADVANCE(138);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(31);
      END_STATE();
    case 64:
      if (lookahead == 's') ADVANCE(32);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(68);
      END_STATE();
    case 66:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(151);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(25);
      END_STATE();
    case 70:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 72:
      if (lookahead == 'u') ADVANCE(62);
      END_STATE();
    case 73:
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 74:
      if (lookahead == 'w') ADVANCE(45);
      END_STATE();
    case 75:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '2')) ADVANCE(93);
      END_STATE();
    case 76:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      END_STATE();
    case 77:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 78:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      END_STATE();
    case 79:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      END_STATE();
    case 80:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(120);
      END_STATE();
    case 81:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(120);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 82:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(125);
      END_STATE();
    case 83:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(124);
      END_STATE();
    case 84:
      if (eof) ADVANCE(86);
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '\r') ADVANCE(106);
      if (lookahead == '!') ADVANCE(109);
      if (lookahead == '"') ADVANCE(165);
      if (lookahead == '#') ADVANCE(158);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(113);
      if (lookahead == ')') ADVANCE(114);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(247);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '[') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == ']') ADVANCE(188);
      if (lookahead == 'a') ADVANCE(219);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(229);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(231);
      if (lookahead == 'r') ADVANCE(206);
      if (lookahead == 's') ADVANCE(245);
      if (lookahead == 't') ADVANCE(200);
      if (lookahead == 'w') ADVANCE(210);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '~') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(84)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(249);
      END_STATE();
    case 85:
      if (eof) ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 86:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_and);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_or);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_stream_redirect);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_direction);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '&') ADVANCE(75);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '&') ADVANCE(75);
      if (lookahead == '>') ADVANCE(97);
      if (lookahead == '?') ADVANCE(94);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '&') ADVANCE(75);
      if (lookahead == '?') ADVANCE(94);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '>') ADVANCE(99);
      if (lookahead == '?') ADVANCE(94);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '?') ADVANCE(94);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(91);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(92);
      if (lookahead == '<') ADVANCE(94);
      if (lookahead == '>') ADVANCE(98);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '\r') ADVANCE(106);
      if (lookahead == '\\') ADVANCE(20);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(105);
      if (lookahead == '\r') ADVANCE(107);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '\r') ADVANCE(106);
      if (lookahead == '\\') ADVANCE(20);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(105);
      if (lookahead == '\r') ADVANCE(107);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_not);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_function);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_end);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(82);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '>') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(119);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(120);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(248);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '>') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(249);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(123);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(254);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(124);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(125);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(126);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(127);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(254);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_return);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_switch);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_case);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_break);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_continue);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_continue);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_for);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_while);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_if);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_else);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_begin);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_begin);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_test_command_token1);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_test);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_test);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_test_option_token1);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_test_option_token1);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(158);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_variable_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(159);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_double_quote_string_token1);
      if (lookahead == '\n') ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_double_quote_string_token1);
      if (lookahead == '#') ADVANCE(166);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(167);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\\') ADVANCE(168);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_double_quote_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(168);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_single_quote_string_token1);
      if (lookahead == '\n') ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(170);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym_single_quote_string_token1);
      if (lookahead == '#') ADVANCE(170);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(172);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_single_quote_string_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '\r') ADVANCE(106);
      if (lookahead == '\\') ADVANCE(20);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(21);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(251);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(173);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(177);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(173);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(179);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(181);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(183);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(184);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(173);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym__special_character);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym__special_character);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(149);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_home_dir_expansion);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_glob);
      if (lookahead == '*') ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=') ADVANCE(155);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(249);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(216);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(236);
      if (lookahead == 'o') ADVANCE(226);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'c') ADVANCE(209);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'c') ADVANCE(241);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(88);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(118);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(208);
      if (lookahead == 'r') ADVANCE(201);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(234);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(193);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(142);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(137);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(146);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(133);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(238);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'f') ADVANCE(144);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(212);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(131);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(211);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(218);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(221);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(240);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(225);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(230);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'k') ADVANCE(135);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(235);
      if (lookahead == 'n') ADVANCE(198);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(202);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(197);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(196);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(148);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(129);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(116);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(198);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(244);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(242);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(237);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(226);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(232);
      if (lookahead == 'u') ADVANCE(220);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(223);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(90);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(139);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(222);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(239);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(204);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(205);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(111);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(243);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(152);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(195);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(215);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(214);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'u') ADVANCE(233);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'u') ADVANCE(203);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'w') ADVANCE(213);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(126);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_word);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(249);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_brace_word);
      if (lookahead == '\n') ADVANCE(254);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(250);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_brace_word);
      if (lookahead == '#') ADVANCE(250);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(252);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(123);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '\'' || ',' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(254);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_brace_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(123);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(254);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_brace_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(127);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(254);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_brace_word);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(254);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 84},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 2},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 84},
  [15] = {.lex_state = 84},
  [16] = {.lex_state = 84},
  [17] = {.lex_state = 84},
  [18] = {.lex_state = 84},
  [19] = {.lex_state = 84},
  [20] = {.lex_state = 84},
  [21] = {.lex_state = 84},
  [22] = {.lex_state = 84},
  [23] = {.lex_state = 84},
  [24] = {.lex_state = 84},
  [25] = {.lex_state = 84},
  [26] = {.lex_state = 84},
  [27] = {.lex_state = 84},
  [28] = {.lex_state = 84},
  [29] = {.lex_state = 84},
  [30] = {.lex_state = 84},
  [31] = {.lex_state = 84},
  [32] = {.lex_state = 84},
  [33] = {.lex_state = 84},
  [34] = {.lex_state = 84},
  [35] = {.lex_state = 84},
  [36] = {.lex_state = 84},
  [37] = {.lex_state = 84},
  [38] = {.lex_state = 84},
  [39] = {.lex_state = 84},
  [40] = {.lex_state = 84},
  [41] = {.lex_state = 84},
  [42] = {.lex_state = 84},
  [43] = {.lex_state = 84},
  [44] = {.lex_state = 84},
  [45] = {.lex_state = 84},
  [46] = {.lex_state = 84},
  [47] = {.lex_state = 84},
  [48] = {.lex_state = 84},
  [49] = {.lex_state = 84},
  [50] = {.lex_state = 84},
  [51] = {.lex_state = 84},
  [52] = {.lex_state = 84},
  [53] = {.lex_state = 84},
  [54] = {.lex_state = 84},
  [55] = {.lex_state = 84},
  [56] = {.lex_state = 84},
  [57] = {.lex_state = 84},
  [58] = {.lex_state = 84},
  [59] = {.lex_state = 84},
  [60] = {.lex_state = 84},
  [61] = {.lex_state = 84},
  [62] = {.lex_state = 84},
  [63] = {.lex_state = 10},
  [64] = {.lex_state = 10},
  [65] = {.lex_state = 10},
  [66] = {.lex_state = 8},
  [67] = {.lex_state = 8},
  [68] = {.lex_state = 8},
  [69] = {.lex_state = 8},
  [70] = {.lex_state = 8},
  [71] = {.lex_state = 8},
  [72] = {.lex_state = 8},
  [73] = {.lex_state = 8},
  [74] = {.lex_state = 8},
  [75] = {.lex_state = 8},
  [76] = {.lex_state = 8},
  [77] = {.lex_state = 8},
  [78] = {.lex_state = 8},
  [79] = {.lex_state = 8},
  [80] = {.lex_state = 8},
  [81] = {.lex_state = 8},
  [82] = {.lex_state = 8},
  [83] = {.lex_state = 8},
  [84] = {.lex_state = 8},
  [85] = {.lex_state = 8},
  [86] = {.lex_state = 8},
  [87] = {.lex_state = 8},
  [88] = {.lex_state = 8},
  [89] = {.lex_state = 9},
  [90] = {.lex_state = 9},
  [91] = {.lex_state = 9},
  [92] = {.lex_state = 9},
  [93] = {.lex_state = 9},
  [94] = {.lex_state = 9},
  [95] = {.lex_state = 9},
  [96] = {.lex_state = 3},
  [97] = {.lex_state = 3},
  [98] = {.lex_state = 3},
  [99] = {.lex_state = 3},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 2},
  [103] = {.lex_state = 2},
  [104] = {.lex_state = 84},
  [105] = {.lex_state = 84},
  [106] = {.lex_state = 4},
  [107] = {.lex_state = 4},
  [108] = {.lex_state = 4},
  [109] = {.lex_state = 4},
  [110] = {.lex_state = 3, .external_lex_state = 2},
  [111] = {.lex_state = 3, .external_lex_state = 2},
  [112] = {.lex_state = 3, .external_lex_state = 2},
  [113] = {.lex_state = 3, .external_lex_state = 2},
  [114] = {.lex_state = 3, .external_lex_state = 2},
  [115] = {.lex_state = 3, .external_lex_state = 3},
  [116] = {.lex_state = 3, .external_lex_state = 2},
  [117] = {.lex_state = 3, .external_lex_state = 2},
  [118] = {.lex_state = 3, .external_lex_state = 3},
  [119] = {.lex_state = 10},
  [120] = {.lex_state = 3, .external_lex_state = 3},
  [121] = {.lex_state = 3, .external_lex_state = 2},
  [122] = {.lex_state = 3, .external_lex_state = 2},
  [123] = {.lex_state = 3, .external_lex_state = 2},
  [124] = {.lex_state = 3, .external_lex_state = 3},
  [125] = {.lex_state = 3, .external_lex_state = 2},
  [126] = {.lex_state = 3, .external_lex_state = 3},
  [127] = {.lex_state = 3, .external_lex_state = 3},
  [128] = {.lex_state = 3, .external_lex_state = 3},
  [129] = {.lex_state = 3, .external_lex_state = 3},
  [130] = {.lex_state = 3, .external_lex_state = 3},
  [131] = {.lex_state = 8},
  [132] = {.lex_state = 3, .external_lex_state = 3},
  [133] = {.lex_state = 3, .external_lex_state = 3},
  [134] = {.lex_state = 3, .external_lex_state = 3},
  [135] = {.lex_state = 3, .external_lex_state = 3},
  [136] = {.lex_state = 11},
  [137] = {.lex_state = 3, .external_lex_state = 3},
  [138] = {.lex_state = 3, .external_lex_state = 3},
  [139] = {.lex_state = 3, .external_lex_state = 3},
  [140] = {.lex_state = 3, .external_lex_state = 3},
  [141] = {.lex_state = 3, .external_lex_state = 3},
  [142] = {.lex_state = 3, .external_lex_state = 3},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 4, .external_lex_state = 2},
  [147] = {.lex_state = 4, .external_lex_state = 2},
  [148] = {.lex_state = 4, .external_lex_state = 2},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 4, .external_lex_state = 2},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 4, .external_lex_state = 2},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 4, .external_lex_state = 3},
  [156] = {.lex_state = 4, .external_lex_state = 2},
  [157] = {.lex_state = 4, .external_lex_state = 2},
  [158] = {.lex_state = 4, .external_lex_state = 3},
  [159] = {.lex_state = 4, .external_lex_state = 2},
  [160] = {.lex_state = 3},
  [161] = {.lex_state = 3},
  [162] = {.lex_state = 4, .external_lex_state = 2},
  [163] = {.lex_state = 4, .external_lex_state = 2},
  [164] = {.lex_state = 4, .external_lex_state = 2},
  [165] = {.lex_state = 4, .external_lex_state = 3},
  [166] = {.lex_state = 4, .external_lex_state = 3},
  [167] = {.lex_state = 4, .external_lex_state = 3},
  [168] = {.lex_state = 4, .external_lex_state = 3},
  [169] = {.lex_state = 4, .external_lex_state = 3},
  [170] = {.lex_state = 4, .external_lex_state = 3},
  [171] = {.lex_state = 4, .external_lex_state = 3},
  [172] = {.lex_state = 4, .external_lex_state = 3},
  [173] = {.lex_state = 4, .external_lex_state = 3},
  [174] = {.lex_state = 4, .external_lex_state = 3},
  [175] = {.lex_state = 4, .external_lex_state = 3},
  [176] = {.lex_state = 4, .external_lex_state = 3},
  [177] = {.lex_state = 4, .external_lex_state = 3},
  [178] = {.lex_state = 4, .external_lex_state = 3},
  [179] = {.lex_state = 4, .external_lex_state = 3},
  [180] = {.lex_state = 4, .external_lex_state = 3},
  [181] = {.lex_state = 4, .external_lex_state = 3},
  [182] = {.lex_state = 14},
  [183] = {.lex_state = 14},
  [184] = {.lex_state = 14},
  [185] = {.lex_state = 14},
  [186] = {.lex_state = 4},
  [187] = {.lex_state = 14},
  [188] = {.lex_state = 14},
  [189] = {.lex_state = 12},
  [190] = {.lex_state = 14},
  [191] = {.lex_state = 14},
  [192] = {.lex_state = 12},
  [193] = {.lex_state = 14},
  [194] = {.lex_state = 14},
  [195] = {.lex_state = 14},
  [196] = {.lex_state = 14},
  [197] = {.lex_state = 14},
  [198] = {.lex_state = 12},
  [199] = {.lex_state = 5, .external_lex_state = 2},
  [200] = {.lex_state = 5, .external_lex_state = 2},
  [201] = {.lex_state = 12},
  [202] = {.lex_state = 5, .external_lex_state = 2},
  [203] = {.lex_state = 5, .external_lex_state = 2},
  [204] = {.lex_state = 5, .external_lex_state = 2},
  [205] = {.lex_state = 12},
  [206] = {.lex_state = 5, .external_lex_state = 2},
  [207] = {.lex_state = 5, .external_lex_state = 2},
  [208] = {.lex_state = 5, .external_lex_state = 3},
  [209] = {.lex_state = 5, .external_lex_state = 3},
  [210] = {.lex_state = 5, .external_lex_state = 2},
  [211] = {.lex_state = 5, .external_lex_state = 2},
  [212] = {.lex_state = 5, .external_lex_state = 3},
  [213] = {.lex_state = 5, .external_lex_state = 2},
  [214] = {.lex_state = 5, .external_lex_state = 3},
  [215] = {.lex_state = 5, .external_lex_state = 2},
  [216] = {.lex_state = 12},
  [217] = {.lex_state = 5, .external_lex_state = 3},
  [218] = {.lex_state = 5, .external_lex_state = 3},
  [219] = {.lex_state = 5, .external_lex_state = 3},
  [220] = {.lex_state = 5, .external_lex_state = 3},
  [221] = {.lex_state = 5, .external_lex_state = 3},
  [222] = {.lex_state = 5, .external_lex_state = 3},
  [223] = {.lex_state = 5, .external_lex_state = 3},
  [224] = {.lex_state = 12},
  [225] = {.lex_state = 5, .external_lex_state = 3},
  [226] = {.lex_state = 5, .external_lex_state = 3},
  [227] = {.lex_state = 5, .external_lex_state = 3},
  [228] = {.lex_state = 5, .external_lex_state = 3},
  [229] = {.lex_state = 12},
  [230] = {.lex_state = 5, .external_lex_state = 3},
  [231] = {.lex_state = 5, .external_lex_state = 3},
  [232] = {.lex_state = 12},
  [233] = {.lex_state = 5, .external_lex_state = 3},
  [234] = {.lex_state = 5, .external_lex_state = 3},
  [235] = {.lex_state = 12},
  [236] = {.lex_state = 14},
  [237] = {.lex_state = 5},
  [238] = {.lex_state = 5},
  [239] = {.lex_state = 13},
  [240] = {.lex_state = 13},
  [241] = {.lex_state = 13},
  [242] = {.lex_state = 13},
  [243] = {.lex_state = 13},
  [244] = {.lex_state = 13},
  [245] = {.lex_state = 13},
  [246] = {.lex_state = 13},
  [247] = {.lex_state = 13},
  [248] = {.lex_state = 13},
  [249] = {.lex_state = 13},
  [250] = {.lex_state = 13},
  [251] = {.lex_state = 13},
  [252] = {.lex_state = 13},
  [253] = {.lex_state = 13},
  [254] = {.lex_state = 13},
  [255] = {.lex_state = 13},
  [256] = {.lex_state = 6, .external_lex_state = 2},
  [257] = {.lex_state = 6, .external_lex_state = 2},
  [258] = {.lex_state = 6, .external_lex_state = 2},
  [259] = {.lex_state = 6, .external_lex_state = 2},
  [260] = {.lex_state = 6, .external_lex_state = 2},
  [261] = {.lex_state = 6, .external_lex_state = 2},
  [262] = {.lex_state = 6, .external_lex_state = 2},
  [263] = {.lex_state = 13},
  [264] = {.lex_state = 6, .external_lex_state = 3},
  [265] = {.lex_state = 6, .external_lex_state = 2},
  [266] = {.lex_state = 6, .external_lex_state = 3},
  [267] = {.lex_state = 6, .external_lex_state = 2},
  [268] = {.lex_state = 6, .external_lex_state = 3},
  [269] = {.lex_state = 6, .external_lex_state = 2},
  [270] = {.lex_state = 6, .external_lex_state = 3},
  [271] = {.lex_state = 6, .external_lex_state = 2},
  [272] = {.lex_state = 13},
  [273] = {.lex_state = 6, .external_lex_state = 3},
  [274] = {.lex_state = 6, .external_lex_state = 3},
  [275] = {.lex_state = 6, .external_lex_state = 3},
  [276] = {.lex_state = 6, .external_lex_state = 3},
  [277] = {.lex_state = 6, .external_lex_state = 3},
  [278] = {.lex_state = 6, .external_lex_state = 3},
  [279] = {.lex_state = 6, .external_lex_state = 3},
  [280] = {.lex_state = 6, .external_lex_state = 3},
  [281] = {.lex_state = 6, .external_lex_state = 3},
  [282] = {.lex_state = 6, .external_lex_state = 3},
  [283] = {.lex_state = 6, .external_lex_state = 3},
  [284] = {.lex_state = 6, .external_lex_state = 3},
  [285] = {.lex_state = 6, .external_lex_state = 3},
  [286] = {.lex_state = 6, .external_lex_state = 3},
  [287] = {.lex_state = 6, .external_lex_state = 3},
  [288] = {.lex_state = 6},
  [289] = {.lex_state = 6},
  [290] = {.lex_state = 6},
  [291] = {.lex_state = 6},
  [292] = {.lex_state = 6},
  [293] = {.lex_state = 6},
  [294] = {.lex_state = 6},
  [295] = {.lex_state = 6},
  [296] = {.lex_state = 6},
  [297] = {.lex_state = 6},
  [298] = {.lex_state = 6},
  [299] = {.lex_state = 6},
  [300] = {.lex_state = 6},
  [301] = {.lex_state = 6},
  [302] = {.lex_state = 6},
  [303] = {.lex_state = 6},
  [304] = {.lex_state = 6},
  [305] = {.lex_state = 6},
  [306] = {.lex_state = 6},
  [307] = {.lex_state = 6},
  [308] = {.lex_state = 6},
  [309] = {.lex_state = 6},
  [310] = {.lex_state = 6},
  [311] = {.lex_state = 6},
  [312] = {.lex_state = 6},
  [313] = {.lex_state = 6},
  [314] = {.lex_state = 6},
  [315] = {.lex_state = 6},
  [316] = {.lex_state = 6},
  [317] = {.lex_state = 6},
  [318] = {.lex_state = 6},
  [319] = {.lex_state = 6},
  [320] = {.lex_state = 6},
  [321] = {.lex_state = 6},
  [322] = {.lex_state = 6},
  [323] = {.lex_state = 6},
  [324] = {.lex_state = 6},
  [325] = {.lex_state = 6},
  [326] = {.lex_state = 6},
  [327] = {.lex_state = 6},
  [328] = {.lex_state = 6},
  [329] = {.lex_state = 6},
  [330] = {.lex_state = 6},
  [331] = {.lex_state = 6},
  [332] = {.lex_state = 6},
  [333] = {.lex_state = 6},
  [334] = {.lex_state = 6},
  [335] = {.lex_state = 6},
  [336] = {.lex_state = 6},
  [337] = {.lex_state = 6},
  [338] = {.lex_state = 6},
  [339] = {.lex_state = 6},
  [340] = {.lex_state = 6},
  [341] = {.lex_state = 6},
  [342] = {.lex_state = 6},
  [343] = {.lex_state = 6},
  [344] = {.lex_state = 6},
  [345] = {.lex_state = 6},
  [346] = {.lex_state = 6},
  [347] = {.lex_state = 6},
  [348] = {.lex_state = 6},
  [349] = {.lex_state = 6},
  [350] = {.lex_state = 6},
  [351] = {.lex_state = 6},
  [352] = {.lex_state = 6},
  [353] = {.lex_state = 6},
  [354] = {.lex_state = 6},
  [355] = {.lex_state = 6},
  [356] = {.lex_state = 6},
  [357] = {.lex_state = 6},
  [358] = {.lex_state = 6},
  [359] = {.lex_state = 6},
  [360] = {.lex_state = 6},
  [361] = {.lex_state = 6},
  [362] = {.lex_state = 6},
  [363] = {.lex_state = 6},
  [364] = {.lex_state = 6},
  [365] = {.lex_state = 6},
  [366] = {.lex_state = 6},
  [367] = {.lex_state = 6},
  [368] = {.lex_state = 6},
  [369] = {.lex_state = 6},
  [370] = {.lex_state = 6},
  [371] = {.lex_state = 6},
  [372] = {.lex_state = 6},
  [373] = {.lex_state = 6},
  [374] = {.lex_state = 6},
  [375] = {.lex_state = 6},
  [376] = {.lex_state = 6},
  [377] = {.lex_state = 6},
  [378] = {.lex_state = 6},
  [379] = {.lex_state = 6},
  [380] = {.lex_state = 6},
  [381] = {.lex_state = 6},
  [382] = {.lex_state = 13, .external_lex_state = 4},
  [383] = {.lex_state = 13, .external_lex_state = 4},
  [384] = {.lex_state = 13, .external_lex_state = 4},
  [385] = {.lex_state = 7, .external_lex_state = 2},
  [386] = {.lex_state = 7, .external_lex_state = 2},
  [387] = {.lex_state = 13, .external_lex_state = 4},
  [388] = {.lex_state = 7, .external_lex_state = 2},
  [389] = {.lex_state = 7, .external_lex_state = 2},
  [390] = {.lex_state = 13, .external_lex_state = 4},
  [391] = {.lex_state = 7, .external_lex_state = 2},
  [392] = {.lex_state = 7, .external_lex_state = 2},
  [393] = {.lex_state = 13, .external_lex_state = 4},
  [394] = {.lex_state = 13, .external_lex_state = 4},
  [395] = {.lex_state = 7, .external_lex_state = 2},
  [396] = {.lex_state = 13, .external_lex_state = 4},
  [397] = {.lex_state = 7, .external_lex_state = 2},
  [398] = {.lex_state = 7, .external_lex_state = 2},
  [399] = {.lex_state = 13, .external_lex_state = 4},
  [400] = {.lex_state = 13, .external_lex_state = 4},
  [401] = {.lex_state = 7, .external_lex_state = 3},
  [402] = {.lex_state = 7, .external_lex_state = 2},
  [403] = {.lex_state = 7, .external_lex_state = 3},
  [404] = {.lex_state = 13, .external_lex_state = 4},
  [405] = {.lex_state = 7, .external_lex_state = 3},
  [406] = {.lex_state = 7, .external_lex_state = 2},
  [407] = {.lex_state = 7, .external_lex_state = 3},
  [408] = {.lex_state = 7, .external_lex_state = 3},
  [409] = {.lex_state = 15},
  [410] = {.lex_state = 7, .external_lex_state = 3},
  [411] = {.lex_state = 15},
  [412] = {.lex_state = 15},
  [413] = {.lex_state = 7, .external_lex_state = 3},
  [414] = {.lex_state = 13},
  [415] = {.lex_state = 7, .external_lex_state = 3},
  [416] = {.lex_state = 7, .external_lex_state = 3},
  [417] = {.lex_state = 15},
  [418] = {.lex_state = 15},
  [419] = {.lex_state = 7, .external_lex_state = 3},
  [420] = {.lex_state = 13},
  [421] = {.lex_state = 15},
  [422] = {.lex_state = 7, .external_lex_state = 3},
  [423] = {.lex_state = 7, .external_lex_state = 3},
  [424] = {.lex_state = 7, .external_lex_state = 3},
  [425] = {.lex_state = 13},
  [426] = {.lex_state = 15},
  [427] = {.lex_state = 13},
  [428] = {.lex_state = 15},
  [429] = {.lex_state = 15},
  [430] = {.lex_state = 15},
  [431] = {.lex_state = 13},
  [432] = {.lex_state = 13},
  [433] = {.lex_state = 15},
  [434] = {.lex_state = 13},
  [435] = {.lex_state = 15},
  [436] = {.lex_state = 15},
  [437] = {.lex_state = 13},
  [438] = {.lex_state = 7, .external_lex_state = 3},
  [439] = {.lex_state = 13},
  [440] = {.lex_state = 13},
  [441] = {.lex_state = 7, .external_lex_state = 3},
  [442] = {.lex_state = 13},
  [443] = {.lex_state = 15},
  [444] = {.lex_state = 13},
  [445] = {.lex_state = 13},
  [446] = {.lex_state = 7, .external_lex_state = 3},
  [447] = {.lex_state = 7, .external_lex_state = 3},
  [448] = {.lex_state = 7, .external_lex_state = 3},
  [449] = {.lex_state = 13},
  [450] = {.lex_state = 13},
  [451] = {.lex_state = 7, .external_lex_state = 3},
  [452] = {.lex_state = 15},
  [453] = {.lex_state = 15, .external_lex_state = 4},
  [454] = {.lex_state = 15, .external_lex_state = 4},
  [455] = {.lex_state = 15, .external_lex_state = 4},
  [456] = {.lex_state = 7},
  [457] = {.lex_state = 15, .external_lex_state = 4},
  [458] = {.lex_state = 15, .external_lex_state = 4},
  [459] = {.lex_state = 16},
  [460] = {.lex_state = 15, .external_lex_state = 4},
  [461] = {.lex_state = 16},
  [462] = {.lex_state = 15, .external_lex_state = 4},
  [463] = {.lex_state = 16},
  [464] = {.lex_state = 16},
  [465] = {.lex_state = 16},
  [466] = {.lex_state = 15, .external_lex_state = 4},
  [467] = {.lex_state = 16},
  [468] = {.lex_state = 0, .external_lex_state = 5},
  [469] = {.lex_state = 0, .external_lex_state = 5},
  [470] = {.lex_state = 15, .external_lex_state = 4},
  [471] = {.lex_state = 0, .external_lex_state = 5},
  [472] = {.lex_state = 15, .external_lex_state = 4},
  [473] = {.lex_state = 16},
  [474] = {.lex_state = 15, .external_lex_state = 4},
  [475] = {.lex_state = 16},
  [476] = {.lex_state = 16},
  [477] = {.lex_state = 7},
  [478] = {.lex_state = 0, .external_lex_state = 5},
  [479] = {.lex_state = 16},
  [480] = {.lex_state = 16},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0, .external_lex_state = 5},
  [483] = {.lex_state = 16},
  [484] = {.lex_state = 16},
  [485] = {.lex_state = 16},
  [486] = {.lex_state = 16},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 16},
  [489] = {.lex_state = 0, .external_lex_state = 5},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 15},
  [492] = {.lex_state = 15},
  [493] = {.lex_state = 17},
  [494] = {.lex_state = 17},
  [495] = {.lex_state = 17},
  [496] = {.lex_state = 0, .external_lex_state = 5},
  [497] = {.lex_state = 17},
  [498] = {.lex_state = 15},
  [499] = {.lex_state = 17},
  [500] = {.lex_state = 0, .external_lex_state = 6},
  [501] = {.lex_state = 0, .external_lex_state = 5},
  [502] = {.lex_state = 0, .external_lex_state = 6},
  [503] = {.lex_state = 17},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 17},
  [506] = {.lex_state = 17},
  [507] = {.lex_state = 17},
  [508] = {.lex_state = 0, .external_lex_state = 5},
  [509] = {.lex_state = 0, .external_lex_state = 5},
  [510] = {.lex_state = 17},
  [511] = {.lex_state = 17},
  [512] = {.lex_state = 17},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 17},
  [515] = {.lex_state = 0, .external_lex_state = 5},
  [516] = {.lex_state = 0, .external_lex_state = 6},
  [517] = {.lex_state = 17},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 17},
  [520] = {.lex_state = 0, .external_lex_state = 6},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0, .external_lex_state = 6},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0, .external_lex_state = 6},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0, .external_lex_state = 6},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0, .external_lex_state = 6},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0, .external_lex_state = 6},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0, .external_lex_state = 6},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0, .external_lex_state = 6},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0, .external_lex_state = 6},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0, .external_lex_state = 6},
  [548] = {.lex_state = 0, .external_lex_state = 6},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0, .external_lex_state = 6},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0, .external_lex_state = 6},
  [556] = {.lex_state = 0, .external_lex_state = 6},
  [557] = {.lex_state = 0, .external_lex_state = 6},
  [558] = {.lex_state = 0, .external_lex_state = 6},
  [559] = {.lex_state = 0, .external_lex_state = 6},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0, .external_lex_state = 6},
  [563] = {.lex_state = 0, .external_lex_state = 6},
  [564] = {.lex_state = 0, .external_lex_state = 6},
  [565] = {.lex_state = 0, .external_lex_state = 6},
  [566] = {.lex_state = 13},
  [567] = {.lex_state = 13},
  [568] = {.lex_state = 13},
  [569] = {.lex_state = 13},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 13},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 13},
  [577] = {.lex_state = 13},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 13},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 16},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
};

enum {
  ts_external_token__concat = 0,
  ts_external_token__concat_oct = 1,
  ts_external_token__brace_concat = 2,
  ts_external_token__concat_list = 3,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__concat] = sym__concat,
  [ts_external_token__concat_oct] = sym__concat_oct,
  [ts_external_token__brace_concat] = sym__brace_concat,
  [ts_external_token__concat_list] = sym__concat_list,
};

static const bool ts_external_scanner_states[7][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__concat] = true,
    [ts_external_token__concat_oct] = true,
    [ts_external_token__brace_concat] = true,
    [ts_external_token__concat_list] = true,
  },
  [2] = {
    [ts_external_token__concat] = true,
    [ts_external_token__concat_oct] = true,
    [ts_external_token__concat_list] = true,
  },
  [3] = {
    [ts_external_token__concat] = true,
    [ts_external_token__concat_oct] = true,
  },
  [4] = {
    [ts_external_token__concat_list] = true,
  },
  [5] = {
    [ts_external_token__brace_concat] = true,
    [ts_external_token__concat_list] = true,
  },
  [6] = {
    [ts_external_token__brace_concat] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [sym_stream_redirect] = ACTIONS(1),
    [sym_direction] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_continue] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_test] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [aux_sym_test_option_token1] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym__special_character] = ACTIONS(1),
    [sym_home_dir_expansion] = ACTIONS(1),
    [sym_glob] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym__concat_oct] = ACTIONS(1),
    [sym__brace_concat] = ACTIONS(1),
    [sym__concat_list] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(587),
    [sym_conditional_execution] = STATE(340),
    [sym_redirected_statement] = STATE(340),
    [sym_pipe] = STATE(340),
    [sym_negated_statement] = STATE(340),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(340),
    [sym_return] = STATE(340),
    [sym_switch_statement] = STATE(340),
    [sym_for_statement] = STATE(340),
    [sym_while_statement] = STATE(340),
    [sym_if_statement] = STATE(340),
    [sym_begin_statement] = STATE(340),
    [sym_test_command] = STATE(340),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(340),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_program_repeat1] = STATE(25),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_CR] = ACTIONS(9),
    [anon_sym_CR_LF] = ACTIONS(9),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(25),
    [sym_continue] = ACTIONS(25),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [2] = {
    [sym_conditional_execution] = STATE(343),
    [sym_redirected_statement] = STATE(343),
    [sym_pipe] = STATE(343),
    [sym__terminated_opt_statement] = STATE(4),
    [sym_negated_statement] = STATE(343),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(343),
    [sym_return] = STATE(343),
    [sym_switch_statement] = STATE(343),
    [sym_for_statement] = STATE(343),
    [sym_while_statement] = STATE(343),
    [sym_if_statement] = STATE(343),
    [sym_else_if_clause] = STATE(481),
    [sym_else_clause] = STATE(581),
    [sym_begin_statement] = STATE(343),
    [sym_test_command] = STATE(343),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(343),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(4),
    [aux_sym_if_statement_repeat1] = STATE(481),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_LF] = ACTIONS(49),
    [anon_sym_CR] = ACTIONS(49),
    [anon_sym_CR_LF] = ACTIONS(49),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(51),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_else] = ACTIONS(55),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [3] = {
    [sym_conditional_execution] = STATE(343),
    [sym_redirected_statement] = STATE(343),
    [sym_pipe] = STATE(343),
    [sym__terminated_opt_statement] = STATE(2),
    [sym_negated_statement] = STATE(343),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(343),
    [sym_return] = STATE(343),
    [sym_switch_statement] = STATE(343),
    [sym_for_statement] = STATE(343),
    [sym_while_statement] = STATE(343),
    [sym_if_statement] = STATE(343),
    [sym_else_if_clause] = STATE(487),
    [sym_else_clause] = STATE(582),
    [sym_begin_statement] = STATE(343),
    [sym_test_command] = STATE(343),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(343),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(2),
    [aux_sym_if_statement_repeat1] = STATE(487),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(57),
    [anon_sym_CR] = ACTIONS(57),
    [anon_sym_CR_LF] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(59),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_else] = ACTIONS(55),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [4] = {
    [sym_conditional_execution] = STATE(343),
    [sym_redirected_statement] = STATE(343),
    [sym_pipe] = STATE(343),
    [sym__terminated_opt_statement] = STATE(4),
    [sym_negated_statement] = STATE(343),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(343),
    [sym_return] = STATE(343),
    [sym_switch_statement] = STATE(343),
    [sym_for_statement] = STATE(343),
    [sym_while_statement] = STATE(343),
    [sym_if_statement] = STATE(343),
    [sym_begin_statement] = STATE(343),
    [sym_test_command] = STATE(343),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(343),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(4),
    [anon_sym_and] = ACTIONS(61),
    [anon_sym_or] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(64),
    [anon_sym_AMP] = ACTIONS(64),
    [anon_sym_LF] = ACTIONS(64),
    [anon_sym_CR] = ACTIONS(64),
    [anon_sym_CR_LF] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_not] = ACTIONS(67),
    [anon_sym_DOLLAR] = ACTIONS(70),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(76),
    [anon_sym_end] = ACTIONS(79),
    [sym_integer] = ACTIONS(81),
    [sym_float] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(84),
    [anon_sym_switch] = ACTIONS(87),
    [sym_break] = ACTIONS(90),
    [sym_continue] = ACTIONS(90),
    [anon_sym_for] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(96),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_else] = ACTIONS(79),
    [anon_sym_begin] = ACTIONS(102),
    [aux_sym_test_command_token1] = ACTIONS(105),
    [anon_sym_test] = ACTIONS(108),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(111),
    [anon_sym_DQUOTE] = ACTIONS(114),
    [anon_sym_SQUOTE] = ACTIONS(117),
    [sym_escape_sequence] = ACTIONS(81),
    [sym__special_character] = ACTIONS(120),
    [sym_home_dir_expansion] = ACTIONS(81),
    [sym_glob] = ACTIONS(81),
    [sym_word] = ACTIONS(81),
  },
  [5] = {
    [sym_conditional_execution] = STATE(343),
    [sym_redirected_statement] = STATE(343),
    [sym_pipe] = STATE(343),
    [sym__terminated_opt_statement] = STATE(4),
    [sym_negated_statement] = STATE(343),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(343),
    [sym_return] = STATE(343),
    [sym_switch_statement] = STATE(343),
    [sym_for_statement] = STATE(343),
    [sym_while_statement] = STATE(343),
    [sym_if_statement] = STATE(343),
    [sym_begin_statement] = STATE(343),
    [sym_test_command] = STATE(343),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(343),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(4),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_LF] = ACTIONS(49),
    [anon_sym_CR] = ACTIONS(49),
    [anon_sym_CR_LF] = ACTIONS(49),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(123),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_else] = ACTIONS(123),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [6] = {
    [sym_conditional_execution] = STATE(343),
    [sym_redirected_statement] = STATE(343),
    [sym_pipe] = STATE(343),
    [sym__terminated_opt_statement] = STATE(5),
    [sym_negated_statement] = STATE(343),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(343),
    [sym_return] = STATE(343),
    [sym_switch_statement] = STATE(343),
    [sym_for_statement] = STATE(343),
    [sym_while_statement] = STATE(343),
    [sym_if_statement] = STATE(343),
    [sym_begin_statement] = STATE(343),
    [sym_test_command] = STATE(343),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(343),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(5),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym_AMP] = ACTIONS(125),
    [anon_sym_LF] = ACTIONS(125),
    [anon_sym_CR] = ACTIONS(125),
    [anon_sym_CR_LF] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(127),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_else] = ACTIONS(127),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [7] = {
    [sym_conditional_execution] = STATE(345),
    [sym_redirected_statement] = STATE(345),
    [sym_pipe] = STATE(345),
    [sym__terminated_opt_statement] = STATE(9),
    [sym_negated_statement] = STATE(345),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(345),
    [sym_return] = STATE(345),
    [sym_switch_statement] = STATE(345),
    [sym_for_statement] = STATE(345),
    [sym_while_statement] = STATE(345),
    [sym_if_statement] = STATE(345),
    [sym_begin_statement] = STATE(345),
    [sym_test_command] = STATE(345),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(345),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(9),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(129),
    [anon_sym_AMP] = ACTIONS(129),
    [anon_sym_LF] = ACTIONS(129),
    [anon_sym_CR] = ACTIONS(129),
    [anon_sym_CR_LF] = ACTIONS(129),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(131),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(133),
    [sym_continue] = ACTIONS(133),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [8] = {
    [sym_conditional_execution] = STATE(345),
    [sym_redirected_statement] = STATE(345),
    [sym_pipe] = STATE(345),
    [sym__terminated_opt_statement] = STATE(13),
    [sym_negated_statement] = STATE(345),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(345),
    [sym_return] = STATE(345),
    [sym_switch_statement] = STATE(345),
    [sym_for_statement] = STATE(345),
    [sym_while_statement] = STATE(345),
    [sym_if_statement] = STATE(345),
    [sym_begin_statement] = STATE(345),
    [sym_test_command] = STATE(345),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(345),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(13),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(135),
    [anon_sym_LF] = ACTIONS(135),
    [anon_sym_CR] = ACTIONS(135),
    [anon_sym_CR_LF] = ACTIONS(135),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(137),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(133),
    [sym_continue] = ACTIONS(133),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [9] = {
    [sym_conditional_execution] = STATE(345),
    [sym_redirected_statement] = STATE(345),
    [sym_pipe] = STATE(345),
    [sym__terminated_opt_statement] = STATE(13),
    [sym_negated_statement] = STATE(345),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(345),
    [sym_return] = STATE(345),
    [sym_switch_statement] = STATE(345),
    [sym_for_statement] = STATE(345),
    [sym_while_statement] = STATE(345),
    [sym_if_statement] = STATE(345),
    [sym_begin_statement] = STATE(345),
    [sym_test_command] = STATE(345),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(345),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(13),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(135),
    [anon_sym_LF] = ACTIONS(135),
    [anon_sym_CR] = ACTIONS(135),
    [anon_sym_CR_LF] = ACTIONS(135),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(139),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(133),
    [sym_continue] = ACTIONS(133),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [10] = {
    [sym_conditional_execution] = STATE(345),
    [sym_redirected_statement] = STATE(345),
    [sym_pipe] = STATE(345),
    [sym__terminated_opt_statement] = STATE(8),
    [sym_negated_statement] = STATE(345),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(345),
    [sym_return] = STATE(345),
    [sym_switch_statement] = STATE(345),
    [sym_for_statement] = STATE(345),
    [sym_while_statement] = STATE(345),
    [sym_if_statement] = STATE(345),
    [sym_begin_statement] = STATE(345),
    [sym_test_command] = STATE(345),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(345),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(8),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(141),
    [anon_sym_AMP] = ACTIONS(141),
    [anon_sym_LF] = ACTIONS(141),
    [anon_sym_CR] = ACTIONS(141),
    [anon_sym_CR_LF] = ACTIONS(141),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(143),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(133),
    [sym_continue] = ACTIONS(133),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [11] = {
    [sym_conditional_execution] = STATE(345),
    [sym_redirected_statement] = STATE(345),
    [sym_pipe] = STATE(345),
    [sym__terminated_opt_statement] = STATE(13),
    [sym_negated_statement] = STATE(345),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(345),
    [sym_return] = STATE(345),
    [sym_switch_statement] = STATE(345),
    [sym_for_statement] = STATE(345),
    [sym_while_statement] = STATE(345),
    [sym_if_statement] = STATE(345),
    [sym_begin_statement] = STATE(345),
    [sym_test_command] = STATE(345),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(345),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(13),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(135),
    [anon_sym_LF] = ACTIONS(135),
    [anon_sym_CR] = ACTIONS(135),
    [anon_sym_CR_LF] = ACTIONS(135),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(145),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(133),
    [sym_continue] = ACTIONS(133),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [12] = {
    [sym_conditional_execution] = STATE(345),
    [sym_redirected_statement] = STATE(345),
    [sym_pipe] = STATE(345),
    [sym__terminated_opt_statement] = STATE(11),
    [sym_negated_statement] = STATE(345),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(345),
    [sym_return] = STATE(345),
    [sym_switch_statement] = STATE(345),
    [sym_for_statement] = STATE(345),
    [sym_while_statement] = STATE(345),
    [sym_if_statement] = STATE(345),
    [sym_begin_statement] = STATE(345),
    [sym_test_command] = STATE(345),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(345),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(11),
    [anon_sym_and] = ACTIONS(7),
    [anon_sym_or] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_AMP] = ACTIONS(147),
    [anon_sym_LF] = ACTIONS(147),
    [anon_sym_CR] = ACTIONS(147),
    [anon_sym_CR_LF] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_end] = ACTIONS(149),
    [sym_integer] = ACTIONS(19),
    [sym_float] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(133),
    [sym_continue] = ACTIONS(133),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [aux_sym_test_command_token1] = ACTIONS(35),
    [anon_sym_test] = ACTIONS(37),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [sym_escape_sequence] = ACTIONS(19),
    [sym__special_character] = ACTIONS(47),
    [sym_home_dir_expansion] = ACTIONS(19),
    [sym_glob] = ACTIONS(19),
    [sym_word] = ACTIONS(19),
  },
  [13] = {
    [sym_conditional_execution] = STATE(345),
    [sym_redirected_statement] = STATE(345),
    [sym_pipe] = STATE(345),
    [sym__terminated_opt_statement] = STATE(13),
    [sym_negated_statement] = STATE(345),
    [sym_command_substitution_dollar] = STATE(181),
    [sym_command_substitution_fish] = STATE(181),
    [sym_command_substitution] = STATE(166),
    [sym_function_definition] = STATE(345),
    [sym_return] = STATE(345),
    [sym_switch_statement] = STATE(345),
    [sym_for_statement] = STATE(345),
    [sym_while_statement] = STATE(345),
    [sym_if_statement] = STATE(345),
    [sym_begin_statement] = STATE(345),
    [sym_test_command] = STATE(345),
    [sym_variable_expansion] = STATE(166),
    [sym_brace_expansion] = STATE(166),
    [sym_double_quote_string] = STATE(166),
    [sym_single_quote_string] = STATE(166),
    [sym_command] = STATE(345),
    [sym_concatenation] = STATE(108),
    [sym__expression] = STATE(108),
    [aux_sym_while_statement_repeat1] = STATE(13),
    [anon_sym_and] = ACTIONS(61),
    [anon_sym_or] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(151),
    [anon_sym_AMP] = ACTIONS(151),
    [anon_sym_LF] = ACTIONS(151),
    [anon_sym_CR] = ACTIONS(151),
    [anon_sym_CR_LF] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_not] = ACTIONS(67),
    [anon_sym_DOLLAR] = ACTIONS(70),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(76),
    [anon_sym_end] = ACTIONS(79),
    [sym_integer] = ACTIONS(81),
    [sym_float] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(84),
    [anon_sym_switch] = ACTIONS(87),
    [sym_break] = ACTIONS(154),
    [sym_continue] = ACTIONS(154),
    [anon_sym_for] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(96),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_begin] = ACTIONS(102),
    [aux_sym_test_command_token1] = ACTIONS(105),
    [anon_sym_test] = ACTIONS(108),
    [sym_comment] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(111),
    [anon_sym_DQUOTE] = ACTIONS(114),
    [anon_sym_SQUOTE] = ACTIONS(117),
    [sym_escape_sequence] = ACTIONS(81),
    [sym__special_character] = ACTIONS(120),
    [sym_home_dir_expansion] = ACTIONS(81),
    [sym_glob] = ACTIONS(81),
    [sym_word] = ACTIONS(81),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(161), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(335), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [112] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(165), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(337), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [224] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(169), 1,
      anon_sym_RPAREN,
    STATE(18), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(171), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(167), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(292), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [336] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(173), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(175), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(293), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [448] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(177), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(179), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(317), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [560] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(183), 1,
      anon_sym_RPAREN,
    STATE(21), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(185), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(181), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(295), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [672] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(189), 1,
      anon_sym_RPAREN,
    STATE(22), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(191), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(187), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(296), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [784] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(193), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(195), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(297), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [896] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(197), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(199), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(298), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1008] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(203), 1,
      anon_sym_RPAREN,
    STATE(51), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(205), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(201), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(299), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1120] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(209), 1,
      anon_sym_RPAREN,
    STATE(62), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(211), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(207), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(333), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1232] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(213), 1,
      ts_builtin_sym_end,
    STATE(44), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(25), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(215), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(340), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1344] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(217), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(219), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(302), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1456] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(221), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(223), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(334), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1568] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(227), 1,
      anon_sym_RPAREN,
    STATE(26), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(229), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(225), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(332), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1680] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(233), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(307), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1792] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(237), 1,
      anon_sym_RPAREN,
    STATE(48), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(239), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(235), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(309), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [1904] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(243), 1,
      anon_sym_RPAREN,
    STATE(27), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(245), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(241), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(336), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2016] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(249), 1,
      anon_sym_RPAREN,
    STATE(61), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(251), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(247), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(310), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2128] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(255), 1,
      anon_sym_RPAREN,
    STATE(35), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(257), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(253), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(306), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2240] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(261), 1,
      anon_sym_RPAREN,
    STATE(52), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(263), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(259), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(301), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2352] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(265), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(267), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(308), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2464] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(269), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(271), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(311), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2576] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(275), 1,
      anon_sym_RPAREN,
    STATE(29), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(277), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(273), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(305), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2688] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(281), 1,
      anon_sym_RPAREN,
    STATE(36), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(283), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(279), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(315), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2800] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(287), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(289), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(285), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(294), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [2912] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(293), 1,
      anon_sym_RPAREN,
    STATE(15), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(295), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(291), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(323), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3024] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(297), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(299), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(321), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3136] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(301), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(303), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(316), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3248] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(309), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(305), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(318), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3360] = 27,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(311), 1,
      ts_builtin_sym_end,
    ACTIONS(322), 1,
      anon_sym_DOLLAR,
    ACTIONS(325), 1,
      anon_sym_LPAREN,
    ACTIONS(328), 1,
      anon_sym_function,
    ACTIONS(334), 1,
      anon_sym_return,
    ACTIONS(337), 1,
      anon_sym_switch,
    ACTIONS(343), 1,
      anon_sym_for,
    ACTIONS(346), 1,
      anon_sym_while,
    ACTIONS(349), 1,
      anon_sym_if,
    ACTIONS(352), 1,
      anon_sym_begin,
    ACTIONS(355), 1,
      aux_sym_test_command_token1,
    ACTIONS(358), 1,
      anon_sym_test,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_DQUOTE,
    ACTIONS(367), 1,
      anon_sym_SQUOTE,
    ACTIONS(370), 1,
      sym__special_character,
    STATE(44), 1,
      aux_sym_program_repeat1,
    ACTIONS(313), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(319), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(340), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(316), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(331), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(340), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3472] = 27,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(322), 1,
      anon_sym_DOLLAR,
    ACTIONS(325), 1,
      anon_sym_LPAREN,
    ACTIONS(328), 1,
      anon_sym_function,
    ACTIONS(334), 1,
      anon_sym_return,
    ACTIONS(337), 1,
      anon_sym_switch,
    ACTIONS(343), 1,
      anon_sym_for,
    ACTIONS(346), 1,
      anon_sym_while,
    ACTIONS(349), 1,
      anon_sym_if,
    ACTIONS(352), 1,
      anon_sym_begin,
    ACTIONS(355), 1,
      aux_sym_test_command_token1,
    ACTIONS(358), 1,
      anon_sym_test,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    ACTIONS(364), 1,
      anon_sym_DQUOTE,
    ACTIONS(367), 1,
      anon_sym_SQUOTE,
    ACTIONS(370), 1,
      sym__special_character,
    ACTIONS(376), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(313), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(319), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(378), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(373), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(331), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(366), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3584] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(381), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(383), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(320), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3696] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(387), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(389), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(385), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(322), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3808] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(391), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(393), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(312), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [3920] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(395), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(397), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(324), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4032] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(399), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(401), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(319), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4144] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(403), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(405), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(303), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4256] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(407), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(409), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(304), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4368] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(413), 1,
      anon_sym_RPAREN,
    STATE(41), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(415), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(411), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(314), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4480] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(419), 1,
      anon_sym_RPAREN,
    STATE(14), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(421), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(417), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(300), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4592] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(425), 1,
      anon_sym_RPAREN,
    STATE(49), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(427), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(423), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(325), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4704] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(429), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(431), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(326), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4816] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(435), 1,
      anon_sym_RPAREN,
    STATE(56), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(437), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(433), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(327), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [4928] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(439), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(441), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(328), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5040] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(445), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(447), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(443), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(313), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5152] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(451), 1,
      anon_sym_RPAREN,
    STATE(58), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(453), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(449), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(330), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5264] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(455), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(457), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(288), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5376] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(459), 1,
      anon_sym_RPAREN,
    STATE(45), 1,
      aux_sym_program_repeat1,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(461), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(157), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(331), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5488] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(463), 2,
      anon_sym_end,
      anon_sym_case,
    ACTIONS(465), 2,
      sym_break,
      sym_continue,
    STATE(65), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(380), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5597] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(465), 2,
      sym_break,
      sym_continue,
    ACTIONS(469), 2,
      anon_sym_end,
      anon_sym_case,
    STATE(63), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(380), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5706] = 27,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(477), 1,
      anon_sym_DOLLAR,
    ACTIONS(480), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_function,
    ACTIONS(491), 1,
      anon_sym_return,
    ACTIONS(494), 1,
      anon_sym_switch,
    ACTIONS(500), 1,
      anon_sym_for,
    ACTIONS(503), 1,
      anon_sym_while,
    ACTIONS(506), 1,
      anon_sym_if,
    ACTIONS(509), 1,
      anon_sym_begin,
    ACTIONS(512), 1,
      aux_sym_test_command_token1,
    ACTIONS(515), 1,
      anon_sym_test,
    ACTIONS(518), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_DQUOTE,
    ACTIONS(524), 1,
      anon_sym_SQUOTE,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(530), 1,
      sym__special_character,
    ACTIONS(471), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(474), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(486), 2,
      anon_sym_end,
      anon_sym_case,
    ACTIONS(497), 2,
      sym_break,
      sym_continue,
    STATE(65), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(488), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(380), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5815] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(533), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(81), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [5923] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(537), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6031] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(539), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6139] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(541), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6247] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(543), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(79), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6355] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(545), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(69), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6463] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(547), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(86), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6571] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(549), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(80), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6679] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(551), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(67), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6787] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(553), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(84), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [6895] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(555), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7003] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(557), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(82), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7111] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(559), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(76), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7219] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(561), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7327] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(563), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7435] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(565), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7543] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(567), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7651] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(569), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(87), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7759] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(571), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7867] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(573), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(68), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [7975] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(575), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8083] = 27,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(577), 1,
      anon_sym_end,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(535), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8191] = 27,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(477), 1,
      anon_sym_DOLLAR,
    ACTIONS(480), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_function,
    ACTIONS(486), 1,
      anon_sym_end,
    ACTIONS(491), 1,
      anon_sym_return,
    ACTIONS(494), 1,
      anon_sym_switch,
    ACTIONS(500), 1,
      anon_sym_for,
    ACTIONS(503), 1,
      anon_sym_while,
    ACTIONS(506), 1,
      anon_sym_if,
    ACTIONS(509), 1,
      anon_sym_begin,
    ACTIONS(512), 1,
      aux_sym_test_command_token1,
    ACTIONS(515), 1,
      anon_sym_test,
    ACTIONS(518), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_DQUOTE,
    ACTIONS(524), 1,
      anon_sym_SQUOTE,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(530), 1,
      sym__special_character,
    ACTIONS(471), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(474), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(579), 2,
      sym_break,
      sym_continue,
    STATE(88), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(488), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(339), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8299] = 26,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    STATE(10), 1,
      sym__terminated_statement,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(582), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(347), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8403] = 26,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    STATE(6), 1,
      sym__terminated_statement,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(584), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(344), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8507] = 26,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    STATE(3), 1,
      sym__terminated_statement,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(584), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(344), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8611] = 25,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(586), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(289), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8712] = 25,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(588), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(290), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8813] = 25,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(590), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(291), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [8914] = 25,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(35), 1,
      aux_sym_test_command_token1,
    ACTIONS(37), 1,
      anon_sym_test,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    ACTIONS(467), 1,
      sym_escape_sequence,
    ACTIONS(7), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(11), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(592), 2,
      sym_break,
      sym_continue,
    STATE(108), 2,
      sym_concatenation,
      sym__expression,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(19), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    STATE(329), 13,
      sym_conditional_execution,
      sym_redirected_statement,
      sym_pipe,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_test_command,
      sym_command,
  [9015] = 14,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_DOLLAR,
    ACTIONS(598), 1,
      anon_sym_LPAREN,
    ACTIONS(604), 1,
      anon_sym_LBRACE,
    ACTIONS(606), 1,
      anon_sym_DQUOTE,
    ACTIONS(608), 1,
      anon_sym_SQUOTE,
    ACTIONS(610), 1,
      sym__special_character,
    STATE(99), 1,
      aux_sym_test_command_repeat1,
    STATE(142), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(602), 3,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
    STATE(160), 4,
      sym__test_expression,
      sym_test_option,
      sym_concatenation,
      sym__expression,
    STATE(120), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(600), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(594), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [9083] = 14,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_DOLLAR,
    ACTIONS(598), 1,
      anon_sym_LPAREN,
    ACTIONS(604), 1,
      anon_sym_LBRACE,
    ACTIONS(606), 1,
      anon_sym_DQUOTE,
    ACTIONS(608), 1,
      anon_sym_SQUOTE,
    ACTIONS(610), 1,
      sym__special_character,
    STATE(98), 1,
      aux_sym_test_command_repeat1,
    STATE(142), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(602), 3,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
    STATE(160), 4,
      sym__test_expression,
      sym_test_option,
      sym_concatenation,
      sym__expression,
    STATE(120), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(600), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(612), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [9151] = 14,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_DOLLAR,
    ACTIONS(598), 1,
      anon_sym_LPAREN,
    ACTIONS(604), 1,
      anon_sym_LBRACE,
    ACTIONS(606), 1,
      anon_sym_DQUOTE,
    ACTIONS(608), 1,
      anon_sym_SQUOTE,
    ACTIONS(610), 1,
      sym__special_character,
    STATE(99), 1,
      aux_sym_test_command_repeat1,
    STATE(142), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(602), 3,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
    STATE(160), 4,
      sym__test_expression,
      sym_test_option,
      sym_concatenation,
      sym__expression,
    STATE(120), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(600), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(594), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [9219] = 14,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(616), 1,
      anon_sym_DOLLAR,
    ACTIONS(619), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_LBRACE,
    ACTIONS(631), 1,
      anon_sym_DQUOTE,
    ACTIONS(634), 1,
      anon_sym_SQUOTE,
    ACTIONS(637), 1,
      sym__special_character,
    STATE(99), 1,
      aux_sym_test_command_repeat1,
    STATE(142), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(625), 3,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
    STATE(160), 4,
      sym__test_expression,
      sym_test_option,
      sym_concatenation,
      sym__expression,
    STATE(120), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(622), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(614), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [9287] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(640), 34,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_else,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9327] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(642), 34,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_else,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9367] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(642), 33,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9406] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(640), 33,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9445] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(376), 33,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_function,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9484] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(311), 1,
      ts_builtin_sym_end,
    ACTIONS(376), 32,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9525] = 13,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    STATE(107), 1,
      aux_sym_command_repeat1,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(186), 2,
      sym_concatenation,
      sym__expression,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(644), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [9586] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(648), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_LPAREN,
    ACTIONS(657), 1,
      anon_sym_LBRACE,
    ACTIONS(660), 1,
      anon_sym_DQUOTE,
    ACTIONS(663), 1,
      anon_sym_SQUOTE,
    ACTIONS(666), 1,
      sym__special_character,
    STATE(107), 1,
      aux_sym_command_repeat1,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(186), 2,
      sym_concatenation,
      sym__expression,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(654), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(646), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [9647] = 13,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(47), 1,
      sym__special_character,
    STATE(106), 1,
      aux_sym_command_repeat1,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(186), 2,
      sym_concatenation,
      sym__expression,
    STATE(166), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(19), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(669), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [9708] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_DOLLAR,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_LBRACE,
    ACTIONS(681), 1,
      anon_sym_DQUOTE,
    ACTIONS(683), 1,
      anon_sym_SQUOTE,
    ACTIONS(685), 1,
      sym__special_character,
    STATE(284), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(374), 2,
      sym_concatenation,
      sym__expression,
    STATE(264), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(677), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(671), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [9766] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(111), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(687), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9806] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(112), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(691), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9846] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(699), 1,
      sym__concat_list,
    STATE(112), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(697), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(695), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9888] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(702), 1,
      sym__concat_list,
    STATE(112), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(691), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9930] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(702), 1,
      sym__concat_list,
    STATE(113), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(687), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [9972] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(706), 1,
      sym__concat,
    ACTIONS(708), 1,
      sym__concat_oct,
    STATE(124), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(704), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10013] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(712), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(710), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10050] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(714), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10087] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(720), 1,
      sym__concat,
    ACTIONS(723), 1,
      sym__concat_oct,
    STATE(118), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(718), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10128] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(726), 1,
      sym_escape_sequence,
    ACTIONS(642), 28,
      anon_sym_and,
      anon_sym_or,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_case,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10165] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(706), 1,
      sym__concat,
    ACTIONS(708), 1,
      sym__concat_oct,
    STATE(124), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(728), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10206] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(730), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10243] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(734), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10280] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(740), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(738), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10317] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(706), 1,
      sym__concat,
    ACTIONS(744), 1,
      sym__concat_oct,
    STATE(118), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(742), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10358] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(697), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(695), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10395] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(748), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(746), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10431] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(752), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(750), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10467] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(734), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10503] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(756), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(754), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10539] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(760), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(758), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10575] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(726), 1,
      sym_escape_sequence,
    ACTIONS(642), 27,
      anon_sym_and,
      anon_sym_or,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      aux_sym_test_command_token1,
      anon_sym_test,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10611] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(764), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(762), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10647] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(730), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10683] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(768), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(766), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10719] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(772), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(770), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10755] = 15,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_DOLLAR,
    ACTIONS(598), 1,
      anon_sym_LPAREN,
    ACTIONS(604), 1,
      anon_sym_LBRACE,
    ACTIONS(606), 1,
      anon_sym_DQUOTE,
    ACTIONS(608), 1,
      anon_sym_SQUOTE,
    ACTIONS(610), 1,
      sym__special_character,
    ACTIONS(774), 1,
      anon_sym_RBRACK,
    ACTIONS(776), 1,
      sym_escape_sequence,
    STATE(96), 1,
      aux_sym_test_command_repeat1,
    STATE(142), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(602), 3,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
    STATE(160), 4,
      sym__test_expression,
      sym_test_option,
      sym_concatenation,
      sym__expression,
    ACTIONS(600), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(120), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [10815] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(780), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(778), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10851] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(784), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(782), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10887] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(714), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10923] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(788), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(786), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10959] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(790), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(718), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [10995] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(794), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(792), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11031] = 17,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(796), 1,
      anon_sym_SEMI,
    ACTIONS(798), 1,
      anon_sym_AMP,
    ACTIONS(800), 1,
      anon_sym_LF,
    ACTIONS(802), 1,
      anon_sym_CR,
    ACTIONS(804), 1,
      anon_sym_CR_LF,
    ACTIONS(806), 1,
      anon_sym_DOLLAR,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_LBRACE,
    ACTIONS(814), 1,
      anon_sym_DQUOTE,
    ACTIONS(816), 1,
      anon_sym_SQUOTE,
    ACTIONS(818), 1,
      sym__special_character,
    STATE(154), 1,
      aux_sym_for_statement_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(237), 2,
      sym_concatenation,
      sym__expression,
    STATE(208), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(810), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11094] = 17,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(806), 1,
      anon_sym_DOLLAR,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_LBRACE,
    ACTIONS(814), 1,
      anon_sym_DQUOTE,
    ACTIONS(816), 1,
      anon_sym_SQUOTE,
    ACTIONS(818), 1,
      sym__special_character,
    ACTIONS(820), 1,
      anon_sym_SEMI,
    ACTIONS(822), 1,
      anon_sym_AMP,
    ACTIONS(824), 1,
      anon_sym_LF,
    ACTIONS(826), 1,
      anon_sym_CR,
    ACTIONS(828), 1,
      anon_sym_CR_LF,
    STATE(145), 1,
      aux_sym_function_definition_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(238), 2,
      sym_concatenation,
      sym__expression,
    STATE(208), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(810), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11157] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_DOLLAR,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    ACTIONS(841), 1,
      anon_sym_LBRACE,
    ACTIONS(844), 1,
      anon_sym_DQUOTE,
    ACTIONS(847), 1,
      anon_sym_SQUOTE,
    ACTIONS(850), 1,
      sym__special_character,
    STATE(145), 1,
      aux_sym_function_definition_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(238), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(830), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(208), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(838), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11212] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(853), 1,
      sym__concat_list,
    STATE(152), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(691), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11251] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(150), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(687), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11288] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(853), 1,
      sym__concat_list,
    STATE(146), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(687), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11327] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(857), 1,
      anon_sym_DOLLAR,
    ACTIONS(860), 1,
      anon_sym_LPAREN,
    ACTIONS(866), 1,
      anon_sym_LBRACE,
    ACTIONS(869), 1,
      anon_sym_DQUOTE,
    ACTIONS(872), 1,
      anon_sym_SQUOTE,
    ACTIONS(875), 1,
      sym__special_character,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(149), 3,
      sym_concatenation,
      sym__expression,
      aux_sym_case_clause_repeat1,
    ACTIONS(855), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(208), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(863), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11380] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(152), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(691), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11417] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(806), 1,
      anon_sym_DOLLAR,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_LBRACE,
    ACTIONS(814), 1,
      anon_sym_DQUOTE,
    ACTIONS(816), 1,
      anon_sym_SQUOTE,
    ACTIONS(818), 1,
      sym__special_character,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(149), 3,
      sym_concatenation,
      sym__expression,
      aux_sym_case_clause_repeat1,
    ACTIONS(878), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(208), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(810), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11470] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(880), 1,
      sym__concat_list,
    STATE(152), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(697), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(695), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11509] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(806), 1,
      anon_sym_DOLLAR,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_LBRACE,
    ACTIONS(814), 1,
      anon_sym_DQUOTE,
    ACTIONS(816), 1,
      anon_sym_SQUOTE,
    ACTIONS(818), 1,
      sym__special_character,
    STATE(144), 1,
      aux_sym_function_definition_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(238), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(883), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(208), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(810), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11564] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(887), 1,
      anon_sym_DOLLAR,
    ACTIONS(890), 1,
      anon_sym_LPAREN,
    ACTIONS(896), 1,
      anon_sym_LBRACE,
    ACTIONS(899), 1,
      anon_sym_DQUOTE,
    ACTIONS(902), 1,
      anon_sym_SQUOTE,
    ACTIONS(905), 1,
      sym__special_character,
    STATE(154), 1,
      aux_sym_for_statement_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(237), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(885), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(208), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(893), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11619] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(908), 1,
      sym__concat,
    ACTIONS(910), 1,
      sym__concat_oct,
    STATE(158), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(704), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11657] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(740), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(738), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11691] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(714), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11725] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(908), 1,
      sym__concat,
    ACTIONS(912), 1,
      sym__concat_oct,
    STATE(165), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(742), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11763] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(730), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11797] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(914), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11829] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(916), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_EQ,
      anon_sym_BANG_EQ,
      aux_sym_test_option_token1,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11861] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(734), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11895] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(697), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(695), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11929] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(712), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(710), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [11963] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(918), 1,
      sym__concat,
    ACTIONS(921), 1,
      sym__concat_oct,
    STATE(165), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(718), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12001] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(908), 1,
      sym__concat,
    ACTIONS(910), 1,
      sym__concat_oct,
    STATE(158), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(728), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12039] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(714), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12072] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(748), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(746), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12105] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(756), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(754), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12138] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(752), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(750), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12171] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(768), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(766), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12204] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(734), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12237] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(790), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(718), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12270] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(788), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(786), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12303] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(764), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(762), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12336] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(760), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(758), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12369] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(730), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12402] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(784), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(782), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12435] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(780), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(778), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12468] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(772), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(770), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12501] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(794), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(792), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12534] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(932), 1,
      anon_sym_COMMA,
    ACTIONS(934), 1,
      anon_sym_RBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    STATE(527), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(536), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [12585] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(932), 1,
      anon_sym_COMMA,
    ACTIONS(934), 1,
      anon_sym_RBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    STATE(561), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(523), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [12636] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(932), 1,
      anon_sym_COMMA,
    ACTIONS(934), 1,
      anon_sym_RBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    STATE(538), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(521), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [12687] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(932), 1,
      anon_sym_COMMA,
    ACTIONS(934), 1,
      anon_sym_RBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    STATE(541), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(529), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [12738] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(940), 23,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [12767] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(932), 1,
      anon_sym_COMMA,
    ACTIONS(934), 1,
      anon_sym_RBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    STATE(550), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(554), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [12818] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(932), 1,
      anon_sym_COMMA,
    ACTIONS(934), 1,
      anon_sym_RBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    STATE(535), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(546), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [12869] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(806), 1,
      anon_sym_DOLLAR,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_LBRACE,
    ACTIONS(814), 1,
      anon_sym_DQUOTE,
    ACTIONS(816), 1,
      anon_sym_SQUOTE,
    ACTIONS(818), 1,
      sym__special_character,
    ACTIONS(942), 1,
      sym_escape_sequence,
    STATE(143), 1,
      aux_sym_for_statement_repeat1,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(237), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(810), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(208), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [12919] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    ACTIONS(944), 1,
      anon_sym_COMMA,
    STATE(531), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(532), 1,
      sym_variable_expansion,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(571), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [12969] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    STATE(544), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(551), 1,
      sym_variable_expansion,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(575), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [13019] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(806), 1,
      anon_sym_DOLLAR,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_LBRACE,
    ACTIONS(814), 1,
      anon_sym_DQUOTE,
    ACTIONS(816), 1,
      anon_sym_SQUOTE,
    ACTIONS(818), 1,
      sym__special_character,
    ACTIONS(942), 1,
      sym_escape_sequence,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(151), 3,
      sym_concatenation,
      sym__expression,
      aux_sym_case_clause_repeat1,
    ACTIONS(810), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(208), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [13067] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    ACTIONS(948), 1,
      anon_sym_COMMA,
    STATE(520), 1,
      sym_variable_expansion,
    STATE(553), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(580), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [13117] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    ACTIONS(950), 1,
      anon_sym_COMMA,
    STATE(543), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(548), 1,
      sym_variable_expansion,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(574), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [13167] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    ACTIONS(952), 1,
      anon_sym_COMMA,
    STATE(534), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(537), 1,
      sym_variable_expansion,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(578), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [13217] = 13,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    ACTIONS(954), 1,
      anon_sym_COMMA,
    STATE(528), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(558), 1,
      sym_variable_expansion,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(570), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 5,
      sym_command_substitution,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [13267] = 11,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    ACTIONS(934), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(572), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(928), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(502), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [13313] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(956), 1,
      anon_sym_DOLLAR,
    ACTIONS(958), 1,
      anon_sym_LPAREN,
    ACTIONS(962), 1,
      anon_sym_LBRACE,
    ACTIONS(964), 1,
      anon_sym_DQUOTE,
    ACTIONS(966), 1,
      anon_sym_SQUOTE,
    ACTIONS(968), 1,
      sym_escape_sequence,
    ACTIONS(970), 1,
      sym__special_character,
    STATE(451), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(477), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(960), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(407), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [13360] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(972), 1,
      sym__concat_list,
    STATE(199), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(697), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(695), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13393] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(202), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(687), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13424] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(806), 1,
      anon_sym_DOLLAR,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_LBRACE,
    ACTIONS(814), 1,
      anon_sym_DQUOTE,
    ACTIONS(816), 1,
      anon_sym_SQUOTE,
    ACTIONS(818), 1,
      sym__special_character,
    ACTIONS(942), 1,
      sym_escape_sequence,
    STATE(153), 2,
      sym_concatenation,
      sym__expression,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(810), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(208), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [13471] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(199), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(691), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13502] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(975), 1,
      sym__concat_list,
    STATE(204), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(687), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13535] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(975), 1,
      sym__concat_list,
    STATE(199), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(691), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13568] = 12,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_DOLLAR,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_LBRACE,
    ACTIONS(681), 1,
      anon_sym_DQUOTE,
    ACTIONS(683), 1,
      anon_sym_SQUOTE,
    ACTIONS(685), 1,
      sym__special_character,
    ACTIONS(977), 1,
      sym_escape_sequence,
    STATE(284), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(372), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(677), 5,
      sym_integer,
      sym_float,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(264), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [13615] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(734), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13643] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(712), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(710), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13671] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(979), 1,
      sym__concat,
    ACTIONS(981), 1,
      sym__concat_oct,
    STATE(212), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(728), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13703] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(979), 1,
      sym__concat,
    ACTIONS(981), 1,
      sym__concat_oct,
    STATE(212), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(704), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13735] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(740), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(738), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13763] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(697), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(695), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13791] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(979), 1,
      sym__concat,
    ACTIONS(983), 1,
      sym__concat_oct,
    STATE(214), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(742), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13823] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(714), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13851] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(985), 1,
      sym__concat,
    ACTIONS(988), 1,
      sym__concat_oct,
    STATE(214), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(718), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13883] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(730), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13911] = 10,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_DOLLAR,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_LBRACE,
    ACTIONS(681), 1,
      anon_sym_DQUOTE,
    ACTIONS(683), 1,
      anon_sym_SQUOTE,
    ACTIONS(993), 1,
      sym_escape_sequence,
    STATE(284), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(279), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(991), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13952] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(780), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(778), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [13979] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(790), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(718), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14006] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(788), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(786), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14033] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(764), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(762), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14060] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(760), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(758), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14087] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(768), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(766), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14114] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(756), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(754), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14141] = 10,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(806), 1,
      anon_sym_DOLLAR,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      anon_sym_LBRACE,
    ACTIONS(814), 1,
      anon_sym_DQUOTE,
    ACTIONS(816), 1,
      anon_sym_SQUOTE,
    ACTIONS(997), 1,
      sym_escape_sequence,
    STATE(228), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(218), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(995), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14182] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(772), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(770), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14209] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(784), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(782), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14236] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(748), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(746), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14263] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(794), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(792), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14290] = 10,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_SQUOTE,
    ACTIONS(1001), 1,
      sym_escape_sequence,
    STATE(181), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(173), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(999), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14331] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(752), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(750), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14358] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(730), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14385] = 10,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_DOLLAR,
    ACTIONS(598), 1,
      anon_sym_LPAREN,
    ACTIONS(604), 1,
      anon_sym_LBRACE,
    ACTIONS(606), 1,
      anon_sym_DQUOTE,
    ACTIONS(608), 1,
      anon_sym_SQUOTE,
    ACTIONS(1005), 1,
      sym_escape_sequence,
    STATE(142), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(141), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(1003), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14426] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(714), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14453] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(734), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14480] = 10,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(956), 1,
      anon_sym_DOLLAR,
    ACTIONS(958), 1,
      anon_sym_LPAREN,
    ACTIONS(962), 1,
      anon_sym_LBRACE,
    ACTIONS(964), 1,
      anon_sym_DQUOTE,
    ACTIONS(966), 1,
      anon_sym_SQUOTE,
    ACTIONS(1009), 1,
      sym_escape_sequence,
    STATE(451), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(422), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(1007), 6,
      sym_integer,
      sym_float,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14521] = 9,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(924), 1,
      anon_sym_DOLLAR,
    ACTIONS(926), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      anon_sym_LBRACE,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    STATE(563), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    ACTIONS(1011), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(542), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [14559] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1013), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14582] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1015), 17,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym__special_character,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [14605] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1023), 1,
      anon_sym_RBRACK,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    STATE(425), 1,
      sym_index,
    STATE(242), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14647] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1031), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(243), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14689] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1033), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(242), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14731] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1035), 1,
      anon_sym_DOLLAR,
    ACTIONS(1038), 1,
      anon_sym_LPAREN,
    ACTIONS(1041), 1,
      sym_integer,
    ACTIONS(1044), 1,
      anon_sym_RBRACK,
    ACTIONS(1046), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1049), 1,
      anon_sym_DQUOTE,
    ACTIONS(1052), 1,
      anon_sym_SQUOTE,
    STATE(425), 1,
      sym_index,
    STATE(242), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14773] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1055), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(242), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14815] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1057), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(239), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14857] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1059), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(241), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14899] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1061), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(247), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14941] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1063), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(242), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [14983] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1065), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(249), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15025] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1067), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(242), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15067] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1069), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(251), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15109] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1071), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(242), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15151] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1073), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(253), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15193] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1075), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(242), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15235] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1077), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(255), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15277] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1025), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    ACTIONS(1079), 1,
      anon_sym_RBRACK,
    STATE(425), 1,
      sym_index,
    STATE(242), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15319] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(260), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(687), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15344] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1081), 1,
      sym__concat_list,
    STATE(259), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(687), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15371] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1083), 1,
      sym__concat_list,
    STATE(258), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(697), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(695), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15398] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1081), 1,
      sym__concat_list,
    STATE(258), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(691), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15425] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(258), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(691), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15450] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(740), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(738), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15472] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(712), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(710), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15494] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    STATE(414), 1,
      sym_index,
    ACTIONS(1086), 2,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15530] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1088), 1,
      sym__concat,
    ACTIONS(1090), 1,
      sym__concat_oct,
    STATE(268), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(728), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15556] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(697), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(695), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15578] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1088), 1,
      sym__concat,
    ACTIONS(1090), 1,
      sym__concat_oct,
    STATE(268), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(704), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15604] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(730), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15626] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1088), 1,
      sym__concat,
    ACTIONS(1092), 1,
      sym__concat_oct,
    STATE(270), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(742), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15652] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(714), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15674] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1094), 1,
      sym__concat,
    ACTIONS(1097), 1,
      sym__concat_oct,
    STATE(270), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(718), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15700] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(734), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15722] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    ACTIONS(1021), 1,
      sym_integer,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    ACTIONS(1029), 1,
      anon_sym_SQUOTE,
    STATE(420), 1,
      sym_index,
    ACTIONS(1100), 2,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
    STATE(432), 2,
      sym_command_substitution_dollar,
      sym_command_substitution_fish,
    STATE(427), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [15758] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(748), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(746), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15779] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(756), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(754), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15800] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(714), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15821] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(768), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(766), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15842] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(784), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(782), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15863] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(752), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(750), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15884] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(790), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(718), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15905] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(730), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15926] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(788), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(786), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15947] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(764), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(762), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15968] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(734), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [15989] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(794), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(792), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [16010] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(760), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(758), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [16031] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(772), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(770), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [16052] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(780), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(778), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [16073] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1112), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16103] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1114), 9,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [16127] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1116), 6,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [16155] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1118), 8,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [16181] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(177), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16211] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1120), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16241] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(173), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16271] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(193), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16301] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(197), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16331] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1122), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16361] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1124), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16391] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16421] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16451] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(407), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16481] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1126), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16511] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1128), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16541] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1130), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16571] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16601] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(265), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16631] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1132), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16661] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1134), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16691] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(391), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16721] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(455), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16751] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1136), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16781] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1138), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16811] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16841] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(297), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16871] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16901] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1140), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16931] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1142), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16961] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(301), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [16991] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1144), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17021] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1146), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17051] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1148), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17081] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(381), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17111] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17141] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1150), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17171] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(395), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17201] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1152), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17231] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17261] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1154), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17291] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1156), 6,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17319] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(439), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17349] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1158), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17379] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17409] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17439] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1160), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17469] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1162), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17499] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17529] = 8,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1164), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17559] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1166), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17576] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1168), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17603] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1170), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17630] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1172), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17647] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1174), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17664] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1176), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17691] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1178), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17718] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1180), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17745] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1182), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17762] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1184), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [17789] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1186), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17806] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1188), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17823] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1190), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17840] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1192), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17857] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1190), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17874] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1190), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17891] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1190), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17908] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1194), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17925] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1196), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17942] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1196), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17959] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1196), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17976] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1198), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [17993] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1196), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18010] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1190), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18027] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1200), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18044] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1166), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18061] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1166), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18078] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1166), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18095] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1110), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18122] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1202), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18139] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1196), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18156] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1204), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18173] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1206), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18190] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1166), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18207] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1208), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18224] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1210), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18241] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1212), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18258] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1206), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18275] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1206), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18292] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1206), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18309] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1206), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18326] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1214), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18343] = 7,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1104), 1,
      sym_stream_redirect,
    ACTIONS(1106), 1,
      sym_direction,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    STATE(348), 1,
      sym_file_redirect,
    ACTIONS(1102), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1216), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18370] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1218), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      sym_stream_redirect,
      sym_direction,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [18387] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1220), 1,
      sym__concat_list,
    STATE(382), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(697), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18406] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(382), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18423] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1223), 1,
      sym__concat_list,
    STATE(387), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18442] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(391), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(687), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18461] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym__concat_list,
    STATE(386), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(697), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(695), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18482] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1223), 1,
      sym__concat_list,
    STATE(382), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18501] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1228), 1,
      sym__concat_list,
    STATE(389), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(687), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18522] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1228), 1,
      sym__concat_list,
    STATE(386), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(691), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18543] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(383), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18560] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(386), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(691), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18579] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(714), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18595] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18609] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18623] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(712), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(710), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18639] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18653] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(734), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18669] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(730), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18685] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18699] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18713] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1230), 1,
      sym__concat,
    ACTIONS(1233), 1,
      sym__concat_oct,
    STATE(401), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(718), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18733] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(697), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(695), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18749] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1236), 1,
      sym__concat,
    ACTIONS(1238), 1,
      sym__concat_oct,
    STATE(405), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(704), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18769] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18783] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1236), 1,
      sym__concat,
    ACTIONS(1240), 1,
      sym__concat_oct,
    STATE(401), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(742), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18803] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(740), 3,
      sym__concat,
      sym__concat_oct,
      sym__concat_list,
    ACTIONS(738), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18819] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1236), 1,
      sym__concat,
    ACTIONS(1238), 1,
      sym__concat_oct,
    STATE(405), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(728), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18839] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(760), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(758), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18854] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1244), 1,
      anon_sym_DQUOTE,
    ACTIONS(1246), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1248), 1,
      sym_escape_sequence,
    STATE(435), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [18875] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(752), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(750), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18890] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1250), 1,
      anon_sym_DQUOTE,
    ACTIONS(1252), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1254), 1,
      sym_escape_sequence,
    STATE(429), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [18911] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1246), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1248), 1,
      sym_escape_sequence,
    ACTIONS(1256), 1,
      anon_sym_DQUOTE,
    STATE(435), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [18932] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(734), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18947] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1258), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [18960] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(714), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18975] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(730), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [18990] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1246), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1248), 1,
      sym_escape_sequence,
    ACTIONS(1260), 1,
      anon_sym_DQUOTE,
    STATE(435), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19011] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1262), 1,
      anon_sym_DQUOTE,
    ACTIONS(1264), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1266), 1,
      sym_escape_sequence,
    STATE(417), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19032] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(748), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(746), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19047] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1086), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19060] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1268), 1,
      anon_sym_DQUOTE,
    ACTIONS(1270), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1272), 1,
      sym_escape_sequence,
    STATE(430), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19081] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(790), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(718), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19096] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(768), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(766), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19111] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(756), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(754), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19126] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1276), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1274), 6,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19141] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1278), 1,
      anon_sym_DQUOTE,
    ACTIONS(1280), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1282), 1,
      sym_escape_sequence,
    STATE(409), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19162] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1284), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19175] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1246), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1248), 1,
      sym_escape_sequence,
    ACTIONS(1286), 1,
      anon_sym_DQUOTE,
    STATE(435), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19196] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1246), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1248), 1,
      sym_escape_sequence,
    ACTIONS(1288), 1,
      anon_sym_DQUOTE,
    STATE(435), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19217] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1246), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1248), 1,
      sym_escape_sequence,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    STATE(435), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19238] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19251] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19264] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1292), 1,
      anon_sym_DQUOTE,
    ACTIONS(1294), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1296), 1,
      sym_escape_sequence,
    STATE(412), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19285] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19298] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1298), 1,
      anon_sym_DOLLAR,
    ACTIONS(1301), 1,
      anon_sym_DQUOTE,
    ACTIONS(1303), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1306), 1,
      sym_escape_sequence,
    STATE(435), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19319] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1309), 1,
      anon_sym_DQUOTE,
    ACTIONS(1311), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1313), 1,
      sym_escape_sequence,
    STATE(428), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19340] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19353] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(772), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(770), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19368] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19381] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19394] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(780), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(778), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19409] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19422] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1315), 1,
      anon_sym_DQUOTE,
    ACTIONS(1317), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1319), 1,
      sym_escape_sequence,
    STATE(452), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19443] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19456] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19469] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(788), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(786), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19484] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(784), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(782), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19499] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(764), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(762), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19514] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19527] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [19540] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(794), 2,
      sym__concat,
      sym__concat_oct,
    ACTIONS(792), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19555] = 6,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1242), 1,
      anon_sym_DOLLAR,
    ACTIONS(1246), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1248), 1,
      sym_escape_sequence,
    ACTIONS(1321), 1,
      anon_sym_DQUOTE,
    STATE(435), 3,
      sym_command_substitution_dollar,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [19576] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(458), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(691), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19592] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(693), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1323), 1,
      sym__concat_list,
    STATE(458), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(691), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19610] = 4,
    ACTIONS(39), 1,
      sym_comment,
    STATE(453), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(687), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19626] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1327), 1,
      anon_sym_if,
    ACTIONS(1325), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19640] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(689), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1323), 1,
      sym__concat_list,
    STATE(454), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(687), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19658] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(697), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(1329), 1,
      sym__concat_list,
    STATE(458), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(695), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19676] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1332), 1,
      anon_sym_DOLLAR,
    ACTIONS(1334), 1,
      anon_sym_LPAREN,
    ACTIONS(1336), 1,
      sym_variable_name,
    STATE(147), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [19693] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(740), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(738), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19706] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1338), 1,
      anon_sym_DOLLAR,
    ACTIONS(1340), 1,
      anon_sym_LPAREN,
    ACTIONS(1342), 1,
      sym_variable_name,
    STATE(457), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [19723] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(730), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19736] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1344), 1,
      anon_sym_DOLLAR,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(1348), 1,
      sym_variable_name,
    STATE(388), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [19753] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1332), 1,
      anon_sym_DOLLAR,
    ACTIONS(1350), 1,
      anon_sym_LPAREN,
    ACTIONS(1352), 1,
      sym_variable_name,
    STATE(148), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [19770] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1354), 1,
      anon_sym_DOLLAR,
    ACTIONS(1356), 1,
      anon_sym_LPAREN,
    ACTIONS(1358), 1,
      sym_variable_name,
    STATE(257), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [19787] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(697), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(695), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19800] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1354), 1,
      anon_sym_DOLLAR,
    ACTIONS(1360), 1,
      anon_sym_LPAREN,
    ACTIONS(1362), 1,
      sym_variable_name,
    STATE(256), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [19817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(482), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [19830] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1364), 1,
      sym__concat_list,
    STATE(482), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(693), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [19845] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(734), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19858] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1364), 1,
      sym__concat_list,
    STATE(469), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [19873] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(712), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(710), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19886] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1344), 1,
      anon_sym_DOLLAR,
    ACTIONS(1366), 1,
      anon_sym_LPAREN,
    ACTIONS(1368), 1,
      sym_variable_name,
    STATE(385), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [19903] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 2,
      sym__concat_list,
      aux_sym_double_quote_string_token1,
    ACTIONS(714), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [19916] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1370), 1,
      anon_sym_DOLLAR,
    ACTIONS(1372), 1,
      anon_sym_LPAREN,
    ACTIONS(1374), 1,
      sym_variable_name,
    STATE(200), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [19933] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1376), 1,
      anon_sym_DOLLAR,
    ACTIONS(1378), 1,
      anon_sym_LPAREN,
    ACTIONS(1380), 1,
      sym_variable_name,
    STATE(110), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [19950] = 2,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1382), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [19961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(468), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(689), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [19974] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 1,
      anon_sym_DOLLAR,
    ACTIONS(1386), 1,
      anon_sym_LPAREN,
    ACTIONS(1388), 1,
      sym_variable_name,
    STATE(471), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [19991] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 1,
      anon_sym_DOLLAR,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    ACTIONS(1392), 1,
      sym_variable_name,
    STATE(478), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [20008] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1394), 1,
      anon_sym_end,
    ACTIONS(1396), 1,
      anon_sym_else,
    STATE(586), 1,
      sym_else_clause,
    STATE(504), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
  [20025] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      sym__concat_list,
    STATE(482), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(697), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20040] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1338), 1,
      anon_sym_DOLLAR,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      sym_variable_name,
    STATE(455), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [20057] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1376), 1,
      anon_sym_DOLLAR,
    ACTIONS(1405), 1,
      anon_sym_LPAREN,
    ACTIONS(1407), 1,
      sym_variable_name,
    STATE(114), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [20074] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1409), 1,
      anon_sym_DOLLAR,
    ACTIONS(1411), 1,
      anon_sym_LPAREN,
    ACTIONS(1413), 1,
      sym_variable_name,
    STATE(384), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [20091] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1370), 1,
      anon_sym_DOLLAR,
    ACTIONS(1415), 1,
      anon_sym_LPAREN,
    ACTIONS(1417), 1,
      sym_variable_name,
    STATE(203), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [20108] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1396), 1,
      anon_sym_else,
    ACTIONS(1419), 1,
      anon_sym_end,
    STATE(581), 1,
      sym_else_clause,
    STATE(504), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
  [20125] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1409), 1,
      anon_sym_DOLLAR,
    ACTIONS(1421), 1,
      anon_sym_LPAREN,
    ACTIONS(1423), 1,
      sym_variable_name,
    STATE(390), 2,
      sym_command_substitution_dollar,
      sym_variable_expansion,
  [20142] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20152] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1425), 1,
      anon_sym_end,
    ACTIONS(1427), 1,
      anon_sym_case,
    STATE(490), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
  [20166] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(732), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(730), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [20178] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(716), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(714), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [20190] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1430), 1,
      anon_sym_SQUOTE,
    ACTIONS(1432), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1434), 1,
      sym_escape_sequence,
    STATE(499), 1,
      aux_sym_single_quote_string_repeat1,
  [20206] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1436), 1,
      anon_sym_SQUOTE,
    ACTIONS(1438), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1440), 1,
      sym_escape_sequence,
    STATE(505), 1,
      aux_sym_single_quote_string_repeat1,
  [20222] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1432), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1434), 1,
      sym_escape_sequence,
    ACTIONS(1442), 1,
      anon_sym_SQUOTE,
    STATE(499), 1,
      aux_sym_single_quote_string_repeat1,
  [20238] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20248] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1444), 1,
      anon_sym_SQUOTE,
    ACTIONS(1446), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1448), 1,
      sym_escape_sequence,
    STATE(503), 1,
      aux_sym_single_quote_string_repeat1,
  [20264] = 3,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(736), 1,
      aux_sym_double_quote_string_token1,
    ACTIONS(734), 3,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [20276] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1450), 1,
      anon_sym_SQUOTE,
    ACTIONS(1452), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1455), 1,
      sym_escape_sequence,
    STATE(499), 1,
      aux_sym_single_quote_string_repeat1,
  [20292] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1460), 1,
      sym__brace_concat,
    STATE(500), 1,
      aux_sym_brace_concatenation_repeat1,
    ACTIONS(1458), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20306] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20316] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 1,
      sym__brace_concat,
    STATE(516), 1,
      aux_sym_brace_concatenation_repeat1,
    ACTIONS(1463), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20330] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1432), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1434), 1,
      sym_escape_sequence,
    ACTIONS(1467), 1,
      anon_sym_SQUOTE,
    STATE(499), 1,
      aux_sym_single_quote_string_repeat1,
  [20346] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1469), 1,
      anon_sym_end,
    ACTIONS(1471), 1,
      anon_sym_else,
    STATE(504), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
  [20360] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1432), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1434), 1,
      sym_escape_sequence,
    ACTIONS(1474), 1,
      anon_sym_SQUOTE,
    STATE(499), 1,
      aux_sym_single_quote_string_repeat1,
  [20376] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1476), 1,
      anon_sym_SQUOTE,
    ACTIONS(1478), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1480), 1,
      sym_escape_sequence,
    STATE(493), 1,
      aux_sym_single_quote_string_repeat1,
  [20392] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1482), 1,
      anon_sym_SQUOTE,
    ACTIONS(1484), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1486), 1,
      sym_escape_sequence,
    STATE(512), 1,
      aux_sym_single_quote_string_repeat1,
  [20408] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20418] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20428] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1432), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1434), 1,
      sym_escape_sequence,
    ACTIONS(1488), 1,
      anon_sym_SQUOTE,
    STATE(499), 1,
      aux_sym_single_quote_string_repeat1,
  [20444] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1432), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1434), 1,
      sym_escape_sequence,
    ACTIONS(1490), 1,
      anon_sym_SQUOTE,
    STATE(499), 1,
      aux_sym_single_quote_string_repeat1,
  [20460] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1432), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1434), 1,
      sym_escape_sequence,
    ACTIONS(1492), 1,
      anon_sym_SQUOTE,
    STATE(499), 1,
      aux_sym_single_quote_string_repeat1,
  [20476] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1494), 1,
      anon_sym_end,
    ACTIONS(1496), 1,
      anon_sym_case,
    STATE(490), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
  [20490] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1498), 1,
      anon_sym_SQUOTE,
    ACTIONS(1500), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1502), 1,
      sym_escape_sequence,
    STATE(495), 1,
      aux_sym_single_quote_string_repeat1,
  [20506] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20516] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 1,
      sym__brace_concat,
    STATE(500), 1,
      aux_sym_brace_concatenation_repeat1,
    ACTIONS(1504), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20530] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1506), 1,
      anon_sym_SQUOTE,
    ACTIONS(1508), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1510), 1,
      sym_escape_sequence,
    STATE(511), 1,
      aux_sym_single_quote_string_repeat1,
  [20546] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1496), 1,
      anon_sym_case,
    ACTIONS(1512), 1,
      anon_sym_end,
    STATE(513), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
  [20560] = 5,
    ACTIONS(39), 1,
      sym_comment,
    ACTIONS(1514), 1,
      anon_sym_SQUOTE,
    ACTIONS(1516), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1518), 1,
      sym_escape_sequence,
    STATE(510), 1,
      aux_sym_single_quote_string_repeat1,
  [20576] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1522), 1,
      anon_sym_RBRACE,
    ACTIONS(1520), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [20587] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1526), 1,
      anon_sym_RBRACE,
    STATE(539), 1,
      aux_sym_brace_expansion_repeat1,
  [20600] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20609] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1526), 1,
      anon_sym_RBRACE,
    STATE(552), 1,
      aux_sym_brace_expansion_repeat1,
  [20622] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1526), 1,
      anon_sym_RBRACE,
    ACTIONS(1528), 1,
      anon_sym_COMMA,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20635] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20644] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1531), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20657] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1533), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20670] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1535), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20683] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1526), 1,
      anon_sym_RBRACE,
    STATE(549), 1,
      aux_sym_brace_expansion_repeat1,
  [20696] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20705] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1537), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20718] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1537), 1,
      anon_sym_RBRACE,
    ACTIONS(1520), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [20729] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1539), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20742] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1541), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20755] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1543), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20768] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1526), 1,
      anon_sym_RBRACE,
    STATE(526), 1,
      aux_sym_brace_expansion_repeat1,
  [20781] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1541), 1,
      anon_sym_RBRACE,
    ACTIONS(1520), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [20792] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1545), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20805] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1547), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20818] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20827] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1549), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20840] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1458), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20849] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1551), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20862] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1553), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20875] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(784), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20884] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1526), 1,
      anon_sym_RBRACE,
    STATE(533), 1,
      aux_sym_brace_expansion_repeat1,
  [20897] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [20906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1551), 1,
      anon_sym_RBRACE,
    ACTIONS(1520), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [20917] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1555), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20930] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1557), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20943] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1553), 1,
      anon_sym_RBRACE,
    ACTIONS(1520), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [20954] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1559), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20967] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1522), 1,
      anon_sym_RBRACE,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [20980] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1526), 1,
      anon_sym_RBRACE,
    STATE(560), 1,
      aux_sym_brace_expansion_repeat1,
  [20993] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [21002] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [21011] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [21020] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1535), 1,
      anon_sym_RBRACE,
    ACTIONS(1520), 2,
      sym__brace_concat,
      anon_sym_COMMA,
  [21031] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [21040] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1561), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [21053] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    ACTIONS(1563), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      aux_sym_brace_expansion_repeat1,
  [21066] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [21075] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [21084] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [21093] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [21102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1565), 1,
      anon_sym_LBRACK,
    STATE(163), 1,
      sym_list_element_access,
  [21112] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1567), 1,
      anon_sym_LBRACK,
    STATE(402), 1,
      sym_list_element_access,
  [21122] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1569), 1,
      anon_sym_LBRACK,
    STATE(125), 1,
      sym_list_element_access,
  [21132] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1571), 1,
      anon_sym_LBRACK,
    STATE(466), 1,
      sym_list_element_access,
  [21142] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    STATE(550), 1,
      aux_sym_brace_expansion_repeat1,
  [21152] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    STATE(527), 1,
      aux_sym_brace_expansion_repeat1,
  [21162] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1526), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [21170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1573), 1,
      anon_sym_LBRACK,
    STATE(211), 1,
      sym_list_element_access,
  [21180] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    STATE(535), 1,
      aux_sym_brace_expansion_repeat1,
  [21190] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    STATE(538), 1,
      aux_sym_brace_expansion_repeat1,
  [21200] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1575), 1,
      anon_sym_LBRACK,
    STATE(501), 1,
      sym_list_element_access,
  [21210] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1577), 1,
      anon_sym_LBRACK,
    STATE(404), 1,
      sym_list_element_access,
  [21220] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    STATE(561), 1,
      aux_sym_brace_expansion_repeat1,
  [21230] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1579), 1,
      anon_sym_LBRACK,
    STATE(265), 1,
      sym_list_element_access,
  [21240] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    STATE(541), 1,
      aux_sym_brace_expansion_repeat1,
  [21250] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1394), 1,
      anon_sym_end,
  [21257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1419), 1,
      anon_sym_end,
  [21264] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1581), 1,
      anon_sym_in,
  [21271] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      sym_variable_name,
  [21278] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1585), 1,
      anon_sym_if,
  [21285] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1587), 1,
      anon_sym_end,
  [21292] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1589), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(14)] = 0,
  [SMALL_STATE(15)] = 112,
  [SMALL_STATE(16)] = 224,
  [SMALL_STATE(17)] = 336,
  [SMALL_STATE(18)] = 448,
  [SMALL_STATE(19)] = 560,
  [SMALL_STATE(20)] = 672,
  [SMALL_STATE(21)] = 784,
  [SMALL_STATE(22)] = 896,
  [SMALL_STATE(23)] = 1008,
  [SMALL_STATE(24)] = 1120,
  [SMALL_STATE(25)] = 1232,
  [SMALL_STATE(26)] = 1344,
  [SMALL_STATE(27)] = 1456,
  [SMALL_STATE(28)] = 1568,
  [SMALL_STATE(29)] = 1680,
  [SMALL_STATE(30)] = 1792,
  [SMALL_STATE(31)] = 1904,
  [SMALL_STATE(32)] = 2016,
  [SMALL_STATE(33)] = 2128,
  [SMALL_STATE(34)] = 2240,
  [SMALL_STATE(35)] = 2352,
  [SMALL_STATE(36)] = 2464,
  [SMALL_STATE(37)] = 2576,
  [SMALL_STATE(38)] = 2688,
  [SMALL_STATE(39)] = 2800,
  [SMALL_STATE(40)] = 2912,
  [SMALL_STATE(41)] = 3024,
  [SMALL_STATE(42)] = 3136,
  [SMALL_STATE(43)] = 3248,
  [SMALL_STATE(44)] = 3360,
  [SMALL_STATE(45)] = 3472,
  [SMALL_STATE(46)] = 3584,
  [SMALL_STATE(47)] = 3696,
  [SMALL_STATE(48)] = 3808,
  [SMALL_STATE(49)] = 3920,
  [SMALL_STATE(50)] = 4032,
  [SMALL_STATE(51)] = 4144,
  [SMALL_STATE(52)] = 4256,
  [SMALL_STATE(53)] = 4368,
  [SMALL_STATE(54)] = 4480,
  [SMALL_STATE(55)] = 4592,
  [SMALL_STATE(56)] = 4704,
  [SMALL_STATE(57)] = 4816,
  [SMALL_STATE(58)] = 4928,
  [SMALL_STATE(59)] = 5040,
  [SMALL_STATE(60)] = 5152,
  [SMALL_STATE(61)] = 5264,
  [SMALL_STATE(62)] = 5376,
  [SMALL_STATE(63)] = 5488,
  [SMALL_STATE(64)] = 5597,
  [SMALL_STATE(65)] = 5706,
  [SMALL_STATE(66)] = 5815,
  [SMALL_STATE(67)] = 5923,
  [SMALL_STATE(68)] = 6031,
  [SMALL_STATE(69)] = 6139,
  [SMALL_STATE(70)] = 6247,
  [SMALL_STATE(71)] = 6355,
  [SMALL_STATE(72)] = 6463,
  [SMALL_STATE(73)] = 6571,
  [SMALL_STATE(74)] = 6679,
  [SMALL_STATE(75)] = 6787,
  [SMALL_STATE(76)] = 6895,
  [SMALL_STATE(77)] = 7003,
  [SMALL_STATE(78)] = 7111,
  [SMALL_STATE(79)] = 7219,
  [SMALL_STATE(80)] = 7327,
  [SMALL_STATE(81)] = 7435,
  [SMALL_STATE(82)] = 7543,
  [SMALL_STATE(83)] = 7651,
  [SMALL_STATE(84)] = 7759,
  [SMALL_STATE(85)] = 7867,
  [SMALL_STATE(86)] = 7975,
  [SMALL_STATE(87)] = 8083,
  [SMALL_STATE(88)] = 8191,
  [SMALL_STATE(89)] = 8299,
  [SMALL_STATE(90)] = 8403,
  [SMALL_STATE(91)] = 8507,
  [SMALL_STATE(92)] = 8611,
  [SMALL_STATE(93)] = 8712,
  [SMALL_STATE(94)] = 8813,
  [SMALL_STATE(95)] = 8914,
  [SMALL_STATE(96)] = 9015,
  [SMALL_STATE(97)] = 9083,
  [SMALL_STATE(98)] = 9151,
  [SMALL_STATE(99)] = 9219,
  [SMALL_STATE(100)] = 9287,
  [SMALL_STATE(101)] = 9327,
  [SMALL_STATE(102)] = 9367,
  [SMALL_STATE(103)] = 9406,
  [SMALL_STATE(104)] = 9445,
  [SMALL_STATE(105)] = 9484,
  [SMALL_STATE(106)] = 9525,
  [SMALL_STATE(107)] = 9586,
  [SMALL_STATE(108)] = 9647,
  [SMALL_STATE(109)] = 9708,
  [SMALL_STATE(110)] = 9766,
  [SMALL_STATE(111)] = 9806,
  [SMALL_STATE(112)] = 9846,
  [SMALL_STATE(113)] = 9888,
  [SMALL_STATE(114)] = 9930,
  [SMALL_STATE(115)] = 9972,
  [SMALL_STATE(116)] = 10013,
  [SMALL_STATE(117)] = 10050,
  [SMALL_STATE(118)] = 10087,
  [SMALL_STATE(119)] = 10128,
  [SMALL_STATE(120)] = 10165,
  [SMALL_STATE(121)] = 10206,
  [SMALL_STATE(122)] = 10243,
  [SMALL_STATE(123)] = 10280,
  [SMALL_STATE(124)] = 10317,
  [SMALL_STATE(125)] = 10358,
  [SMALL_STATE(126)] = 10395,
  [SMALL_STATE(127)] = 10431,
  [SMALL_STATE(128)] = 10467,
  [SMALL_STATE(129)] = 10503,
  [SMALL_STATE(130)] = 10539,
  [SMALL_STATE(131)] = 10575,
  [SMALL_STATE(132)] = 10611,
  [SMALL_STATE(133)] = 10647,
  [SMALL_STATE(134)] = 10683,
  [SMALL_STATE(135)] = 10719,
  [SMALL_STATE(136)] = 10755,
  [SMALL_STATE(137)] = 10815,
  [SMALL_STATE(138)] = 10851,
  [SMALL_STATE(139)] = 10887,
  [SMALL_STATE(140)] = 10923,
  [SMALL_STATE(141)] = 10959,
  [SMALL_STATE(142)] = 10995,
  [SMALL_STATE(143)] = 11031,
  [SMALL_STATE(144)] = 11094,
  [SMALL_STATE(145)] = 11157,
  [SMALL_STATE(146)] = 11212,
  [SMALL_STATE(147)] = 11251,
  [SMALL_STATE(148)] = 11288,
  [SMALL_STATE(149)] = 11327,
  [SMALL_STATE(150)] = 11380,
  [SMALL_STATE(151)] = 11417,
  [SMALL_STATE(152)] = 11470,
  [SMALL_STATE(153)] = 11509,
  [SMALL_STATE(154)] = 11564,
  [SMALL_STATE(155)] = 11619,
  [SMALL_STATE(156)] = 11657,
  [SMALL_STATE(157)] = 11691,
  [SMALL_STATE(158)] = 11725,
  [SMALL_STATE(159)] = 11763,
  [SMALL_STATE(160)] = 11797,
  [SMALL_STATE(161)] = 11829,
  [SMALL_STATE(162)] = 11861,
  [SMALL_STATE(163)] = 11895,
  [SMALL_STATE(164)] = 11929,
  [SMALL_STATE(165)] = 11963,
  [SMALL_STATE(166)] = 12001,
  [SMALL_STATE(167)] = 12039,
  [SMALL_STATE(168)] = 12072,
  [SMALL_STATE(169)] = 12105,
  [SMALL_STATE(170)] = 12138,
  [SMALL_STATE(171)] = 12171,
  [SMALL_STATE(172)] = 12204,
  [SMALL_STATE(173)] = 12237,
  [SMALL_STATE(174)] = 12270,
  [SMALL_STATE(175)] = 12303,
  [SMALL_STATE(176)] = 12336,
  [SMALL_STATE(177)] = 12369,
  [SMALL_STATE(178)] = 12402,
  [SMALL_STATE(179)] = 12435,
  [SMALL_STATE(180)] = 12468,
  [SMALL_STATE(181)] = 12501,
  [SMALL_STATE(182)] = 12534,
  [SMALL_STATE(183)] = 12585,
  [SMALL_STATE(184)] = 12636,
  [SMALL_STATE(185)] = 12687,
  [SMALL_STATE(186)] = 12738,
  [SMALL_STATE(187)] = 12767,
  [SMALL_STATE(188)] = 12818,
  [SMALL_STATE(189)] = 12869,
  [SMALL_STATE(190)] = 12919,
  [SMALL_STATE(191)] = 12969,
  [SMALL_STATE(192)] = 13019,
  [SMALL_STATE(193)] = 13067,
  [SMALL_STATE(194)] = 13117,
  [SMALL_STATE(195)] = 13167,
  [SMALL_STATE(196)] = 13217,
  [SMALL_STATE(197)] = 13267,
  [SMALL_STATE(198)] = 13313,
  [SMALL_STATE(199)] = 13360,
  [SMALL_STATE(200)] = 13393,
  [SMALL_STATE(201)] = 13424,
  [SMALL_STATE(202)] = 13471,
  [SMALL_STATE(203)] = 13502,
  [SMALL_STATE(204)] = 13535,
  [SMALL_STATE(205)] = 13568,
  [SMALL_STATE(206)] = 13615,
  [SMALL_STATE(207)] = 13643,
  [SMALL_STATE(208)] = 13671,
  [SMALL_STATE(209)] = 13703,
  [SMALL_STATE(210)] = 13735,
  [SMALL_STATE(211)] = 13763,
  [SMALL_STATE(212)] = 13791,
  [SMALL_STATE(213)] = 13823,
  [SMALL_STATE(214)] = 13851,
  [SMALL_STATE(215)] = 13883,
  [SMALL_STATE(216)] = 13911,
  [SMALL_STATE(217)] = 13952,
  [SMALL_STATE(218)] = 13979,
  [SMALL_STATE(219)] = 14006,
  [SMALL_STATE(220)] = 14033,
  [SMALL_STATE(221)] = 14060,
  [SMALL_STATE(222)] = 14087,
  [SMALL_STATE(223)] = 14114,
  [SMALL_STATE(224)] = 14141,
  [SMALL_STATE(225)] = 14182,
  [SMALL_STATE(226)] = 14209,
  [SMALL_STATE(227)] = 14236,
  [SMALL_STATE(228)] = 14263,
  [SMALL_STATE(229)] = 14290,
  [SMALL_STATE(230)] = 14331,
  [SMALL_STATE(231)] = 14358,
  [SMALL_STATE(232)] = 14385,
  [SMALL_STATE(233)] = 14426,
  [SMALL_STATE(234)] = 14453,
  [SMALL_STATE(235)] = 14480,
  [SMALL_STATE(236)] = 14521,
  [SMALL_STATE(237)] = 14559,
  [SMALL_STATE(238)] = 14582,
  [SMALL_STATE(239)] = 14605,
  [SMALL_STATE(240)] = 14647,
  [SMALL_STATE(241)] = 14689,
  [SMALL_STATE(242)] = 14731,
  [SMALL_STATE(243)] = 14773,
  [SMALL_STATE(244)] = 14815,
  [SMALL_STATE(245)] = 14857,
  [SMALL_STATE(246)] = 14899,
  [SMALL_STATE(247)] = 14941,
  [SMALL_STATE(248)] = 14983,
  [SMALL_STATE(249)] = 15025,
  [SMALL_STATE(250)] = 15067,
  [SMALL_STATE(251)] = 15109,
  [SMALL_STATE(252)] = 15151,
  [SMALL_STATE(253)] = 15193,
  [SMALL_STATE(254)] = 15235,
  [SMALL_STATE(255)] = 15277,
  [SMALL_STATE(256)] = 15319,
  [SMALL_STATE(257)] = 15344,
  [SMALL_STATE(258)] = 15371,
  [SMALL_STATE(259)] = 15398,
  [SMALL_STATE(260)] = 15425,
  [SMALL_STATE(261)] = 15450,
  [SMALL_STATE(262)] = 15472,
  [SMALL_STATE(263)] = 15494,
  [SMALL_STATE(264)] = 15530,
  [SMALL_STATE(265)] = 15556,
  [SMALL_STATE(266)] = 15578,
  [SMALL_STATE(267)] = 15604,
  [SMALL_STATE(268)] = 15626,
  [SMALL_STATE(269)] = 15652,
  [SMALL_STATE(270)] = 15674,
  [SMALL_STATE(271)] = 15700,
  [SMALL_STATE(272)] = 15722,
  [SMALL_STATE(273)] = 15758,
  [SMALL_STATE(274)] = 15779,
  [SMALL_STATE(275)] = 15800,
  [SMALL_STATE(276)] = 15821,
  [SMALL_STATE(277)] = 15842,
  [SMALL_STATE(278)] = 15863,
  [SMALL_STATE(279)] = 15884,
  [SMALL_STATE(280)] = 15905,
  [SMALL_STATE(281)] = 15926,
  [SMALL_STATE(282)] = 15947,
  [SMALL_STATE(283)] = 15968,
  [SMALL_STATE(284)] = 15989,
  [SMALL_STATE(285)] = 16010,
  [SMALL_STATE(286)] = 16031,
  [SMALL_STATE(287)] = 16052,
  [SMALL_STATE(288)] = 16073,
  [SMALL_STATE(289)] = 16103,
  [SMALL_STATE(290)] = 16127,
  [SMALL_STATE(291)] = 16155,
  [SMALL_STATE(292)] = 16181,
  [SMALL_STATE(293)] = 16211,
  [SMALL_STATE(294)] = 16241,
  [SMALL_STATE(295)] = 16271,
  [SMALL_STATE(296)] = 16301,
  [SMALL_STATE(297)] = 16331,
  [SMALL_STATE(298)] = 16361,
  [SMALL_STATE(299)] = 16391,
  [SMALL_STATE(300)] = 16421,
  [SMALL_STATE(301)] = 16451,
  [SMALL_STATE(302)] = 16481,
  [SMALL_STATE(303)] = 16511,
  [SMALL_STATE(304)] = 16541,
  [SMALL_STATE(305)] = 16571,
  [SMALL_STATE(306)] = 16601,
  [SMALL_STATE(307)] = 16631,
  [SMALL_STATE(308)] = 16661,
  [SMALL_STATE(309)] = 16691,
  [SMALL_STATE(310)] = 16721,
  [SMALL_STATE(311)] = 16751,
  [SMALL_STATE(312)] = 16781,
  [SMALL_STATE(313)] = 16811,
  [SMALL_STATE(314)] = 16841,
  [SMALL_STATE(315)] = 16871,
  [SMALL_STATE(316)] = 16901,
  [SMALL_STATE(317)] = 16931,
  [SMALL_STATE(318)] = 16961,
  [SMALL_STATE(319)] = 16991,
  [SMALL_STATE(320)] = 17021,
  [SMALL_STATE(321)] = 17051,
  [SMALL_STATE(322)] = 17081,
  [SMALL_STATE(323)] = 17111,
  [SMALL_STATE(324)] = 17141,
  [SMALL_STATE(325)] = 17171,
  [SMALL_STATE(326)] = 17201,
  [SMALL_STATE(327)] = 17231,
  [SMALL_STATE(328)] = 17261,
  [SMALL_STATE(329)] = 17291,
  [SMALL_STATE(330)] = 17319,
  [SMALL_STATE(331)] = 17349,
  [SMALL_STATE(332)] = 17379,
  [SMALL_STATE(333)] = 17409,
  [SMALL_STATE(334)] = 17439,
  [SMALL_STATE(335)] = 17469,
  [SMALL_STATE(336)] = 17499,
  [SMALL_STATE(337)] = 17529,
  [SMALL_STATE(338)] = 17559,
  [SMALL_STATE(339)] = 17576,
  [SMALL_STATE(340)] = 17603,
  [SMALL_STATE(341)] = 17630,
  [SMALL_STATE(342)] = 17647,
  [SMALL_STATE(343)] = 17664,
  [SMALL_STATE(344)] = 17691,
  [SMALL_STATE(345)] = 17718,
  [SMALL_STATE(346)] = 17745,
  [SMALL_STATE(347)] = 17762,
  [SMALL_STATE(348)] = 17789,
  [SMALL_STATE(349)] = 17806,
  [SMALL_STATE(350)] = 17823,
  [SMALL_STATE(351)] = 17840,
  [SMALL_STATE(352)] = 17857,
  [SMALL_STATE(353)] = 17874,
  [SMALL_STATE(354)] = 17891,
  [SMALL_STATE(355)] = 17908,
  [SMALL_STATE(356)] = 17925,
  [SMALL_STATE(357)] = 17942,
  [SMALL_STATE(358)] = 17959,
  [SMALL_STATE(359)] = 17976,
  [SMALL_STATE(360)] = 17993,
  [SMALL_STATE(361)] = 18010,
  [SMALL_STATE(362)] = 18027,
  [SMALL_STATE(363)] = 18044,
  [SMALL_STATE(364)] = 18061,
  [SMALL_STATE(365)] = 18078,
  [SMALL_STATE(366)] = 18095,
  [SMALL_STATE(367)] = 18122,
  [SMALL_STATE(368)] = 18139,
  [SMALL_STATE(369)] = 18156,
  [SMALL_STATE(370)] = 18173,
  [SMALL_STATE(371)] = 18190,
  [SMALL_STATE(372)] = 18207,
  [SMALL_STATE(373)] = 18224,
  [SMALL_STATE(374)] = 18241,
  [SMALL_STATE(375)] = 18258,
  [SMALL_STATE(376)] = 18275,
  [SMALL_STATE(377)] = 18292,
  [SMALL_STATE(378)] = 18309,
  [SMALL_STATE(379)] = 18326,
  [SMALL_STATE(380)] = 18343,
  [SMALL_STATE(381)] = 18370,
  [SMALL_STATE(382)] = 18387,
  [SMALL_STATE(383)] = 18406,
  [SMALL_STATE(384)] = 18423,
  [SMALL_STATE(385)] = 18442,
  [SMALL_STATE(386)] = 18461,
  [SMALL_STATE(387)] = 18482,
  [SMALL_STATE(388)] = 18501,
  [SMALL_STATE(389)] = 18522,
  [SMALL_STATE(390)] = 18543,
  [SMALL_STATE(391)] = 18560,
  [SMALL_STATE(392)] = 18579,
  [SMALL_STATE(393)] = 18595,
  [SMALL_STATE(394)] = 18609,
  [SMALL_STATE(395)] = 18623,
  [SMALL_STATE(396)] = 18639,
  [SMALL_STATE(397)] = 18653,
  [SMALL_STATE(398)] = 18669,
  [SMALL_STATE(399)] = 18685,
  [SMALL_STATE(400)] = 18699,
  [SMALL_STATE(401)] = 18713,
  [SMALL_STATE(402)] = 18733,
  [SMALL_STATE(403)] = 18749,
  [SMALL_STATE(404)] = 18769,
  [SMALL_STATE(405)] = 18783,
  [SMALL_STATE(406)] = 18803,
  [SMALL_STATE(407)] = 18819,
  [SMALL_STATE(408)] = 18839,
  [SMALL_STATE(409)] = 18854,
  [SMALL_STATE(410)] = 18875,
  [SMALL_STATE(411)] = 18890,
  [SMALL_STATE(412)] = 18911,
  [SMALL_STATE(413)] = 18932,
  [SMALL_STATE(414)] = 18947,
  [SMALL_STATE(415)] = 18960,
  [SMALL_STATE(416)] = 18975,
  [SMALL_STATE(417)] = 18990,
  [SMALL_STATE(418)] = 19011,
  [SMALL_STATE(419)] = 19032,
  [SMALL_STATE(420)] = 19047,
  [SMALL_STATE(421)] = 19060,
  [SMALL_STATE(422)] = 19081,
  [SMALL_STATE(423)] = 19096,
  [SMALL_STATE(424)] = 19111,
  [SMALL_STATE(425)] = 19126,
  [SMALL_STATE(426)] = 19141,
  [SMALL_STATE(427)] = 19162,
  [SMALL_STATE(428)] = 19175,
  [SMALL_STATE(429)] = 19196,
  [SMALL_STATE(430)] = 19217,
  [SMALL_STATE(431)] = 19238,
  [SMALL_STATE(432)] = 19251,
  [SMALL_STATE(433)] = 19264,
  [SMALL_STATE(434)] = 19285,
  [SMALL_STATE(435)] = 19298,
  [SMALL_STATE(436)] = 19319,
  [SMALL_STATE(437)] = 19340,
  [SMALL_STATE(438)] = 19353,
  [SMALL_STATE(439)] = 19368,
  [SMALL_STATE(440)] = 19381,
  [SMALL_STATE(441)] = 19394,
  [SMALL_STATE(442)] = 19409,
  [SMALL_STATE(443)] = 19422,
  [SMALL_STATE(444)] = 19443,
  [SMALL_STATE(445)] = 19456,
  [SMALL_STATE(446)] = 19469,
  [SMALL_STATE(447)] = 19484,
  [SMALL_STATE(448)] = 19499,
  [SMALL_STATE(449)] = 19514,
  [SMALL_STATE(450)] = 19527,
  [SMALL_STATE(451)] = 19540,
  [SMALL_STATE(452)] = 19555,
  [SMALL_STATE(453)] = 19576,
  [SMALL_STATE(454)] = 19592,
  [SMALL_STATE(455)] = 19610,
  [SMALL_STATE(456)] = 19626,
  [SMALL_STATE(457)] = 19640,
  [SMALL_STATE(458)] = 19658,
  [SMALL_STATE(459)] = 19676,
  [SMALL_STATE(460)] = 19693,
  [SMALL_STATE(461)] = 19706,
  [SMALL_STATE(462)] = 19723,
  [SMALL_STATE(463)] = 19736,
  [SMALL_STATE(464)] = 19753,
  [SMALL_STATE(465)] = 19770,
  [SMALL_STATE(466)] = 19787,
  [SMALL_STATE(467)] = 19800,
  [SMALL_STATE(468)] = 19817,
  [SMALL_STATE(469)] = 19830,
  [SMALL_STATE(470)] = 19845,
  [SMALL_STATE(471)] = 19858,
  [SMALL_STATE(472)] = 19873,
  [SMALL_STATE(473)] = 19886,
  [SMALL_STATE(474)] = 19903,
  [SMALL_STATE(475)] = 19916,
  [SMALL_STATE(476)] = 19933,
  [SMALL_STATE(477)] = 19950,
  [SMALL_STATE(478)] = 19961,
  [SMALL_STATE(479)] = 19974,
  [SMALL_STATE(480)] = 19991,
  [SMALL_STATE(481)] = 20008,
  [SMALL_STATE(482)] = 20025,
  [SMALL_STATE(483)] = 20040,
  [SMALL_STATE(484)] = 20057,
  [SMALL_STATE(485)] = 20074,
  [SMALL_STATE(486)] = 20091,
  [SMALL_STATE(487)] = 20108,
  [SMALL_STATE(488)] = 20125,
  [SMALL_STATE(489)] = 20142,
  [SMALL_STATE(490)] = 20152,
  [SMALL_STATE(491)] = 20166,
  [SMALL_STATE(492)] = 20178,
  [SMALL_STATE(493)] = 20190,
  [SMALL_STATE(494)] = 20206,
  [SMALL_STATE(495)] = 20222,
  [SMALL_STATE(496)] = 20238,
  [SMALL_STATE(497)] = 20248,
  [SMALL_STATE(498)] = 20264,
  [SMALL_STATE(499)] = 20276,
  [SMALL_STATE(500)] = 20292,
  [SMALL_STATE(501)] = 20306,
  [SMALL_STATE(502)] = 20316,
  [SMALL_STATE(503)] = 20330,
  [SMALL_STATE(504)] = 20346,
  [SMALL_STATE(505)] = 20360,
  [SMALL_STATE(506)] = 20376,
  [SMALL_STATE(507)] = 20392,
  [SMALL_STATE(508)] = 20408,
  [SMALL_STATE(509)] = 20418,
  [SMALL_STATE(510)] = 20428,
  [SMALL_STATE(511)] = 20444,
  [SMALL_STATE(512)] = 20460,
  [SMALL_STATE(513)] = 20476,
  [SMALL_STATE(514)] = 20490,
  [SMALL_STATE(515)] = 20506,
  [SMALL_STATE(516)] = 20516,
  [SMALL_STATE(517)] = 20530,
  [SMALL_STATE(518)] = 20546,
  [SMALL_STATE(519)] = 20560,
  [SMALL_STATE(520)] = 20576,
  [SMALL_STATE(521)] = 20587,
  [SMALL_STATE(522)] = 20600,
  [SMALL_STATE(523)] = 20609,
  [SMALL_STATE(524)] = 20622,
  [SMALL_STATE(525)] = 20635,
  [SMALL_STATE(526)] = 20644,
  [SMALL_STATE(527)] = 20657,
  [SMALL_STATE(528)] = 20670,
  [SMALL_STATE(529)] = 20683,
  [SMALL_STATE(530)] = 20696,
  [SMALL_STATE(531)] = 20705,
  [SMALL_STATE(532)] = 20718,
  [SMALL_STATE(533)] = 20729,
  [SMALL_STATE(534)] = 20742,
  [SMALL_STATE(535)] = 20755,
  [SMALL_STATE(536)] = 20768,
  [SMALL_STATE(537)] = 20781,
  [SMALL_STATE(538)] = 20792,
  [SMALL_STATE(539)] = 20805,
  [SMALL_STATE(540)] = 20818,
  [SMALL_STATE(541)] = 20827,
  [SMALL_STATE(542)] = 20840,
  [SMALL_STATE(543)] = 20849,
  [SMALL_STATE(544)] = 20862,
  [SMALL_STATE(545)] = 20875,
  [SMALL_STATE(546)] = 20884,
  [SMALL_STATE(547)] = 20897,
  [SMALL_STATE(548)] = 20906,
  [SMALL_STATE(549)] = 20917,
  [SMALL_STATE(550)] = 20930,
  [SMALL_STATE(551)] = 20943,
  [SMALL_STATE(552)] = 20954,
  [SMALL_STATE(553)] = 20967,
  [SMALL_STATE(554)] = 20980,
  [SMALL_STATE(555)] = 20993,
  [SMALL_STATE(556)] = 21002,
  [SMALL_STATE(557)] = 21011,
  [SMALL_STATE(558)] = 21020,
  [SMALL_STATE(559)] = 21031,
  [SMALL_STATE(560)] = 21040,
  [SMALL_STATE(561)] = 21053,
  [SMALL_STATE(562)] = 21066,
  [SMALL_STATE(563)] = 21075,
  [SMALL_STATE(564)] = 21084,
  [SMALL_STATE(565)] = 21093,
  [SMALL_STATE(566)] = 21102,
  [SMALL_STATE(567)] = 21112,
  [SMALL_STATE(568)] = 21122,
  [SMALL_STATE(569)] = 21132,
  [SMALL_STATE(570)] = 21142,
  [SMALL_STATE(571)] = 21152,
  [SMALL_STATE(572)] = 21162,
  [SMALL_STATE(573)] = 21170,
  [SMALL_STATE(574)] = 21180,
  [SMALL_STATE(575)] = 21190,
  [SMALL_STATE(576)] = 21200,
  [SMALL_STATE(577)] = 21210,
  [SMALL_STATE(578)] = 21220,
  [SMALL_STATE(579)] = 21230,
  [SMALL_STATE(580)] = 21240,
  [SMALL_STATE(581)] = 21250,
  [SMALL_STATE(582)] = 21257,
  [SMALL_STATE(583)] = 21264,
  [SMALL_STATE(584)] = 21271,
  [SMALL_STATE(585)] = 21278,
  [SMALL_STATE(586)] = 21285,
  [SMALL_STATE(587)] = 21292,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(464),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(584),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(411),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(494),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(4),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(456),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [61] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(93),
  [64] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(4),
  [67] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(94),
  [70] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(464),
  [73] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(54),
  [76] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(201),
  [79] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2),
  [81] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(166),
  [84] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(109),
  [87] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(198),
  [90] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(343),
  [93] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(584),
  [96] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(89),
  [99] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(91),
  [102] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(7),
  [105] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(136),
  [108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(97),
  [111] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(191),
  [114] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(411),
  [117] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(494),
  [120] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(155),
  [123] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_clause, 4, .production_id = 16),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [127] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_clause, 3, .production_id = 16),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [139] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(373),
  [145] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 3),
  [147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 2),
  [151] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(13),
  [154] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(345),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(335),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(492),
  [165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [171] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [177] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(317),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(287),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(441),
  [205] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(333),
  [213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(213),
  [223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(334),
  [225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [227] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [229] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [231] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [235] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [237] = {.entry = {.count = 1, .reusable = false}}, SHIFT(564),
  [239] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [241] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [251] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(413),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [259] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [263] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(415),
  [267] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(311),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [275] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [277] = {.entry = {.count = 1, .reusable = false}}, SHIFT(305),
  [279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [281] = {.entry = {.count = 1, .reusable = false}}, SHIFT(396),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(498),
  [295] = {.entry = {.count = 1, .reusable = false}}, SHIFT(323),
  [297] = {.entry = {.count = 1, .reusable = false}}, SHIFT(525),
  [299] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(440),
  [303] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [305] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(445),
  [309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(318),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2),
  [313] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(93),
  [316] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(44),
  [319] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(94),
  [322] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(464),
  [325] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(54),
  [328] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(201),
  [331] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(166),
  [334] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(109),
  [337] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(198),
  [340] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(340),
  [343] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(584),
  [346] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(89),
  [349] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(91),
  [352] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(7),
  [355] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(136),
  [358] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(97),
  [361] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(191),
  [364] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(411),
  [367] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(494),
  [370] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(155),
  [373] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(45),
  [376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2),
  [378] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(366),
  [381] = {.entry = {.count = 1, .reusable = false}}, SHIFT(474),
  [383] = {.entry = {.count = 1, .reusable = false}}, SHIFT(320),
  [385] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [387] = {.entry = {.count = 1, .reusable = false}}, SHIFT(470),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(559),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [395] = {.entry = {.count = 1, .reusable = false}}, SHIFT(496),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(431),
  [401] = {.entry = {.count = 1, .reusable = false}}, SHIFT(319),
  [403] = {.entry = {.count = 1, .reusable = false}}, SHIFT(419),
  [405] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [407] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [409] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [411] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(530),
  [415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(314),
  [417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [421] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [423] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [425] = {.entry = {.count = 1, .reusable = false}}, SHIFT(509),
  [427] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [429] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [431] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [437] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(392),
  [441] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [445] = {.entry = {.count = 1, .reusable = false}}, SHIFT(439),
  [447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(313),
  [449] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [451] = {.entry = {.count = 1, .reusable = false}}, SHIFT(397),
  [453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(330),
  [455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [457] = {.entry = {.count = 1, .reusable = false}}, SHIFT(288),
  [459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [461] = {.entry = {.count = 1, .reusable = false}}, SHIFT(331),
  [463] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_clause, 4),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(380),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [469] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_clause, 3),
  [471] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(93),
  [474] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(94),
  [477] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(464),
  [480] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(54),
  [483] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(201),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2),
  [488] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(166),
  [491] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(109),
  [494] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(198),
  [497] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(380),
  [500] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(584),
  [503] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(89),
  [506] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(91),
  [509] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(7),
  [512] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(136),
  [515] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(97),
  [518] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(191),
  [521] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(411),
  [524] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(494),
  [527] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(166),
  [530] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(155),
  [533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [535] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [543] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [545] = {.entry = {.count = 1, .reusable = false}}, SHIFT(377),
  [547] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [549] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [551] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(370),
  [555] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [557] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [559] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [561] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [563] = {.entry = {.count = 1, .reusable = false}}, SHIFT(358),
  [565] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [567] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [571] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [573] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [575] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [577] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [579] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(339),
  [582] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [590] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [592] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [594] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_test_command, 2, .production_id = 4),
  [596] = {.entry = {.count = 1, .reusable = false}}, SHIFT(484),
  [598] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [600] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [602] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [604] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [606] = {.entry = {.count = 1, .reusable = false}}, SHIFT(436),
  [608] = {.entry = {.count = 1, .reusable = false}}, SHIFT(519),
  [610] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_test_command, 1),
  [614] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_test_command_repeat1, 2, .production_id = 9),
  [616] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_test_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(484),
  [619] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_test_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(37),
  [622] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_test_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(120),
  [625] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_test_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(161),
  [628] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_test_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(193),
  [631] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_test_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(436),
  [634] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_test_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(519),
  [637] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_test_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(115),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__terminated_opt_statement, 2),
  [642] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__terminated_statement, 2),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command, 2, .production_id = 5),
  [646] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9),
  [648] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(464),
  [651] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(54),
  [654] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(166),
  [657] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(191),
  [660] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(411),
  [663] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(494),
  [666] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(155),
  [669] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command, 1, .production_id = 2),
  [671] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return, 1),
  [673] = {.entry = {.count = 1, .reusable = false}}, SHIFT(465),
  [675] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [677] = {.entry = {.count = 1, .reusable = false}}, SHIFT(264),
  [679] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [681] = {.entry = {.count = 1, .reusable = false}}, SHIFT(421),
  [683] = {.entry = {.count = 1, .reusable = false}}, SHIFT(497),
  [685] = {.entry = {.count = 1, .reusable = false}}, SHIFT(266),
  [687] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_expansion, 2),
  [689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_expansion, 2),
  [691] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_expansion, 3),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_expansion, 3),
  [695] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_variable_expansion_repeat1, 2),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2),
  [699] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(568),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [704] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, .production_id = 1),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [710] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_element_access, 2),
  [712] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_element_access, 2),
  [714] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_dollar, 4),
  [716] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_dollar, 4),
  [718] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2),
  [720] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(232),
  [723] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(118),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__terminated_statement, 2),
  [728] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [730] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_dollar, 5),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_dollar, 5),
  [734] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_dollar, 3),
  [736] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_dollar, 3),
  [738] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_element_access, 3),
  [740] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_element_access, 3),
  [742] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_concatenation, 2),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [746] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_fish, 3),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_fish, 3),
  [750] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_brace_expansion, 5),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_expansion, 5),
  [754] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_double_quote_string, 2),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_double_quote_string, 2),
  [758] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_single_quote_string, 3),
  [760] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_quote_string, 3),
  [762] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_double_quote_string, 3),
  [764] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_double_quote_string, 3),
  [766] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_single_quote_string, 2),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_quote_string, 2),
  [770] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_fish, 4),
  [772] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_fish, 4),
  [774] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [778] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution_fish, 2),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution_fish, 2),
  [782] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_brace_expansion, 4),
  [784] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_expansion, 4),
  [786] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_brace_expansion, 3),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_expansion, 3),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2),
  [792] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution, 1),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution, 1),
  [796] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [798] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [800] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [802] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [804] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [806] = {.entry = {.count = 1, .reusable = false}}, SHIFT(486),
  [808] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [810] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [812] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [814] = {.entry = {.count = 1, .reusable = false}}, SHIFT(433),
  [816] = {.entry = {.count = 1, .reusable = false}}, SHIFT(506),
  [818] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [820] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [822] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [824] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [826] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [828] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [830] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11),
  [832] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(486),
  [835] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(39),
  [838] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(208),
  [841] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(196),
  [844] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(433),
  [847] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(506),
  [850] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(209),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [855] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2),
  [857] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(486),
  [860] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(39),
  [863] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(208),
  [866] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(196),
  [869] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(433),
  [872] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(506),
  [875] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(209),
  [878] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [880] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(566),
  [883] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [885] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15),
  [887] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(486),
  [890] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(39),
  [893] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(208),
  [896] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(196),
  [899] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(433),
  [902] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(506),
  [905] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(209),
  [908] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [912] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [914] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_test_command_repeat1, 1, .production_id = 3),
  [916] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_test_option, 1),
  [918] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(229),
  [921] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(165),
  [924] = {.entry = {.count = 1, .reusable = false}}, SHIFT(479),
  [926] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [928] = {.entry = {.count = 1, .reusable = false}}, SHIFT(502),
  [930] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [932] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [934] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_brace_expansion_repeat1, 1),
  [936] = {.entry = {.count = 1, .reusable = false}}, SHIFT(418),
  [938] = {.entry = {.count = 1, .reusable = false}}, SHIFT(514),
  [940] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 1, .production_id = 3),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [944] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [946] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [948] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [950] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [952] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [954] = {.entry = {.count = 1, .reusable = false}}, SHIFT(187),
  [956] = {.entry = {.count = 1, .reusable = false}}, SHIFT(463),
  [958] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [960] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [962] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [964] = {.entry = {.count = 1, .reusable = false}}, SHIFT(443),
  [966] = {.entry = {.count = 1, .reusable = false}}, SHIFT(517),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [970] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [972] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(573),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [985] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(224),
  [988] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(214),
  [991] = {.entry = {.count = 1, .reusable = false}}, SHIFT(279),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [995] = {.entry = {.count = 1, .reusable = false}}, SHIFT(218),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [999] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1003] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1007] = {.entry = {.count = 1, .reusable = false}}, SHIFT(422),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1011] = {.entry = {.count = 1, .reusable = false}}, SHIFT(542),
  [1013] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 1, .production_id = 13),
  [1015] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 1, .production_id = 6),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1035] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(485),
  [1038] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(59),
  [1041] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(427),
  [1044] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2),
  [1046] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(272),
  [1049] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(426),
  [1052] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(507),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1083] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(579),
  [1086] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 2),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1094] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(216),
  [1097] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(270),
  [1100] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 1),
  [1102] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [1104] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [1106] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [1108] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [1110] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [1112] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [1114] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pipe, 3),
  [1116] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional_execution, 2),
  [1118] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negated_statement, 2),
  [1120] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [1122] = {.entry = {.count = 1, .reusable = false}}, SHIFT(286),
  [1124] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [1126] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [1128] = {.entry = {.count = 1, .reusable = false}}, SHIFT(438),
  [1130] = {.entry = {.count = 1, .reusable = false}}, SHIFT(280),
  [1132] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [1134] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [1136] = {.entry = {.count = 1, .reusable = false}}, SHIFT(394),
  [1138] = {.entry = {.count = 1, .reusable = false}}, SHIFT(547),
  [1140] = {.entry = {.count = 1, .reusable = false}}, SHIFT(437),
  [1142] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [1144] = {.entry = {.count = 1, .reusable = false}}, SHIFT(434),
  [1146] = {.entry = {.count = 1, .reusable = false}}, SHIFT(462),
  [1148] = {.entry = {.count = 1, .reusable = false}}, SHIFT(522),
  [1150] = {.entry = {.count = 1, .reusable = false}}, SHIFT(515),
  [1152] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [1154] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [1156] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional_execution, 3),
  [1158] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [1160] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [1162] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [1164] = {.entry = {.count = 1, .reusable = false}}, SHIFT(491),
  [1166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 5, .production_id = 14),
  [1168] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [1170] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [1172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 8),
  [1174] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_test_command, 2),
  [1176] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [1178] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [1180] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [1182] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_begin_statement, 2),
  [1184] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [1186] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_redirected_statement, 2),
  [1188] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 5, .production_id = 10),
  [1190] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 6, .production_id = 14),
  [1192] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3, .production_id = 8),
  [1194] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_begin_statement, 3),
  [1196] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 7, .production_id = 17),
  [1198] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 4, .production_id = 12),
  [1200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 5, .production_id = 12),
  [1202] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, .production_id = 8),
  [1204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 4, .production_id = 8),
  [1206] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 6, .production_id = 17),
  [1208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_file_redirect, 2, .production_id = 7),
  [1210] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 3, .production_id = 8),
  [1212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return, 2),
  [1214] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 8),
  [1216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [1218] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 4, .production_id = 10),
  [1220] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(577),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1225] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(567),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1230] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(235),
  [1233] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(401),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1242] = {.entry = {.count = 1, .reusable = false}}, SHIFT(461),
  [1244] = {.entry = {.count = 1, .reusable = false}}, SHIFT(450),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(435),
  [1250] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1254] = {.entry = {.count = 1, .reusable = false}}, SHIFT(429),
  [1256] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [1258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 3),
  [1260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(556),
  [1262] = {.entry = {.count = 1, .reusable = false}}, SHIFT(565),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1266] = {.entry = {.count = 1, .reusable = false}}, SHIFT(417),
  [1268] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1272] = {.entry = {.count = 1, .reusable = false}}, SHIFT(430),
  [1274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 1),
  [1276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(442),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1282] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [1284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index, 1),
  [1286] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [1288] = {.entry = {.count = 1, .reusable = false}}, SHIFT(175),
  [1290] = {.entry = {.count = 1, .reusable = false}}, SHIFT(282),
  [1292] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [1294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1296] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [1298] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_quote_string_repeat1, 2), SHIFT_REPEAT(461),
  [1301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_double_quote_string_repeat1, 2),
  [1303] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_double_quote_string_repeat1, 2), SHIFT_REPEAT(435),
  [1306] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_quote_string_repeat1, 2), SHIFT_REPEAT(435),
  [1309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [1313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(428),
  [1315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(424),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(452),
  [1321] = {.entry = {.count = 1, .reusable = false}}, SHIFT(448),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1325] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [1327] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [1329] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(569),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(518),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1398] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(576),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2),
  [1427] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(192),
  [1430] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [1432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(499),
  [1436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [1438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1440] = {.entry = {.count = 1, .reusable = false}}, SHIFT(505),
  [1442] = {.entry = {.count = 1, .reusable = false}}, SHIFT(555),
  [1444] = {.entry = {.count = 1, .reusable = false}}, SHIFT(276),
  [1446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [1448] = {.entry = {.count = 1, .reusable = false}}, SHIFT(503),
  [1450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_single_quote_string_repeat1, 2),
  [1452] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_single_quote_string_repeat1, 2), SHIFT_REPEAT(499),
  [1455] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_single_quote_string_repeat1, 2), SHIFT_REPEAT(499),
  [1458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_brace_concatenation_repeat1, 2),
  [1460] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_brace_concatenation_repeat1, 2), SHIFT_REPEAT(236),
  [1463] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__brace_expression, 1),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1467] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [1469] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2),
  [1471] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2), SHIFT_REPEAT(585),
  [1474] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [1476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [1478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(493),
  [1482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(444),
  [1484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1486] = {.entry = {.count = 1, .reusable = false}}, SHIFT(512),
  [1488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [1490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(408),
  [1492] = {.entry = {.count = 1, .reusable = false}}, SHIFT(449),
  [1494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(562),
  [1500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1502] = {.entry = {.count = 1, .reusable = false}}, SHIFT(495),
  [1504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_concatenation, 2),
  [1506] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [1508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1510] = {.entry = {.count = 1, .reusable = false}}, SHIFT(511),
  [1512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1514] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [1516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1518] = {.entry = {.count = 1, .reusable = false}}, SHIFT(510),
  [1520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__base_brace_expression, 1),
  [1522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_brace_expansion_repeat1, 2),
  [1528] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_brace_expansion_repeat1, 2), SHIFT_REPEAT(197),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1589] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_fish_external_scanner_create(void);
void tree_sitter_fish_external_scanner_destroy(void *);
bool tree_sitter_fish_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_fish_external_scanner_serialize(void *, char *);
void tree_sitter_fish_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_fish(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_fish_external_scanner_create,
      tree_sitter_fish_external_scanner_destroy,
      tree_sitter_fish_external_scanner_scan,
      tree_sitter_fish_external_scanner_serialize,
      tree_sitter_fish_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
