/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLPragmaHandler;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.DataTransferState;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class SQLPragmaExport
implements SQLPragmaHandler {
    private static final Log log = Log.getLog(SQLPragmaExport.class);
    public static final String PARAMETER_TYPE = "type";
    private static final String PRODUCER_NODE_ID = "database_producer";
    private static final String CONSUMER_NODE_ID = "stream_consumer";
    private static final String PROCESSOR_ID_PREFIX = "stream_consumer:stream.";

    public int processPragma(@NotNull DBRProgressMonitor monitor, @NotNull DBSDataContainer container, @NotNull Map<String, Object> parameters) throws DBException {
        String type = JSONUtils.getString(parameters, (String)PARAMETER_TYPE);
        if (CommonUtils.isEmpty((String)type)) {
            throw new DBException("`type` attribute is mandatory");
        }
        DataTransferRegistry registry = DataTransferRegistry.getInstance();
        DataTransferNodeDescriptor producerNode = registry.getNodeById(PRODUCER_NODE_ID);
        DataTransferNodeDescriptor consumerNode = registry.getNodeById(CONSUMER_NODE_ID);
        DataTransferProcessorDescriptor processor = registry.getProcessor(PROCESSOR_ID_PREFIX + type);
        if (processor == null) {
            throw new DBException("Can't find processor of type '" + type + "'");
        }
        DataTransferSettings settings = new DataTransferSettings(Collections.singleton(new DatabaseTransferProducer(container, null)), Collections.singleton(new StreamTransferConsumer()), Map.of("producer", producerNode.getId(), "consumer", consumerNode.getId(), "processor", processor.getId(), "processors", Map.of(processor.getFullId(), SQLPragmaExport.createProcessorSettings(processor, parameters)), producerNode.getNodeClass().getSimpleName(), SQLPragmaExport.createProducerSettings(parameters), consumerNode.getNodeClass().getSimpleName(), SQLPragmaExport.createConsumerSettings(parameters)), new DataTransferState(), true, true, false, false);
        UIUtils.asyncExec(() -> {
            DataTransferWizard wizard = new DataTransferWizard(null, settings, true){

                @Override
                protected boolean includePipesConfigurationPage() {
                    return false;
                }
            };
            new TaskConfigurationWizardDialog(UIUtils.getActiveWorkbenchWindow(), (TaskConfigurationWizard)wizard, null).open();
        });
        return 3;
    }

    @NotNull
    private static Map<String, Object> createProducerSettings(@NotNull Map<String, Object> parameters) {
        return JSONUtils.getObject(parameters, (String)"producer");
    }

    @NotNull
    private static Map<String, Object> createConsumerSettings(@NotNull Map<String, Object> parameters) {
        return JSONUtils.getObject(parameters, (String)"consumer");
    }

    @NotNull
    private static Map<String, Object> createProcessorSettings(@NotNull DataTransferProcessorDescriptor processor, @NotNull Map<String, Object> parameters) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        StringJoiner names = new StringJoiner(",");
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = processor.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor dBPPropertyDescriptor = dBPPropertyDescriptorArray[n2];
            properties.put(dBPPropertyDescriptor.getId(), dBPPropertyDescriptor.getDefaultValue());
            names.add(dBPPropertyDescriptor.getId());
            ++n2;
        }
        for (Map.Entry entry : JSONUtils.getObject(parameters, (String)"processor").entrySet()) {
            DBPPropertyDescriptor propertyDescriptor = processor.getProperty((String)entry.getKey());
            if (propertyDescriptor == null) {
                log.debug((Object)("Skipping unknown property " + (String)entry.getKey()));
                continue;
            }
            properties.put((String)entry.getKey(), PropertyDescriptor.convertString((String)CommonUtils.toString(entry.getValue()), (Class)propertyDescriptor.getDataType()));
        }
        properties.put("@propNames", names.toString());
        return properties;
    }
}

