/***************************************************************************
                          sdl.h  -  description
                             -------------------
    begin                : Thu Apr 20 2000
    copyright            : (C) 2000 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SDL_H
#define SDL_H

#include <SDL.h>

#ifdef __cplusplus
extern "C" {
#endif

//#define DEBUG

// draw region //
#define DR_SETSRC(p, i, j) {dr_src.s = p; dr_src.r.x = i; dr_src.r.y = j; dr_src.r.w = dr_dst.r.w; dr_src.r.h = dr_dst.r.h;}
#define DR_SETDST(p, i, j, k, l) {dr_dst.s = p; dr_dst.r.x = i; dr_dst.r.y = j; dr_dst.r.w = k; dr_dst.r.h = l;}
#define DR_SETFULLSRC(p) {dr_src.s = p; dr_src.r.x = 0; dr_src.r.y = 0; dr_src.r.w = dr_dst.r.w; dr_src.r.h = dr_dst.r.h;}
#define DR_SETFULLDST(p) {dr_dst.s = p; dr_dst.r.x = 0; dr_dst.r.y = 0; dr_dst.r.w = (p)->w; dr_dst.r.h = (p)->h;}
typedef struct {
    SDL_Surface *s;
    SDL_Rect    r;
} DrawRgn;

// Sdl Surface //
SDL_Surface* SSur_Load(char *fname, int f);
SDL_Surface* SSur_Create(int w, int h, int f);
int  SSur_DisplayFormat(SDL_Surface *sur);
void SSur_Begin(SDL_Surface *sur);
void SSur_End(SDL_Surface *sur);
void SSur_Blit(void);
void SSur_AlphaBlit(int alpha);
void SSur_Fill(int c);

// Sdl Font //
#define TA_X_LEFT	(1L<<1)
#define TA_X_CENTER	(1L<<2)
#define TA_X_RIGHT	(1L<<3)
#define TA_Y_TOP	(1L<<4)
#define TA_Y_CENTER	(1L<<5)
#define TA_Y_BOTTOM	(1L<<6)
typedef struct {
    SDL_Surface        *sur;
    int         algn;
    int         clr;
    int         lh;
    char        lw[256];
    int         loff[256];
    char        keys[256];
    char        off;
    char        num;
    //last written rect
    int     	lastX;
    int         lastY;
    int	        lastW;
    int	        lastH;
} SFnt;
SFnt* SFnt_Load(char *fname);
SFnt* SFnt_LoadFixed(char *fname, int off, int len, int w);
void SFnt_Free(SFnt *sfnt);
int  SFnt_Write(SFnt *sfnt, SDL_Surface *dest, int x, int y, char *str, int alpha);
void SFnt_Begin(SFnt *sfnt);
void SFnt_End(SFnt *sfnt);
SDL_Rect SFnt_LastRect(SFnt *fnt);
int  SFnt_TextWidth(SFnt *fnt, char *str);

// Sdl //
#define SDL_DIM_STEPS   8
#define SDL_DIM_DELAY   20
#define SDL_DIM()   Sdl_Dim(SDL_DIM_STEPS, SDL_DIM_DELAY, 255)
#define SDL_UNDIM() Sdl_UnDim(SDL_DIM_STEPS, SDL_DIM_DELAY, 255)
typedef struct {
    SDL_Surface *scr;
} Sdl;
void Sdl_Init(int f);
void Sdl_Quit();
int  Sdl_SetVideoMode(int w, int h, int d, int f);
void Sdl_Update(int x, int y, int w, int h);
void Sdl_FullUpdate();
void Sdl_Dim(int steps, int delay, int trp);
void Sdl_UnDim(int steps, int delay, int trp);
int  Sdl_WaitForKey();
void Sdl_WaitForClick();
// hardware funcs //
/*void Sdl_Begin();
void Sdl_End();
void Sdl_Flip();
void Sdl_SetClipRgn(int x, int y, int w, int h);*/

#ifdef __cplusplus
};
#endif

#endif
