pub const ANALOG_AUXIN_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0x742ef867_09e1_40a3_82d3_9669ba35325f);
pub const ANALOG_FM_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0x7728087b_2bb9_4e30_8078_449476e59dbb);
pub const ANALOG_TV_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0xb820d87e_e0e3_478f_8a38_4e13f7b3df42);
pub const ATSCChannelTuneRequest: windows_core::GUID = windows_core::GUID::from_u128(0x0369b4e6_45b6_11d3_b650_00c04f79498e);
pub const ATSCComponentType: windows_core::GUID = windows_core::GUID::from_u128(0xa8dcf3d5_0780_4ef4_8a83_2cffaacb8ace);
pub const ATSCLocator: windows_core::GUID = windows_core::GUID::from_u128(0x8872ff1b_98fa_4d7a_8d93_c9f1055f85bb);
pub const ATSCTuningSpace: windows_core::GUID = windows_core::GUID::from_u128(0xa2e30750_6c3d_11d3_b653_00c04f79498e);
pub const ATSC_EIT_TID: u32 = 203u32;
pub const ATSC_ETM_LOCATION_IN_PTC_FOR_EVENT: u32 = 2u32;
pub const ATSC_ETM_LOCATION_IN_PTC_FOR_PSIP: u32 = 1u32;
pub const ATSC_ETM_LOCATION_NOT_PRESENT: u32 = 0u32;
pub const ATSC_ETM_LOCATION_RESERVED: u32 = 3u32;
pub const ATSC_ETT_TID: u32 = 204u32;
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct ATSC_FILTER_OPTIONS {
    pub fSpecifyEtmId: windows_core::BOOL,
    pub EtmId: u32,
}
pub const ATSC_MGT_PID: u32 = 8187u32;
pub const ATSC_MGT_TID: u32 = 199u32;
pub const ATSC_PIT_TID: u32 = 208u32;
pub const ATSC_RRT_PID: u32 = 8187u32;
pub const ATSC_RRT_TID: u32 = 202u32;
pub const ATSC_STT_PID: u32 = 8187u32;
pub const ATSC_STT_TID: u32 = 205u32;
pub const ATSC_TERRESTRIAL_TV_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0x0dad2fdd_5fd7_11d3_8f50_00c04f7971e2);
pub const ATSC_VCT_CABL_TID: u32 = 201u32;
pub const ATSC_VCT_PID: u32 = 8187u32;
pub const ATSC_VCT_TERR_TID: u32 = 200u32;
pub const AgeBased: EnTvRat_System = EnTvRat_System(9i32);
pub const AnalogAudioComponentType: windows_core::GUID = windows_core::GUID::from_u128(0x28ab0005_e845_4ffa_aa9b_f4665236141c);
pub const AnalogLocator: windows_core::GUID = windows_core::GUID::from_u128(0x49638b91_48ab_48b7_a47a_7d0e75a08ede);
pub const AnalogRadioTuningSpace: windows_core::GUID = windows_core::GUID::from_u128(0x8a674b4c_1f63_11d3_b64c_00c04f79498e);
pub const AnalogTVTuningSpace: windows_core::GUID = windows_core::GUID::from_u128(0x8a674b4d_1f63_11d3_b64c_00c04f79498e);
pub const AudioType_Commentary: u32 = 5u32;
pub const AudioType_Dialogue: u32 = 4u32;
pub const AudioType_Emergency: u32 = 6u32;
pub const AudioType_Hearing_Impaired: u32 = 3u32;
pub const AudioType_Music_And_Effects: u32 = 1u32;
pub const AudioType_Reserved: i32 = -1i32;
pub const AudioType_Standard: u32 = 0u32;
pub const AudioType_Visually_Impaired: u32 = 2u32;
pub const AudioType_Voiceover: u32 = 7u32;
pub const AuxInTuningSpace: windows_core::GUID = windows_core::GUID::from_u128(0xf9769a06_7aca_4e39_9cfb_97bb35f0e77e);
pub const BDANETWORKTYPE_ATSC: windows_core::GUID = windows_core::GUID::from_u128(0x71985f51_1ca1_11d3_9cc8_00c04f7971e0);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_DEBUG_DATA {
    pub lResult: i32,
    pub uuidDebugDataType: windows_core::GUID,
    pub ulDataSize: u32,
    pub argbDebugData: [u8; 1],
}
impl Default for BDA_DEBUG_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_DEBUG_DATA_AVAILABLE: windows_core::GUID = windows_core::GUID::from_u128(0x69c24f54_9983_497e_b415_282be4c555fb);
pub const BDA_DEBUG_DATA_TYPE_STRING: windows_core::GUID = windows_core::GUID::from_u128(0xa806e767_de5c_430c_80bf_a21ebe06c748);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_DigitalSignalStandard(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_EVENT_DATA {
    pub lResult: i32,
    pub ulEventID: u32,
    pub uuidEventType: windows_core::GUID,
    pub ulEventDataLength: u32,
    pub argbEventData: [u8; 1],
}
impl Default for BDA_EVENT_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_LockType(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_SignalType(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct BDA_TRANSPORT_INFO {
    pub ulcbPhyiscalPacket: u32,
    pub ulcbPhyiscalFrame: u32,
    pub ulcbPhyiscalFrameAlignment: u32,
    pub AvgTimePerFrame: i64,
}
pub const BSKYB_TERRESTRIAL_TV_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0x9e9e46c6_3aba_4f08_ad0e_cc5ac8148c2b);
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct BadSampleInfo {
    pub hrReason: windows_core::HRESULT,
}
pub const Bda_DigitalStandard_ATSC: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(8i32);
pub const Bda_DigitalStandard_DVB_C: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(4i32);
pub const Bda_DigitalStandard_DVB_S: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(2i32);
pub const Bda_DigitalStandard_DVB_T: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(1i32);
pub const Bda_DigitalStandard_ISDB_C: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(64i32);
pub const Bda_DigitalStandard_ISDB_S: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(32i32);
pub const Bda_DigitalStandard_ISDB_T: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(16i32);
pub const Bda_DigitalStandard_None: BDA_DigitalSignalStandard = BDA_DigitalSignalStandard(0i32);
pub const Bda_LockType_Complete: BDA_LockType = BDA_LockType(128i32);
pub const Bda_LockType_DecoderDemod: BDA_LockType = BDA_LockType(2i32);
pub const Bda_LockType_None: BDA_LockType = BDA_LockType(0i32);
pub const Bda_LockType_PLL: BDA_LockType = BDA_LockType(1i32);
pub const Bda_SignalType_Analog: BDA_SignalType = BDA_SignalType(1i32);
pub const Bda_SignalType_Digital: BDA_SignalType = BDA_SignalType(2i32);
pub const Bda_SignalType_Unknown: BDA_SignalType = BDA_SignalType(0i32);
pub const BfAttrNone: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BfEnTvRat_Attributes_CAE_TV(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BfEnTvRat_Attributes_CAF_TV(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BfEnTvRat_Attributes_MPAA(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BfEnTvRat_Attributes_US_TV(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BfEnTvRat_GenericAttributes(pub i32);
pub const BfIsAttr_1: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(2i32);
pub const BfIsAttr_2: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(4i32);
pub const BfIsAttr_3: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(8i32);
pub const BfIsAttr_4: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(16i32);
pub const BfIsAttr_5: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(32i32);
pub const BfIsAttr_6: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(64i32);
pub const BfIsAttr_7: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(128i32);
pub const BfIsBlocked: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(1i32);
pub const BfValidAttrSubmask: BfEnTvRat_GenericAttributes = BfEnTvRat_GenericAttributes(255i32);
pub const BroadcastEventService: windows_core::GUID = windows_core::GUID::from_u128(0x0b3ffb92_0919_4934_9d5b_619c719d0202);
pub const CAE_IsBlocked: BfEnTvRat_Attributes_CAE_TV = BfEnTvRat_Attributes_CAE_TV(1i32);
pub const CAE_TV_14: EnTvRat_CAE_TV = EnTvRat_CAE_TV(5i32);
pub const CAE_TV_18: EnTvRat_CAE_TV = EnTvRat_CAE_TV(6i32);
pub const CAE_TV_C: EnTvRat_CAE_TV = EnTvRat_CAE_TV(1i32);
pub const CAE_TV_C8: EnTvRat_CAE_TV = EnTvRat_CAE_TV(2i32);
pub const CAE_TV_Exempt: EnTvRat_CAE_TV = EnTvRat_CAE_TV(0i32);
pub const CAE_TV_G: EnTvRat_CAE_TV = EnTvRat_CAE_TV(3i32);
pub const CAE_TV_PG: EnTvRat_CAE_TV = EnTvRat_CAE_TV(4i32);
pub const CAE_TV_Reserved: EnTvRat_CAE_TV = EnTvRat_CAE_TV(7i32);
pub const CAE_ValidAttrSubmask: BfEnTvRat_Attributes_CAE_TV = BfEnTvRat_Attributes_CAE_TV(1i32);
pub const CAF_IsBlocked: BfEnTvRat_Attributes_CAF_TV = BfEnTvRat_Attributes_CAF_TV(1i32);
pub const CAF_TV_13: EnTvRat_CAF_TV = EnTvRat_CAF_TV(3i32);
pub const CAF_TV_16: EnTvRat_CAF_TV = EnTvRat_CAF_TV(4i32);
pub const CAF_TV_18: EnTvRat_CAF_TV = EnTvRat_CAF_TV(5i32);
pub const CAF_TV_8: EnTvRat_CAF_TV = EnTvRat_CAF_TV(2i32);
pub const CAF_TV_Exempt: EnTvRat_CAF_TV = EnTvRat_CAF_TV(0i32);
pub const CAF_TV_G: EnTvRat_CAF_TV = EnTvRat_CAF_TV(1i32);
pub const CAF_TV_Reserved: EnTvRat_CAF_TV = EnTvRat_CAF_TV(7i32);
pub const CAF_TV_Reserved6: EnTvRat_CAF_TV = EnTvRat_CAF_TV(6i32);
pub const CAF_ValidAttrSubmask: BfEnTvRat_Attributes_CAF_TV = BfEnTvRat_Attributes_CAF_TV(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CAPTURE_STREAMTIME {
    pub StreamTime: i64,
}
pub const CLSID_CPCAFiltersCategory: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4fc_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_DTFilterEncProperties: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c482_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_DTFilterTagProperties: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c492_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_ETFilterEncProperties: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c481_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_ETFilterTagProperties: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c491_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_Mpeg2TableFilter: windows_core::GUID = windows_core::GUID::from_u128(0x752845f1_758f_4c83_a043_4270c593308e);
pub const CLSID_PTFilter: windows_core::GUID = windows_core::GUID::from_u128(0x9cd31617_b303_4f96_8330_2eb173ea4dc6);
pub const CLSID_XDSCodecProperties: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c483_0049_4e2b_98fb_9537f6ce516d);
pub const CLSID_XDSCodecTagProperties: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c493_0049_4e2b_98fb_9537f6ce516d);
pub const COMPONENT_TAG_CAPTION_MAX: u32 = 55u32;
pub const COMPONENT_TAG_CAPTION_MIN: u32 = 48u32;
pub const COMPONENT_TAG_SUPERIMPOSE_MAX: u32 = 63u32;
pub const COMPONENT_TAG_SUPERIMPOSE_MIN: u32 = 56u32;
pub const CONTENT: RecordingType = RecordingType(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COPPEventBlockReason(pub i32);
pub const COPP_Activate: COPPEventBlockReason = COPPEventBlockReason(8i32);
pub const COPP_AeroGlassOff: COPPEventBlockReason = COPPEventBlockReason(5i32);
pub const COPP_BadCertificate: COPPEventBlockReason = COPPEventBlockReason(3i32);
pub const COPP_BadDriver: COPPEventBlockReason = COPPEventBlockReason(0i32);
pub const COPP_DigitalAudioUnprotected: COPPEventBlockReason = COPPEventBlockReason(9i32);
pub const COPP_ForbiddenVideo: COPPEventBlockReason = COPPEventBlockReason(7i32);
pub const COPP_InvalidBusProtection: COPPEventBlockReason = COPPEventBlockReason(4i32);
pub const COPP_NoCardHDCPSupport: COPPEventBlockReason = COPPEventBlockReason(1i32);
pub const COPP_NoMonitorHDCPSupport: COPPEventBlockReason = COPPEventBlockReason(2i32);
pub const COPP_RogueApp: COPPEventBlockReason = COPPEventBlockReason(6i32);
pub const COPP_Unknown: COPPEventBlockReason = COPPEventBlockReason(-1i32);
pub const CPEVENT_BITSHIFT_COPP: CPEventBitShift = CPEventBitShift(1i32);
pub const CPEVENT_BITSHIFT_DOWNRES: CPEventBitShift = CPEventBitShift(5i32);
pub const CPEVENT_BITSHIFT_LICENSE: CPEventBitShift = CPEventBitShift(2i32);
pub const CPEVENT_BITSHIFT_NO_PLAYREADY: CPEventBitShift = CPEventBitShift(9i32);
pub const CPEVENT_BITSHIFT_PENDING_CERTIFICATE: CPEventBitShift = CPEventBitShift(8i32);
pub const CPEVENT_BITSHIFT_RATINGS: CPEventBitShift = CPEventBitShift(0i32);
pub const CPEVENT_BITSHIFT_ROLLBACK: CPEventBitShift = CPEventBitShift(3i32);
pub const CPEVENT_BITSHIFT_SAC: CPEventBitShift = CPEventBitShift(4i32);
pub const CPEVENT_BITSHIFT_STUBLIB: CPEventBitShift = CPEventBitShift(6i32);
pub const CPEVENT_BITSHIFT_UNTRUSTEDGRAPH: CPEventBitShift = CPEventBitShift(7i32);
pub const CPEVENT_COPP: CPEvents = CPEvents(2i32);
pub const CPEVENT_DOWNRES: CPEvents = CPEvents(6i32);
pub const CPEVENT_LICENSE: CPEvents = CPEvents(3i32);
pub const CPEVENT_NONE: CPEvents = CPEvents(0i32);
pub const CPEVENT_PROTECTWINDOWED: CPEvents = CPEvents(9i32);
pub const CPEVENT_RATINGS: CPEvents = CPEvents(1i32);
pub const CPEVENT_ROLLBACK: CPEvents = CPEvents(4i32);
pub const CPEVENT_SAC: CPEvents = CPEvents(5i32);
pub const CPEVENT_STUBLIB: CPEvents = CPEvents(7i32);
pub const CPEVENT_UNTRUSTEDGRAPH: CPEvents = CPEvents(8i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CPEventBitShift(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CPEvents(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CPRecordingStatus(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CRID_LOCATION(pub i32);
pub const CRID_LOCATION_DVB_RESERVED1: CRID_LOCATION = CRID_LOCATION(2i32);
pub const CRID_LOCATION_DVB_RESERVED2: CRID_LOCATION = CRID_LOCATION(3i32);
pub const CRID_LOCATION_IN_CIT: CRID_LOCATION = CRID_LOCATION(1i32);
pub const CRID_LOCATION_IN_DESCRIPTOR: CRID_LOCATION = CRID_LOCATION(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CROSSBAR_DEFAULT_FLAGS(pub i32);
pub const CXDSData: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4f4_0049_4e2b_98fb_9537f6ce516d);
pub const Canadian_English: EnTvRat_System = EnTvRat_System(2i32);
pub const Canadian_French: EnTvRat_System = EnTvRat_System(3i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct ChannelChangeInfo {
    pub state: ChannelChangeSpanningEvent_State,
    pub TimeStamp: u64,
}
pub const ChannelChangeSpanningEvent_End: ChannelChangeSpanningEvent_State = ChannelChangeSpanningEvent_State(2i32);
pub const ChannelChangeSpanningEvent_Start: ChannelChangeSpanningEvent_State = ChannelChangeSpanningEvent_State(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ChannelChangeSpanningEvent_State(pub i32);
pub const ChannelIDTuneRequest: windows_core::GUID = windows_core::GUID::from_u128(0x3a9428a7_31a4_45e9_9efb_e055bf7bb3db);
pub const ChannelIDTuningSpace: windows_core::GUID = windows_core::GUID::from_u128(0xcc829a2f_3365_463f_af13_81dbb6f3a555);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct ChannelInfo {
    pub lFrequency: i32,
    pub Anonymous: ChannelInfo_0,
}
impl Default for ChannelInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union ChannelInfo_0 {
    pub DVB: ChannelInfo_0_0,
    pub DC: ChannelInfo_0_1,
    pub ATSC: ChannelInfo_0_2,
}
impl Default for ChannelInfo_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct ChannelInfo_0_2 {
    pub lProgNumber: i32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct ChannelInfo_0_1 {
    pub lProgNumber: i32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct ChannelInfo_0_0 {
    pub lONID: i32,
    pub lTSID: i32,
    pub lSID: i32,
}
pub const ChannelTuneRequest: windows_core::GUID = windows_core::GUID::from_u128(0x0369b4e5_45b6_11d3_b650_00c04f79498e);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ChannelType(pub i32);
pub const ChannelTypeAudio: ChannelType = ChannelType(4i32);
pub const ChannelTypeCaptions: ChannelType = ChannelType(32i32);
pub const ChannelTypeData: ChannelType = ChannelType(128i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct ChannelTypeInfo {
    pub channelType: ChannelType,
    pub timeStamp: u64,
}
pub const ChannelTypeNone: ChannelType = ChannelType(0i32);
pub const ChannelTypeOther: ChannelType = ChannelType(1i32);
pub const ChannelTypeSubtitles: ChannelType = ChannelType(16i32);
pub const ChannelTypeSuperimpose: ChannelType = ChannelType(64i32);
pub const ChannelTypeText: ChannelType = ChannelType(8i32);
pub const ChannelTypeVideo: ChannelType = ChannelType(2i32);
pub const Component: windows_core::GUID = windows_core::GUID::from_u128(0x59dc47a8_116c_11d3_9d8e_00c04f72d980);
pub const ComponentType: windows_core::GUID = windows_core::GUID::from_u128(0x823535a0_0318_11d3_9d8e_00c04f72d980);
pub const ComponentTypes: windows_core::GUID = windows_core::GUID::from_u128(0xa1a2b1c4_0e3a_11d3_9d8e_00c04f72d980);
pub const Components: windows_core::GUID = windows_core::GUID::from_u128(0x809b6661_94c4_49e6_b6ec_3f0f862215aa);
pub const CreatePropBagOnRegKey: windows_core::GUID = windows_core::GUID::from_u128(0x8a674b49_1f63_11d3_b64c_00c04f79498e);
pub const DEF_MODE_PROFILE: CROSSBAR_DEFAULT_FLAGS = CROSSBAR_DEFAULT_FLAGS(1i32);
pub const DEF_MODE_STREAMS: CROSSBAR_DEFAULT_FLAGS = CROSSBAR_DEFAULT_FLAGS(2i32);
pub const DESC_LINKAGE_CA_REPLACEMENT: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(3i32);
pub const DESC_LINKAGE_COMPLETE_NET_BOUQUET_SI: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(4i32);
pub const DESC_LINKAGE_DATA: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(6i32);
pub const DESC_LINKAGE_EPG: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(2i32);
pub const DESC_LINKAGE_INFORMATION: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(1i32);
pub const DESC_LINKAGE_REPLACEMENT: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(5i32);
pub const DESC_LINKAGE_RESERVED0: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(0i32);
pub const DESC_LINKAGE_RESERVED1: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(7i32);
pub const DESC_LINKAGE_RESERVED2: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(255i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DESC_LINKAGE_TYPE(pub i32);
pub const DESC_LINKAGE_USER: DESC_LINKAGE_TYPE = DESC_LINKAGE_TYPE(8i32);
pub const DIGITAL_CABLE_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0x143827ab_f77b_498d_81ca_5a007aec28bf);
pub const DIRECT_TV_SATELLITE_TV_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0x93b66fb5_93d4_4323_921c_c1f52df61d3f);
pub const DISPID_CHTUNER_ACTR_MINOR_CHANNEL: DISPID_TUNER = DISPID_TUNER(201i32);
pub const DISPID_CHTUNER_ATVAC_CHANNEL: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_CHTUNER_ATVDC_CONTENT: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_CHTUNER_ATVDC_SYSTEM: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_CHTUNER_CIDTR_CHANNELID: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_CHTUNER_CTR_CHANNEL: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_CHTUNER_DCTR_MAJOR_CHANNEL: DISPID_TUNER = DISPID_TUNER(301i32);
pub const DISPID_CHTUNER_DCTR_SRCID: DISPID_TUNER = DISPID_TUNER(302i32);
pub const DISPID_DVBTUNER_DVBC_ATTRIBUTESVALID: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_DVBTUNER_DVBC_COMPONENTTYPE: DISPID_TUNER = DISPID_TUNER(104i32);
pub const DISPID_DVBTUNER_DVBC_PID: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_DVBTUNER_DVBC_TAG: DISPID_TUNER = DISPID_TUNER(103i32);
pub const DISPID_DVBTUNER_ONID: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_DVBTUNER_SID: DISPID_TUNER = DISPID_TUNER(103i32);
pub const DISPID_DVBTUNER_TSID: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_MP2TUNERFACTORY_CREATETUNEREQUEST: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_MP2TUNER_PROGNO: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_MP2TUNER_TSID: DISPID_TUNER = DISPID_TUNER(101i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DISPID_TUNER(pub i32);
pub const DISPID_TUNER_ATSCCT_FLAGS: DISPID_TUNER = DISPID_TUNER(300i32);
pub const DISPID_TUNER_CT_CATEGORY: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_TUNER_CT_CLONE: DISPID_TUNER = DISPID_TUNER(9i32);
pub const DISPID_TUNER_CT_MEDIAFORMATTYPE: DISPID_TUNER = DISPID_TUNER(6i32);
pub const DISPID_TUNER_CT_MEDIAMAJORTYPE: DISPID_TUNER = DISPID_TUNER(2i32);
pub const DISPID_TUNER_CT_MEDIASUBTYPE: DISPID_TUNER = DISPID_TUNER(4i32);
pub const DISPID_TUNER_CT_MEDIATYPE: DISPID_TUNER = DISPID_TUNER(8i32);
pub const DISPID_TUNER_CT__MEDIAFORMATTYPE: DISPID_TUNER = DISPID_TUNER(7i32);
pub const DISPID_TUNER_CT__MEDIAMAJORTYPE: DISPID_TUNER = DISPID_TUNER(3i32);
pub const DISPID_TUNER_CT__MEDIASUBTYPE: DISPID_TUNER = DISPID_TUNER(5i32);
pub const DISPID_TUNER_C_ANALOG_AUDIO: DISPID_TUNER = DISPID_TUNER(201i32);
pub const DISPID_TUNER_C_CLONE: DISPID_TUNER = DISPID_TUNER(5i32);
pub const DISPID_TUNER_C_DESCRIPTION: DISPID_TUNER = DISPID_TUNER(4i32);
pub const DISPID_TUNER_C_LANGID: DISPID_TUNER = DISPID_TUNER(3i32);
pub const DISPID_TUNER_C_MP2_PCRPID: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_TUNER_C_MP2_PID: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_TUNER_C_MP2_PROGNO: DISPID_TUNER = DISPID_TUNER(103i32);
pub const DISPID_TUNER_C_STATUS: DISPID_TUNER = DISPID_TUNER(2i32);
pub const DISPID_TUNER_C_TYPE: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_TUNER_LCT_LANGID: DISPID_TUNER = DISPID_TUNER(100i32);
pub const DISPID_TUNER_L_ANALOG_STANDARD: DISPID_TUNER = DISPID_TUNER(601i32);
pub const DISPID_TUNER_L_ATSC_MP2_PROGNO: DISPID_TUNER = DISPID_TUNER(203i32);
pub const DISPID_TUNER_L_ATSC_PHYS_CHANNEL: DISPID_TUNER = DISPID_TUNER(201i32);
pub const DISPID_TUNER_L_ATSC_TSID: DISPID_TUNER = DISPID_TUNER(202i32);
pub const DISPID_TUNER_L_CARRFREQ: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_TUNER_L_CLONE: DISPID_TUNER = DISPID_TUNER(8i32);
pub const DISPID_TUNER_L_DTV_O_MAJOR_CHANNEL: DISPID_TUNER = DISPID_TUNER(701i32);
pub const DISPID_TUNER_L_DVBS2_DISEQ_LNB_SOURCE: DISPID_TUNER = DISPID_TUNER(406i32);
pub const DISPID_TUNER_L_DVBS2_PILOT: DISPID_TUNER = DISPID_TUNER(412i32);
pub const DISPID_TUNER_L_DVBS2_ROLLOFF: DISPID_TUNER = DISPID_TUNER(411i32);
pub const DISPID_TUNER_L_DVBS_AZIMUTH: DISPID_TUNER = DISPID_TUNER(404i32);
pub const DISPID_TUNER_L_DVBS_ELEVATION: DISPID_TUNER = DISPID_TUNER(405i32);
pub const DISPID_TUNER_L_DVBS_ORBITAL: DISPID_TUNER = DISPID_TUNER(403i32);
pub const DISPID_TUNER_L_DVBS_POLARISATION: DISPID_TUNER = DISPID_TUNER(401i32);
pub const DISPID_TUNER_L_DVBS_WEST: DISPID_TUNER = DISPID_TUNER(402i32);
pub const DISPID_TUNER_L_DVBT2_PHYSICALLAYERPIPEID: DISPID_TUNER = DISPID_TUNER(351i32);
pub const DISPID_TUNER_L_DVBT_BANDWIDTH: DISPID_TUNER = DISPID_TUNER(301i32);
pub const DISPID_TUNER_L_DVBT_GUARDINTERVAL: DISPID_TUNER = DISPID_TUNER(304i32);
pub const DISPID_TUNER_L_DVBT_HALPHA: DISPID_TUNER = DISPID_TUNER(305i32);
pub const DISPID_TUNER_L_DVBT_INUSE: DISPID_TUNER = DISPID_TUNER(307i32);
pub const DISPID_TUNER_L_DVBT_LPINNERFECMETHOD: DISPID_TUNER = DISPID_TUNER(302i32);
pub const DISPID_TUNER_L_DVBT_LPINNERFECRATE: DISPID_TUNER = DISPID_TUNER(303i32);
pub const DISPID_TUNER_L_DVBT_TRANSMISSIONMODE: DISPID_TUNER = DISPID_TUNER(306i32);
pub const DISPID_TUNER_L_INNERFECMETHOD: DISPID_TUNER = DISPID_TUNER(2i32);
pub const DISPID_TUNER_L_INNERFECRATE: DISPID_TUNER = DISPID_TUNER(3i32);
pub const DISPID_TUNER_L_MOD: DISPID_TUNER = DISPID_TUNER(6i32);
pub const DISPID_TUNER_L_OUTERFECMETHOD: DISPID_TUNER = DISPID_TUNER(4i32);
pub const DISPID_TUNER_L_OUTERFECRATE: DISPID_TUNER = DISPID_TUNER(5i32);
pub const DISPID_TUNER_L_SYMRATE: DISPID_TUNER = DISPID_TUNER(7i32);
pub const DISPID_TUNER_MP2CT_TYPE: DISPID_TUNER = DISPID_TUNER(200i32);
pub const DISPID_TUNER_TR_CLONE: DISPID_TUNER = DISPID_TUNER(3i32);
pub const DISPID_TUNER_TR_COMPONENTS: DISPID_TUNER = DISPID_TUNER(2i32);
pub const DISPID_TUNER_TR_LOCATOR: DISPID_TUNER = DISPID_TUNER(4i32);
pub const DISPID_TUNER_TR_TUNINGSPACE: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_TUNER_TS_AR_COUNTRYCODE: DISPID_TUNER = DISPID_TUNER(104i32);
pub const DISPID_TUNER_TS_AR_MAXFREQUENCY: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_TUNER_TS_AR_MINFREQUENCY: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_TUNER_TS_AR_STEP: DISPID_TUNER = DISPID_TUNER(103i32);
pub const DISPID_TUNER_TS_ATSC_MAXMINORCHANNEL: DISPID_TUNER = DISPID_TUNER(202i32);
pub const DISPID_TUNER_TS_ATSC_MAXPHYSCHANNEL: DISPID_TUNER = DISPID_TUNER(204i32);
pub const DISPID_TUNER_TS_ATSC_MINMINORCHANNEL: DISPID_TUNER = DISPID_TUNER(201i32);
pub const DISPID_TUNER_TS_ATSC_MINPHYSCHANNEL: DISPID_TUNER = DISPID_TUNER(203i32);
pub const DISPID_TUNER_TS_ATV_COUNTRYCODE: DISPID_TUNER = DISPID_TUNER(104i32);
pub const DISPID_TUNER_TS_ATV_INPUTTYPE: DISPID_TUNER = DISPID_TUNER(103i32);
pub const DISPID_TUNER_TS_ATV_MAXCHANNEL: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_TUNER_TS_ATV_MINCHANNEL: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_TUNER_TS_AUX_COUNTRYCODE: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_TUNER_TS_CLONE: DISPID_TUNER = DISPID_TUNER(12i32);
pub const DISPID_TUNER_TS_CLSID: DISPID_TUNER = DISPID_TUNER(3i32);
pub const DISPID_TUNER_TS_CREATETUNEREQUEST: DISPID_TUNER = DISPID_TUNER(6i32);
pub const DISPID_TUNER_TS_DC_MAXMAJORCHANNEL: DISPID_TUNER = DISPID_TUNER(302i32);
pub const DISPID_TUNER_TS_DC_MAXSOURCEID: DISPID_TUNER = DISPID_TUNER(304i32);
pub const DISPID_TUNER_TS_DC_MINMAJORCHANNEL: DISPID_TUNER = DISPID_TUNER(301i32);
pub const DISPID_TUNER_TS_DC_MINSOURCEID: DISPID_TUNER = DISPID_TUNER(303i32);
pub const DISPID_TUNER_TS_DEFAULTPREFERREDCOMPONENTTYPES: DISPID_TUNER = DISPID_TUNER(9i32);
pub const DISPID_TUNER_TS_DEFLOCATOR: DISPID_TUNER = DISPID_TUNER(11i32);
pub const DISPID_TUNER_TS_DVB2_NETWORK_ID: DISPID_TUNER = DISPID_TUNER(102i32);
pub const DISPID_TUNER_TS_DVBS2_HI_OSC_FREQ_OVERRIDE: DISPID_TUNER = DISPID_TUNER(408i32);
pub const DISPID_TUNER_TS_DVBS2_LNB_SWITCH_FREQ_OVERRIDE: DISPID_TUNER = DISPID_TUNER(409i32);
pub const DISPID_TUNER_TS_DVBS2_LOW_OSC_FREQ_OVERRIDE: DISPID_TUNER = DISPID_TUNER(407i32);
pub const DISPID_TUNER_TS_DVBS2_SPECTRAL_INVERSION_OVERRIDE: DISPID_TUNER = DISPID_TUNER(410i32);
pub const DISPID_TUNER_TS_DVBS_HI_OSC_FREQ: DISPID_TUNER = DISPID_TUNER(1002i32);
pub const DISPID_TUNER_TS_DVBS_INPUT_RANGE: DISPID_TUNER = DISPID_TUNER(1004i32);
pub const DISPID_TUNER_TS_DVBS_LNB_SWITCH_FREQ: DISPID_TUNER = DISPID_TUNER(1003i32);
pub const DISPID_TUNER_TS_DVBS_LOW_OSC_FREQ: DISPID_TUNER = DISPID_TUNER(1001i32);
pub const DISPID_TUNER_TS_DVBS_SPECTRAL_INVERSION: DISPID_TUNER = DISPID_TUNER(1005i32);
pub const DISPID_TUNER_TS_DVB_SYSTEMTYPE: DISPID_TUNER = DISPID_TUNER(101i32);
pub const DISPID_TUNER_TS_ENUMCATEGORYGUIDS: DISPID_TUNER = DISPID_TUNER(7i32);
pub const DISPID_TUNER_TS_ENUMDEVICEMONIKERS: DISPID_TUNER = DISPID_TUNER(8i32);
pub const DISPID_TUNER_TS_FREQMAP: DISPID_TUNER = DISPID_TUNER(10i32);
pub const DISPID_TUNER_TS_FRIENDLYNAME: DISPID_TUNER = DISPID_TUNER(2i32);
pub const DISPID_TUNER_TS_NETWORKTYPE: DISPID_TUNER = DISPID_TUNER(4i32);
pub const DISPID_TUNER_TS_UNIQUENAME: DISPID_TUNER = DISPID_TUNER(1i32);
pub const DISPID_TUNER_TS__NETWORKTYPE: DISPID_TUNER = DISPID_TUNER(5i32);
pub const DOWNRES_Always: DownResEventParam = DownResEventParam(0i32);
pub const DOWNRES_InWindowOnly: DownResEventParam = DownResEventParam(1i32);
pub const DOWNRES_Undefined: DownResEventParam = DownResEventParam(2i32);
pub const DSATTRIB_BadSampleInfo: windows_core::GUID = windows_core::GUID::from_u128(0xe4846dda_5838_42b4_b897_6f7e5faa2f2f);
pub const DSATTRIB_WMDRMProtectionInfo: windows_core::GUID = windows_core::GUID::from_u128(0x40749583_6b9d_4eec_b43c_67a1801e1a9b);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DSHOW_STREAM_DESC {
    pub VersionNo: u32,
    pub StreamId: u32,
    pub Default: windows_core::BOOL,
    pub Creation: windows_core::BOOL,
    pub Reserved: u32,
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct DSMCC_ELEMENT {
    pub pid: u16,
    pub bComponentTag: u8,
    pub dwCarouselId: u32,
    pub dwTransactionId: u32,
    pub pNext: *mut DSMCC_ELEMENT,
}
impl Default for DSMCC_ELEMENT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct DSMCC_FILTER_OPTIONS {
    pub fSpecifyProtocol: windows_core::BOOL,
    pub Protocol: u8,
    pub fSpecifyType: windows_core::BOOL,
    pub Type: u8,
    pub fSpecifyMessageId: windows_core::BOOL,
    pub MessageId: u16,
    pub fSpecifyTransactionId: windows_core::BOOL,
    pub fUseTrxIdMessageIdMask: windows_core::BOOL,
    pub TransactionId: u32,
    pub fSpecifyModuleVersion: windows_core::BOOL,
    pub ModuleVersion: u8,
    pub fSpecifyBlockNumber: windows_core::BOOL,
    pub BlockNumber: u16,
    pub fGetModuleCall: windows_core::BOOL,
    pub NumberOfBlocksInModule: u16,
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct DSMCC_SECTION {
    pub TableId: u8,
    pub Header: DSMCC_SECTION_0,
    pub TableIdExtension: u16,
    pub Version: DSMCC_SECTION_1,
    pub SectionNumber: u8,
    pub LastSectionNumber: u8,
    pub ProtocolDiscriminator: u8,
    pub DsmccType: u8,
    pub MessageId: u16,
    pub TransactionId: u32,
    pub Reserved: u8,
    pub AdaptationLength: u8,
    pub MessageLength: u16,
    pub RemainingData: [u8; 1],
}
impl Default for DSMCC_SECTION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub union DSMCC_SECTION_0 {
    pub S: MPEG_HEADER_BITS_MIDL,
    pub W: u16,
}
impl Default for DSMCC_SECTION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DSMCC_SECTION_1 {
    pub S: MPEG_HEADER_VERSION_BITS_MIDL,
    pub B: u8,
}
impl Default for DSMCC_SECTION_1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DTFilter: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4f2_0049_4e2b_98fb_9537f6ce516d);
pub const DTV_CardStatus_Error: u32 = 2u32;
pub const DTV_CardStatus_FirmwareDownload: u32 = 3u32;
pub const DTV_CardStatus_Inserted: u32 = 0u32;
pub const DTV_CardStatus_Removed: u32 = 1u32;
pub const DTV_Entitlement_CanDecrypt: u32 = 0u32;
pub const DTV_Entitlement_NotEntitled: u32 = 1u32;
pub const DTV_Entitlement_TechnicalFailure: u32 = 2u32;
pub const DTV_MMIMessage_Close: u32 = 1u32;
pub const DTV_MMIMessage_Open: u32 = 0u32;
pub const DVBCLocator: windows_core::GUID = windows_core::GUID::from_u128(0xc531d9fd_9685_4028_8b68_6e1232079f1e);
pub const DVBSLocator: windows_core::GUID = windows_core::GUID::from_u128(0x1df7d126_4050_47f0_a7cf_4c4ca9241333);
pub const DVBSTuningSpace: windows_core::GUID = windows_core::GUID::from_u128(0xb64016f3_c9a2_4066_96f0_bd9563314726);
pub const DVBS_SCAN_TABLE_MAX_SIZE: u32 = 400u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DVBScramblingControlSpanningEvent {
    pub ulPID: u32,
    pub fScrambled: windows_core::BOOL,
}
pub const DVBTLocator: windows_core::GUID = windows_core::GUID::from_u128(0x9cd64701_bdf3_4d14_8e03_f12983d86664);
pub const DVBTLocator2: windows_core::GUID = windows_core::GUID::from_u128(0xefe3fa02_45d7_4920_be96_53fa7f35b0e6);
pub const DVBTuneRequest: windows_core::GUID = windows_core::GUID::from_u128(0x15d6504a_5494_499c_886c_973c9e53b9f1);
pub const DVBTuningSpace: windows_core::GUID = windows_core::GUID::from_u128(0xc6b14b32_76aa_4a86_a7ac_5c79aaf58da7);
pub const DVB_BAT_PID: u32 = 17u32;
pub const DVB_BAT_TID: u32 = 74u32;
pub const DVB_CABLE_TV_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0xdc0c0fe7_0485_4266_b93f_68fbf80ed834);
pub const DVB_DIT_PID: u32 = 30u32;
pub const DVB_DIT_TID: u32 = 126u32;
pub const DVB_EIT_ACTUAL_TID: u32 = 78u32;
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct DVB_EIT_FILTER_OPTIONS {
    pub fSpecifySegment: windows_core::BOOL,
    pub bSegment: u8,
}
pub const DVB_EIT_OTHER_TID: u32 = 79u32;
pub const DVB_EIT_PID: u32 = 18u32;
pub const DVB_NIT_ACTUAL_TID: u32 = 64u32;
pub const DVB_NIT_OTHER_TID: u32 = 65u32;
pub const DVB_NIT_PID: u32 = 16u32;
pub const DVB_RST_PID: u32 = 19u32;
pub const DVB_RST_TID: u32 = 113u32;
pub const DVB_SATELLITE_TV_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0xfa4b375a_45b4_4d45_8440_263957b11623);
pub const DVB_SDT_ACTUAL_TID: u32 = 66u32;
pub const DVB_SDT_OTHER_TID: u32 = 70u32;
pub const DVB_SDT_PID: u32 = 17u32;
pub const DVB_SIT_PID: u32 = 31u32;
pub const DVB_SIT_TID: u32 = 127u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVB_STRCONV_MODE(pub i32);
pub const DVB_ST_PID_16: u32 = 16u32;
pub const DVB_ST_PID_17: u32 = 17u32;
pub const DVB_ST_PID_18: u32 = 18u32;
pub const DVB_ST_PID_19: u32 = 19u32;
pub const DVB_ST_PID_20: u32 = 20u32;
pub const DVB_ST_TID: u32 = 114u32;
pub const DVB_TDT_PID: u32 = 20u32;
pub const DVB_TDT_TID: u32 = 112u32;
pub const DVB_TERRESTRIAL_TV_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0x216c62df_6d7f_4e9a_8571_05f14edb766a);
pub const DVB_TOT_PID: u32 = 20u32;
pub const DVB_TOT_TID: u32 = 115u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVDFilterState(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVDMenuIDConstants(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVDSPExt(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVDTextStringType(pub i32);
#[repr(C)]
#[cfg(feature = "Win32_Media_MediaFoundation")]
#[derive(Clone, Debug, Default, PartialEq)]
pub struct DVR_STREAM_DESC {
    pub Version: u32,
    pub StreamId: u32,
    pub Default: windows_core::BOOL,
    pub Creation: windows_core::BOOL,
    pub Reserved: u32,
    pub guidSubMediaType: windows_core::GUID,
    pub guidFormatType: windows_core::GUID,
    pub MediaType: super::super::MediaFoundation::AM_MEDIA_TYPE,
}
pub const DigitalCableLocator: windows_core::GUID = windows_core::GUID::from_u128(0x03c06416_d127_407a_ab4c_fdd279abbe5d);
pub const DigitalCableTuneRequest: windows_core::GUID = windows_core::GUID::from_u128(0x26ec0b63_aa90_458a_8df4_5659f2c8a18a);
pub const DigitalCableTuningSpace: windows_core::GUID = windows_core::GUID::from_u128(0xd9bb4cee_b87a_47f1_ac92_b08d9c7813fc);
pub const DigitalLocator: windows_core::GUID = windows_core::GUID::from_u128(0x6e50cc0d_c19b_4bf6_810b_5bd60761f5cc);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DisplaySizeList(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DownResEventParam(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DualMonoInfo {
    pub LangID1: u16,
    pub LangID2: u16,
    pub lISOLangCode1: i32,
    pub lISOLangCode2: i32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DvbParentalRatingDescriptor {
    pub ulNumParams: u32,
    pub pParams: [DvbParentalRatingParam; 1],
}
impl Default for DvbParentalRatingDescriptor {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DvbParentalRatingParam {
    pub szCountryCode: [i8; 4],
    pub bRating: u8,
}
impl Default for DvbParentalRatingParam {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const ECHOSTAR_SATELLITE_TV_NETWORK_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0xc4f6b31b_c6bf_4759_886f_a7386dca27a0);
pub const ENCDEC_CPEVENT: EncDecEvents = EncDecEvents(0i32);
pub const ENCDEC_RECORDING_STATUS: EncDecEvents = EncDecEvents(1i32);
pub const ESEventFactory: windows_core::GUID = windows_core::GUID::from_u128(0x8e8a07da_71f8_40c1_a929_5e3a868ac2c6);
pub const ESEventService: windows_core::GUID = windows_core::GUID::from_u128(0xc20447fc_ec60_475e_813f_d2b0a6decefe);
pub const ETFilter: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4f1_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ARIBcontentSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x3a954083_93d0_463e_90b2_0742c496edf0);
pub const EVENTID_AudioDescriptorSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x107bd41c_a6da_4691_8369_11b2cdaa288e);
pub const EVENTID_AudioTypeSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x501cbfbe_b849_42ce_9be9_3db869fb82b3);
pub const EVENTID_BDAConditionalAccessTAG: windows_core::GUID = windows_core::GUID::from_u128(0xefc3a459_ae8b_4b4a_8fe9_79a0d097f3ea);
pub const EVENTID_BDAEventingServicePendingEvent: windows_core::GUID = windows_core::GUID::from_u128(0x5ca51711_5ddc_41a6_9430_e41b8b3bbc5b);
pub const EVENTID_BDA_CASBroadcastMMI: windows_core::GUID = windows_core::GUID::from_u128(0x676876f0_1132_404c_a7ca_e72069a9d54f);
pub const EVENTID_BDA_CASCloseMMI: windows_core::GUID = windows_core::GUID::from_u128(0x5d0f550f_de2e_479d_8345_ec0e9557e8a2);
pub const EVENTID_BDA_CASOpenMMI: windows_core::GUID = windows_core::GUID::from_u128(0x85dac915_e593_410d_8471_d6812105f28e);
pub const EVENTID_BDA_CASReleaseTuner: windows_core::GUID = windows_core::GUID::from_u128(0x20c1a16b_441f_49a5_bb5c_e9a04495c6c1);
pub const EVENTID_BDA_CASRequestTuner: windows_core::GUID = windows_core::GUID::from_u128(0xcf39a9d8_f5d3_4685_be57_ed81dba46b27);
pub const EVENTID_BDA_DiseqCResponseAvailable: windows_core::GUID = windows_core::GUID::from_u128(0xefa628f8_1f2c_4b67_9ea5_acf6fa9a1f36);
pub const EVENTID_BDA_EncoderSignalLock: windows_core::GUID = windows_core::GUID::from_u128(0x5ec90eb9_39fa_4cfc_b93f_00bb11077f5e);
pub const EVENTID_BDA_FdcStatus: windows_core::GUID = windows_core::GUID::from_u128(0x05f25366_d0eb_43d2_bc3c_682b863df142);
pub const EVENTID_BDA_FdcTableSection: windows_core::GUID = windows_core::GUID::from_u128(0x6a0cd757_4ce3_4e5b_9444_7187b87152c5);
pub const EVENTID_BDA_GPNVValueUpdate: windows_core::GUID = windows_core::GUID::from_u128(0xff75c68c_f416_4e7e_bf17_6d55c5df1575);
pub const EVENTID_BDA_GuideDataAvailable: windows_core::GUID = windows_core::GUID::from_u128(0x98db717a_478a_4cd4_92d0_95f66b89e5b1);
pub const EVENTID_BDA_GuideDataError: windows_core::GUID = windows_core::GUID::from_u128(0xac33c448_6f73_4fd7_b341_594c360d8d74);
pub const EVENTID_BDA_GuideServiceInformationUpdated: windows_core::GUID = windows_core::GUID::from_u128(0xa1c3ea2b_175f_4458_b735_507d22db23a6);
pub const EVENTID_BDA_IsdbCASResponse: windows_core::GUID = windows_core::GUID::from_u128(0xd4cb1966_41bc_4ced_9a20_fdceac78f70d);
pub const EVENTID_BDA_LbigsCloseConnectionHandle: windows_core::GUID = windows_core::GUID::from_u128(0xc2f08b99_65ef_4314_9671_e99d4cce0bae);
pub const EVENTID_BDA_LbigsOpenConnection: windows_core::GUID = windows_core::GUID::from_u128(0x356207b2_6f31_4eb0_a271_b3fa6bb7680f);
pub const EVENTID_BDA_LbigsSendData: windows_core::GUID = windows_core::GUID::from_u128(0x1123277b_f1c6_4154_8b0d_48e6157059aa);
pub const EVENTID_BDA_RatingPinReset: windows_core::GUID = windows_core::GUID::from_u128(0xc6e048c0_c574_4c26_bcda_2f4d35eb5e85);
pub const EVENTID_BDA_TransprtStreamSelectorInfo: windows_core::GUID = windows_core::GUID::from_u128(0xc40f9f85_09d0_489c_9e9c_0abbb56951b0);
pub const EVENTID_BDA_TunerNoSignal: windows_core::GUID = windows_core::GUID::from_u128(0xe29b382b_1edd_4930_bc46_682fd72d2dfb);
pub const EVENTID_BDA_TunerSignalLock: windows_core::GUID = windows_core::GUID::from_u128(0x1872e740_f573_429b_a00e_d9c1e408af09);
pub const EVENTID_BDA_UpdateDrmStatus: windows_core::GUID = windows_core::GUID::from_u128(0x65a6f681_1462_473b_88ce_cb731427bdb5);
pub const EVENTID_BDA_UpdateScanState: windows_core::GUID = windows_core::GUID::from_u128(0x55702b50_7b49_42b8_a82f_4afb691b0628);
pub const EVENTID_CADenialCountChanged: windows_core::GUID = windows_core::GUID::from_u128(0x2a65c528_2249_4070_ac16_00390cdfb2dd);
pub const EVENTID_CASFailureSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0xead831ae_5529_4d1f_afce_0d8cd1257d30);
pub const EVENTID_CSDescriptorSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0xefe779d9_97f0_4786_800d_95cf505ddc66);
pub const EVENTID_CandidatePostTuneData: windows_core::GUID = windows_core::GUID::from_u128(0x9f02d3d0_9f06_4369_9f1e_3ad6ca19807e);
pub const EVENTID_CardStatusChanged: windows_core::GUID = windows_core::GUID::from_u128(0xa265faea_f874_4b38_9ff7_c53d02969996);
pub const EVENTID_ChannelChangeSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x9067c5e5_4c5c_4205_86c8_7afe20fe1efa);
pub const EVENTID_ChannelInfoSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x41f36d80_4132_4cc2_b121_01a43219d81b);
pub const EVENTID_ChannelTypeSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x72ab1d51_87d2_489b_ba11_0e08dc210243);
pub const EVENTID_CtxADescriptorSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x3ab4a2e6_4247_4b34_896c_30afa5d21c24);
pub const EVENTID_DFNWithNoActualAVData: windows_core::GUID = windows_core::GUID::from_u128(0xf5689ffe_55f9_4bb3_96be_ae971c63bae0);
pub const EVENTID_DRMParingStatusChanged: windows_core::GUID = windows_core::GUID::from_u128(0x000906f5_f0d1_41d6_a7df_4028697669f6);
pub const EVENTID_DRMParingStepComplete: windows_core::GUID = windows_core::GUID::from_u128(0x5b2ebf78_b752_4420_b41e_a472dc95828e);
pub const EVENTID_DTFilterCOPPBlock: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4ea_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterCOPPUnblock: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4e8_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterDataFormatFailure: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4ed_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterDataFormatOK: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4ec_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterRatingChange: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4e2_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterRatingsBlock: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4e3_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterRatingsUnblock: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4e4_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DTFilterXDSPacket: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4e5_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_DVBScramblingControlSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x4bd4e1c4_90a1_4109_8236_27f00e7dcc5b);
pub const EVENTID_DemultiplexerFilterDiscontinuity: windows_core::GUID = windows_core::GUID::from_u128(0x16155770_aed5_475c_bb98_95a33070df0c);
pub const EVENTID_DualMonoSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0xa9a29b56_a84b_488c_89d5_0d4e7657c8ce);
pub const EVENTID_DvbParentalRatingDescriptor: windows_core::GUID = windows_core::GUID::from_u128(0x2a67a58d_eca5_4eac_abcb_e734d3776d0a);
pub const EVENTID_EASMessageReceived: windows_core::GUID = windows_core::GUID::from_u128(0xd10df9d5_c261_4b85_9e8a_517b3299cab2);
pub const EVENTID_ETDTFilterLicenseFailure: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4ef_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ETDTFilterLicenseOK: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4ee_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ETFilterCopyNever: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4f0_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ETFilterCopyOnce: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4eb_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ETFilterEncryptionOff: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4e7_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_ETFilterEncryptionOn: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4e6_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_EmmMessageSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x6bf00268_4f7e_4294_aa87_e9e953e43f14);
pub const EVENTID_EncDecFilterError: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4e9_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_EncDecFilterEvent: windows_core::GUID = windows_core::GUID::from_u128(0x4a1b465b_0fb9_4159_afbd_e33006a0f9f4);
pub const EVENTID_EntitlementChanged: windows_core::GUID = windows_core::GUID::from_u128(0x9071ad5d_2359_4c95_8694_afa81d70bfd5);
pub const EVENTID_FormatNotSupportedEvent: windows_core::GUID = windows_core::GUID::from_u128(0x24b2280a_b2aa_4777_bf65_63f35e7b024a);
pub const EVENTID_LanguageSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0xe292666d_9c02_448d_aa8d_781a93fdc395);
pub const EVENTID_MMIMessage: windows_core::GUID = windows_core::GUID::from_u128(0x052c29af_09a4_4b93_890f_bd6a348968a4);
pub const EVENTID_NewSignalAcquired: windows_core::GUID = windows_core::GUID::from_u128(0xc87ec52d_cd18_404a_a076_c02a273d3de7);
pub const EVENTID_PBDAParentalControlEvent: windows_core::GUID = windows_core::GUID::from_u128(0xf947aa85_fb52_48e8_b9c5_e1e1f411a51a);
pub const EVENTID_PIDListSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x47fc8f65_e2bb_4634_9cef_fdbfe6261d5c);
pub const EVENTID_PSITable: windows_core::GUID = windows_core::GUID::from_u128(0x1b9c3703_d447_4e16_97bb_01799fc031ed);
pub const EVENTID_RRTSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0xf6cfc8f4_da93_4f2f_bff8_ba1ee6fca3a2);
pub const EVENTID_SBE2RecControlStarted: windows_core::GUID = windows_core::GUID::from_u128(0x8966a89e_f83e_4c0e_bc3b_bfa7649e04cb);
pub const EVENTID_SBE2RecControlStopped: windows_core::GUID = windows_core::GUID::from_u128(0x454b1ec8_0c9b_4caa_b1a1_1e7a2666f6c3);
pub const EVENTID_STBChannelNumber: windows_core::GUID = windows_core::GUID::from_u128(0x17c4d730_d0f0_413a_8c99_500469de35ad);
pub const EVENTID_ServiceTerminated: windows_core::GUID = windows_core::GUID::from_u128(0x0a1d591c_e0d2_4f8e_8960_2335bef45ccb);
pub const EVENTID_SignalAndServiceStatusSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x8068c5cb_3c04_492b_b47d_0308820dce51);
pub const EVENTID_SignalStatusChanged: windows_core::GUID = windows_core::GUID::from_u128(0x6d9cfaf2_702d_4b01_8dff_6892ad20d191);
pub const EVENTID_StreamIDSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0xcaf1ab68_e153_4d41_a6b3_a7c998db75ee);
pub const EVENTID_StreamTypeSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x82af2ebc_30a6_4264_a80b_ad2e1372ac60);
pub const EVENTID_SubtitleSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x5dcec048_d0b9_4163_872c_4f32223be88a);
pub const EVENTID_TeletextSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x9599d950_5f33_4617_af7c_1e54b510daa3);
pub const EVENTID_TuneFailureEvent: windows_core::GUID = windows_core::GUID::from_u128(0xd97287b2_2dfd_436a_9485_99d7d4ab5a69);
pub const EVENTID_TuneFailureSpanningEvent: windows_core::GUID = windows_core::GUID::from_u128(0x6f8aa455_5ee1_48ab_a27c_4c8d70b9aeba);
pub const EVENTID_TuningChanged: windows_core::GUID = windows_core::GUID::from_u128(0x9d7e6235_4b7d_425d_a6d1_d717c33b9c4c);
pub const EVENTID_TuningChanging: windows_core::GUID = windows_core::GUID::from_u128(0x83183c03_c09e_45c4_a719_807a94952bf9);
pub const EVENTID_XDSCodecDuplicateXDSRating: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4df_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_XDSCodecNewXDSPacket: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4e1_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTID_XDSCodecNewXDSRating: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4e0_0049_4e2b_98fb_9537f6ce516d);
pub const EVENTTYPE_CASDescrambleFailureEvent: windows_core::GUID = windows_core::GUID::from_u128(0xb2127d42_7be5_4f4b_9130_6679899f4f4b);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EnTag_Mode(pub i32);
pub const EnTag_Once: EnTag_Mode = EnTag_Mode(1i32);
pub const EnTag_Remove: EnTag_Mode = EnTag_Mode(0i32);
pub const EnTag_Repeat: EnTag_Mode = EnTag_Mode(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EnTvRat_CAE_TV(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EnTvRat_CAF_TV(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EnTvRat_GenericLevel(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EnTvRat_MPAA(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EnTvRat_System(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EnTvRat_US_TV(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EncDecEvents(pub i32);
pub const EvalRat: windows_core::GUID = windows_core::GUID::from_u128(0xc5c5c5f1_3abc_11d6_b25b_00c04fa0c026);
pub const FORMATNOTSUPPORTED_CLEAR: FormatNotSupportedEvents = FormatNotSupportedEvents(0i32);
pub const FORMATNOTSUPPORTED_NOTSUPPORTED: FormatNotSupportedEvents = FormatNotSupportedEvents(1i32);
pub const FORMATTYPE_CPFilters_Processed: windows_core::GUID = windows_core::GUID::from_u128(0x6739b36f_1d5f_4ac2_8192_28bb0e73d16a);
pub const FORMATTYPE_ETDTFilter_Tagged: windows_core::GUID = windows_core::GUID::from_u128(0xc4c4c4d1_0049_4e2b_98fb_9537f6ce516d);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FormatNotSupportedEvents(pub i32);
pub const FrameMode: PositionModeList = PositionModeList(0i32);
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IATSCChannelTuneRequest, IATSCChannelTuneRequest_Vtbl, 0x0369b4e1_45b6_11d3_b650_00c04f79498e);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IATSCChannelTuneRequest {
    type Target = IChannelTuneRequest;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IATSCChannelTuneRequest, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuneRequest, IChannelTuneRequest);
#[cfg(feature = "Win32_System_Com")]
impl IATSCChannelTuneRequest {
    pub unsafe fn MinorChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MinorChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMinorChannel(&self, minorchannel: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMinorChannel)(windows_core::Interface::as_raw(self), minorchannel).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IATSCChannelTuneRequest_Vtbl {
    pub base__: IChannelTuneRequest_Vtbl,
    pub MinorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMinorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IATSCChannelTuneRequest_Impl: IChannelTuneRequest_Impl {
    fn MinorChannel(&self) -> windows_core::Result<i32>;
    fn SetMinorChannel(&self, minorchannel: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IATSCChannelTuneRequest_Vtbl {
    pub const fn new<Identity: IATSCChannelTuneRequest_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn MinorChannel<Identity: IATSCChannelTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, minorchannel: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSCChannelTuneRequest_Impl::MinorChannel(this) {
                    Ok(ok__) => {
                        minorchannel.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMinorChannel<Identity: IATSCChannelTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, minorchannel: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSCChannelTuneRequest_Impl::SetMinorChannel(this, core::mem::transmute_copy(&minorchannel)).into()
            }
        }
        Self {
            base__: IChannelTuneRequest_Vtbl::new::<Identity, OFFSET>(),
            MinorChannel: MinorChannel::<Identity, OFFSET>,
            SetMinorChannel: SetMinorChannel::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IATSCChannelTuneRequest as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuneRequest as windows_core::Interface>::IID || iid == &<IChannelTuneRequest as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IATSCChannelTuneRequest {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IATSCComponentType, IATSCComponentType_Vtbl, 0xfc189e4d_7bd4_4125_b3b3_3a76a332cc96);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IATSCComponentType {
    type Target = IMPEG2ComponentType;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IATSCComponentType, windows_core::IUnknown, super::super::super::System::Com::IDispatch, IComponentType, ILanguageComponentType, IMPEG2ComponentType);
#[cfg(feature = "Win32_System_Com")]
impl IATSCComponentType {
    pub unsafe fn Flags(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Flags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetFlags(&self, flags: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IATSCComponentType_Vtbl {
    pub base__: IMPEG2ComponentType_Vtbl,
    pub Flags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IATSCComponentType_Impl: IMPEG2ComponentType_Impl {
    fn Flags(&self) -> windows_core::Result<i32>;
    fn SetFlags(&self, flags: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IATSCComponentType_Vtbl {
    pub const fn new<Identity: IATSCComponentType_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Flags<Identity: IATSCComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSCComponentType_Impl::Flags(this) {
                    Ok(ok__) => {
                        flags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetFlags<Identity: IATSCComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSCComponentType_Impl::SetFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        Self { base__: IMPEG2ComponentType_Vtbl::new::<Identity, OFFSET>(), Flags: Flags::<Identity, OFFSET>, SetFlags: SetFlags::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IATSCComponentType as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<IComponentType as windows_core::Interface>::IID || iid == &<ILanguageComponentType as windows_core::Interface>::IID || iid == &<IMPEG2ComponentType as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IATSCComponentType {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IATSCLocator, IATSCLocator_Vtbl, 0xbf8d986f_8c2b_4131_94d7_4d3d9fcc21ef);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IATSCLocator {
    type Target = IDigitalLocator;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IATSCLocator, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ILocator, IDigitalLocator);
#[cfg(feature = "Win32_System_Com")]
impl IATSCLocator {
    pub unsafe fn PhysicalChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).PhysicalChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetPhysicalChannel(&self, physicalchannel: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPhysicalChannel)(windows_core::Interface::as_raw(self), physicalchannel).ok() }
    }
    pub unsafe fn TSID(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).TSID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTSID(&self, tsid: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTSID)(windows_core::Interface::as_raw(self), tsid).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IATSCLocator_Vtbl {
    pub base__: IDigitalLocator_Vtbl,
    pub PhysicalChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetPhysicalChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub TSID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetTSID: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IATSCLocator_Impl: IDigitalLocator_Impl {
    fn PhysicalChannel(&self) -> windows_core::Result<i32>;
    fn SetPhysicalChannel(&self, physicalchannel: i32) -> windows_core::Result<()>;
    fn TSID(&self) -> windows_core::Result<i32>;
    fn SetTSID(&self, tsid: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IATSCLocator_Vtbl {
    pub const fn new<Identity: IATSCLocator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn PhysicalChannel<Identity: IATSCLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, physicalchannel: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSCLocator_Impl::PhysicalChannel(this) {
                    Ok(ok__) => {
                        physicalchannel.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetPhysicalChannel<Identity: IATSCLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, physicalchannel: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSCLocator_Impl::SetPhysicalChannel(this, core::mem::transmute_copy(&physicalchannel)).into()
            }
        }
        unsafe extern "system" fn TSID<Identity: IATSCLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tsid: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSCLocator_Impl::TSID(this) {
                    Ok(ok__) => {
                        tsid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTSID<Identity: IATSCLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tsid: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSCLocator_Impl::SetTSID(this, core::mem::transmute_copy(&tsid)).into()
            }
        }
        Self {
            base__: IDigitalLocator_Vtbl::new::<Identity, OFFSET>(),
            PhysicalChannel: PhysicalChannel::<Identity, OFFSET>,
            SetPhysicalChannel: SetPhysicalChannel::<Identity, OFFSET>,
            TSID: TSID::<Identity, OFFSET>,
            SetTSID: SetTSID::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IATSCLocator as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ILocator as windows_core::Interface>::IID || iid == &<IDigitalLocator as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IATSCLocator {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IATSCLocator2, IATSCLocator2_Vtbl, 0x612aa885_66cf_4090_ba0a_566f5312e4ca);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IATSCLocator2 {
    type Target = IATSCLocator;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IATSCLocator2, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ILocator, IDigitalLocator, IATSCLocator);
#[cfg(feature = "Win32_System_Com")]
impl IATSCLocator2 {
    pub unsafe fn ProgramNumber(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ProgramNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetProgramNumber(&self, programnumber: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetProgramNumber)(windows_core::Interface::as_raw(self), programnumber).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IATSCLocator2_Vtbl {
    pub base__: IATSCLocator_Vtbl,
    pub ProgramNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetProgramNumber: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IATSCLocator2_Impl: IATSCLocator_Impl {
    fn ProgramNumber(&self) -> windows_core::Result<i32>;
    fn SetProgramNumber(&self, programnumber: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IATSCLocator2_Vtbl {
    pub const fn new<Identity: IATSCLocator2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ProgramNumber<Identity: IATSCLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, programnumber: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSCLocator2_Impl::ProgramNumber(this) {
                    Ok(ok__) => {
                        programnumber.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetProgramNumber<Identity: IATSCLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, programnumber: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSCLocator2_Impl::SetProgramNumber(this, core::mem::transmute_copy(&programnumber)).into()
            }
        }
        Self {
            base__: IATSCLocator_Vtbl::new::<Identity, OFFSET>(),
            ProgramNumber: ProgramNumber::<Identity, OFFSET>,
            SetProgramNumber: SetProgramNumber::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IATSCLocator2 as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ILocator as windows_core::Interface>::IID || iid == &<IDigitalLocator as windows_core::Interface>::IID || iid == &<IATSCLocator as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IATSCLocator2 {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IATSCTuningSpace, IATSCTuningSpace_Vtbl, 0x0369b4e2_45b6_11d3_b650_00c04f79498e);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IATSCTuningSpace {
    type Target = IAnalogTVTuningSpace;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IATSCTuningSpace, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuningSpace, IAnalogTVTuningSpace);
#[cfg(feature = "Win32_System_Com")]
impl IATSCTuningSpace {
    pub unsafe fn MinMinorChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MinMinorChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMinMinorChannel(&self, newminminorchannelval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMinMinorChannel)(windows_core::Interface::as_raw(self), newminminorchannelval).ok() }
    }
    pub unsafe fn MaxMinorChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MaxMinorChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMaxMinorChannel(&self, newmaxminorchannelval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMaxMinorChannel)(windows_core::Interface::as_raw(self), newmaxminorchannelval).ok() }
    }
    pub unsafe fn MinPhysicalChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MinPhysicalChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMinPhysicalChannel(&self, newminphysicalchannelval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMinPhysicalChannel)(windows_core::Interface::as_raw(self), newminphysicalchannelval).ok() }
    }
    pub unsafe fn MaxPhysicalChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MaxPhysicalChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMaxPhysicalChannel(&self, newmaxphysicalchannelval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMaxPhysicalChannel)(windows_core::Interface::as_raw(self), newmaxphysicalchannelval).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IATSCTuningSpace_Vtbl {
    pub base__: IAnalogTVTuningSpace_Vtbl,
    pub MinMinorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMinMinorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub MaxMinorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMaxMinorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub MinPhysicalChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMinPhysicalChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub MaxPhysicalChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMaxPhysicalChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IATSCTuningSpace_Impl: IAnalogTVTuningSpace_Impl {
    fn MinMinorChannel(&self) -> windows_core::Result<i32>;
    fn SetMinMinorChannel(&self, newminminorchannelval: i32) -> windows_core::Result<()>;
    fn MaxMinorChannel(&self) -> windows_core::Result<i32>;
    fn SetMaxMinorChannel(&self, newmaxminorchannelval: i32) -> windows_core::Result<()>;
    fn MinPhysicalChannel(&self) -> windows_core::Result<i32>;
    fn SetMinPhysicalChannel(&self, newminphysicalchannelval: i32) -> windows_core::Result<()>;
    fn MaxPhysicalChannel(&self) -> windows_core::Result<i32>;
    fn SetMaxPhysicalChannel(&self, newmaxphysicalchannelval: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IATSCTuningSpace_Vtbl {
    pub const fn new<Identity: IATSCTuningSpace_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn MinMinorChannel<Identity: IATSCTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, minminorchannelval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSCTuningSpace_Impl::MinMinorChannel(this) {
                    Ok(ok__) => {
                        minminorchannelval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMinMinorChannel<Identity: IATSCTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newminminorchannelval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSCTuningSpace_Impl::SetMinMinorChannel(this, core::mem::transmute_copy(&newminminorchannelval)).into()
            }
        }
        unsafe extern "system" fn MaxMinorChannel<Identity: IATSCTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, maxminorchannelval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSCTuningSpace_Impl::MaxMinorChannel(this) {
                    Ok(ok__) => {
                        maxminorchannelval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMaxMinorChannel<Identity: IATSCTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newmaxminorchannelval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSCTuningSpace_Impl::SetMaxMinorChannel(this, core::mem::transmute_copy(&newmaxminorchannelval)).into()
            }
        }
        unsafe extern "system" fn MinPhysicalChannel<Identity: IATSCTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, minphysicalchannelval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSCTuningSpace_Impl::MinPhysicalChannel(this) {
                    Ok(ok__) => {
                        minphysicalchannelval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMinPhysicalChannel<Identity: IATSCTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newminphysicalchannelval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSCTuningSpace_Impl::SetMinPhysicalChannel(this, core::mem::transmute_copy(&newminphysicalchannelval)).into()
            }
        }
        unsafe extern "system" fn MaxPhysicalChannel<Identity: IATSCTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, maxphysicalchannelval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSCTuningSpace_Impl::MaxPhysicalChannel(this) {
                    Ok(ok__) => {
                        maxphysicalchannelval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMaxPhysicalChannel<Identity: IATSCTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newmaxphysicalchannelval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSCTuningSpace_Impl::SetMaxPhysicalChannel(this, core::mem::transmute_copy(&newmaxphysicalchannelval)).into()
            }
        }
        Self {
            base__: IAnalogTVTuningSpace_Vtbl::new::<Identity, OFFSET>(),
            MinMinorChannel: MinMinorChannel::<Identity, OFFSET>,
            SetMinMinorChannel: SetMinMinorChannel::<Identity, OFFSET>,
            MaxMinorChannel: MaxMinorChannel::<Identity, OFFSET>,
            SetMaxMinorChannel: SetMaxMinorChannel::<Identity, OFFSET>,
            MinPhysicalChannel: MinPhysicalChannel::<Identity, OFFSET>,
            SetMinPhysicalChannel: SetMinPhysicalChannel::<Identity, OFFSET>,
            MaxPhysicalChannel: MaxPhysicalChannel::<Identity, OFFSET>,
            SetMaxPhysicalChannel: SetMaxPhysicalChannel::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IATSCTuningSpace as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuningSpace as windows_core::Interface>::IID || iid == &<IAnalogTVTuningSpace as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IATSCTuningSpace {}
windows_core::imp::define_interface!(IATSC_EIT, IATSC_EIT_Vtbl, 0xd7c212d7_76a2_4b4b_aa56_846879a80096);
windows_core::imp::interface_hierarchy!(IATSC_EIT, windows_core::IUnknown);
impl IATSC_EIT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetVersionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSourceId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSourceId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetProtocolVersion(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProtocolVersion)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordEventId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordEventId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordStartTime(&self, dwrecordindex: u32) -> windows_core::Result<MPEG_DATE_AND_TIME> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordStartTime)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordEtmLocation(&self, dwrecordindex: u32) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordEtmLocation)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordDuration(&self, dwrecordindex: u32) -> windows_core::Result<MPEG_TIME> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordDuration)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordTitleText(&self, dwrecordindex: u32, pdwlength: *mut u32, pptext: *mut *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordTitleText)(windows_core::Interface::as_raw(self), dwrecordindex, pdwlength as _, pptext as _).ok() }
    }
    pub unsafe fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCountOfDescriptors)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordDescriptorByIndex)(windows_core::Interface::as_raw(self), dwrecordindex, dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordDescriptorByTag)(windows_core::Interface::as_raw(self), dwrecordindex, btag, pdwcookie as _, core::mem::transmute(ppdescriptor)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSC_EIT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetSourceId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetProtocolVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRecordEventId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordStartTime: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut MPEG_DATE_AND_TIME) -> windows_core::HRESULT,
    pub GetRecordEtmLocation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
    pub GetRecordDuration: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut MPEG_TIME) -> windows_core::HRESULT,
    pub GetRecordTitleText: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, *mut *mut u8) -> windows_core::HRESULT,
    pub GetRecordCountOfDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRecordDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRecordDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IATSC_EIT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetVersionNumber(&self) -> windows_core::Result<u8>;
    fn GetSourceId(&self) -> windows_core::Result<u16>;
    fn GetProtocolVersion(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u32>;
    fn GetRecordEventId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordStartTime(&self, dwrecordindex: u32) -> windows_core::Result<MPEG_DATE_AND_TIME>;
    fn GetRecordEtmLocation(&self, dwrecordindex: u32) -> windows_core::Result<u8>;
    fn GetRecordDuration(&self, dwrecordindex: u32) -> windows_core::Result<MPEG_TIME>;
    fn GetRecordTitleText(&self, dwrecordindex: u32, pdwlength: *mut u32, pptext: *mut *mut u8) -> windows_core::Result<()>;
    fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32>;
    fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
}
impl IATSC_EIT_Vtbl {
    pub const fn new<Identity: IATSC_EIT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_EIT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetVersionNumber<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_EIT_Impl::GetVersionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSourceId<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_EIT_Impl::GetSourceId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetProtocolVersion<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_EIT_Impl::GetProtocolVersion(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_EIT_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordEventId<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_EIT_Impl::GetRecordEventId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordStartTime<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pmdtval: *mut MPEG_DATE_AND_TIME) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_EIT_Impl::GetRecordStartTime(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pmdtval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordEtmLocation<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_EIT_Impl::GetRecordEtmLocation(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDuration<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pmdval: *mut MPEG_TIME) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_EIT_Impl::GetRecordDuration(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pmdval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordTitleText<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pdwlength: *mut u32, pptext: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_EIT_Impl::GetRecordTitleText(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&pdwlength), core::mem::transmute_copy(&pptext)).into()
            }
        }
        unsafe extern "system" fn GetRecordCountOfDescriptors<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_EIT_Impl::GetRecordCountOfDescriptors(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByIndex<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_EIT_Impl::GetRecordDescriptorByIndex(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByTag<Identity: IATSC_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_EIT_Impl::GetRecordDescriptorByTag(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetVersionNumber: GetVersionNumber::<Identity, OFFSET>,
            GetSourceId: GetSourceId::<Identity, OFFSET>,
            GetProtocolVersion: GetProtocolVersion::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordEventId: GetRecordEventId::<Identity, OFFSET>,
            GetRecordStartTime: GetRecordStartTime::<Identity, OFFSET>,
            GetRecordEtmLocation: GetRecordEtmLocation::<Identity, OFFSET>,
            GetRecordDuration: GetRecordDuration::<Identity, OFFSET>,
            GetRecordTitleText: GetRecordTitleText::<Identity, OFFSET>,
            GetRecordCountOfDescriptors: GetRecordCountOfDescriptors::<Identity, OFFSET>,
            GetRecordDescriptorByIndex: GetRecordDescriptorByIndex::<Identity, OFFSET>,
            GetRecordDescriptorByTag: GetRecordDescriptorByTag::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IATSC_EIT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IATSC_EIT {}
windows_core::imp::define_interface!(IATSC_ETT, IATSC_ETT_Vtbl, 0x5a142cc9_b8cf_4a86_a040_e9cadf3ef3e7);
windows_core::imp::interface_hierarchy!(IATSC_ETT, windows_core::IUnknown);
impl IATSC_ETT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetVersionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetProtocolVersion(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProtocolVersion)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetEtmId(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEtmId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetExtendedMessageText(&self, pdwlength: *mut u32, pptext: *mut *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetExtendedMessageText)(windows_core::Interface::as_raw(self), pdwlength as _, pptext as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSC_ETT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetProtocolVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetEtmId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetExtendedMessageText: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut *mut u8) -> windows_core::HRESULT,
}
pub trait IATSC_ETT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetVersionNumber(&self) -> windows_core::Result<u8>;
    fn GetProtocolVersion(&self) -> windows_core::Result<u8>;
    fn GetEtmId(&self) -> windows_core::Result<u32>;
    fn GetExtendedMessageText(&self, pdwlength: *mut u32, pptext: *mut *mut u8) -> windows_core::Result<()>;
}
impl IATSC_ETT_Vtbl {
    pub const fn new<Identity: IATSC_ETT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IATSC_ETT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_ETT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetVersionNumber<Identity: IATSC_ETT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_ETT_Impl::GetVersionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetProtocolVersion<Identity: IATSC_ETT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_ETT_Impl::GetProtocolVersion(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetEtmId<Identity: IATSC_ETT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_ETT_Impl::GetEtmId(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetExtendedMessageText<Identity: IATSC_ETT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwlength: *mut u32, pptext: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_ETT_Impl::GetExtendedMessageText(this, core::mem::transmute_copy(&pdwlength), core::mem::transmute_copy(&pptext)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetVersionNumber: GetVersionNumber::<Identity, OFFSET>,
            GetProtocolVersion: GetProtocolVersion::<Identity, OFFSET>,
            GetEtmId: GetEtmId::<Identity, OFFSET>,
            GetExtendedMessageText: GetExtendedMessageText::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IATSC_ETT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IATSC_ETT {}
windows_core::imp::define_interface!(IATSC_MGT, IATSC_MGT_Vtbl, 0x8877dabd_c137_4073_97e3_779407a5d87a);
windows_core::imp::interface_hierarchy!(IATSC_MGT, windows_core::IUnknown);
impl IATSC_MGT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetVersionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetProtocolVersion(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProtocolVersion)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordType(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordType)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordTypePid(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordTypePid)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordVersionNumber(&self, dwrecordindex: u32) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordVersionNumber)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCountOfDescriptors)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordDescriptorByIndex)(windows_core::Interface::as_raw(self), dwrecordindex, dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordDescriptorByTag)(windows_core::Interface::as_raw(self), dwrecordindex, btag, pdwcookie as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn GetCountOfTableDescriptors(&self, pdwval: *const u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCountOfTableDescriptors)(windows_core::Interface::as_raw(self), pdwval).ok() }
    }
    pub unsafe fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTableDescriptorByIndex)(windows_core::Interface::as_raw(self), dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTableDescriptorByTag)(windows_core::Interface::as_raw(self), btag, pdwcookie as _, core::mem::transmute(ppdescriptor)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSC_MGT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetProtocolVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRecordType: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordTypePid: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
    pub GetRecordCountOfDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRecordDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRecordDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCountOfTableDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, *const u32) -> windows_core::HRESULT,
    pub GetTableDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTableDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IATSC_MGT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetVersionNumber(&self) -> windows_core::Result<u8>;
    fn GetProtocolVersion(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u32>;
    fn GetRecordType(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordTypePid(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordVersionNumber(&self, dwrecordindex: u32) -> windows_core::Result<u8>;
    fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32>;
    fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn GetCountOfTableDescriptors(&self, pdwval: *const u32) -> windows_core::Result<()>;
    fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
}
impl IATSC_MGT_Vtbl {
    pub const fn new<Identity: IATSC_MGT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_MGT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetVersionNumber<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_MGT_Impl::GetVersionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetProtocolVersion<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_MGT_Impl::GetProtocolVersion(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_MGT_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordType<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_MGT_Impl::GetRecordType(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordTypePid<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, ppidval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_MGT_Impl::GetRecordTypePid(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        ppidval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordVersionNumber<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_MGT_Impl::GetRecordVersionNumber(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCountOfDescriptors<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_MGT_Impl::GetRecordCountOfDescriptors(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByIndex<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_MGT_Impl::GetRecordDescriptorByIndex(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByTag<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_MGT_Impl::GetRecordDescriptorByTag(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn GetCountOfTableDescriptors<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *const u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_MGT_Impl::GetCountOfTableDescriptors(this, core::mem::transmute_copy(&pdwval)).into()
            }
        }
        unsafe extern "system" fn GetTableDescriptorByIndex<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_MGT_Impl::GetTableDescriptorByIndex(this, core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByTag<Identity: IATSC_MGT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_MGT_Impl::GetTableDescriptorByTag(this, core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetVersionNumber: GetVersionNumber::<Identity, OFFSET>,
            GetProtocolVersion: GetProtocolVersion::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordType: GetRecordType::<Identity, OFFSET>,
            GetRecordTypePid: GetRecordTypePid::<Identity, OFFSET>,
            GetRecordVersionNumber: GetRecordVersionNumber::<Identity, OFFSET>,
            GetRecordCountOfDescriptors: GetRecordCountOfDescriptors::<Identity, OFFSET>,
            GetRecordDescriptorByIndex: GetRecordDescriptorByIndex::<Identity, OFFSET>,
            GetRecordDescriptorByTag: GetRecordDescriptorByTag::<Identity, OFFSET>,
            GetCountOfTableDescriptors: GetCountOfTableDescriptors::<Identity, OFFSET>,
            GetTableDescriptorByIndex: GetTableDescriptorByIndex::<Identity, OFFSET>,
            GetTableDescriptorByTag: GetTableDescriptorByTag::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IATSC_MGT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IATSC_MGT {}
windows_core::imp::define_interface!(IATSC_STT, IATSC_STT_Vtbl, 0x6bf42423_217d_4d6f_81e1_3a7b360ec896);
windows_core::imp::interface_hierarchy!(IATSC_STT, windows_core::IUnknown);
impl IATSC_STT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetProtocolVersion(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProtocolVersion)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSystemTime(&self) -> windows_core::Result<MPEG_DATE_AND_TIME> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSystemTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetGpsUtcOffset(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetGpsUtcOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDaylightSavings(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDaylightSavings)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfTableDescriptors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTableDescriptorByIndex)(windows_core::Interface::as_raw(self), dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTableDescriptorByTag)(windows_core::Interface::as_raw(self), btag, pdwcookie as _, core::mem::transmute(ppdescriptor)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSC_STT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetProtocolVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetSystemTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut MPEG_DATE_AND_TIME) -> windows_core::HRESULT,
    pub GetGpsUtcOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetDaylightSavings: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetCountOfTableDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTableDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTableDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IATSC_STT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetProtocolVersion(&self) -> windows_core::Result<u8>;
    fn GetSystemTime(&self) -> windows_core::Result<MPEG_DATE_AND_TIME>;
    fn GetGpsUtcOffset(&self) -> windows_core::Result<u8>;
    fn GetDaylightSavings(&self) -> windows_core::Result<u16>;
    fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32>;
    fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
}
impl IATSC_STT_Vtbl {
    pub const fn new<Identity: IATSC_STT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IATSC_STT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_STT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetProtocolVersion<Identity: IATSC_STT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_STT_Impl::GetProtocolVersion(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSystemTime<Identity: IATSC_STT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmdtsystemtime: *mut MPEG_DATE_AND_TIME) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_STT_Impl::GetSystemTime(this) {
                    Ok(ok__) => {
                        pmdtsystemtime.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetGpsUtcOffset<Identity: IATSC_STT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_STT_Impl::GetGpsUtcOffset(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDaylightSavings<Identity: IATSC_STT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_STT_Impl::GetDaylightSavings(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfTableDescriptors<Identity: IATSC_STT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_STT_Impl::GetCountOfTableDescriptors(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByIndex<Identity: IATSC_STT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_STT_Impl::GetTableDescriptorByIndex(this, core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByTag<Identity: IATSC_STT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_STT_Impl::GetTableDescriptorByTag(this, core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetProtocolVersion: GetProtocolVersion::<Identity, OFFSET>,
            GetSystemTime: GetSystemTime::<Identity, OFFSET>,
            GetGpsUtcOffset: GetGpsUtcOffset::<Identity, OFFSET>,
            GetDaylightSavings: GetDaylightSavings::<Identity, OFFSET>,
            GetCountOfTableDescriptors: GetCountOfTableDescriptors::<Identity, OFFSET>,
            GetTableDescriptorByIndex: GetTableDescriptorByIndex::<Identity, OFFSET>,
            GetTableDescriptorByTag: GetTableDescriptorByTag::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IATSC_STT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IATSC_STT {}
windows_core::imp::define_interface!(IATSC_VCT, IATSC_VCT_Vtbl, 0x26879a18_32f9_46c6_91f0_fb6479270e8c);
windows_core::imp::interface_hierarchy!(IATSC_VCT, windows_core::IUnknown);
impl IATSC_VCT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetVersionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTransportStreamId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTransportStreamId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetProtocolVersion(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProtocolVersion)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordName(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::PWSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordName)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordMajorChannelNumber(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordMajorChannelNumber)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordMinorChannelNumber(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordMinorChannelNumber)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordModulationMode(&self, dwrecordindex: u32) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordModulationMode)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCarrierFrequency(&self, dwrecordindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCarrierFrequency)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordTransportStreamId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordTransportStreamId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordProgramNumber(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordProgramNumber)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordEtmLocation(&self, dwrecordindex: u32) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordEtmLocation)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordIsAccessControlledBitSet(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordIsAccessControlledBitSet)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordIsHiddenBitSet(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordIsHiddenBitSet)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordIsPathSelectBitSet(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordIsPathSelectBitSet)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordIsOutOfBandBitSet(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordIsOutOfBandBitSet)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordIsHideGuideBitSet(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordIsHideGuideBitSet)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordServiceType(&self, dwrecordindex: u32) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordServiceType)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordSourceId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordSourceId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCountOfDescriptors)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordDescriptorByIndex)(windows_core::Interface::as_raw(self), dwrecordindex, dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordDescriptorByTag)(windows_core::Interface::as_raw(self), dwrecordindex, btag, pdwcookie as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn GetCountOfTableDescriptors(&self, pdwval: *const u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCountOfTableDescriptors)(windows_core::Interface::as_raw(self), pdwval).ok() }
    }
    pub unsafe fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTableDescriptorByIndex)(windows_core::Interface::as_raw(self), dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTableDescriptorByTag)(windows_core::Interface::as_raw(self), btag, pdwcookie as _, core::mem::transmute(ppdescriptor)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IATSC_VCT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetTransportStreamId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetProtocolVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRecordName: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetRecordMajorChannelNumber: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordMinorChannelNumber: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordModulationMode: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
    pub GetRecordCarrierFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRecordTransportStreamId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordProgramNumber: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordEtmLocation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
    pub GetRecordIsAccessControlledBitSet: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetRecordIsHiddenBitSet: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetRecordIsPathSelectBitSet: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetRecordIsOutOfBandBitSet: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetRecordIsHideGuideBitSet: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetRecordServiceType: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
    pub GetRecordSourceId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordCountOfDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRecordDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRecordDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCountOfTableDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, *const u32) -> windows_core::HRESULT,
    pub GetTableDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTableDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IATSC_VCT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetVersionNumber(&self) -> windows_core::Result<u8>;
    fn GetTransportStreamId(&self) -> windows_core::Result<u16>;
    fn GetProtocolVersion(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u32>;
    fn GetRecordName(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::PWSTR>;
    fn GetRecordMajorChannelNumber(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordMinorChannelNumber(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordModulationMode(&self, dwrecordindex: u32) -> windows_core::Result<u8>;
    fn GetRecordCarrierFrequency(&self, dwrecordindex: u32) -> windows_core::Result<u32>;
    fn GetRecordTransportStreamId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordProgramNumber(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordEtmLocation(&self, dwrecordindex: u32) -> windows_core::Result<u8>;
    fn GetRecordIsAccessControlledBitSet(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL>;
    fn GetRecordIsHiddenBitSet(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL>;
    fn GetRecordIsPathSelectBitSet(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL>;
    fn GetRecordIsOutOfBandBitSet(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL>;
    fn GetRecordIsHideGuideBitSet(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL>;
    fn GetRecordServiceType(&self, dwrecordindex: u32) -> windows_core::Result<u8>;
    fn GetRecordSourceId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32>;
    fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn GetCountOfTableDescriptors(&self, pdwval: *const u32) -> windows_core::Result<()>;
    fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
}
impl IATSC_VCT_Vtbl {
    pub const fn new<Identity: IATSC_VCT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_VCT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetVersionNumber<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetVersionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTransportStreamId<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetTransportStreamId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetProtocolVersion<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetProtocolVersion(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordName<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwsname: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordName(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwsname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordMajorChannelNumber<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordMajorChannelNumber(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordMinorChannelNumber<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordMinorChannelNumber(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordModulationMode<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordModulationMode(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCarrierFrequency<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordCarrierFrequency(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordTransportStreamId<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordTransportStreamId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordProgramNumber<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordProgramNumber(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordEtmLocation<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordEtmLocation(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordIsAccessControlledBitSet<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordIsAccessControlledBitSet(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordIsHiddenBitSet<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordIsHiddenBitSet(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordIsPathSelectBitSet<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordIsPathSelectBitSet(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordIsOutOfBandBitSet<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordIsOutOfBandBitSet(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordIsHideGuideBitSet<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordIsHideGuideBitSet(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordServiceType<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordServiceType(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordSourceId<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordSourceId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCountOfDescriptors<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordCountOfDescriptors(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByIndex<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetRecordDescriptorByIndex(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByTag<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_VCT_Impl::GetRecordDescriptorByTag(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn GetCountOfTableDescriptors<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *const u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_VCT_Impl::GetCountOfTableDescriptors(this, core::mem::transmute_copy(&pdwval)).into()
            }
        }
        unsafe extern "system" fn GetTableDescriptorByIndex<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IATSC_VCT_Impl::GetTableDescriptorByIndex(this, core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByTag<Identity: IATSC_VCT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IATSC_VCT_Impl::GetTableDescriptorByTag(this, core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetVersionNumber: GetVersionNumber::<Identity, OFFSET>,
            GetTransportStreamId: GetTransportStreamId::<Identity, OFFSET>,
            GetProtocolVersion: GetProtocolVersion::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordName: GetRecordName::<Identity, OFFSET>,
            GetRecordMajorChannelNumber: GetRecordMajorChannelNumber::<Identity, OFFSET>,
            GetRecordMinorChannelNumber: GetRecordMinorChannelNumber::<Identity, OFFSET>,
            GetRecordModulationMode: GetRecordModulationMode::<Identity, OFFSET>,
            GetRecordCarrierFrequency: GetRecordCarrierFrequency::<Identity, OFFSET>,
            GetRecordTransportStreamId: GetRecordTransportStreamId::<Identity, OFFSET>,
            GetRecordProgramNumber: GetRecordProgramNumber::<Identity, OFFSET>,
            GetRecordEtmLocation: GetRecordEtmLocation::<Identity, OFFSET>,
            GetRecordIsAccessControlledBitSet: GetRecordIsAccessControlledBitSet::<Identity, OFFSET>,
            GetRecordIsHiddenBitSet: GetRecordIsHiddenBitSet::<Identity, OFFSET>,
            GetRecordIsPathSelectBitSet: GetRecordIsPathSelectBitSet::<Identity, OFFSET>,
            GetRecordIsOutOfBandBitSet: GetRecordIsOutOfBandBitSet::<Identity, OFFSET>,
            GetRecordIsHideGuideBitSet: GetRecordIsHideGuideBitSet::<Identity, OFFSET>,
            GetRecordServiceType: GetRecordServiceType::<Identity, OFFSET>,
            GetRecordSourceId: GetRecordSourceId::<Identity, OFFSET>,
            GetRecordCountOfDescriptors: GetRecordCountOfDescriptors::<Identity, OFFSET>,
            GetRecordDescriptorByIndex: GetRecordDescriptorByIndex::<Identity, OFFSET>,
            GetRecordDescriptorByTag: GetRecordDescriptorByTag::<Identity, OFFSET>,
            GetCountOfTableDescriptors: GetCountOfTableDescriptors::<Identity, OFFSET>,
            GetTableDescriptorByIndex: GetTableDescriptorByIndex::<Identity, OFFSET>,
            GetTableDescriptorByTag: GetTableDescriptorByTag::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IATSC_VCT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IATSC_VCT {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAnalogAudioComponentType, IAnalogAudioComponentType_Vtbl, 0x2cfeb2a8_1787_4a24_a941_c6eaec39c842);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAnalogAudioComponentType {
    type Target = IComponentType;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAnalogAudioComponentType, windows_core::IUnknown, super::super::super::System::Com::IDispatch, IComponentType);
#[cfg(feature = "Win32_System_Com")]
impl IAnalogAudioComponentType {
    pub unsafe fn AnalogAudioMode(&self) -> windows_core::Result<super::TVAudioMode> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AnalogAudioMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetAnalogAudioMode(&self, mode: super::TVAudioMode) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAnalogAudioMode)(windows_core::Interface::as_raw(self), mode).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAnalogAudioComponentType_Vtbl {
    pub base__: IComponentType_Vtbl,
    pub AnalogAudioMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::TVAudioMode) -> windows_core::HRESULT,
    pub SetAnalogAudioMode: unsafe extern "system" fn(*mut core::ffi::c_void, super::TVAudioMode) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAnalogAudioComponentType_Impl: IComponentType_Impl {
    fn AnalogAudioMode(&self) -> windows_core::Result<super::TVAudioMode>;
    fn SetAnalogAudioMode(&self, mode: super::TVAudioMode) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAnalogAudioComponentType_Vtbl {
    pub const fn new<Identity: IAnalogAudioComponentType_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AnalogAudioMode<Identity: IAnalogAudioComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mode: *mut super::TVAudioMode) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAnalogAudioComponentType_Impl::AnalogAudioMode(this) {
                    Ok(ok__) => {
                        mode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetAnalogAudioMode<Identity: IAnalogAudioComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mode: super::TVAudioMode) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnalogAudioComponentType_Impl::SetAnalogAudioMode(this, core::mem::transmute_copy(&mode)).into()
            }
        }
        Self {
            base__: IComponentType_Vtbl::new::<Identity, OFFSET>(),
            AnalogAudioMode: AnalogAudioMode::<Identity, OFFSET>,
            SetAnalogAudioMode: SetAnalogAudioMode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAnalogAudioComponentType as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<IComponentType as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAnalogAudioComponentType {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAnalogLocator, IAnalogLocator_Vtbl, 0x34d1f26b_e339_430d_abce_738cb48984dc);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAnalogLocator {
    type Target = ILocator;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAnalogLocator, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ILocator);
#[cfg(feature = "Win32_System_Com")]
impl IAnalogLocator {
    pub unsafe fn VideoStandard(&self) -> windows_core::Result<super::AnalogVideoStandard> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).VideoStandard)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetVideoStandard(&self, avs: super::AnalogVideoStandard) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetVideoStandard)(windows_core::Interface::as_raw(self), avs).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAnalogLocator_Vtbl {
    pub base__: ILocator_Vtbl,
    pub VideoStandard: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::AnalogVideoStandard) -> windows_core::HRESULT,
    pub SetVideoStandard: unsafe extern "system" fn(*mut core::ffi::c_void, super::AnalogVideoStandard) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAnalogLocator_Impl: ILocator_Impl {
    fn VideoStandard(&self) -> windows_core::Result<super::AnalogVideoStandard>;
    fn SetVideoStandard(&self, avs: super::AnalogVideoStandard) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAnalogLocator_Vtbl {
    pub const fn new<Identity: IAnalogLocator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn VideoStandard<Identity: IAnalogLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, avs: *mut super::AnalogVideoStandard) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAnalogLocator_Impl::VideoStandard(this) {
                    Ok(ok__) => {
                        avs.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetVideoStandard<Identity: IAnalogLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, avs: super::AnalogVideoStandard) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnalogLocator_Impl::SetVideoStandard(this, core::mem::transmute_copy(&avs)).into()
            }
        }
        Self {
            base__: ILocator_Vtbl::new::<Identity, OFFSET>(),
            VideoStandard: VideoStandard::<Identity, OFFSET>,
            SetVideoStandard: SetVideoStandard::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAnalogLocator as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ILocator as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAnalogLocator {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAnalogRadioTuningSpace, IAnalogRadioTuningSpace_Vtbl, 0x2a6e293b_2595_11d3_b64c_00c04f79498e);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAnalogRadioTuningSpace {
    type Target = ITuningSpace;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAnalogRadioTuningSpace, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuningSpace);
#[cfg(feature = "Win32_System_Com")]
impl IAnalogRadioTuningSpace {
    pub unsafe fn MinFrequency(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MinFrequency)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMinFrequency(&self, newminfrequencyval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMinFrequency)(windows_core::Interface::as_raw(self), newminfrequencyval).ok() }
    }
    pub unsafe fn MaxFrequency(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MaxFrequency)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMaxFrequency(&self, newmaxfrequencyval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMaxFrequency)(windows_core::Interface::as_raw(self), newmaxfrequencyval).ok() }
    }
    pub unsafe fn Step(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Step)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetStep(&self, newstepval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetStep)(windows_core::Interface::as_raw(self), newstepval).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAnalogRadioTuningSpace_Vtbl {
    pub base__: ITuningSpace_Vtbl,
    pub MinFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMinFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub MaxFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMaxFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub Step: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetStep: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAnalogRadioTuningSpace_Impl: ITuningSpace_Impl {
    fn MinFrequency(&self) -> windows_core::Result<i32>;
    fn SetMinFrequency(&self, newminfrequencyval: i32) -> windows_core::Result<()>;
    fn MaxFrequency(&self) -> windows_core::Result<i32>;
    fn SetMaxFrequency(&self, newmaxfrequencyval: i32) -> windows_core::Result<()>;
    fn Step(&self) -> windows_core::Result<i32>;
    fn SetStep(&self, newstepval: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAnalogRadioTuningSpace_Vtbl {
    pub const fn new<Identity: IAnalogRadioTuningSpace_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn MinFrequency<Identity: IAnalogRadioTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, minfrequencyval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAnalogRadioTuningSpace_Impl::MinFrequency(this) {
                    Ok(ok__) => {
                        minfrequencyval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMinFrequency<Identity: IAnalogRadioTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newminfrequencyval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnalogRadioTuningSpace_Impl::SetMinFrequency(this, core::mem::transmute_copy(&newminfrequencyval)).into()
            }
        }
        unsafe extern "system" fn MaxFrequency<Identity: IAnalogRadioTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, maxfrequencyval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAnalogRadioTuningSpace_Impl::MaxFrequency(this) {
                    Ok(ok__) => {
                        maxfrequencyval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMaxFrequency<Identity: IAnalogRadioTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newmaxfrequencyval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnalogRadioTuningSpace_Impl::SetMaxFrequency(this, core::mem::transmute_copy(&newmaxfrequencyval)).into()
            }
        }
        unsafe extern "system" fn Step<Identity: IAnalogRadioTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, stepval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAnalogRadioTuningSpace_Impl::Step(this) {
                    Ok(ok__) => {
                        stepval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetStep<Identity: IAnalogRadioTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newstepval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnalogRadioTuningSpace_Impl::SetStep(this, core::mem::transmute_copy(&newstepval)).into()
            }
        }
        Self {
            base__: ITuningSpace_Vtbl::new::<Identity, OFFSET>(),
            MinFrequency: MinFrequency::<Identity, OFFSET>,
            SetMinFrequency: SetMinFrequency::<Identity, OFFSET>,
            MaxFrequency: MaxFrequency::<Identity, OFFSET>,
            SetMaxFrequency: SetMaxFrequency::<Identity, OFFSET>,
            Step: Step::<Identity, OFFSET>,
            SetStep: SetStep::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAnalogRadioTuningSpace as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuningSpace as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAnalogRadioTuningSpace {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAnalogRadioTuningSpace2, IAnalogRadioTuningSpace2_Vtbl, 0x39dd45da_2da8_46ba_8a8a_87e2b73d983a);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAnalogRadioTuningSpace2 {
    type Target = IAnalogRadioTuningSpace;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAnalogRadioTuningSpace2, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuningSpace, IAnalogRadioTuningSpace);
#[cfg(feature = "Win32_System_Com")]
impl IAnalogRadioTuningSpace2 {
    pub unsafe fn CountryCode(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CountryCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetCountryCode(&self, newcountrycodeval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCountryCode)(windows_core::Interface::as_raw(self), newcountrycodeval).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAnalogRadioTuningSpace2_Vtbl {
    pub base__: IAnalogRadioTuningSpace_Vtbl,
    pub CountryCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetCountryCode: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAnalogRadioTuningSpace2_Impl: IAnalogRadioTuningSpace_Impl {
    fn CountryCode(&self) -> windows_core::Result<i32>;
    fn SetCountryCode(&self, newcountrycodeval: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAnalogRadioTuningSpace2_Vtbl {
    pub const fn new<Identity: IAnalogRadioTuningSpace2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CountryCode<Identity: IAnalogRadioTuningSpace2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, countrycodeval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAnalogRadioTuningSpace2_Impl::CountryCode(this) {
                    Ok(ok__) => {
                        countrycodeval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetCountryCode<Identity: IAnalogRadioTuningSpace2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newcountrycodeval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnalogRadioTuningSpace2_Impl::SetCountryCode(this, core::mem::transmute_copy(&newcountrycodeval)).into()
            }
        }
        Self {
            base__: IAnalogRadioTuningSpace_Vtbl::new::<Identity, OFFSET>(),
            CountryCode: CountryCode::<Identity, OFFSET>,
            SetCountryCode: SetCountryCode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAnalogRadioTuningSpace2 as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuningSpace as windows_core::Interface>::IID || iid == &<IAnalogRadioTuningSpace as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAnalogRadioTuningSpace2 {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAnalogTVTuningSpace, IAnalogTVTuningSpace_Vtbl, 0x2a6e293c_2595_11d3_b64c_00c04f79498e);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAnalogTVTuningSpace {
    type Target = ITuningSpace;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAnalogTVTuningSpace, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuningSpace);
#[cfg(feature = "Win32_System_Com")]
impl IAnalogTVTuningSpace {
    pub unsafe fn MinChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MinChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMinChannel(&self, newminchannelval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMinChannel)(windows_core::Interface::as_raw(self), newminchannelval).ok() }
    }
    pub unsafe fn MaxChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MaxChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMaxChannel(&self, newmaxchannelval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMaxChannel)(windows_core::Interface::as_raw(self), newmaxchannelval).ok() }
    }
    pub unsafe fn InputType(&self) -> windows_core::Result<super::TunerInputType> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).InputType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetInputType(&self, newinputtypeval: super::TunerInputType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetInputType)(windows_core::Interface::as_raw(self), newinputtypeval).ok() }
    }
    pub unsafe fn CountryCode(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CountryCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetCountryCode(&self, newcountrycodeval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCountryCode)(windows_core::Interface::as_raw(self), newcountrycodeval).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAnalogTVTuningSpace_Vtbl {
    pub base__: ITuningSpace_Vtbl,
    pub MinChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMinChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub MaxChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMaxChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub InputType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::TunerInputType) -> windows_core::HRESULT,
    pub SetInputType: unsafe extern "system" fn(*mut core::ffi::c_void, super::TunerInputType) -> windows_core::HRESULT,
    pub CountryCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetCountryCode: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAnalogTVTuningSpace_Impl: ITuningSpace_Impl {
    fn MinChannel(&self) -> windows_core::Result<i32>;
    fn SetMinChannel(&self, newminchannelval: i32) -> windows_core::Result<()>;
    fn MaxChannel(&self) -> windows_core::Result<i32>;
    fn SetMaxChannel(&self, newmaxchannelval: i32) -> windows_core::Result<()>;
    fn InputType(&self) -> windows_core::Result<super::TunerInputType>;
    fn SetInputType(&self, newinputtypeval: super::TunerInputType) -> windows_core::Result<()>;
    fn CountryCode(&self) -> windows_core::Result<i32>;
    fn SetCountryCode(&self, newcountrycodeval: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAnalogTVTuningSpace_Vtbl {
    pub const fn new<Identity: IAnalogTVTuningSpace_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn MinChannel<Identity: IAnalogTVTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, minchannelval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAnalogTVTuningSpace_Impl::MinChannel(this) {
                    Ok(ok__) => {
                        minchannelval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMinChannel<Identity: IAnalogTVTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newminchannelval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnalogTVTuningSpace_Impl::SetMinChannel(this, core::mem::transmute_copy(&newminchannelval)).into()
            }
        }
        unsafe extern "system" fn MaxChannel<Identity: IAnalogTVTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, maxchannelval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAnalogTVTuningSpace_Impl::MaxChannel(this) {
                    Ok(ok__) => {
                        maxchannelval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMaxChannel<Identity: IAnalogTVTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newmaxchannelval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnalogTVTuningSpace_Impl::SetMaxChannel(this, core::mem::transmute_copy(&newmaxchannelval)).into()
            }
        }
        unsafe extern "system" fn InputType<Identity: IAnalogTVTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, inputtypeval: *mut super::TunerInputType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAnalogTVTuningSpace_Impl::InputType(this) {
                    Ok(ok__) => {
                        inputtypeval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetInputType<Identity: IAnalogTVTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newinputtypeval: super::TunerInputType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnalogTVTuningSpace_Impl::SetInputType(this, core::mem::transmute_copy(&newinputtypeval)).into()
            }
        }
        unsafe extern "system" fn CountryCode<Identity: IAnalogTVTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, countrycodeval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAnalogTVTuningSpace_Impl::CountryCode(this) {
                    Ok(ok__) => {
                        countrycodeval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetCountryCode<Identity: IAnalogTVTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newcountrycodeval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAnalogTVTuningSpace_Impl::SetCountryCode(this, core::mem::transmute_copy(&newcountrycodeval)).into()
            }
        }
        Self {
            base__: ITuningSpace_Vtbl::new::<Identity, OFFSET>(),
            MinChannel: MinChannel::<Identity, OFFSET>,
            SetMinChannel: SetMinChannel::<Identity, OFFSET>,
            MaxChannel: MaxChannel::<Identity, OFFSET>,
            SetMaxChannel: SetMaxChannel::<Identity, OFFSET>,
            InputType: InputType::<Identity, OFFSET>,
            SetInputType: SetInputType::<Identity, OFFSET>,
            CountryCode: CountryCode::<Identity, OFFSET>,
            SetCountryCode: SetCountryCode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAnalogTVTuningSpace as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuningSpace as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAnalogTVTuningSpace {}
windows_core::imp::define_interface!(IAtscContentAdvisoryDescriptor, IAtscContentAdvisoryDescriptor_Vtbl, 0xff76e60c_0283_43ea_ba32_b422238547ee);
windows_core::imp::interface_hierarchy!(IAtscContentAdvisoryDescriptor, windows_core::IUnknown);
impl IAtscContentAdvisoryDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRatingRegionCount(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRatingRegionCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordRatingRegion(&self, bindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordRatingRegion)(windows_core::Interface::as_raw(self), bindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordRatedDimensions(&self, bindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordRatedDimensions)(windows_core::Interface::as_raw(self), bindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordRatingDimension(&self, bindexouter: u8, bindexinner: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordRatingDimension)(windows_core::Interface::as_raw(self), bindexouter, bindexinner, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordRatingValue(&self, bindexouter: u8, bindexinner: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordRatingValue)(windows_core::Interface::as_raw(self), bindexouter, bindexinner, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordRatingDescriptionText(&self, bindex: u8, pblength: *mut u8, pptext: *mut *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordRatingDescriptionText)(windows_core::Interface::as_raw(self), bindex, pblength as _, pptext as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAtscContentAdvisoryDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRatingRegionCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordRatingRegion: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetRecordRatedDimensions: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetRecordRatingDimension: unsafe extern "system" fn(*mut core::ffi::c_void, u8, u8, *mut u8) -> windows_core::HRESULT,
    pub GetRecordRatingValue: unsafe extern "system" fn(*mut core::ffi::c_void, u8, u8, *mut u8) -> windows_core::HRESULT,
    pub GetRecordRatingDescriptionText: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8, *mut *mut u8) -> windows_core::HRESULT,
}
pub trait IAtscContentAdvisoryDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetRatingRegionCount(&self) -> windows_core::Result<u8>;
    fn GetRecordRatingRegion(&self, bindex: u8) -> windows_core::Result<u8>;
    fn GetRecordRatedDimensions(&self, bindex: u8) -> windows_core::Result<u8>;
    fn GetRecordRatingDimension(&self, bindexouter: u8, bindexinner: u8) -> windows_core::Result<u8>;
    fn GetRecordRatingValue(&self, bindexouter: u8, bindexinner: u8) -> windows_core::Result<u8>;
    fn GetRecordRatingDescriptionText(&self, bindex: u8, pblength: *mut u8, pptext: *mut *mut u8) -> windows_core::Result<()>;
}
impl IAtscContentAdvisoryDescriptor_Vtbl {
    pub const fn new<Identity: IAtscContentAdvisoryDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IAtscContentAdvisoryDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscContentAdvisoryDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IAtscContentAdvisoryDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscContentAdvisoryDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRatingRegionCount<Identity: IAtscContentAdvisoryDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscContentAdvisoryDescriptor_Impl::GetRatingRegionCount(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordRatingRegion<Identity: IAtscContentAdvisoryDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscContentAdvisoryDescriptor_Impl::GetRecordRatingRegion(this, core::mem::transmute_copy(&bindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordRatedDimensions<Identity: IAtscContentAdvisoryDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscContentAdvisoryDescriptor_Impl::GetRecordRatedDimensions(this, core::mem::transmute_copy(&bindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordRatingDimension<Identity: IAtscContentAdvisoryDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bindexouter: u8, bindexinner: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscContentAdvisoryDescriptor_Impl::GetRecordRatingDimension(this, core::mem::transmute_copy(&bindexouter), core::mem::transmute_copy(&bindexinner)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordRatingValue<Identity: IAtscContentAdvisoryDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bindexouter: u8, bindexinner: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscContentAdvisoryDescriptor_Impl::GetRecordRatingValue(this, core::mem::transmute_copy(&bindexouter), core::mem::transmute_copy(&bindexinner)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordRatingDescriptionText<Identity: IAtscContentAdvisoryDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bindex: u8, pblength: *mut u8, pptext: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAtscContentAdvisoryDescriptor_Impl::GetRecordRatingDescriptionText(this, core::mem::transmute_copy(&bindex), core::mem::transmute_copy(&pblength), core::mem::transmute_copy(&pptext)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetRatingRegionCount: GetRatingRegionCount::<Identity, OFFSET>,
            GetRecordRatingRegion: GetRecordRatingRegion::<Identity, OFFSET>,
            GetRecordRatedDimensions: GetRecordRatedDimensions::<Identity, OFFSET>,
            GetRecordRatingDimension: GetRecordRatingDimension::<Identity, OFFSET>,
            GetRecordRatingValue: GetRecordRatingValue::<Identity, OFFSET>,
            GetRecordRatingDescriptionText: GetRecordRatingDescriptionText::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAtscContentAdvisoryDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAtscContentAdvisoryDescriptor {}
windows_core::imp::define_interface!(IAtscPsipParser, IAtscPsipParser_Vtbl, 0xb2c98995_5eb2_4fb1_b406_f3e8e2026a9a);
windows_core::imp::interface_hierarchy!(IAtscPsipParser, windows_core::IUnknown);
impl IAtscPsipParser {
    pub unsafe fn Initialize<P0>(&self, punkmpeg2data: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), punkmpeg2data.param().abi()).ok() }
    }
    pub unsafe fn GetPAT(&self) -> windows_core::Result<IPAT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPAT)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetCAT(&self, dwtimeout: u32) -> windows_core::Result<ICAT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCAT)(windows_core::Interface::as_raw(self), dwtimeout, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetPMT(&self, pid: u16, pwprogramnumber: *const u16) -> windows_core::Result<IPMT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPMT)(windows_core::Interface::as_raw(self), pid, pwprogramnumber, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTSDT(&self) -> windows_core::Result<ITSDT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTSDT)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetMGT(&self) -> windows_core::Result<IATSC_MGT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMGT)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetVCT(&self, tableid: u8, fgetnexttable: bool) -> windows_core::Result<IATSC_VCT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVCT)(windows_core::Interface::as_raw(self), tableid, fgetnexttable.into(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetEIT(&self, pid: u16, pwsourceid: *const u16, dwtimeout: u32) -> windows_core::Result<IATSC_EIT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEIT)(windows_core::Interface::as_raw(self), pid, pwsourceid, dwtimeout, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetETT(&self, pid: u16, wsourceid: *const u16, pweventid: *const u16) -> windows_core::Result<IATSC_ETT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetETT)(windows_core::Interface::as_raw(self), pid, wsourceid, pweventid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetSTT(&self) -> windows_core::Result<IATSC_STT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSTT)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetEAS(&self, pid: u16) -> windows_core::Result<ISCTE_EAS> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEAS)(windows_core::Interface::as_raw(self), pid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAtscPsipParser_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetPAT: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCAT: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetPMT: unsafe extern "system" fn(*mut core::ffi::c_void, u16, *const u16, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTSDT: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetMGT: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVCT: unsafe extern "system" fn(*mut core::ffi::c_void, u8, windows_core::BOOL, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetEIT: unsafe extern "system" fn(*mut core::ffi::c_void, u16, *const u16, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetETT: unsafe extern "system" fn(*mut core::ffi::c_void, u16, *const u16, *const u16, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetSTT: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetEAS: unsafe extern "system" fn(*mut core::ffi::c_void, u16, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAtscPsipParser_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, punkmpeg2data: windows_core::Ref<'_, windows_core::IUnknown>) -> windows_core::Result<()>;
    fn GetPAT(&self) -> windows_core::Result<IPAT>;
    fn GetCAT(&self, dwtimeout: u32) -> windows_core::Result<ICAT>;
    fn GetPMT(&self, pid: u16, pwprogramnumber: *const u16) -> windows_core::Result<IPMT>;
    fn GetTSDT(&self) -> windows_core::Result<ITSDT>;
    fn GetMGT(&self) -> windows_core::Result<IATSC_MGT>;
    fn GetVCT(&self, tableid: u8, fgetnexttable: windows_core::BOOL) -> windows_core::Result<IATSC_VCT>;
    fn GetEIT(&self, pid: u16, pwsourceid: *const u16, dwtimeout: u32) -> windows_core::Result<IATSC_EIT>;
    fn GetETT(&self, pid: u16, wsourceid: *const u16, pweventid: *const u16) -> windows_core::Result<IATSC_ETT>;
    fn GetSTT(&self) -> windows_core::Result<IATSC_STT>;
    fn GetEAS(&self, pid: u16) -> windows_core::Result<ISCTE_EAS>;
}
impl IAtscPsipParser_Vtbl {
    pub const fn new<Identity: IAtscPsipParser_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, punkmpeg2data: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAtscPsipParser_Impl::Initialize(this, core::mem::transmute_copy(&punkmpeg2data)).into()
            }
        }
        unsafe extern "system" fn GetPAT<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pppat: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscPsipParser_Impl::GetPAT(this) {
                    Ok(ok__) => {
                        pppat.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCAT<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtimeout: u32, ppcat: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscPsipParser_Impl::GetCAT(this, core::mem::transmute_copy(&dwtimeout)) {
                    Ok(ok__) => {
                        ppcat.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPMT<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pid: u16, pwprogramnumber: *const u16, pppmt: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscPsipParser_Impl::GetPMT(this, core::mem::transmute_copy(&pid), core::mem::transmute_copy(&pwprogramnumber)) {
                    Ok(ok__) => {
                        pppmt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTSDT<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pptsdt: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscPsipParser_Impl::GetTSDT(this) {
                    Ok(ok__) => {
                        pptsdt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetMGT<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppmgt: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscPsipParser_Impl::GetMGT(this) {
                    Ok(ok__) => {
                        ppmgt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetVCT<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tableid: u8, fgetnexttable: windows_core::BOOL, ppvct: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscPsipParser_Impl::GetVCT(this, core::mem::transmute_copy(&tableid), core::mem::transmute_copy(&fgetnexttable)) {
                    Ok(ok__) => {
                        ppvct.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetEIT<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pid: u16, pwsourceid: *const u16, dwtimeout: u32, ppeit: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscPsipParser_Impl::GetEIT(this, core::mem::transmute_copy(&pid), core::mem::transmute_copy(&pwsourceid), core::mem::transmute_copy(&dwtimeout)) {
                    Ok(ok__) => {
                        ppeit.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetETT<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pid: u16, wsourceid: *const u16, pweventid: *const u16, ppett: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscPsipParser_Impl::GetETT(this, core::mem::transmute_copy(&pid), core::mem::transmute_copy(&wsourceid), core::mem::transmute_copy(&pweventid)) {
                    Ok(ok__) => {
                        ppett.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSTT<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppstt: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscPsipParser_Impl::GetSTT(this) {
                    Ok(ok__) => {
                        ppstt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetEAS<Identity: IAtscPsipParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pid: u16, ppeas: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAtscPsipParser_Impl::GetEAS(this, core::mem::transmute_copy(&pid)) {
                    Ok(ok__) => {
                        ppeas.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetPAT: GetPAT::<Identity, OFFSET>,
            GetCAT: GetCAT::<Identity, OFFSET>,
            GetPMT: GetPMT::<Identity, OFFSET>,
            GetTSDT: GetTSDT::<Identity, OFFSET>,
            GetMGT: GetMGT::<Identity, OFFSET>,
            GetVCT: GetVCT::<Identity, OFFSET>,
            GetEIT: GetEIT::<Identity, OFFSET>,
            GetETT: GetETT::<Identity, OFFSET>,
            GetSTT: GetSTT::<Identity, OFFSET>,
            GetEAS: GetEAS::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAtscPsipParser as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAtscPsipParser {}
windows_core::imp::define_interface!(IAttributeGet, IAttributeGet_Vtbl, 0x52dbd1ec_e48f_4528_9232_f442a68f0ae1);
windows_core::imp::interface_hierarchy!(IAttributeGet, windows_core::IUnknown);
impl IAttributeGet {
    pub unsafe fn GetCount(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetAttribIndexed(&self, lindex: i32, pguidattribute: *mut windows_core::GUID, pbattribute: *mut u8, pdwattributelength: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetAttribIndexed)(windows_core::Interface::as_raw(self), lindex, pguidattribute as _, pbattribute as _, pdwattributelength as _).ok() }
    }
    pub unsafe fn GetAttrib(&self, guidattribute: windows_core::GUID, pbattribute: *mut u8, pdwattributelength: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetAttrib)(windows_core::Interface::as_raw(self), core::mem::transmute(guidattribute), pbattribute as _, pdwattributelength as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAttributeGet_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetAttribIndexed: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut windows_core::GUID, *mut u8, *mut u32) -> windows_core::HRESULT,
    pub GetAttrib: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::GUID, *mut u8, *mut u32) -> windows_core::HRESULT,
}
pub trait IAttributeGet_Impl: windows_core::IUnknownImpl {
    fn GetCount(&self) -> windows_core::Result<i32>;
    fn GetAttribIndexed(&self, lindex: i32, pguidattribute: *mut windows_core::GUID, pbattribute: *mut u8, pdwattributelength: *mut u32) -> windows_core::Result<()>;
    fn GetAttrib(&self, guidattribute: &windows_core::GUID, pbattribute: *mut u8, pdwattributelength: *mut u32) -> windows_core::Result<()>;
}
impl IAttributeGet_Vtbl {
    pub const fn new<Identity: IAttributeGet_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetCount<Identity: IAttributeGet_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plcount: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAttributeGet_Impl::GetCount(this) {
                    Ok(ok__) => {
                        plcount.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetAttribIndexed<Identity: IAttributeGet_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lindex: i32, pguidattribute: *mut windows_core::GUID, pbattribute: *mut u8, pdwattributelength: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttributeGet_Impl::GetAttribIndexed(this, core::mem::transmute_copy(&lindex), core::mem::transmute_copy(&pguidattribute), core::mem::transmute_copy(&pbattribute), core::mem::transmute_copy(&pdwattributelength)).into()
            }
        }
        unsafe extern "system" fn GetAttrib<Identity: IAttributeGet_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guidattribute: windows_core::GUID, pbattribute: *mut u8, pdwattributelength: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttributeGet_Impl::GetAttrib(this, core::mem::transmute(&guidattribute), core::mem::transmute_copy(&pbattribute), core::mem::transmute_copy(&pdwattributelength)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetCount: GetCount::<Identity, OFFSET>,
            GetAttribIndexed: GetAttribIndexed::<Identity, OFFSET>,
            GetAttrib: GetAttrib::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAttributeGet as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAttributeGet {}
windows_core::imp::define_interface!(IAttributeSet, IAttributeSet_Vtbl, 0x583ec3cc_4960_4857_982b_41a33ea0a006);
windows_core::imp::interface_hierarchy!(IAttributeSet, windows_core::IUnknown);
impl IAttributeSet {
    pub unsafe fn SetAttrib(&self, guidattribute: windows_core::GUID, pbattribute: *const u8, dwattributelength: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAttrib)(windows_core::Interface::as_raw(self), core::mem::transmute(guidattribute), pbattribute, dwattributelength).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAttributeSet_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAttrib: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::GUID, *const u8, u32) -> windows_core::HRESULT,
}
pub trait IAttributeSet_Impl: windows_core::IUnknownImpl {
    fn SetAttrib(&self, guidattribute: &windows_core::GUID, pbattribute: *const u8, dwattributelength: u32) -> windows_core::Result<()>;
}
impl IAttributeSet_Vtbl {
    pub const fn new<Identity: IAttributeSet_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetAttrib<Identity: IAttributeSet_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guidattribute: windows_core::GUID, pbattribute: *const u8, dwattributelength: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttributeSet_Impl::SetAttrib(this, core::mem::transmute(&guidattribute), core::mem::transmute_copy(&pbattribute), core::mem::transmute_copy(&dwattributelength)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), SetAttrib: SetAttrib::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAttributeSet as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAttributeSet {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAuxInTuningSpace, IAuxInTuningSpace_Vtbl, 0xe48244b8_7e17_4f76_a763_5090ff1e2f30);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAuxInTuningSpace {
    type Target = ITuningSpace;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAuxInTuningSpace, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuningSpace);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAuxInTuningSpace_Vtbl {
    pub base__: ITuningSpace_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAuxInTuningSpace_Impl: ITuningSpace_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAuxInTuningSpace_Vtbl {
    pub const fn new<Identity: IAuxInTuningSpace_Impl, const OFFSET: isize>() -> Self {
        Self { base__: ITuningSpace_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAuxInTuningSpace as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuningSpace as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAuxInTuningSpace {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAuxInTuningSpace2, IAuxInTuningSpace2_Vtbl, 0xb10931ed_8bfe_4ab0_9dce_e469c29a9729);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAuxInTuningSpace2 {
    type Target = IAuxInTuningSpace;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAuxInTuningSpace2, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuningSpace, IAuxInTuningSpace);
#[cfg(feature = "Win32_System_Com")]
impl IAuxInTuningSpace2 {
    pub unsafe fn CountryCode(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CountryCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetCountryCode(&self, newcountrycodeval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCountryCode)(windows_core::Interface::as_raw(self), newcountrycodeval).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAuxInTuningSpace2_Vtbl {
    pub base__: IAuxInTuningSpace_Vtbl,
    pub CountryCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetCountryCode: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAuxInTuningSpace2_Impl: IAuxInTuningSpace_Impl {
    fn CountryCode(&self) -> windows_core::Result<i32>;
    fn SetCountryCode(&self, newcountrycodeval: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAuxInTuningSpace2_Vtbl {
    pub const fn new<Identity: IAuxInTuningSpace2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CountryCode<Identity: IAuxInTuningSpace2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, countrycodeval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAuxInTuningSpace2_Impl::CountryCode(this) {
                    Ok(ok__) => {
                        countrycodeval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetCountryCode<Identity: IAuxInTuningSpace2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newcountrycodeval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAuxInTuningSpace2_Impl::SetCountryCode(this, core::mem::transmute_copy(&newcountrycodeval)).into()
            }
        }
        Self {
            base__: IAuxInTuningSpace_Vtbl::new::<Identity, OFFSET>(),
            CountryCode: CountryCode::<Identity, OFFSET>,
            SetCountryCode: SetCountryCode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAuxInTuningSpace2 as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuningSpace as windows_core::Interface>::IID || iid == &<IAuxInTuningSpace as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAuxInTuningSpace2 {}
windows_core::imp::define_interface!(IBDAComparable, IBDAComparable_Vtbl, 0xb34505e0_2f0e_497b_80bc_d43f3b24ed7f);
windows_core::imp::interface_hierarchy!(IBDAComparable, windows_core::IUnknown);
impl IBDAComparable {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CompareExact<P0>(&self, compareto: P0) -> windows_core::Result<i32>
    where
        P0: windows_core::Param<super::super::super::System::Com::IDispatch>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CompareExact)(windows_core::Interface::as_raw(self), compareto.param().abi(), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CompareEquivalent<P0>(&self, compareto: P0, dwflags: u32) -> windows_core::Result<i32>
    where
        P0: windows_core::Param<super::super::super::System::Com::IDispatch>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CompareEquivalent)(windows_core::Interface::as_raw(self), compareto.param().abi(), dwflags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn HashExact(&self) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).HashExact)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn HashExactIncremental(&self, partialresult: i64) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).HashExactIncremental)(windows_core::Interface::as_raw(self), partialresult, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn HashEquivalent(&self, dwflags: u32) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).HashEquivalent)(windows_core::Interface::as_raw(self), dwflags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn HashEquivalentIncremental(&self, partialresult: i64, dwflags: u32) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).HashEquivalentIncremental)(windows_core::Interface::as_raw(self), partialresult, dwflags, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDAComparable_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CompareExact: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CompareExact: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CompareEquivalent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, *mut i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CompareEquivalent: usize,
    pub HashExact: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
    pub HashExactIncremental: unsafe extern "system" fn(*mut core::ffi::c_void, i64, *mut i64) -> windows_core::HRESULT,
    pub HashEquivalent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut i64) -> windows_core::HRESULT,
    pub HashEquivalentIncremental: unsafe extern "system" fn(*mut core::ffi::c_void, i64, u32, *mut i64) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IBDAComparable_Impl: windows_core::IUnknownImpl {
    fn CompareExact(&self, compareto: windows_core::Ref<'_, super::super::super::System::Com::IDispatch>) -> windows_core::Result<i32>;
    fn CompareEquivalent(&self, compareto: windows_core::Ref<'_, super::super::super::System::Com::IDispatch>, dwflags: u32) -> windows_core::Result<i32>;
    fn HashExact(&self) -> windows_core::Result<i64>;
    fn HashExactIncremental(&self, partialresult: i64) -> windows_core::Result<i64>;
    fn HashEquivalent(&self, dwflags: u32) -> windows_core::Result<i64>;
    fn HashEquivalentIncremental(&self, partialresult: i64, dwflags: u32) -> windows_core::Result<i64>;
}
#[cfg(feature = "Win32_System_Com")]
impl IBDAComparable_Vtbl {
    pub const fn new<Identity: IBDAComparable_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CompareExact<Identity: IBDAComparable_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, compareto: *mut core::ffi::c_void, result: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDAComparable_Impl::CompareExact(this, core::mem::transmute_copy(&compareto)) {
                    Ok(ok__) => {
                        result.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CompareEquivalent<Identity: IBDAComparable_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, compareto: *mut core::ffi::c_void, dwflags: u32, result: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDAComparable_Impl::CompareEquivalent(this, core::mem::transmute_copy(&compareto), core::mem::transmute_copy(&dwflags)) {
                    Ok(ok__) => {
                        result.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn HashExact<Identity: IBDAComparable_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, result: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDAComparable_Impl::HashExact(this) {
                    Ok(ok__) => {
                        result.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn HashExactIncremental<Identity: IBDAComparable_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, partialresult: i64, result: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDAComparable_Impl::HashExactIncremental(this, core::mem::transmute_copy(&partialresult)) {
                    Ok(ok__) => {
                        result.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn HashEquivalent<Identity: IBDAComparable_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwflags: u32, result: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDAComparable_Impl::HashEquivalent(this, core::mem::transmute_copy(&dwflags)) {
                    Ok(ok__) => {
                        result.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn HashEquivalentIncremental<Identity: IBDAComparable_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, partialresult: i64, dwflags: u32, result: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDAComparable_Impl::HashEquivalentIncremental(this, core::mem::transmute_copy(&partialresult), core::mem::transmute_copy(&dwflags)) {
                    Ok(ok__) => {
                        result.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            CompareExact: CompareExact::<Identity, OFFSET>,
            CompareEquivalent: CompareEquivalent::<Identity, OFFSET>,
            HashExact: HashExact::<Identity, OFFSET>,
            HashExactIncremental: HashExactIncremental::<Identity, OFFSET>,
            HashEquivalent: HashEquivalent::<Identity, OFFSET>,
            HashEquivalentIncremental: HashEquivalentIncremental::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDAComparable as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IBDAComparable {}
windows_core::imp::define_interface!(IBDACreateTuneRequestEx, IBDACreateTuneRequestEx_Vtbl, 0xc0a4a1d4_2b3c_491a_ba22_499fbadd4d12);
windows_core::imp::interface_hierarchy!(IBDACreateTuneRequestEx, windows_core::IUnknown);
impl IBDACreateTuneRequestEx {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateTuneRequestEx(&self, tunerequestiid: *const windows_core::GUID) -> windows_core::Result<ITuneRequest> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateTuneRequestEx)(windows_core::Interface::as_raw(self), tunerequestiid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDACreateTuneRequestEx_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateTuneRequestEx: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateTuneRequestEx: usize,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IBDACreateTuneRequestEx_Impl: windows_core::IUnknownImpl {
    fn CreateTuneRequestEx(&self, tunerequestiid: *const windows_core::GUID) -> windows_core::Result<ITuneRequest>;
}
#[cfg(feature = "Win32_System_Com")]
impl IBDACreateTuneRequestEx_Vtbl {
    pub const fn new<Identity: IBDACreateTuneRequestEx_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CreateTuneRequestEx<Identity: IBDACreateTuneRequestEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tunerequestiid: *const windows_core::GUID, tunerequest: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDACreateTuneRequestEx_Impl::CreateTuneRequestEx(this, core::mem::transmute_copy(&tunerequestiid)) {
                    Ok(ok__) => {
                        tunerequest.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), CreateTuneRequestEx: CreateTuneRequestEx::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDACreateTuneRequestEx as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IBDACreateTuneRequestEx {}
windows_core::imp::define_interface!(IBDA_TIF_REGISTRATION, IBDA_TIF_REGISTRATION_Vtbl, 0xdfef4a68_ee61_415f_9ccb_cd95f2f98a3a);
windows_core::imp::interface_hierarchy!(IBDA_TIF_REGISTRATION, windows_core::IUnknown);
impl IBDA_TIF_REGISTRATION {
    pub unsafe fn RegisterTIFEx<P0>(&self, ptifinputpin: P0, ppvregistrationcontext: *mut u32, ppmpeg2datacontrol: *mut Option<windows_core::IUnknown>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::IPin>,
    {
        unsafe { (windows_core::Interface::vtable(self).RegisterTIFEx)(windows_core::Interface::as_raw(self), ptifinputpin.param().abi(), ppvregistrationcontext as _, core::mem::transmute(ppmpeg2datacontrol)).ok() }
    }
    pub unsafe fn UnregisterTIF(&self, pvregistrationcontext: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UnregisterTIF)(windows_core::Interface::as_raw(self), pvregistrationcontext).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_TIF_REGISTRATION_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub RegisterTIFEx: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnregisterTIF: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
pub trait IBDA_TIF_REGISTRATION_Impl: windows_core::IUnknownImpl {
    fn RegisterTIFEx(&self, ptifinputpin: windows_core::Ref<'_, super::IPin>, ppvregistrationcontext: *mut u32, ppmpeg2datacontrol: windows_core::OutRef<'_, windows_core::IUnknown>) -> windows_core::Result<()>;
    fn UnregisterTIF(&self, pvregistrationcontext: u32) -> windows_core::Result<()>;
}
impl IBDA_TIF_REGISTRATION_Vtbl {
    pub const fn new<Identity: IBDA_TIF_REGISTRATION_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn RegisterTIFEx<Identity: IBDA_TIF_REGISTRATION_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptifinputpin: *mut core::ffi::c_void, ppvregistrationcontext: *mut u32, ppmpeg2datacontrol: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_TIF_REGISTRATION_Impl::RegisterTIFEx(this, core::mem::transmute_copy(&ptifinputpin), core::mem::transmute_copy(&ppvregistrationcontext), core::mem::transmute_copy(&ppmpeg2datacontrol)).into()
            }
        }
        unsafe extern "system" fn UnregisterTIF<Identity: IBDA_TIF_REGISTRATION_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvregistrationcontext: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_TIF_REGISTRATION_Impl::UnregisterTIF(this, core::mem::transmute_copy(&pvregistrationcontext)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            RegisterTIFEx: RegisterTIFEx::<Identity, OFFSET>,
            UnregisterTIF: UnregisterTIF::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_TIF_REGISTRATION as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_TIF_REGISTRATION {}
windows_core::imp::define_interface!(ICAT, ICAT_Vtbl, 0x7c6995fb_2a31_4bd7_953e_b1ad7fb7d31c);
windows_core::imp::interface_hierarchy!(ICAT, windows_core::IUnknown);
impl ICAT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetVersionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfTableDescriptors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTableDescriptorByIndex)(windows_core::Interface::as_raw(self), dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTableDescriptorByTag)(windows_core::Interface::as_raw(self), btag, pdwcookie as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForNextTable)(windows_core::Interface::as_raw(self), hnexttableavailable).ok() }
    }
    pub unsafe fn GetNextTable(&self, dwtimeout: u32) -> windows_core::Result<ICAT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNextTable)(windows_core::Interface::as_raw(self), dwtimeout, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForWhenCurrent)(windows_core::Interface::as_raw(self), hnexttableiscurrent).ok() }
    }
    pub unsafe fn ConvertNextToCurrent(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConvertNextToCurrent)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICAT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfTableDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTableDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTableDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub GetNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForWhenCurrent: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub ConvertNextToCurrent: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait ICAT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetVersionNumber(&self) -> windows_core::Result<u8>;
    fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32>;
    fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn GetNextTable(&self, dwtimeout: u32) -> windows_core::Result<ICAT>;
    fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn ConvertNextToCurrent(&self) -> windows_core::Result<()>;
}
impl ICAT_Vtbl {
    pub const fn new<Identity: ICAT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: ICAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICAT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetVersionNumber<Identity: ICAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICAT_Impl::GetVersionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfTableDescriptors<Identity: ICAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICAT_Impl::GetCountOfTableDescriptors(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByIndex<Identity: ICAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICAT_Impl::GetTableDescriptorByIndex(this, core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByTag<Identity: ICAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICAT_Impl::GetTableDescriptorByTag(this, core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn RegisterForNextTable<Identity: ICAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICAT_Impl::RegisterForNextTable(this, core::mem::transmute_copy(&hnexttableavailable)).into()
            }
        }
        unsafe extern "system" fn GetNextTable<Identity: ICAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtimeout: u32, ppcat: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICAT_Impl::GetNextTable(this, core::mem::transmute_copy(&dwtimeout)) {
                    Ok(ok__) => {
                        ppcat.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RegisterForWhenCurrent<Identity: ICAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICAT_Impl::RegisterForWhenCurrent(this, core::mem::transmute_copy(&hnexttableiscurrent)).into()
            }
        }
        unsafe extern "system" fn ConvertNextToCurrent<Identity: ICAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICAT_Impl::ConvertNextToCurrent(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetVersionNumber: GetVersionNumber::<Identity, OFFSET>,
            GetCountOfTableDescriptors: GetCountOfTableDescriptors::<Identity, OFFSET>,
            GetTableDescriptorByIndex: GetTableDescriptorByIndex::<Identity, OFFSET>,
            GetTableDescriptorByTag: GetTableDescriptorByTag::<Identity, OFFSET>,
            RegisterForNextTable: RegisterForNextTable::<Identity, OFFSET>,
            GetNextTable: GetNextTable::<Identity, OFFSET>,
            RegisterForWhenCurrent: RegisterForWhenCurrent::<Identity, OFFSET>,
            ConvertNextToCurrent: ConvertNextToCurrent::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICAT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for ICAT {}
windows_core::imp::define_interface!(ICaptionServiceDescriptor, ICaptionServiceDescriptor_Vtbl, 0x40834007_6834_46f0_bd45_d5f6a6be258c);
windows_core::imp::interface_hierarchy!(ICaptionServiceDescriptor, windows_core::IUnknown);
impl ICaptionServiceDescriptor {
    pub unsafe fn GetNumberOfServices(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberOfServices)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLanguageCode(&self, bindex: u8, langcode: &mut [u8; 3]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetLanguageCode)(windows_core::Interface::as_raw(self), bindex, core::mem::transmute(langcode.as_ptr())).ok() }
    }
    pub unsafe fn GetCaptionServiceNumber(&self, bindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCaptionServiceNumber)(windows_core::Interface::as_raw(self), bindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCCType(&self, bindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCCType)(windows_core::Interface::as_raw(self), bindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetEasyReader(&self, bindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEasyReader)(windows_core::Interface::as_raw(self), bindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetWideAspectRatio(&self, bindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetWideAspectRatio)(windows_core::Interface::as_raw(self), bindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICaptionServiceDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetNumberOfServices: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLanguageCode: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetCaptionServiceNumber: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetCCType: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetEasyReader: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetWideAspectRatio: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
}
pub trait ICaptionServiceDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetNumberOfServices(&self) -> windows_core::Result<u8>;
    fn GetLanguageCode(&self, bindex: u8, langcode: *mut u8) -> windows_core::Result<()>;
    fn GetCaptionServiceNumber(&self, bindex: u8) -> windows_core::Result<u8>;
    fn GetCCType(&self, bindex: u8) -> windows_core::Result<u8>;
    fn GetEasyReader(&self, bindex: u8) -> windows_core::Result<u8>;
    fn GetWideAspectRatio(&self, bindex: u8) -> windows_core::Result<u8>;
}
impl ICaptionServiceDescriptor_Vtbl {
    pub const fn new<Identity: ICaptionServiceDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetNumberOfServices<Identity: ICaptionServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICaptionServiceDescriptor_Impl::GetNumberOfServices(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLanguageCode<Identity: ICaptionServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bindex: u8, langcode: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICaptionServiceDescriptor_Impl::GetLanguageCode(this, core::mem::transmute_copy(&bindex), core::mem::transmute_copy(&langcode)).into()
            }
        }
        unsafe extern "system" fn GetCaptionServiceNumber<Identity: ICaptionServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICaptionServiceDescriptor_Impl::GetCaptionServiceNumber(this, core::mem::transmute_copy(&bindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCCType<Identity: ICaptionServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICaptionServiceDescriptor_Impl::GetCCType(this, core::mem::transmute_copy(&bindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetEasyReader<Identity: ICaptionServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICaptionServiceDescriptor_Impl::GetEasyReader(this, core::mem::transmute_copy(&bindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetWideAspectRatio<Identity: ICaptionServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICaptionServiceDescriptor_Impl::GetWideAspectRatio(this, core::mem::transmute_copy(&bindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetNumberOfServices: GetNumberOfServices::<Identity, OFFSET>,
            GetLanguageCode: GetLanguageCode::<Identity, OFFSET>,
            GetCaptionServiceNumber: GetCaptionServiceNumber::<Identity, OFFSET>,
            GetCCType: GetCCType::<Identity, OFFSET>,
            GetEasyReader: GetEasyReader::<Identity, OFFSET>,
            GetWideAspectRatio: GetWideAspectRatio::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICaptionServiceDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for ICaptionServiceDescriptor {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IChannelIDTuneRequest, IChannelIDTuneRequest_Vtbl, 0x156eff60_86f4_4e28_89fc_109799fd57ee);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IChannelIDTuneRequest {
    type Target = ITuneRequest;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IChannelIDTuneRequest, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuneRequest);
#[cfg(feature = "Win32_System_Com")]
impl IChannelIDTuneRequest {
    pub unsafe fn ChannelID(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ChannelID)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn SetChannelID(&self, channelid: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetChannelID)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(channelid)).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IChannelIDTuneRequest_Vtbl {
    pub base__: ITuneRequest_Vtbl,
    pub ChannelID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetChannelID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IChannelIDTuneRequest_Impl: ITuneRequest_Impl {
    fn ChannelID(&self) -> windows_core::Result<windows_core::BSTR>;
    fn SetChannelID(&self, channelid: &windows_core::BSTR) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IChannelIDTuneRequest_Vtbl {
    pub const fn new<Identity: IChannelIDTuneRequest_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ChannelID<Identity: IChannelIDTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, channelid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IChannelIDTuneRequest_Impl::ChannelID(this) {
                    Ok(ok__) => {
                        channelid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetChannelID<Identity: IChannelIDTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, channelid: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IChannelIDTuneRequest_Impl::SetChannelID(this, core::mem::transmute(&channelid)).into()
            }
        }
        Self { base__: ITuneRequest_Vtbl::new::<Identity, OFFSET>(), ChannelID: ChannelID::<Identity, OFFSET>, SetChannelID: SetChannelID::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IChannelIDTuneRequest as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuneRequest as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IChannelIDTuneRequest {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IChannelTuneRequest, IChannelTuneRequest_Vtbl, 0x0369b4e0_45b6_11d3_b650_00c04f79498e);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IChannelTuneRequest {
    type Target = ITuneRequest;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IChannelTuneRequest, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuneRequest);
#[cfg(feature = "Win32_System_Com")]
impl IChannelTuneRequest {
    pub unsafe fn Channel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Channel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetChannel(&self, channel: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetChannel)(windows_core::Interface::as_raw(self), channel).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IChannelTuneRequest_Vtbl {
    pub base__: ITuneRequest_Vtbl,
    pub Channel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IChannelTuneRequest_Impl: ITuneRequest_Impl {
    fn Channel(&self) -> windows_core::Result<i32>;
    fn SetChannel(&self, channel: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IChannelTuneRequest_Vtbl {
    pub const fn new<Identity: IChannelTuneRequest_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Channel<Identity: IChannelTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, channel: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IChannelTuneRequest_Impl::Channel(this) {
                    Ok(ok__) => {
                        channel.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetChannel<Identity: IChannelTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, channel: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IChannelTuneRequest_Impl::SetChannel(this, core::mem::transmute_copy(&channel)).into()
            }
        }
        Self { base__: ITuneRequest_Vtbl::new::<Identity, OFFSET>(), Channel: Channel::<Identity, OFFSET>, SetChannel: SetChannel::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IChannelTuneRequest as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuneRequest as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IChannelTuneRequest {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IComponent, IComponent_Vtbl, 0x1a5576fc_0e19_11d3_9d8e_00c04f72d980);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IComponent {
    type Target = super::super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IComponent, windows_core::IUnknown, super::super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IComponent {
    pub unsafe fn Type(&self) -> windows_core::Result<IComponentType> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Type)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetType<P0>(&self, ct: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IComponentType>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetType)(windows_core::Interface::as_raw(self), ct.param().abi()).ok() }
    }
    pub unsafe fn DescLangID(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).DescLangID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetDescLangID(&self, langid: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDescLangID)(windows_core::Interface::as_raw(self), langid).ok() }
    }
    pub unsafe fn Status(&self) -> windows_core::Result<super::ComponentStatus> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Status)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetStatus(&self, status: super::ComponentStatus) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetStatus)(windows_core::Interface::as_raw(self), status).ok() }
    }
    pub unsafe fn Description(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Description)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn SetDescription(&self, description: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDescription)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(description)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IComponent> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IComponent_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    pub Type: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DescLangID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetDescLangID: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub Status: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::ComponentStatus) -> windows_core::HRESULT,
    pub SetStatus: unsafe extern "system" fn(*mut core::ffi::c_void, super::ComponentStatus) -> windows_core::HRESULT,
    pub Description: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetDescription: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IComponent_Impl: super::super::super::System::Com::IDispatch_Impl {
    fn Type(&self) -> windows_core::Result<IComponentType>;
    fn SetType(&self, ct: windows_core::Ref<'_, IComponentType>) -> windows_core::Result<()>;
    fn DescLangID(&self) -> windows_core::Result<i32>;
    fn SetDescLangID(&self, langid: i32) -> windows_core::Result<()>;
    fn Status(&self) -> windows_core::Result<super::ComponentStatus>;
    fn SetStatus(&self, status: super::ComponentStatus) -> windows_core::Result<()>;
    fn Description(&self) -> windows_core::Result<windows_core::BSTR>;
    fn SetDescription(&self, description: &windows_core::BSTR) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IComponent>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IComponent_Vtbl {
    pub const fn new<Identity: IComponent_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Type<Identity: IComponent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ct: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponent_Impl::Type(this) {
                    Ok(ok__) => {
                        ct.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetType<Identity: IComponent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ct: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponent_Impl::SetType(this, core::mem::transmute_copy(&ct)).into()
            }
        }
        unsafe extern "system" fn DescLangID<Identity: IComponent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, langid: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponent_Impl::DescLangID(this) {
                    Ok(ok__) => {
                        langid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetDescLangID<Identity: IComponent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, langid: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponent_Impl::SetDescLangID(this, core::mem::transmute_copy(&langid)).into()
            }
        }
        unsafe extern "system" fn Status<Identity: IComponent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, status: *mut super::ComponentStatus) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponent_Impl::Status(this) {
                    Ok(ok__) => {
                        status.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetStatus<Identity: IComponent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, status: super::ComponentStatus) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponent_Impl::SetStatus(this, core::mem::transmute_copy(&status)).into()
            }
        }
        unsafe extern "system" fn Description<Identity: IComponent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, description: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponent_Impl::Description(this) {
                    Ok(ok__) => {
                        description.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetDescription<Identity: IComponent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, description: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponent_Impl::SetDescription(this, core::mem::transmute(&description)).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IComponent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newcomponent: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponent_Impl::Clone(this) {
                    Ok(ok__) => {
                        newcomponent.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Type: Type::<Identity, OFFSET>,
            SetType: SetType::<Identity, OFFSET>,
            DescLangID: DescLangID::<Identity, OFFSET>,
            SetDescLangID: SetDescLangID::<Identity, OFFSET>,
            Status: Status::<Identity, OFFSET>,
            SetStatus: SetStatus::<Identity, OFFSET>,
            Description: Description::<Identity, OFFSET>,
            SetDescription: SetDescription::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IComponent as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IComponent {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IComponentType, IComponentType_Vtbl, 0x6a340dc0_0311_11d3_9d8e_00c04f72d980);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IComponentType {
    type Target = super::super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IComponentType, windows_core::IUnknown, super::super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IComponentType {
    pub unsafe fn Category(&self) -> windows_core::Result<super::ComponentCategory> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Category)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetCategory(&self, category: super::ComponentCategory) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCategory)(windows_core::Interface::as_raw(self), category).ok() }
    }
    pub unsafe fn MediaMajorType(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MediaMajorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn SetMediaMajorType(&self, mediamajortype: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMediaMajorType)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(mediamajortype)).ok() }
    }
    pub unsafe fn _MediaMajorType(&self) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self)._MediaMajorType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Set_MediaMajorType(&self, mediamajortypeguid: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Set_MediaMajorType)(windows_core::Interface::as_raw(self), mediamajortypeguid).ok() }
    }
    pub unsafe fn MediaSubType(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MediaSubType)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn SetMediaSubType(&self, mediasubtype: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMediaSubType)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(mediasubtype)).ok() }
    }
    pub unsafe fn _MediaSubType(&self) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self)._MediaSubType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Set_MediaSubType(&self, mediasubtypeguid: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Set_MediaSubType)(windows_core::Interface::as_raw(self), mediasubtypeguid).ok() }
    }
    pub unsafe fn MediaFormatType(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MediaFormatType)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn SetMediaFormatType(&self, mediaformattype: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMediaFormatType)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(mediaformattype)).ok() }
    }
    pub unsafe fn _MediaFormatType(&self) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self)._MediaFormatType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Set_MediaFormatType(&self, mediaformattypeguid: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Set_MediaFormatType)(windows_core::Interface::as_raw(self), mediaformattypeguid).ok() }
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn MediaType(&self) -> windows_core::Result<super::super::MediaFoundation::AM_MEDIA_TYPE> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MediaType)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetMediaType(&self, mediatype: *const super::super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMediaType)(windows_core::Interface::as_raw(self), core::mem::transmute(mediatype)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IComponentType> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IComponentType_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    pub Category: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::ComponentCategory) -> windows_core::HRESULT,
    pub SetCategory: unsafe extern "system" fn(*mut core::ffi::c_void, super::ComponentCategory) -> windows_core::HRESULT,
    pub MediaMajorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetMediaMajorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _MediaMajorType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub Set_MediaMajorType: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub MediaSubType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetMediaSubType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _MediaSubType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub Set_MediaSubType: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub MediaFormatType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetMediaFormatType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _MediaFormatType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub Set_MediaFormatType: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub MediaType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    MediaType: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetMediaType: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetMediaType: usize,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IComponentType_Impl: super::super::super::System::Com::IDispatch_Impl {
    fn Category(&self) -> windows_core::Result<super::ComponentCategory>;
    fn SetCategory(&self, category: super::ComponentCategory) -> windows_core::Result<()>;
    fn MediaMajorType(&self) -> windows_core::Result<windows_core::BSTR>;
    fn SetMediaMajorType(&self, mediamajortype: &windows_core::BSTR) -> windows_core::Result<()>;
    fn _MediaMajorType(&self) -> windows_core::Result<windows_core::GUID>;
    fn Set_MediaMajorType(&self, mediamajortypeguid: *const windows_core::GUID) -> windows_core::Result<()>;
    fn MediaSubType(&self) -> windows_core::Result<windows_core::BSTR>;
    fn SetMediaSubType(&self, mediasubtype: &windows_core::BSTR) -> windows_core::Result<()>;
    fn _MediaSubType(&self) -> windows_core::Result<windows_core::GUID>;
    fn Set_MediaSubType(&self, mediasubtypeguid: *const windows_core::GUID) -> windows_core::Result<()>;
    fn MediaFormatType(&self) -> windows_core::Result<windows_core::BSTR>;
    fn SetMediaFormatType(&self, mediaformattype: &windows_core::BSTR) -> windows_core::Result<()>;
    fn _MediaFormatType(&self) -> windows_core::Result<windows_core::GUID>;
    fn Set_MediaFormatType(&self, mediaformattypeguid: *const windows_core::GUID) -> windows_core::Result<()>;
    fn MediaType(&self) -> windows_core::Result<super::super::MediaFoundation::AM_MEDIA_TYPE>;
    fn SetMediaType(&self, mediatype: *const super::super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IComponentType>;
}
#[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IComponentType_Vtbl {
    pub const fn new<Identity: IComponentType_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Category<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, category: *mut super::ComponentCategory) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentType_Impl::Category(this) {
                    Ok(ok__) => {
                        category.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetCategory<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, category: super::ComponentCategory) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentType_Impl::SetCategory(this, core::mem::transmute_copy(&category)).into()
            }
        }
        unsafe extern "system" fn MediaMajorType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediamajortype: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentType_Impl::MediaMajorType(this) {
                    Ok(ok__) => {
                        mediamajortype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMediaMajorType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediamajortype: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentType_Impl::SetMediaMajorType(this, core::mem::transmute(&mediamajortype)).into()
            }
        }
        unsafe extern "system" fn _MediaMajorType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediamajortypeguid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentType_Impl::_MediaMajorType(this) {
                    Ok(ok__) => {
                        mediamajortypeguid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Set_MediaMajorType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediamajortypeguid: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentType_Impl::Set_MediaMajorType(this, core::mem::transmute_copy(&mediamajortypeguid)).into()
            }
        }
        unsafe extern "system" fn MediaSubType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediasubtype: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentType_Impl::MediaSubType(this) {
                    Ok(ok__) => {
                        mediasubtype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMediaSubType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediasubtype: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentType_Impl::SetMediaSubType(this, core::mem::transmute(&mediasubtype)).into()
            }
        }
        unsafe extern "system" fn _MediaSubType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediasubtypeguid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentType_Impl::_MediaSubType(this) {
                    Ok(ok__) => {
                        mediasubtypeguid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Set_MediaSubType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediasubtypeguid: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentType_Impl::Set_MediaSubType(this, core::mem::transmute_copy(&mediasubtypeguid)).into()
            }
        }
        unsafe extern "system" fn MediaFormatType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediaformattype: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentType_Impl::MediaFormatType(this) {
                    Ok(ok__) => {
                        mediaformattype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMediaFormatType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediaformattype: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentType_Impl::SetMediaFormatType(this, core::mem::transmute(&mediaformattype)).into()
            }
        }
        unsafe extern "system" fn _MediaFormatType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediaformattypeguid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentType_Impl::_MediaFormatType(this) {
                    Ok(ok__) => {
                        mediaformattypeguid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Set_MediaFormatType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediaformattypeguid: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentType_Impl::Set_MediaFormatType(this, core::mem::transmute_copy(&mediaformattypeguid)).into()
            }
        }
        unsafe extern "system" fn MediaType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediatype: *mut super::super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentType_Impl::MediaType(this) {
                    Ok(ok__) => {
                        mediatype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMediaType<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mediatype: *const super::super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentType_Impl::SetMediaType(this, core::mem::transmute_copy(&mediatype)).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IComponentType_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newct: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentType_Impl::Clone(this) {
                    Ok(ok__) => {
                        newct.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Category: Category::<Identity, OFFSET>,
            SetCategory: SetCategory::<Identity, OFFSET>,
            MediaMajorType: MediaMajorType::<Identity, OFFSET>,
            SetMediaMajorType: SetMediaMajorType::<Identity, OFFSET>,
            _MediaMajorType: _MediaMajorType::<Identity, OFFSET>,
            Set_MediaMajorType: Set_MediaMajorType::<Identity, OFFSET>,
            MediaSubType: MediaSubType::<Identity, OFFSET>,
            SetMediaSubType: SetMediaSubType::<Identity, OFFSET>,
            _MediaSubType: _MediaSubType::<Identity, OFFSET>,
            Set_MediaSubType: Set_MediaSubType::<Identity, OFFSET>,
            MediaFormatType: MediaFormatType::<Identity, OFFSET>,
            SetMediaFormatType: SetMediaFormatType::<Identity, OFFSET>,
            _MediaFormatType: _MediaFormatType::<Identity, OFFSET>,
            Set_MediaFormatType: Set_MediaFormatType::<Identity, OFFSET>,
            MediaType: MediaType::<Identity, OFFSET>,
            SetMediaType: SetMediaType::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IComponentType as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IComponentType {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IComponentTypes, IComponentTypes_Vtbl, 0x0dc13d4a_0313_11d3_9d8e_00c04f72d980);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IComponentTypes {
    type Target = super::super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IComponentTypes, windows_core::IUnknown, super::super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IComponentTypes {
    pub unsafe fn Count(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn _NewEnum(&self) -> windows_core::Result<super::super::super::System::Ole::IEnumVARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self)._NewEnum)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn EnumComponentTypes(&self) -> windows_core::Result<IEnumComponentTypes> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumComponentTypes)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn get_Item(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<IComponentType> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).get_Item)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(index), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn put_Item<P1>(&self, index: &super::super::super::System::Variant::VARIANT, componenttype: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IComponentType>,
    {
        unsafe { (windows_core::Interface::vtable(self).put_Item)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(index), componenttype.param().abi()).ok() }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Add<P0>(&self, componenttype: P0) -> windows_core::Result<super::super::super::System::Variant::VARIANT>
    where
        P0: windows_core::Param<IComponentType>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Add)(windows_core::Interface::as_raw(self), componenttype.param().abi(), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Remove(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Remove)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(index)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IComponentTypes> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IComponentTypes_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub _NewEnum: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    _NewEnum: usize,
    pub EnumComponentTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub get_Item: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Variant::VARIANT, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    get_Item: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub put_Item: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Variant::VARIANT, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    put_Item: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub Add: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    Add: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub Remove: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    Remove: usize,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IComponentTypes_Impl: super::super::super::System::Com::IDispatch_Impl {
    fn Count(&self) -> windows_core::Result<i32>;
    fn _NewEnum(&self) -> windows_core::Result<super::super::super::System::Ole::IEnumVARIANT>;
    fn EnumComponentTypes(&self) -> windows_core::Result<IEnumComponentTypes>;
    fn get_Item(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<IComponentType>;
    fn put_Item(&self, index: &super::super::super::System::Variant::VARIANT, componenttype: windows_core::Ref<'_, IComponentType>) -> windows_core::Result<()>;
    fn Add(&self, componenttype: windows_core::Ref<'_, IComponentType>) -> windows_core::Result<super::super::super::System::Variant::VARIANT>;
    fn Remove(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IComponentTypes>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IComponentTypes_Vtbl {
    pub const fn new<Identity: IComponentTypes_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Count<Identity: IComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentTypes_Impl::Count(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn _NewEnum<Identity: IComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppnewenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentTypes_Impl::_NewEnum(this) {
                    Ok(ok__) => {
                        ppnewenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumComponentTypes<Identity: IComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppnewenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentTypes_Impl::EnumComponentTypes(this) {
                    Ok(ok__) => {
                        ppnewenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn get_Item<Identity: IComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: super::super::super::System::Variant::VARIANT, componenttype: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentTypes_Impl::get_Item(this, core::mem::transmute(&index)) {
                    Ok(ok__) => {
                        componenttype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn put_Item<Identity: IComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: super::super::super::System::Variant::VARIANT, componenttype: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentTypes_Impl::put_Item(this, core::mem::transmute(&index), core::mem::transmute_copy(&componenttype)).into()
            }
        }
        unsafe extern "system" fn Add<Identity: IComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, componenttype: *mut core::ffi::c_void, newindex: *mut super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentTypes_Impl::Add(this, core::mem::transmute_copy(&componenttype)) {
                    Ok(ok__) => {
                        newindex.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Remove<Identity: IComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentTypes_Impl::Remove(this, core::mem::transmute(&index)).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newlist: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentTypes_Impl::Clone(this) {
                    Ok(ok__) => {
                        newlist.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Count: Count::<Identity, OFFSET>,
            _NewEnum: _NewEnum::<Identity, OFFSET>,
            EnumComponentTypes: EnumComponentTypes::<Identity, OFFSET>,
            get_Item: get_Item::<Identity, OFFSET>,
            put_Item: put_Item::<Identity, OFFSET>,
            Add: Add::<Identity, OFFSET>,
            Remove: Remove::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IComponentTypes as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IComponentTypes {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IComponents, IComponents_Vtbl, 0x39a48091_fffe_4182_a161_3ff802640e26);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IComponents {
    type Target = super::super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IComponents, windows_core::IUnknown, super::super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IComponents {
    pub unsafe fn Count(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn _NewEnum(&self) -> windows_core::Result<super::super::super::System::Ole::IEnumVARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self)._NewEnum)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn EnumComponents(&self) -> windows_core::Result<IEnumComponents> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumComponents)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn get_Item(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<IComponent> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).get_Item)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(index), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Add<P0>(&self, component: P0) -> windows_core::Result<super::super::super::System::Variant::VARIANT>
    where
        P0: windows_core::Param<IComponent>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Add)(windows_core::Interface::as_raw(self), component.param().abi(), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Remove(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Remove)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(index)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IComponents> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn put_Item<P1>(&self, index: &super::super::super::System::Variant::VARIANT, ppcomponent: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IComponent>,
    {
        unsafe { (windows_core::Interface::vtable(self).put_Item)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(index), ppcomponent.param().abi()).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IComponents_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub _NewEnum: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    _NewEnum: usize,
    pub EnumComponents: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub get_Item: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Variant::VARIANT, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    get_Item: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub Add: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    Add: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub Remove: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    Remove: usize,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub put_Item: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Variant::VARIANT, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    put_Item: usize,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IComponents_Impl: super::super::super::System::Com::IDispatch_Impl {
    fn Count(&self) -> windows_core::Result<i32>;
    fn _NewEnum(&self) -> windows_core::Result<super::super::super::System::Ole::IEnumVARIANT>;
    fn EnumComponents(&self) -> windows_core::Result<IEnumComponents>;
    fn get_Item(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<IComponent>;
    fn Add(&self, component: windows_core::Ref<'_, IComponent>) -> windows_core::Result<super::super::super::System::Variant::VARIANT>;
    fn Remove(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IComponents>;
    fn put_Item(&self, index: &super::super::super::System::Variant::VARIANT, ppcomponent: windows_core::Ref<'_, IComponent>) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IComponents_Vtbl {
    pub const fn new<Identity: IComponents_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Count<Identity: IComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponents_Impl::Count(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn _NewEnum<Identity: IComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppnewenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponents_Impl::_NewEnum(this) {
                    Ok(ok__) => {
                        ppnewenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumComponents<Identity: IComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppnewenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponents_Impl::EnumComponents(this) {
                    Ok(ok__) => {
                        ppnewenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn get_Item<Identity: IComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: super::super::super::System::Variant::VARIANT, ppcomponent: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponents_Impl::get_Item(this, core::mem::transmute(&index)) {
                    Ok(ok__) => {
                        ppcomponent.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Add<Identity: IComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, component: *mut core::ffi::c_void, newindex: *mut super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponents_Impl::Add(this, core::mem::transmute_copy(&component)) {
                    Ok(ok__) => {
                        newindex.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Remove<Identity: IComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponents_Impl::Remove(this, core::mem::transmute(&index)).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newlist: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponents_Impl::Clone(this) {
                    Ok(ok__) => {
                        newlist.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn put_Item<Identity: IComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: super::super::super::System::Variant::VARIANT, ppcomponent: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponents_Impl::put_Item(this, core::mem::transmute(&index), core::mem::transmute_copy(&ppcomponent)).into()
            }
        }
        Self {
            base__: super::super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Count: Count::<Identity, OFFSET>,
            _NewEnum: _NewEnum::<Identity, OFFSET>,
            EnumComponents: EnumComponents::<Identity, OFFSET>,
            get_Item: get_Item::<Identity, OFFSET>,
            Add: Add::<Identity, OFFSET>,
            Remove: Remove::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
            put_Item: put_Item::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IComponents as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IComponents {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IComponentsOld, IComponentsOld_Vtbl, 0xfcd01846_0e19_11d3_9d8e_00c04f72d980);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IComponentsOld {
    type Target = super::super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IComponentsOld, windows_core::IUnknown, super::super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IComponentsOld {
    pub unsafe fn Count(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn _NewEnum(&self) -> windows_core::Result<super::super::super::System::Ole::IEnumVARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self)._NewEnum)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn EnumComponents(&self) -> windows_core::Result<IEnumComponents> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumComponents)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn get_Item(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<IComponent> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).get_Item)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(index), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Add<P0>(&self, component: P0) -> windows_core::Result<super::super::super::System::Variant::VARIANT>
    where
        P0: windows_core::Param<IComponent>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Add)(windows_core::Interface::as_raw(self), component.param().abi(), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Remove(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Remove)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(index)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IComponents> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IComponentsOld_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub _NewEnum: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    _NewEnum: usize,
    pub EnumComponents: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub get_Item: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Variant::VARIANT, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    get_Item: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub Add: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    Add: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub Remove: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    Remove: usize,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IComponentsOld_Impl: super::super::super::System::Com::IDispatch_Impl {
    fn Count(&self) -> windows_core::Result<i32>;
    fn _NewEnum(&self) -> windows_core::Result<super::super::super::System::Ole::IEnumVARIANT>;
    fn EnumComponents(&self) -> windows_core::Result<IEnumComponents>;
    fn get_Item(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<IComponent>;
    fn Add(&self, component: windows_core::Ref<'_, IComponent>) -> windows_core::Result<super::super::super::System::Variant::VARIANT>;
    fn Remove(&self, index: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IComponents>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IComponentsOld_Vtbl {
    pub const fn new<Identity: IComponentsOld_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Count<Identity: IComponentsOld_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentsOld_Impl::Count(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn _NewEnum<Identity: IComponentsOld_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppnewenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentsOld_Impl::_NewEnum(this) {
                    Ok(ok__) => {
                        ppnewenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumComponents<Identity: IComponentsOld_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppnewenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentsOld_Impl::EnumComponents(this) {
                    Ok(ok__) => {
                        ppnewenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn get_Item<Identity: IComponentsOld_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: super::super::super::System::Variant::VARIANT, ppcomponent: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentsOld_Impl::get_Item(this, core::mem::transmute(&index)) {
                    Ok(ok__) => {
                        ppcomponent.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Add<Identity: IComponentsOld_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, component: *mut core::ffi::c_void, newindex: *mut super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentsOld_Impl::Add(this, core::mem::transmute_copy(&component)) {
                    Ok(ok__) => {
                        newindex.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Remove<Identity: IComponentsOld_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: super::super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComponentsOld_Impl::Remove(this, core::mem::transmute(&index)).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IComponentsOld_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newlist: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComponentsOld_Impl::Clone(this) {
                    Ok(ok__) => {
                        newlist.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Count: Count::<Identity, OFFSET>,
            _NewEnum: _NewEnum::<Identity, OFFSET>,
            EnumComponents: EnumComponents::<Identity, OFFSET>,
            get_Item: get_Item::<Identity, OFFSET>,
            Add: Add::<Identity, OFFSET>,
            Remove: Remove::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IComponentsOld as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IComponentsOld {}
windows_core::imp::define_interface!(ICreatePropBagOnRegKey, ICreatePropBagOnRegKey_Vtbl, 0x8a674b48_1f63_11d3_b64c_00c04f79498e);
windows_core::imp::interface_hierarchy!(ICreatePropBagOnRegKey, windows_core::IUnknown);
impl ICreatePropBagOnRegKey {
    #[cfg(feature = "Win32_System_Registry")]
    pub unsafe fn Create<P1>(&self, hkey: super::super::super::System::Registry::HKEY, subkey: P1, uloptions: u32, samdesired: u32, iid: *const windows_core::GUID, ppbag: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).Create)(windows_core::Interface::as_raw(self), hkey, subkey.param().abi(), uloptions, samdesired, iid, ppbag as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreatePropBagOnRegKey_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Registry")]
    pub Create: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Registry::HKEY, windows_core::PCWSTR, u32, u32, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Registry"))]
    Create: usize,
}
#[cfg(feature = "Win32_System_Registry")]
pub trait ICreatePropBagOnRegKey_Impl: windows_core::IUnknownImpl {
    fn Create(&self, hkey: super::super::super::System::Registry::HKEY, subkey: &windows_core::PCWSTR, uloptions: u32, samdesired: u32, iid: *const windows_core::GUID, ppbag: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_System_Registry")]
impl ICreatePropBagOnRegKey_Vtbl {
    pub const fn new<Identity: ICreatePropBagOnRegKey_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Create<Identity: ICreatePropBagOnRegKey_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hkey: super::super::super::System::Registry::HKEY, subkey: windows_core::PCWSTR, uloptions: u32, samdesired: u32, iid: *const windows_core::GUID, ppbag: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICreatePropBagOnRegKey_Impl::Create(this, core::mem::transmute_copy(&hkey), core::mem::transmute(&subkey), core::mem::transmute_copy(&uloptions), core::mem::transmute_copy(&samdesired), core::mem::transmute_copy(&iid), core::mem::transmute_copy(&ppbag)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Create: Create::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICreatePropBagOnRegKey as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Registry")]
impl windows_core::RuntimeName for ICreatePropBagOnRegKey {}
windows_core::imp::define_interface!(IDTFilter, IDTFilter_Vtbl, 0xc4c4c4b2_0049_4e2b_98fb_9537f6ce516d);
windows_core::imp::interface_hierarchy!(IDTFilter, windows_core::IUnknown);
impl IDTFilter {
    pub unsafe fn EvalRatObjOK(&self) -> windows_core::Result<windows_core::HRESULT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EvalRatObjOK)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCurrRating(&self, pensystem: *mut EnTvRat_System, penrating: *mut EnTvRat_GenericLevel, plbfenattr: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCurrRating)(windows_core::Interface::as_raw(self), pensystem as _, penrating as _, plbfenattr as _).ok() }
    }
    pub unsafe fn get_BlockedRatingAttributes(&self, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).get_BlockedRatingAttributes)(windows_core::Interface::as_raw(self), ensystem, enlevel, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn put_BlockedRatingAttributes(&self, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel, lbfattrs: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).put_BlockedRatingAttributes)(windows_core::Interface::as_raw(self), ensystem, enlevel, lbfattrs).ok() }
    }
    pub unsafe fn BlockUnRated(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).BlockUnRated)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetBlockUnRated(&self, fblockunratedshows: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBlockUnRated)(windows_core::Interface::as_raw(self), fblockunratedshows.into()).ok() }
    }
    pub unsafe fn BlockUnRatedDelay(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).BlockUnRatedDelay)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetBlockUnRatedDelay(&self, msecsdelaybeforeblock: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBlockUnRatedDelay)(windows_core::Interface::as_raw(self), msecsdelaybeforeblock).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDTFilter_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub EvalRatObjOK: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::HRESULT) -> windows_core::HRESULT,
    pub GetCurrRating: unsafe extern "system" fn(*mut core::ffi::c_void, *mut EnTvRat_System, *mut EnTvRat_GenericLevel, *mut i32) -> windows_core::HRESULT,
    pub get_BlockedRatingAttributes: unsafe extern "system" fn(*mut core::ffi::c_void, EnTvRat_System, EnTvRat_GenericLevel, *mut i32) -> windows_core::HRESULT,
    pub put_BlockedRatingAttributes: unsafe extern "system" fn(*mut core::ffi::c_void, EnTvRat_System, EnTvRat_GenericLevel, i32) -> windows_core::HRESULT,
    pub BlockUnRated: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetBlockUnRated: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub BlockUnRatedDelay: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetBlockUnRatedDelay: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
pub trait IDTFilter_Impl: windows_core::IUnknownImpl {
    fn EvalRatObjOK(&self) -> windows_core::Result<windows_core::HRESULT>;
    fn GetCurrRating(&self, pensystem: *mut EnTvRat_System, penrating: *mut EnTvRat_GenericLevel, plbfenattr: *mut i32) -> windows_core::Result<()>;
    fn get_BlockedRatingAttributes(&self, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel) -> windows_core::Result<i32>;
    fn put_BlockedRatingAttributes(&self, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel, lbfattrs: i32) -> windows_core::Result<()>;
    fn BlockUnRated(&self) -> windows_core::Result<windows_core::BOOL>;
    fn SetBlockUnRated(&self, fblockunratedshows: windows_core::BOOL) -> windows_core::Result<()>;
    fn BlockUnRatedDelay(&self) -> windows_core::Result<i32>;
    fn SetBlockUnRatedDelay(&self, msecsdelaybeforeblock: i32) -> windows_core::Result<()>;
}
impl IDTFilter_Vtbl {
    pub const fn new<Identity: IDTFilter_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn EvalRatObjOK<Identity: IDTFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, phrcocreateretval: *mut windows_core::HRESULT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDTFilter_Impl::EvalRatObjOK(this) {
                    Ok(ok__) => {
                        phrcocreateretval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCurrRating<Identity: IDTFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pensystem: *mut EnTvRat_System, penrating: *mut EnTvRat_GenericLevel, plbfenattr: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDTFilter_Impl::GetCurrRating(this, core::mem::transmute_copy(&pensystem), core::mem::transmute_copy(&penrating), core::mem::transmute_copy(&plbfenattr)).into()
            }
        }
        unsafe extern "system" fn get_BlockedRatingAttributes<Identity: IDTFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel, plbfenattr: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDTFilter_Impl::get_BlockedRatingAttributes(this, core::mem::transmute_copy(&ensystem), core::mem::transmute_copy(&enlevel)) {
                    Ok(ok__) => {
                        plbfenattr.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn put_BlockedRatingAttributes<Identity: IDTFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel, lbfattrs: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDTFilter_Impl::put_BlockedRatingAttributes(this, core::mem::transmute_copy(&ensystem), core::mem::transmute_copy(&enlevel), core::mem::transmute_copy(&lbfattrs)).into()
            }
        }
        unsafe extern "system" fn BlockUnRated<Identity: IDTFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfblockunratedshows: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDTFilter_Impl::BlockUnRated(this) {
                    Ok(ok__) => {
                        pfblockunratedshows.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetBlockUnRated<Identity: IDTFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fblockunratedshows: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDTFilter_Impl::SetBlockUnRated(this, core::mem::transmute_copy(&fblockunratedshows)).into()
            }
        }
        unsafe extern "system" fn BlockUnRatedDelay<Identity: IDTFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmsecsdelaybeforeblock: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDTFilter_Impl::BlockUnRatedDelay(this) {
                    Ok(ok__) => {
                        pmsecsdelaybeforeblock.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetBlockUnRatedDelay<Identity: IDTFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, msecsdelaybeforeblock: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDTFilter_Impl::SetBlockUnRatedDelay(this, core::mem::transmute_copy(&msecsdelaybeforeblock)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            EvalRatObjOK: EvalRatObjOK::<Identity, OFFSET>,
            GetCurrRating: GetCurrRating::<Identity, OFFSET>,
            get_BlockedRatingAttributes: get_BlockedRatingAttributes::<Identity, OFFSET>,
            put_BlockedRatingAttributes: put_BlockedRatingAttributes::<Identity, OFFSET>,
            BlockUnRated: BlockUnRated::<Identity, OFFSET>,
            SetBlockUnRated: SetBlockUnRated::<Identity, OFFSET>,
            BlockUnRatedDelay: BlockUnRatedDelay::<Identity, OFFSET>,
            SetBlockUnRatedDelay: SetBlockUnRatedDelay::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDTFilter as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDTFilter {}
windows_core::imp::define_interface!(IDTFilter2, IDTFilter2_Vtbl, 0xc4c4c4b4_0049_4e2b_98fb_9537f6ce516d);
impl core::ops::Deref for IDTFilter2 {
    type Target = IDTFilter;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDTFilter2, windows_core::IUnknown, IDTFilter);
impl IDTFilter2 {
    pub unsafe fn ChallengeUrl(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ChallengeUrl)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetCurrLicenseExpDate(&self, prottype: *const ProtType) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCurrLicenseExpDate)(windows_core::Interface::as_raw(self), prottype, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLastErrorCode(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetLastErrorCode)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDTFilter2_Vtbl {
    pub base__: IDTFilter_Vtbl,
    pub ChallengeUrl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCurrLicenseExpDate: unsafe extern "system" fn(*mut core::ffi::c_void, *const ProtType, *mut i32) -> windows_core::HRESULT,
    pub GetLastErrorCode: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDTFilter2_Impl: IDTFilter_Impl {
    fn ChallengeUrl(&self) -> windows_core::Result<windows_core::BSTR>;
    fn GetCurrLicenseExpDate(&self, prottype: *const ProtType) -> windows_core::Result<i32>;
    fn GetLastErrorCode(&self) -> windows_core::Result<()>;
}
impl IDTFilter2_Vtbl {
    pub const fn new<Identity: IDTFilter2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ChallengeUrl<Identity: IDTFilter2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrchallengeurl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDTFilter2_Impl::ChallengeUrl(this) {
                    Ok(ok__) => {
                        pbstrchallengeurl.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCurrLicenseExpDate<Identity: IDTFilter2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prottype: *const ProtType, lpdatetime: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDTFilter2_Impl::GetCurrLicenseExpDate(this, core::mem::transmute_copy(&prottype)) {
                    Ok(ok__) => {
                        lpdatetime.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLastErrorCode<Identity: IDTFilter2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDTFilter2_Impl::GetLastErrorCode(this).into()
            }
        }
        Self {
            base__: IDTFilter_Vtbl::new::<Identity, OFFSET>(),
            ChallengeUrl: ChallengeUrl::<Identity, OFFSET>,
            GetCurrLicenseExpDate: GetCurrLicenseExpDate::<Identity, OFFSET>,
            GetLastErrorCode: GetLastErrorCode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDTFilter2 as windows_core::Interface>::IID || iid == &<IDTFilter as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDTFilter2 {}
windows_core::imp::define_interface!(IDTFilter3, IDTFilter3_Vtbl, 0x513998cc_e929_4cdf_9fbd_bad1e0314866);
impl core::ops::Deref for IDTFilter3 {
    type Target = IDTFilter2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDTFilter3, windows_core::IUnknown, IDTFilter, IDTFilter2);
impl IDTFilter3 {
    pub unsafe fn GetProtectionType(&self) -> windows_core::Result<ProtType> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProtectionType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn LicenseHasExpirationDate(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).LicenseHasExpirationDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetRights(&self, bstrrights: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetRights)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(bstrrights)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDTFilter3_Vtbl {
    pub base__: IDTFilter2_Vtbl,
    pub GetProtectionType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut ProtType) -> windows_core::HRESULT,
    pub LicenseHasExpirationDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetRights: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDTFilter3_Impl: IDTFilter2_Impl {
    fn GetProtectionType(&self) -> windows_core::Result<ProtType>;
    fn LicenseHasExpirationDate(&self) -> windows_core::Result<windows_core::BOOL>;
    fn SetRights(&self, bstrrights: &windows_core::BSTR) -> windows_core::Result<()>;
}
impl IDTFilter3_Vtbl {
    pub const fn new<Identity: IDTFilter3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetProtectionType<Identity: IDTFilter3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pprotectiontype: *mut ProtType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDTFilter3_Impl::GetProtectionType(this) {
                    Ok(ok__) => {
                        pprotectiontype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn LicenseHasExpirationDate<Identity: IDTFilter3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pflicensehasexpirationdate: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDTFilter3_Impl::LicenseHasExpirationDate(this) {
                    Ok(ok__) => {
                        pflicensehasexpirationdate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetRights<Identity: IDTFilter3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bstrrights: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDTFilter3_Impl::SetRights(this, core::mem::transmute(&bstrrights)).into()
            }
        }
        Self {
            base__: IDTFilter2_Vtbl::new::<Identity, OFFSET>(),
            GetProtectionType: GetProtectionType::<Identity, OFFSET>,
            LicenseHasExpirationDate: LicenseHasExpirationDate::<Identity, OFFSET>,
            SetRights: SetRights::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDTFilter3 as windows_core::Interface>::IID || iid == &<IDTFilter as windows_core::Interface>::IID || iid == &<IDTFilter2 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDTFilter3 {}
windows_core::imp::define_interface!(IDTFilterConfig, IDTFilterConfig_Vtbl, 0xc4c4c4d2_0049_4e2b_98fb_9537f6ce516d);
windows_core::imp::interface_hierarchy!(IDTFilterConfig, windows_core::IUnknown);
impl IDTFilterConfig {
    pub unsafe fn GetSecureChannelObject(&self) -> windows_core::Result<windows_core::IUnknown> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSecureChannelObject)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDTFilterConfig_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetSecureChannelObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDTFilterConfig_Impl: windows_core::IUnknownImpl {
    fn GetSecureChannelObject(&self) -> windows_core::Result<windows_core::IUnknown>;
}
impl IDTFilterConfig_Vtbl {
    pub const fn new<Identity: IDTFilterConfig_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetSecureChannelObject<Identity: IDTFilterConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppunkdrmsecurechannel: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDTFilterConfig_Impl::GetSecureChannelObject(this) {
                    Ok(ok__) => {
                        ppunkdrmsecurechannel.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetSecureChannelObject: GetSecureChannelObject::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDTFilterConfig as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDTFilterConfig {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDTFilterEvents, IDTFilterEvents_Vtbl, 0xc4c4c4c2_0049_4e2b_98fb_9537f6ce516d);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDTFilterEvents {
    type Target = super::super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDTFilterEvents, windows_core::IUnknown, super::super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDTFilterEvents_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDTFilterEvents_Impl: super::super::super::System::Com::IDispatch_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDTFilterEvents_Vtbl {
    pub const fn new<Identity: IDTFilterEvents_Impl, const OFFSET: isize>() -> Self {
        Self { base__: super::super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDTFilterEvents as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDTFilterEvents {}
windows_core::imp::define_interface!(IDTFilterLicenseRenewal, IDTFilterLicenseRenewal_Vtbl, 0x8a78b317_e405_4a43_994a_620d8f5ce25e);
windows_core::imp::interface_hierarchy!(IDTFilterLicenseRenewal, windows_core::IUnknown);
impl IDTFilterLicenseRenewal {
    pub unsafe fn GetLicenseRenewalData(&self, ppwszfilename: *mut windows_core::PWSTR, ppwszexpiredkid: *mut windows_core::PWSTR, ppwsztunerid: *mut windows_core::PWSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetLicenseRenewalData)(windows_core::Interface::as_raw(self), ppwszfilename as _, ppwszexpiredkid as _, ppwsztunerid as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDTFilterLicenseRenewal_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetLicenseRenewalData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR, *mut windows_core::PWSTR, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
pub trait IDTFilterLicenseRenewal_Impl: windows_core::IUnknownImpl {
    fn GetLicenseRenewalData(&self, ppwszfilename: *mut windows_core::PWSTR, ppwszexpiredkid: *mut windows_core::PWSTR, ppwsztunerid: *mut windows_core::PWSTR) -> windows_core::Result<()>;
}
impl IDTFilterLicenseRenewal_Vtbl {
    pub const fn new<Identity: IDTFilterLicenseRenewal_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetLicenseRenewalData<Identity: IDTFilterLicenseRenewal_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppwszfilename: *mut windows_core::PWSTR, ppwszexpiredkid: *mut windows_core::PWSTR, ppwsztunerid: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDTFilterLicenseRenewal_Impl::GetLicenseRenewalData(this, core::mem::transmute_copy(&ppwszfilename), core::mem::transmute_copy(&ppwszexpiredkid), core::mem::transmute_copy(&ppwsztunerid)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetLicenseRenewalData: GetLicenseRenewalData::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDTFilterLicenseRenewal as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDTFilterLicenseRenewal {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDVBCLocator, IDVBCLocator_Vtbl, 0x6e42f36e_1dd2_43c4_9f78_69d25ae39034);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDVBCLocator {
    type Target = IDigitalLocator;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDVBCLocator, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ILocator, IDigitalLocator);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDVBCLocator_Vtbl {
    pub base__: IDigitalLocator_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDVBCLocator_Impl: IDigitalLocator_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDVBCLocator_Vtbl {
    pub const fn new<Identity: IDVBCLocator_Impl, const OFFSET: isize>() -> Self {
        Self { base__: IDigitalLocator_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVBCLocator as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ILocator as windows_core::Interface>::IID || iid == &<IDigitalLocator as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDVBCLocator {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDVBSLocator, IDVBSLocator_Vtbl, 0x3d7c353c_0d04_45f1_a742_f97cc1188dc8);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDVBSLocator {
    type Target = IDigitalLocator;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDVBSLocator, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ILocator, IDigitalLocator);
#[cfg(feature = "Win32_System_Com")]
impl IDVBSLocator {
    pub unsafe fn SignalPolarisation(&self) -> windows_core::Result<super::Polarisation> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SignalPolarisation)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetSignalPolarisation(&self, polarisationval: super::Polarisation) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSignalPolarisation)(windows_core::Interface::as_raw(self), polarisationval).ok() }
    }
    pub unsafe fn WestPosition(&self) -> windows_core::Result<super::super::super::Foundation::VARIANT_BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).WestPosition)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetWestPosition(&self, westlongitude: super::super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetWestPosition)(windows_core::Interface::as_raw(self), westlongitude).ok() }
    }
    pub unsafe fn OrbitalPosition(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).OrbitalPosition)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOrbitalPosition(&self, longitude: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOrbitalPosition)(windows_core::Interface::as_raw(self), longitude).ok() }
    }
    pub unsafe fn Azimuth(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Azimuth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetAzimuth(&self, azimuth: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAzimuth)(windows_core::Interface::as_raw(self), azimuth).ok() }
    }
    pub unsafe fn Elevation(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Elevation)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetElevation(&self, elevation: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetElevation)(windows_core::Interface::as_raw(self), elevation).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDVBSLocator_Vtbl {
    pub base__: IDigitalLocator_Vtbl,
    pub SignalPolarisation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::Polarisation) -> windows_core::HRESULT,
    pub SetSignalPolarisation: unsafe extern "system" fn(*mut core::ffi::c_void, super::Polarisation) -> windows_core::HRESULT,
    pub WestPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetWestPosition: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub OrbitalPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetOrbitalPosition: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub Azimuth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetAzimuth: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub Elevation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetElevation: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDVBSLocator_Impl: IDigitalLocator_Impl {
    fn SignalPolarisation(&self) -> windows_core::Result<super::Polarisation>;
    fn SetSignalPolarisation(&self, polarisationval: super::Polarisation) -> windows_core::Result<()>;
    fn WestPosition(&self) -> windows_core::Result<super::super::super::Foundation::VARIANT_BOOL>;
    fn SetWestPosition(&self, westlongitude: super::super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn OrbitalPosition(&self) -> windows_core::Result<i32>;
    fn SetOrbitalPosition(&self, longitude: i32) -> windows_core::Result<()>;
    fn Azimuth(&self) -> windows_core::Result<i32>;
    fn SetAzimuth(&self, azimuth: i32) -> windows_core::Result<()>;
    fn Elevation(&self) -> windows_core::Result<i32>;
    fn SetElevation(&self, elevation: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDVBSLocator_Vtbl {
    pub const fn new<Identity: IDVBSLocator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SignalPolarisation<Identity: IDVBSLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, polarisationval: *mut super::Polarisation) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator_Impl::SignalPolarisation(this) {
                    Ok(ok__) => {
                        polarisationval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetSignalPolarisation<Identity: IDVBSLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, polarisationval: super::Polarisation) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator_Impl::SetSignalPolarisation(this, core::mem::transmute_copy(&polarisationval)).into()
            }
        }
        unsafe extern "system" fn WestPosition<Identity: IDVBSLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, westlongitude: *mut super::super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator_Impl::WestPosition(this) {
                    Ok(ok__) => {
                        westlongitude.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetWestPosition<Identity: IDVBSLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, westlongitude: super::super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator_Impl::SetWestPosition(this, core::mem::transmute_copy(&westlongitude)).into()
            }
        }
        unsafe extern "system" fn OrbitalPosition<Identity: IDVBSLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, longitude: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator_Impl::OrbitalPosition(this) {
                    Ok(ok__) => {
                        longitude.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOrbitalPosition<Identity: IDVBSLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, longitude: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator_Impl::SetOrbitalPosition(this, core::mem::transmute_copy(&longitude)).into()
            }
        }
        unsafe extern "system" fn Azimuth<Identity: IDVBSLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, azimuth: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator_Impl::Azimuth(this) {
                    Ok(ok__) => {
                        azimuth.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetAzimuth<Identity: IDVBSLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, azimuth: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator_Impl::SetAzimuth(this, core::mem::transmute_copy(&azimuth)).into()
            }
        }
        unsafe extern "system" fn Elevation<Identity: IDVBSLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, elevation: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator_Impl::Elevation(this) {
                    Ok(ok__) => {
                        elevation.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetElevation<Identity: IDVBSLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, elevation: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator_Impl::SetElevation(this, core::mem::transmute_copy(&elevation)).into()
            }
        }
        Self {
            base__: IDigitalLocator_Vtbl::new::<Identity, OFFSET>(),
            SignalPolarisation: SignalPolarisation::<Identity, OFFSET>,
            SetSignalPolarisation: SetSignalPolarisation::<Identity, OFFSET>,
            WestPosition: WestPosition::<Identity, OFFSET>,
            SetWestPosition: SetWestPosition::<Identity, OFFSET>,
            OrbitalPosition: OrbitalPosition::<Identity, OFFSET>,
            SetOrbitalPosition: SetOrbitalPosition::<Identity, OFFSET>,
            Azimuth: Azimuth::<Identity, OFFSET>,
            SetAzimuth: SetAzimuth::<Identity, OFFSET>,
            Elevation: Elevation::<Identity, OFFSET>,
            SetElevation: SetElevation::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVBSLocator as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ILocator as windows_core::Interface>::IID || iid == &<IDigitalLocator as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDVBSLocator {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDVBSLocator2, IDVBSLocator2_Vtbl, 0x6044634a_1733_4f99_b982_5fb12afce4f0);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDVBSLocator2 {
    type Target = IDVBSLocator;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDVBSLocator2, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ILocator, IDigitalLocator, IDVBSLocator);
#[cfg(feature = "Win32_System_Com")]
impl IDVBSLocator2 {
    pub unsafe fn DiseqLNBSource(&self) -> windows_core::Result<super::LNB_Source> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).DiseqLNBSource)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetDiseqLNBSource(&self, diseqlnbsourceval: super::LNB_Source) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDiseqLNBSource)(windows_core::Interface::as_raw(self), diseqlnbsourceval).ok() }
    }
    pub unsafe fn LocalOscillatorOverrideLow(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).LocalOscillatorOverrideLow)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetLocalOscillatorOverrideLow(&self, localoscillatoroverridelowval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLocalOscillatorOverrideLow)(windows_core::Interface::as_raw(self), localoscillatoroverridelowval).ok() }
    }
    pub unsafe fn LocalOscillatorOverrideHigh(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).LocalOscillatorOverrideHigh)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetLocalOscillatorOverrideHigh(&self, localoscillatoroverridehighval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLocalOscillatorOverrideHigh)(windows_core::Interface::as_raw(self), localoscillatoroverridehighval).ok() }
    }
    pub unsafe fn LocalLNBSwitchOverride(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).LocalLNBSwitchOverride)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetLocalLNBSwitchOverride(&self, locallnbswitchoverrideval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLocalLNBSwitchOverride)(windows_core::Interface::as_raw(self), locallnbswitchoverrideval).ok() }
    }
    pub unsafe fn LocalSpectralInversionOverride(&self) -> windows_core::Result<super::SpectralInversion> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).LocalSpectralInversionOverride)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetLocalSpectralInversionOverride(&self, localspectralinversionoverrideval: super::SpectralInversion) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLocalSpectralInversionOverride)(windows_core::Interface::as_raw(self), localspectralinversionoverrideval).ok() }
    }
    pub unsafe fn SignalRollOff(&self) -> windows_core::Result<super::RollOff> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SignalRollOff)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetSignalRollOff(&self, rolloffval: super::RollOff) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSignalRollOff)(windows_core::Interface::as_raw(self), rolloffval).ok() }
    }
    pub unsafe fn SignalPilot(&self) -> windows_core::Result<super::Pilot> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SignalPilot)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetSignalPilot(&self, pilotval: super::Pilot) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSignalPilot)(windows_core::Interface::as_raw(self), pilotval).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDVBSLocator2_Vtbl {
    pub base__: IDVBSLocator_Vtbl,
    pub DiseqLNBSource: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::LNB_Source) -> windows_core::HRESULT,
    pub SetDiseqLNBSource: unsafe extern "system" fn(*mut core::ffi::c_void, super::LNB_Source) -> windows_core::HRESULT,
    pub LocalOscillatorOverrideLow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetLocalOscillatorOverrideLow: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub LocalOscillatorOverrideHigh: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetLocalOscillatorOverrideHigh: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub LocalLNBSwitchOverride: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetLocalLNBSwitchOverride: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub LocalSpectralInversionOverride: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::SpectralInversion) -> windows_core::HRESULT,
    pub SetLocalSpectralInversionOverride: unsafe extern "system" fn(*mut core::ffi::c_void, super::SpectralInversion) -> windows_core::HRESULT,
    pub SignalRollOff: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::RollOff) -> windows_core::HRESULT,
    pub SetSignalRollOff: unsafe extern "system" fn(*mut core::ffi::c_void, super::RollOff) -> windows_core::HRESULT,
    pub SignalPilot: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::Pilot) -> windows_core::HRESULT,
    pub SetSignalPilot: unsafe extern "system" fn(*mut core::ffi::c_void, super::Pilot) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDVBSLocator2_Impl: IDVBSLocator_Impl {
    fn DiseqLNBSource(&self) -> windows_core::Result<super::LNB_Source>;
    fn SetDiseqLNBSource(&self, diseqlnbsourceval: super::LNB_Source) -> windows_core::Result<()>;
    fn LocalOscillatorOverrideLow(&self) -> windows_core::Result<i32>;
    fn SetLocalOscillatorOverrideLow(&self, localoscillatoroverridelowval: i32) -> windows_core::Result<()>;
    fn LocalOscillatorOverrideHigh(&self) -> windows_core::Result<i32>;
    fn SetLocalOscillatorOverrideHigh(&self, localoscillatoroverridehighval: i32) -> windows_core::Result<()>;
    fn LocalLNBSwitchOverride(&self) -> windows_core::Result<i32>;
    fn SetLocalLNBSwitchOverride(&self, locallnbswitchoverrideval: i32) -> windows_core::Result<()>;
    fn LocalSpectralInversionOverride(&self) -> windows_core::Result<super::SpectralInversion>;
    fn SetLocalSpectralInversionOverride(&self, localspectralinversionoverrideval: super::SpectralInversion) -> windows_core::Result<()>;
    fn SignalRollOff(&self) -> windows_core::Result<super::RollOff>;
    fn SetSignalRollOff(&self, rolloffval: super::RollOff) -> windows_core::Result<()>;
    fn SignalPilot(&self) -> windows_core::Result<super::Pilot>;
    fn SetSignalPilot(&self, pilotval: super::Pilot) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDVBSLocator2_Vtbl {
    pub const fn new<Identity: IDVBSLocator2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn DiseqLNBSource<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, diseqlnbsourceval: *mut super::LNB_Source) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator2_Impl::DiseqLNBSource(this) {
                    Ok(ok__) => {
                        diseqlnbsourceval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetDiseqLNBSource<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, diseqlnbsourceval: super::LNB_Source) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator2_Impl::SetDiseqLNBSource(this, core::mem::transmute_copy(&diseqlnbsourceval)).into()
            }
        }
        unsafe extern "system" fn LocalOscillatorOverrideLow<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, localoscillatoroverridelowval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator2_Impl::LocalOscillatorOverrideLow(this) {
                    Ok(ok__) => {
                        localoscillatoroverridelowval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetLocalOscillatorOverrideLow<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, localoscillatoroverridelowval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator2_Impl::SetLocalOscillatorOverrideLow(this, core::mem::transmute_copy(&localoscillatoroverridelowval)).into()
            }
        }
        unsafe extern "system" fn LocalOscillatorOverrideHigh<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, localoscillatoroverridehighval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator2_Impl::LocalOscillatorOverrideHigh(this) {
                    Ok(ok__) => {
                        localoscillatoroverridehighval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetLocalOscillatorOverrideHigh<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, localoscillatoroverridehighval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator2_Impl::SetLocalOscillatorOverrideHigh(this, core::mem::transmute_copy(&localoscillatoroverridehighval)).into()
            }
        }
        unsafe extern "system" fn LocalLNBSwitchOverride<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, locallnbswitchoverrideval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator2_Impl::LocalLNBSwitchOverride(this) {
                    Ok(ok__) => {
                        locallnbswitchoverrideval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetLocalLNBSwitchOverride<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, locallnbswitchoverrideval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator2_Impl::SetLocalLNBSwitchOverride(this, core::mem::transmute_copy(&locallnbswitchoverrideval)).into()
            }
        }
        unsafe extern "system" fn LocalSpectralInversionOverride<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, localspectralinversionoverrideval: *mut super::SpectralInversion) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator2_Impl::LocalSpectralInversionOverride(this) {
                    Ok(ok__) => {
                        localspectralinversionoverrideval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetLocalSpectralInversionOverride<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, localspectralinversionoverrideval: super::SpectralInversion) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator2_Impl::SetLocalSpectralInversionOverride(this, core::mem::transmute_copy(&localspectralinversionoverrideval)).into()
            }
        }
        unsafe extern "system" fn SignalRollOff<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rolloffval: *mut super::RollOff) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator2_Impl::SignalRollOff(this) {
                    Ok(ok__) => {
                        rolloffval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetSignalRollOff<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rolloffval: super::RollOff) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator2_Impl::SetSignalRollOff(this, core::mem::transmute_copy(&rolloffval)).into()
            }
        }
        unsafe extern "system" fn SignalPilot<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pilotval: *mut super::Pilot) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSLocator2_Impl::SignalPilot(this) {
                    Ok(ok__) => {
                        pilotval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetSignalPilot<Identity: IDVBSLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pilotval: super::Pilot) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSLocator2_Impl::SetSignalPilot(this, core::mem::transmute_copy(&pilotval)).into()
            }
        }
        Self {
            base__: IDVBSLocator_Vtbl::new::<Identity, OFFSET>(),
            DiseqLNBSource: DiseqLNBSource::<Identity, OFFSET>,
            SetDiseqLNBSource: SetDiseqLNBSource::<Identity, OFFSET>,
            LocalOscillatorOverrideLow: LocalOscillatorOverrideLow::<Identity, OFFSET>,
            SetLocalOscillatorOverrideLow: SetLocalOscillatorOverrideLow::<Identity, OFFSET>,
            LocalOscillatorOverrideHigh: LocalOscillatorOverrideHigh::<Identity, OFFSET>,
            SetLocalOscillatorOverrideHigh: SetLocalOscillatorOverrideHigh::<Identity, OFFSET>,
            LocalLNBSwitchOverride: LocalLNBSwitchOverride::<Identity, OFFSET>,
            SetLocalLNBSwitchOverride: SetLocalLNBSwitchOverride::<Identity, OFFSET>,
            LocalSpectralInversionOverride: LocalSpectralInversionOverride::<Identity, OFFSET>,
            SetLocalSpectralInversionOverride: SetLocalSpectralInversionOverride::<Identity, OFFSET>,
            SignalRollOff: SignalRollOff::<Identity, OFFSET>,
            SetSignalRollOff: SetSignalRollOff::<Identity, OFFSET>,
            SignalPilot: SignalPilot::<Identity, OFFSET>,
            SetSignalPilot: SetSignalPilot::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVBSLocator2 as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ILocator as windows_core::Interface>::IID || iid == &<IDigitalLocator as windows_core::Interface>::IID || iid == &<IDVBSLocator as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDVBSLocator2 {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDVBSTuningSpace, IDVBSTuningSpace_Vtbl, 0xcdf7be60_d954_42fd_a972_78971958e470);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDVBSTuningSpace {
    type Target = IDVBTuningSpace2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDVBSTuningSpace, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuningSpace, IDVBTuningSpace, IDVBTuningSpace2);
#[cfg(feature = "Win32_System_Com")]
impl IDVBSTuningSpace {
    pub unsafe fn LowOscillator(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).LowOscillator)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetLowOscillator(&self, lowoscillator: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLowOscillator)(windows_core::Interface::as_raw(self), lowoscillator).ok() }
    }
    pub unsafe fn HighOscillator(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).HighOscillator)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetHighOscillator(&self, highoscillator: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetHighOscillator)(windows_core::Interface::as_raw(self), highoscillator).ok() }
    }
    pub unsafe fn LNBSwitch(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).LNBSwitch)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetLNBSwitch(&self, lnbswitch: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLNBSwitch)(windows_core::Interface::as_raw(self), lnbswitch).ok() }
    }
    pub unsafe fn InputRange(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).InputRange)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn SetInputRange(&self, inputrange: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetInputRange)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(inputrange)).ok() }
    }
    pub unsafe fn SpectralInversion(&self) -> windows_core::Result<super::SpectralInversion> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SpectralInversion)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetSpectralInversion(&self, spectralinversionval: super::SpectralInversion) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSpectralInversion)(windows_core::Interface::as_raw(self), spectralinversionval).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDVBSTuningSpace_Vtbl {
    pub base__: IDVBTuningSpace2_Vtbl,
    pub LowOscillator: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetLowOscillator: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub HighOscillator: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetHighOscillator: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub LNBSwitch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetLNBSwitch: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub InputRange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputRange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SpectralInversion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::SpectralInversion) -> windows_core::HRESULT,
    pub SetSpectralInversion: unsafe extern "system" fn(*mut core::ffi::c_void, super::SpectralInversion) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDVBSTuningSpace_Impl: IDVBTuningSpace2_Impl {
    fn LowOscillator(&self) -> windows_core::Result<i32>;
    fn SetLowOscillator(&self, lowoscillator: i32) -> windows_core::Result<()>;
    fn HighOscillator(&self) -> windows_core::Result<i32>;
    fn SetHighOscillator(&self, highoscillator: i32) -> windows_core::Result<()>;
    fn LNBSwitch(&self) -> windows_core::Result<i32>;
    fn SetLNBSwitch(&self, lnbswitch: i32) -> windows_core::Result<()>;
    fn InputRange(&self) -> windows_core::Result<windows_core::BSTR>;
    fn SetInputRange(&self, inputrange: &windows_core::BSTR) -> windows_core::Result<()>;
    fn SpectralInversion(&self) -> windows_core::Result<super::SpectralInversion>;
    fn SetSpectralInversion(&self, spectralinversionval: super::SpectralInversion) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDVBSTuningSpace_Vtbl {
    pub const fn new<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn LowOscillator<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lowoscillator: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSTuningSpace_Impl::LowOscillator(this) {
                    Ok(ok__) => {
                        lowoscillator.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetLowOscillator<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lowoscillator: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSTuningSpace_Impl::SetLowOscillator(this, core::mem::transmute_copy(&lowoscillator)).into()
            }
        }
        unsafe extern "system" fn HighOscillator<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, highoscillator: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSTuningSpace_Impl::HighOscillator(this) {
                    Ok(ok__) => {
                        highoscillator.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetHighOscillator<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, highoscillator: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSTuningSpace_Impl::SetHighOscillator(this, core::mem::transmute_copy(&highoscillator)).into()
            }
        }
        unsafe extern "system" fn LNBSwitch<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lnbswitch: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSTuningSpace_Impl::LNBSwitch(this) {
                    Ok(ok__) => {
                        lnbswitch.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetLNBSwitch<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lnbswitch: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSTuningSpace_Impl::SetLNBSwitch(this, core::mem::transmute_copy(&lnbswitch)).into()
            }
        }
        unsafe extern "system" fn InputRange<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, inputrange: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSTuningSpace_Impl::InputRange(this) {
                    Ok(ok__) => {
                        inputrange.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetInputRange<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, inputrange: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSTuningSpace_Impl::SetInputRange(this, core::mem::transmute(&inputrange)).into()
            }
        }
        unsafe extern "system" fn SpectralInversion<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, spectralinversionval: *mut super::SpectralInversion) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBSTuningSpace_Impl::SpectralInversion(this) {
                    Ok(ok__) => {
                        spectralinversionval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetSpectralInversion<Identity: IDVBSTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, spectralinversionval: super::SpectralInversion) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBSTuningSpace_Impl::SetSpectralInversion(this, core::mem::transmute_copy(&spectralinversionval)).into()
            }
        }
        Self {
            base__: IDVBTuningSpace2_Vtbl::new::<Identity, OFFSET>(),
            LowOscillator: LowOscillator::<Identity, OFFSET>,
            SetLowOscillator: SetLowOscillator::<Identity, OFFSET>,
            HighOscillator: HighOscillator::<Identity, OFFSET>,
            SetHighOscillator: SetHighOscillator::<Identity, OFFSET>,
            LNBSwitch: LNBSwitch::<Identity, OFFSET>,
            SetLNBSwitch: SetLNBSwitch::<Identity, OFFSET>,
            InputRange: InputRange::<Identity, OFFSET>,
            SetInputRange: SetInputRange::<Identity, OFFSET>,
            SpectralInversion: SpectralInversion::<Identity, OFFSET>,
            SetSpectralInversion: SetSpectralInversion::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVBSTuningSpace as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuningSpace as windows_core::Interface>::IID || iid == &<IDVBTuningSpace as windows_core::Interface>::IID || iid == &<IDVBTuningSpace2 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDVBSTuningSpace {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDVBTLocator, IDVBTLocator_Vtbl, 0x8664da16_dda2_42ac_926a_c18f9127c302);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDVBTLocator {
    type Target = IDigitalLocator;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDVBTLocator, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ILocator, IDigitalLocator);
#[cfg(feature = "Win32_System_Com")]
impl IDVBTLocator {
    pub unsafe fn Bandwidth(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Bandwidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetBandwidth(&self, bandwidthval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBandwidth)(windows_core::Interface::as_raw(self), bandwidthval).ok() }
    }
    pub unsafe fn LPInnerFEC(&self) -> windows_core::Result<super::FECMethod> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).LPInnerFEC)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetLPInnerFEC(&self, fec: super::FECMethod) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLPInnerFEC)(windows_core::Interface::as_raw(self), fec).ok() }
    }
    pub unsafe fn LPInnerFECRate(&self) -> windows_core::Result<super::BinaryConvolutionCodeRate> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).LPInnerFECRate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetLPInnerFECRate(&self, fec: super::BinaryConvolutionCodeRate) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLPInnerFECRate)(windows_core::Interface::as_raw(self), fec).ok() }
    }
    pub unsafe fn HAlpha(&self) -> windows_core::Result<super::HierarchyAlpha> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).HAlpha)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetHAlpha(&self, alpha: super::HierarchyAlpha) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetHAlpha)(windows_core::Interface::as_raw(self), alpha).ok() }
    }
    pub unsafe fn Guard(&self) -> windows_core::Result<super::GuardInterval> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Guard)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetGuard(&self, gi: super::GuardInterval) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetGuard)(windows_core::Interface::as_raw(self), gi).ok() }
    }
    pub unsafe fn Mode(&self) -> windows_core::Result<super::TransmissionMode> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Mode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMode(&self, mode: super::TransmissionMode) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMode)(windows_core::Interface::as_raw(self), mode).ok() }
    }
    pub unsafe fn OtherFrequencyInUse(&self) -> windows_core::Result<super::super::super::Foundation::VARIANT_BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).OtherFrequencyInUse)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOtherFrequencyInUse(&self, otherfrequencyinuseval: super::super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOtherFrequencyInUse)(windows_core::Interface::as_raw(self), otherfrequencyinuseval).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDVBTLocator_Vtbl {
    pub base__: IDigitalLocator_Vtbl,
    pub Bandwidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetBandwidth: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub LPInnerFEC: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::FECMethod) -> windows_core::HRESULT,
    pub SetLPInnerFEC: unsafe extern "system" fn(*mut core::ffi::c_void, super::FECMethod) -> windows_core::HRESULT,
    pub LPInnerFECRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::BinaryConvolutionCodeRate) -> windows_core::HRESULT,
    pub SetLPInnerFECRate: unsafe extern "system" fn(*mut core::ffi::c_void, super::BinaryConvolutionCodeRate) -> windows_core::HRESULT,
    pub HAlpha: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::HierarchyAlpha) -> windows_core::HRESULT,
    pub SetHAlpha: unsafe extern "system" fn(*mut core::ffi::c_void, super::HierarchyAlpha) -> windows_core::HRESULT,
    pub Guard: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::GuardInterval) -> windows_core::HRESULT,
    pub SetGuard: unsafe extern "system" fn(*mut core::ffi::c_void, super::GuardInterval) -> windows_core::HRESULT,
    pub Mode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::TransmissionMode) -> windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(*mut core::ffi::c_void, super::TransmissionMode) -> windows_core::HRESULT,
    pub OtherFrequencyInUse: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetOtherFrequencyInUse: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDVBTLocator_Impl: IDigitalLocator_Impl {
    fn Bandwidth(&self) -> windows_core::Result<i32>;
    fn SetBandwidth(&self, bandwidthval: i32) -> windows_core::Result<()>;
    fn LPInnerFEC(&self) -> windows_core::Result<super::FECMethod>;
    fn SetLPInnerFEC(&self, fec: super::FECMethod) -> windows_core::Result<()>;
    fn LPInnerFECRate(&self) -> windows_core::Result<super::BinaryConvolutionCodeRate>;
    fn SetLPInnerFECRate(&self, fec: super::BinaryConvolutionCodeRate) -> windows_core::Result<()>;
    fn HAlpha(&self) -> windows_core::Result<super::HierarchyAlpha>;
    fn SetHAlpha(&self, alpha: super::HierarchyAlpha) -> windows_core::Result<()>;
    fn Guard(&self) -> windows_core::Result<super::GuardInterval>;
    fn SetGuard(&self, gi: super::GuardInterval) -> windows_core::Result<()>;
    fn Mode(&self) -> windows_core::Result<super::TransmissionMode>;
    fn SetMode(&self, mode: super::TransmissionMode) -> windows_core::Result<()>;
    fn OtherFrequencyInUse(&self) -> windows_core::Result<super::super::super::Foundation::VARIANT_BOOL>;
    fn SetOtherFrequencyInUse(&self, otherfrequencyinuseval: super::super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDVBTLocator_Vtbl {
    pub const fn new<Identity: IDVBTLocator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Bandwidth<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bandwidthval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTLocator_Impl::Bandwidth(this) {
                    Ok(ok__) => {
                        bandwidthval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetBandwidth<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bandwidthval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTLocator_Impl::SetBandwidth(this, core::mem::transmute_copy(&bandwidthval)).into()
            }
        }
        unsafe extern "system" fn LPInnerFEC<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fec: *mut super::FECMethod) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTLocator_Impl::LPInnerFEC(this) {
                    Ok(ok__) => {
                        fec.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetLPInnerFEC<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fec: super::FECMethod) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTLocator_Impl::SetLPInnerFEC(this, core::mem::transmute_copy(&fec)).into()
            }
        }
        unsafe extern "system" fn LPInnerFECRate<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fec: *mut super::BinaryConvolutionCodeRate) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTLocator_Impl::LPInnerFECRate(this) {
                    Ok(ok__) => {
                        fec.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetLPInnerFECRate<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fec: super::BinaryConvolutionCodeRate) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTLocator_Impl::SetLPInnerFECRate(this, core::mem::transmute_copy(&fec)).into()
            }
        }
        unsafe extern "system" fn HAlpha<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, alpha: *mut super::HierarchyAlpha) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTLocator_Impl::HAlpha(this) {
                    Ok(ok__) => {
                        alpha.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetHAlpha<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, alpha: super::HierarchyAlpha) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTLocator_Impl::SetHAlpha(this, core::mem::transmute_copy(&alpha)).into()
            }
        }
        unsafe extern "system" fn Guard<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, gi: *mut super::GuardInterval) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTLocator_Impl::Guard(this) {
                    Ok(ok__) => {
                        gi.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetGuard<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, gi: super::GuardInterval) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTLocator_Impl::SetGuard(this, core::mem::transmute_copy(&gi)).into()
            }
        }
        unsafe extern "system" fn Mode<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mode: *mut super::TransmissionMode) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTLocator_Impl::Mode(this) {
                    Ok(ok__) => {
                        mode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMode<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mode: super::TransmissionMode) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTLocator_Impl::SetMode(this, core::mem::transmute_copy(&mode)).into()
            }
        }
        unsafe extern "system" fn OtherFrequencyInUse<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, otherfrequencyinuseval: *mut super::super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTLocator_Impl::OtherFrequencyInUse(this) {
                    Ok(ok__) => {
                        otherfrequencyinuseval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOtherFrequencyInUse<Identity: IDVBTLocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, otherfrequencyinuseval: super::super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTLocator_Impl::SetOtherFrequencyInUse(this, core::mem::transmute_copy(&otherfrequencyinuseval)).into()
            }
        }
        Self {
            base__: IDigitalLocator_Vtbl::new::<Identity, OFFSET>(),
            Bandwidth: Bandwidth::<Identity, OFFSET>,
            SetBandwidth: SetBandwidth::<Identity, OFFSET>,
            LPInnerFEC: LPInnerFEC::<Identity, OFFSET>,
            SetLPInnerFEC: SetLPInnerFEC::<Identity, OFFSET>,
            LPInnerFECRate: LPInnerFECRate::<Identity, OFFSET>,
            SetLPInnerFECRate: SetLPInnerFECRate::<Identity, OFFSET>,
            HAlpha: HAlpha::<Identity, OFFSET>,
            SetHAlpha: SetHAlpha::<Identity, OFFSET>,
            Guard: Guard::<Identity, OFFSET>,
            SetGuard: SetGuard::<Identity, OFFSET>,
            Mode: Mode::<Identity, OFFSET>,
            SetMode: SetMode::<Identity, OFFSET>,
            OtherFrequencyInUse: OtherFrequencyInUse::<Identity, OFFSET>,
            SetOtherFrequencyInUse: SetOtherFrequencyInUse::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVBTLocator as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ILocator as windows_core::Interface>::IID || iid == &<IDigitalLocator as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDVBTLocator {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDVBTLocator2, IDVBTLocator2_Vtbl, 0x448a2edf_ae95_4b43_a3cc_747843c453d4);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDVBTLocator2 {
    type Target = IDVBTLocator;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDVBTLocator2, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ILocator, IDigitalLocator, IDVBTLocator);
#[cfg(feature = "Win32_System_Com")]
impl IDVBTLocator2 {
    pub unsafe fn PhysicalLayerPipeId(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).PhysicalLayerPipeId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetPhysicalLayerPipeId(&self, physicallayerpipeidval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPhysicalLayerPipeId)(windows_core::Interface::as_raw(self), physicallayerpipeidval).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDVBTLocator2_Vtbl {
    pub base__: IDVBTLocator_Vtbl,
    pub PhysicalLayerPipeId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetPhysicalLayerPipeId: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDVBTLocator2_Impl: IDVBTLocator_Impl {
    fn PhysicalLayerPipeId(&self) -> windows_core::Result<i32>;
    fn SetPhysicalLayerPipeId(&self, physicallayerpipeidval: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDVBTLocator2_Vtbl {
    pub const fn new<Identity: IDVBTLocator2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn PhysicalLayerPipeId<Identity: IDVBTLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, physicallayerpipeidval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTLocator2_Impl::PhysicalLayerPipeId(this) {
                    Ok(ok__) => {
                        physicallayerpipeidval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetPhysicalLayerPipeId<Identity: IDVBTLocator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, physicallayerpipeidval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTLocator2_Impl::SetPhysicalLayerPipeId(this, core::mem::transmute_copy(&physicallayerpipeidval)).into()
            }
        }
        Self {
            base__: IDVBTLocator_Vtbl::new::<Identity, OFFSET>(),
            PhysicalLayerPipeId: PhysicalLayerPipeId::<Identity, OFFSET>,
            SetPhysicalLayerPipeId: SetPhysicalLayerPipeId::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVBTLocator2 as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ILocator as windows_core::Interface>::IID || iid == &<IDigitalLocator as windows_core::Interface>::IID || iid == &<IDVBTLocator as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDVBTLocator2 {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDVBTuneRequest, IDVBTuneRequest_Vtbl, 0x0d6f567e_a636_42bb_83ba_ce4c1704afa2);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDVBTuneRequest {
    type Target = ITuneRequest;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDVBTuneRequest, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuneRequest);
#[cfg(feature = "Win32_System_Com")]
impl IDVBTuneRequest {
    pub unsafe fn ONID(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ONID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetONID(&self, onid: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetONID)(windows_core::Interface::as_raw(self), onid).ok() }
    }
    pub unsafe fn TSID(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).TSID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTSID(&self, tsid: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTSID)(windows_core::Interface::as_raw(self), tsid).ok() }
    }
    pub unsafe fn SID(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetSID(&self, sid: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSID)(windows_core::Interface::as_raw(self), sid).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDVBTuneRequest_Vtbl {
    pub base__: ITuneRequest_Vtbl,
    pub ONID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetONID: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub TSID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetTSID: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub SID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetSID: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDVBTuneRequest_Impl: ITuneRequest_Impl {
    fn ONID(&self) -> windows_core::Result<i32>;
    fn SetONID(&self, onid: i32) -> windows_core::Result<()>;
    fn TSID(&self) -> windows_core::Result<i32>;
    fn SetTSID(&self, tsid: i32) -> windows_core::Result<()>;
    fn SID(&self) -> windows_core::Result<i32>;
    fn SetSID(&self, sid: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDVBTuneRequest_Vtbl {
    pub const fn new<Identity: IDVBTuneRequest_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ONID<Identity: IDVBTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, onid: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTuneRequest_Impl::ONID(this) {
                    Ok(ok__) => {
                        onid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetONID<Identity: IDVBTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, onid: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTuneRequest_Impl::SetONID(this, core::mem::transmute_copy(&onid)).into()
            }
        }
        unsafe extern "system" fn TSID<Identity: IDVBTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tsid: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTuneRequest_Impl::TSID(this) {
                    Ok(ok__) => {
                        tsid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTSID<Identity: IDVBTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tsid: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTuneRequest_Impl::SetTSID(this, core::mem::transmute_copy(&tsid)).into()
            }
        }
        unsafe extern "system" fn SID<Identity: IDVBTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, sid: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTuneRequest_Impl::SID(this) {
                    Ok(ok__) => {
                        sid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetSID<Identity: IDVBTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, sid: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTuneRequest_Impl::SetSID(this, core::mem::transmute_copy(&sid)).into()
            }
        }
        Self {
            base__: ITuneRequest_Vtbl::new::<Identity, OFFSET>(),
            ONID: ONID::<Identity, OFFSET>,
            SetONID: SetONID::<Identity, OFFSET>,
            TSID: TSID::<Identity, OFFSET>,
            SetTSID: SetTSID::<Identity, OFFSET>,
            SID: SID::<Identity, OFFSET>,
            SetSID: SetSID::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVBTuneRequest as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuneRequest as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDVBTuneRequest {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDVBTuningSpace, IDVBTuningSpace_Vtbl, 0xada0b268_3b19_4e5b_acc4_49f852be13ba);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDVBTuningSpace {
    type Target = ITuningSpace;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDVBTuningSpace, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuningSpace);
#[cfg(feature = "Win32_System_Com")]
impl IDVBTuningSpace {
    pub unsafe fn SystemType(&self) -> windows_core::Result<super::DVBSystemType> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SystemType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetSystemType(&self, systype: super::DVBSystemType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSystemType)(windows_core::Interface::as_raw(self), systype).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDVBTuningSpace_Vtbl {
    pub base__: ITuningSpace_Vtbl,
    pub SystemType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::DVBSystemType) -> windows_core::HRESULT,
    pub SetSystemType: unsafe extern "system" fn(*mut core::ffi::c_void, super::DVBSystemType) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDVBTuningSpace_Impl: ITuningSpace_Impl {
    fn SystemType(&self) -> windows_core::Result<super::DVBSystemType>;
    fn SetSystemType(&self, systype: super::DVBSystemType) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDVBTuningSpace_Vtbl {
    pub const fn new<Identity: IDVBTuningSpace_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SystemType<Identity: IDVBTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, systype: *mut super::DVBSystemType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTuningSpace_Impl::SystemType(this) {
                    Ok(ok__) => {
                        systype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetSystemType<Identity: IDVBTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, systype: super::DVBSystemType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTuningSpace_Impl::SetSystemType(this, core::mem::transmute_copy(&systype)).into()
            }
        }
        Self {
            base__: ITuningSpace_Vtbl::new::<Identity, OFFSET>(),
            SystemType: SystemType::<Identity, OFFSET>,
            SetSystemType: SetSystemType::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVBTuningSpace as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuningSpace as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDVBTuningSpace {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDVBTuningSpace2, IDVBTuningSpace2_Vtbl, 0x843188b4_ce62_43db_966b_8145a094e040);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDVBTuningSpace2 {
    type Target = IDVBTuningSpace;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDVBTuningSpace2, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuningSpace, IDVBTuningSpace);
#[cfg(feature = "Win32_System_Com")]
impl IDVBTuningSpace2 {
    pub unsafe fn NetworkID(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).NetworkID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetNetworkID(&self, networkid: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetNetworkID)(windows_core::Interface::as_raw(self), networkid).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDVBTuningSpace2_Vtbl {
    pub base__: IDVBTuningSpace_Vtbl,
    pub NetworkID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetNetworkID: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDVBTuningSpace2_Impl: IDVBTuningSpace_Impl {
    fn NetworkID(&self) -> windows_core::Result<i32>;
    fn SetNetworkID(&self, networkid: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDVBTuningSpace2_Vtbl {
    pub const fn new<Identity: IDVBTuningSpace2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn NetworkID<Identity: IDVBTuningSpace2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, networkid: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVBTuningSpace2_Impl::NetworkID(this) {
                    Ok(ok__) => {
                        networkid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetNetworkID<Identity: IDVBTuningSpace2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, networkid: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVBTuningSpace2_Impl::SetNetworkID(this, core::mem::transmute_copy(&networkid)).into()
            }
        }
        Self {
            base__: IDVBTuningSpace_Vtbl::new::<Identity, OFFSET>(),
            NetworkID: NetworkID::<Identity, OFFSET>,
            SetNetworkID: SetNetworkID::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVBTuningSpace2 as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuningSpace as windows_core::Interface>::IID || iid == &<IDVBTuningSpace as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDVBTuningSpace2 {}
windows_core::imp::define_interface!(IDVB_BAT, IDVB_BAT_Vtbl, 0xece9bb0c_43b6_4558_a0ec_1812c34cd6ca);
windows_core::imp::interface_hierarchy!(IDVB_BAT, windows_core::IUnknown);
impl IDVB_BAT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetVersionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetBouquetId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetBouquetId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfTableDescriptors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTableDescriptorByIndex(&self, dwindex: u32, ppdescriptor: *const Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTableDescriptorByIndex)(windows_core::Interface::as_raw(self), dwindex, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: Option<*mut u32>, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTableDescriptorByTag)(windows_core::Interface::as_raw(self), btag, pdwcookie.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordTransportStreamId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordTransportStreamId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordOriginalNetworkId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordOriginalNetworkId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCountOfDescriptors)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordDescriptorByIndex)(windows_core::Interface::as_raw(self), dwrecordindex, dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: Option<*mut u32>, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordDescriptorByTag)(windows_core::Interface::as_raw(self), dwrecordindex, btag, pdwcookie.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForNextTable)(windows_core::Interface::as_raw(self), hnexttableavailable).ok() }
    }
    pub unsafe fn GetNextTable(&self) -> windows_core::Result<IDVB_BAT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNextTable)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForWhenCurrent)(windows_core::Interface::as_raw(self), hnexttableiscurrent).ok() }
    }
    pub unsafe fn ConvertNextToCurrent(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConvertNextToCurrent)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_BAT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetBouquetId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetCountOfTableDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTableDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTableDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRecordTransportStreamId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordOriginalNetworkId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordCountOfDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRecordDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRecordDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub GetNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForWhenCurrent: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub ConvertNextToCurrent: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDVB_BAT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetVersionNumber(&self) -> windows_core::Result<u8>;
    fn GetBouquetId(&self) -> windows_core::Result<u16>;
    fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32>;
    fn GetTableDescriptorByIndex(&self, dwindex: u32, ppdescriptor: *const Option<IGenericDescriptor>) -> windows_core::Result<()>;
    fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u32>;
    fn GetRecordTransportStreamId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordOriginalNetworkId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32>;
    fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn GetNextTable(&self) -> windows_core::Result<IDVB_BAT>;
    fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn ConvertNextToCurrent(&self) -> windows_core::Result<()>;
}
impl IDVB_BAT_Vtbl {
    pub const fn new<Identity: IDVB_BAT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_BAT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetVersionNumber<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_BAT_Impl::GetVersionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetBouquetId<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_BAT_Impl::GetBouquetId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfTableDescriptors<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_BAT_Impl::GetCountOfTableDescriptors(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByIndex<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, ppdescriptor: *const *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_BAT_Impl::GetTableDescriptorByIndex(this, core::mem::transmute_copy(&dwindex), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn GetTableDescriptorByTag<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_BAT_Impl::GetTableDescriptorByTag(this, core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_BAT_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordTransportStreamId<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_BAT_Impl::GetRecordTransportStreamId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordOriginalNetworkId<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_BAT_Impl::GetRecordOriginalNetworkId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCountOfDescriptors<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_BAT_Impl::GetRecordCountOfDescriptors(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByIndex<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_BAT_Impl::GetRecordDescriptorByIndex(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByTag<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_BAT_Impl::GetRecordDescriptorByTag(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn RegisterForNextTable<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_BAT_Impl::RegisterForNextTable(this, core::mem::transmute_copy(&hnexttableavailable)).into()
            }
        }
        unsafe extern "system" fn GetNextTable<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppbat: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_BAT_Impl::GetNextTable(this) {
                    Ok(ok__) => {
                        ppbat.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RegisterForWhenCurrent<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_BAT_Impl::RegisterForWhenCurrent(this, core::mem::transmute_copy(&hnexttableiscurrent)).into()
            }
        }
        unsafe extern "system" fn ConvertNextToCurrent<Identity: IDVB_BAT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_BAT_Impl::ConvertNextToCurrent(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetVersionNumber: GetVersionNumber::<Identity, OFFSET>,
            GetBouquetId: GetBouquetId::<Identity, OFFSET>,
            GetCountOfTableDescriptors: GetCountOfTableDescriptors::<Identity, OFFSET>,
            GetTableDescriptorByIndex: GetTableDescriptorByIndex::<Identity, OFFSET>,
            GetTableDescriptorByTag: GetTableDescriptorByTag::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordTransportStreamId: GetRecordTransportStreamId::<Identity, OFFSET>,
            GetRecordOriginalNetworkId: GetRecordOriginalNetworkId::<Identity, OFFSET>,
            GetRecordCountOfDescriptors: GetRecordCountOfDescriptors::<Identity, OFFSET>,
            GetRecordDescriptorByIndex: GetRecordDescriptorByIndex::<Identity, OFFSET>,
            GetRecordDescriptorByTag: GetRecordDescriptorByTag::<Identity, OFFSET>,
            RegisterForNextTable: RegisterForNextTable::<Identity, OFFSET>,
            GetNextTable: GetNextTable::<Identity, OFFSET>,
            RegisterForWhenCurrent: RegisterForWhenCurrent::<Identity, OFFSET>,
            ConvertNextToCurrent: ConvertNextToCurrent::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_BAT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_BAT {}
windows_core::imp::define_interface!(IDVB_DIT, IDVB_DIT_Vtbl, 0x91bffdf9_9432_410f_86ef_1c228ed0ad70);
windows_core::imp::interface_hierarchy!(IDVB_DIT, windows_core::IUnknown);
impl IDVB_DIT {
    pub unsafe fn Initialize<P0>(&self, psectionlist: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi()).ok() }
    }
    pub unsafe fn GetTransitionFlag(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTransitionFlag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_DIT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTransitionFlag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
}
pub trait IDVB_DIT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>) -> windows_core::Result<()>;
    fn GetTransitionFlag(&self) -> windows_core::Result<windows_core::BOOL>;
}
impl IDVB_DIT_Vtbl {
    pub const fn new<Identity: IDVB_DIT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDVB_DIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_DIT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist)).into()
            }
        }
        unsafe extern "system" fn GetTransitionFlag<Identity: IDVB_DIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_DIT_Impl::GetTransitionFlag(this) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetTransitionFlag: GetTransitionFlag::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_DIT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_DIT {}
windows_core::imp::define_interface!(IDVB_EIT, IDVB_EIT_Vtbl, 0x442db029_02cb_4495_8b92_1c13375bce99);
windows_core::imp::interface_hierarchy!(IDVB_EIT, windows_core::IUnknown);
impl IDVB_EIT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetVersionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetServiceId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTransportStreamId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTransportStreamId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetOriginalNetworkId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOriginalNetworkId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSegmentLastSectionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSegmentLastSectionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLastTableId(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLastTableId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordEventId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordEventId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordStartTime(&self, dwrecordindex: u32) -> windows_core::Result<MPEG_DATE_AND_TIME> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordStartTime)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordDuration(&self, dwrecordindex: u32) -> windows_core::Result<MPEG_TIME> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordDuration)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordRunningStatus(&self, dwrecordindex: u32) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordRunningStatus)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordFreeCAMode(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordFreeCAMode)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCountOfDescriptors)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordDescriptorByIndex)(windows_core::Interface::as_raw(self), dwrecordindex, dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: Option<*mut u32>, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordDescriptorByTag)(windows_core::Interface::as_raw(self), dwrecordindex, btag, pdwcookie.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForNextTable)(windows_core::Interface::as_raw(self), hnexttableavailable).ok() }
    }
    pub unsafe fn GetNextTable(&self) -> windows_core::Result<IDVB_EIT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNextTable)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForWhenCurrent)(windows_core::Interface::as_raw(self), hnexttableiscurrent).ok() }
    }
    pub unsafe fn ConvertNextToCurrent(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConvertNextToCurrent)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetVersionHash(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionHash)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_EIT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetServiceId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetTransportStreamId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetOriginalNetworkId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetSegmentLastSectionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLastTableId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRecordEventId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordStartTime: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut MPEG_DATE_AND_TIME) -> windows_core::HRESULT,
    pub GetRecordDuration: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut MPEG_TIME) -> windows_core::HRESULT,
    pub GetRecordRunningStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
    pub GetRecordFreeCAMode: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetRecordCountOfDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRecordDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRecordDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub GetNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForWhenCurrent: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub ConvertNextToCurrent: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionHash: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IDVB_EIT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetVersionNumber(&self) -> windows_core::Result<u8>;
    fn GetServiceId(&self) -> windows_core::Result<u16>;
    fn GetTransportStreamId(&self) -> windows_core::Result<u16>;
    fn GetOriginalNetworkId(&self) -> windows_core::Result<u16>;
    fn GetSegmentLastSectionNumber(&self) -> windows_core::Result<u8>;
    fn GetLastTableId(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u32>;
    fn GetRecordEventId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordStartTime(&self, dwrecordindex: u32) -> windows_core::Result<MPEG_DATE_AND_TIME>;
    fn GetRecordDuration(&self, dwrecordindex: u32) -> windows_core::Result<MPEG_TIME>;
    fn GetRecordRunningStatus(&self, dwrecordindex: u32) -> windows_core::Result<u8>;
    fn GetRecordFreeCAMode(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL>;
    fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32>;
    fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn GetNextTable(&self) -> windows_core::Result<IDVB_EIT>;
    fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn ConvertNextToCurrent(&self) -> windows_core::Result<()>;
    fn GetVersionHash(&self) -> windows_core::Result<u32>;
}
impl IDVB_EIT_Vtbl {
    pub const fn new<Identity: IDVB_EIT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_EIT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetVersionNumber<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetVersionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetServiceId<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetServiceId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTransportStreamId<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetTransportStreamId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetOriginalNetworkId<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetOriginalNetworkId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSegmentLastSectionNumber<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetSegmentLastSectionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLastTableId<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetLastTableId(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordEventId<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetRecordEventId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordStartTime<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pmdtval: *mut MPEG_DATE_AND_TIME) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetRecordStartTime(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pmdtval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDuration<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pmdval: *mut MPEG_TIME) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetRecordDuration(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pmdval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordRunningStatus<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetRecordRunningStatus(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordFreeCAMode<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetRecordFreeCAMode(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCountOfDescriptors<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetRecordCountOfDescriptors(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByIndex<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetRecordDescriptorByIndex(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByTag<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_EIT_Impl::GetRecordDescriptorByTag(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn RegisterForNextTable<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_EIT_Impl::RegisterForNextTable(this, core::mem::transmute_copy(&hnexttableavailable)).into()
            }
        }
        unsafe extern "system" fn GetNextTable<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppeit: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetNextTable(this) {
                    Ok(ok__) => {
                        ppeit.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RegisterForWhenCurrent<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_EIT_Impl::RegisterForWhenCurrent(this, core::mem::transmute_copy(&hnexttableiscurrent)).into()
            }
        }
        unsafe extern "system" fn ConvertNextToCurrent<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_EIT_Impl::ConvertNextToCurrent(this).into()
            }
        }
        unsafe extern "system" fn GetVersionHash<Identity: IDVB_EIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwversionhash: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT_Impl::GetVersionHash(this) {
                    Ok(ok__) => {
                        pdwversionhash.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetVersionNumber: GetVersionNumber::<Identity, OFFSET>,
            GetServiceId: GetServiceId::<Identity, OFFSET>,
            GetTransportStreamId: GetTransportStreamId::<Identity, OFFSET>,
            GetOriginalNetworkId: GetOriginalNetworkId::<Identity, OFFSET>,
            GetSegmentLastSectionNumber: GetSegmentLastSectionNumber::<Identity, OFFSET>,
            GetLastTableId: GetLastTableId::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordEventId: GetRecordEventId::<Identity, OFFSET>,
            GetRecordStartTime: GetRecordStartTime::<Identity, OFFSET>,
            GetRecordDuration: GetRecordDuration::<Identity, OFFSET>,
            GetRecordRunningStatus: GetRecordRunningStatus::<Identity, OFFSET>,
            GetRecordFreeCAMode: GetRecordFreeCAMode::<Identity, OFFSET>,
            GetRecordCountOfDescriptors: GetRecordCountOfDescriptors::<Identity, OFFSET>,
            GetRecordDescriptorByIndex: GetRecordDescriptorByIndex::<Identity, OFFSET>,
            GetRecordDescriptorByTag: GetRecordDescriptorByTag::<Identity, OFFSET>,
            RegisterForNextTable: RegisterForNextTable::<Identity, OFFSET>,
            GetNextTable: GetNextTable::<Identity, OFFSET>,
            RegisterForWhenCurrent: RegisterForWhenCurrent::<Identity, OFFSET>,
            ConvertNextToCurrent: ConvertNextToCurrent::<Identity, OFFSET>,
            GetVersionHash: GetVersionHash::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_EIT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_EIT {}
windows_core::imp::define_interface!(IDVB_EIT2, IDVB_EIT2_Vtbl, 0x61a389e0_9b9e_4ba0_aeea_5ddd159820ea);
impl core::ops::Deref for IDVB_EIT2 {
    type Target = IDVB_EIT;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDVB_EIT2, windows_core::IUnknown, IDVB_EIT);
impl IDVB_EIT2 {
    pub unsafe fn GetSegmentInfo(&self, pbtid: *mut u8, pbsegment: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSegmentInfo)(windows_core::Interface::as_raw(self), pbtid as _, pbsegment as _).ok() }
    }
    pub unsafe fn GetRecordSection(&self, dwrecordindex: u32) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordSection)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_EIT2_Vtbl {
    pub base__: IDVB_EIT_Vtbl,
    pub GetSegmentInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8, *mut u8) -> windows_core::HRESULT,
    pub GetRecordSection: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
}
pub trait IDVB_EIT2_Impl: IDVB_EIT_Impl {
    fn GetSegmentInfo(&self, pbtid: *mut u8, pbsegment: *mut u8) -> windows_core::Result<()>;
    fn GetRecordSection(&self, dwrecordindex: u32) -> windows_core::Result<u8>;
}
impl IDVB_EIT2_Vtbl {
    pub const fn new<Identity: IDVB_EIT2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetSegmentInfo<Identity: IDVB_EIT2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbtid: *mut u8, pbsegment: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_EIT2_Impl::GetSegmentInfo(this, core::mem::transmute_copy(&pbtid), core::mem::transmute_copy(&pbsegment)).into()
            }
        }
        unsafe extern "system" fn GetRecordSection<Identity: IDVB_EIT2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_EIT2_Impl::GetRecordSection(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IDVB_EIT_Vtbl::new::<Identity, OFFSET>(),
            GetSegmentInfo: GetSegmentInfo::<Identity, OFFSET>,
            GetRecordSection: GetRecordSection::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_EIT2 as windows_core::Interface>::IID || iid == &<IDVB_EIT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_EIT2 {}
windows_core::imp::define_interface!(IDVB_NIT, IDVB_NIT_Vtbl, 0xc64935f4_29e4_4e22_911a_63f7f55cb097);
windows_core::imp::interface_hierarchy!(IDVB_NIT, windows_core::IUnknown);
impl IDVB_NIT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetVersionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNetworkId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNetworkId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfTableDescriptors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTableDescriptorByIndex)(windows_core::Interface::as_raw(self), dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: Option<*mut u32>, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTableDescriptorByTag)(windows_core::Interface::as_raw(self), btag, pdwcookie.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordTransportStreamId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordTransportStreamId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordOriginalNetworkId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordOriginalNetworkId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCountOfDescriptors)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordDescriptorByIndex)(windows_core::Interface::as_raw(self), dwrecordindex, dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: Option<*mut u32>, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordDescriptorByTag)(windows_core::Interface::as_raw(self), dwrecordindex, btag, pdwcookie.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForNextTable)(windows_core::Interface::as_raw(self), hnexttableavailable).ok() }
    }
    pub unsafe fn GetNextTable(&self) -> windows_core::Result<IDVB_NIT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNextTable)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForWhenCurrent)(windows_core::Interface::as_raw(self), hnexttableiscurrent).ok() }
    }
    pub unsafe fn ConvertNextToCurrent(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConvertNextToCurrent)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetVersionHash(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionHash)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_NIT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetNetworkId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetCountOfTableDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTableDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTableDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRecordTransportStreamId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordOriginalNetworkId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordCountOfDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRecordDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRecordDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub GetNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForWhenCurrent: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub ConvertNextToCurrent: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionHash: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IDVB_NIT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetVersionNumber(&self) -> windows_core::Result<u8>;
    fn GetNetworkId(&self) -> windows_core::Result<u16>;
    fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32>;
    fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u32>;
    fn GetRecordTransportStreamId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordOriginalNetworkId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32>;
    fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn GetNextTable(&self) -> windows_core::Result<IDVB_NIT>;
    fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn ConvertNextToCurrent(&self) -> windows_core::Result<()>;
    fn GetVersionHash(&self) -> windows_core::Result<u32>;
}
impl IDVB_NIT_Vtbl {
    pub const fn new<Identity: IDVB_NIT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_NIT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetVersionNumber<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetVersionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNetworkId<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetNetworkId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfTableDescriptors<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetCountOfTableDescriptors(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByIndex<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetTableDescriptorByIndex(this, core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByTag<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_NIT_Impl::GetTableDescriptorByTag(this, core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordTransportStreamId<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetRecordTransportStreamId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordOriginalNetworkId<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetRecordOriginalNetworkId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCountOfDescriptors<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetRecordCountOfDescriptors(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByIndex<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetRecordDescriptorByIndex(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByTag<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_NIT_Impl::GetRecordDescriptorByTag(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn RegisterForNextTable<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_NIT_Impl::RegisterForNextTable(this, core::mem::transmute_copy(&hnexttableavailable)).into()
            }
        }
        unsafe extern "system" fn GetNextTable<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppnit: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetNextTable(this) {
                    Ok(ok__) => {
                        ppnit.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RegisterForWhenCurrent<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_NIT_Impl::RegisterForWhenCurrent(this, core::mem::transmute_copy(&hnexttableiscurrent)).into()
            }
        }
        unsafe extern "system" fn ConvertNextToCurrent<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_NIT_Impl::ConvertNextToCurrent(this).into()
            }
        }
        unsafe extern "system" fn GetVersionHash<Identity: IDVB_NIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwversionhash: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_NIT_Impl::GetVersionHash(this) {
                    Ok(ok__) => {
                        pdwversionhash.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetVersionNumber: GetVersionNumber::<Identity, OFFSET>,
            GetNetworkId: GetNetworkId::<Identity, OFFSET>,
            GetCountOfTableDescriptors: GetCountOfTableDescriptors::<Identity, OFFSET>,
            GetTableDescriptorByIndex: GetTableDescriptorByIndex::<Identity, OFFSET>,
            GetTableDescriptorByTag: GetTableDescriptorByTag::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordTransportStreamId: GetRecordTransportStreamId::<Identity, OFFSET>,
            GetRecordOriginalNetworkId: GetRecordOriginalNetworkId::<Identity, OFFSET>,
            GetRecordCountOfDescriptors: GetRecordCountOfDescriptors::<Identity, OFFSET>,
            GetRecordDescriptorByIndex: GetRecordDescriptorByIndex::<Identity, OFFSET>,
            GetRecordDescriptorByTag: GetRecordDescriptorByTag::<Identity, OFFSET>,
            RegisterForNextTable: RegisterForNextTable::<Identity, OFFSET>,
            GetNextTable: GetNextTable::<Identity, OFFSET>,
            RegisterForWhenCurrent: RegisterForWhenCurrent::<Identity, OFFSET>,
            ConvertNextToCurrent: ConvertNextToCurrent::<Identity, OFFSET>,
            GetVersionHash: GetVersionHash::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_NIT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_NIT {}
windows_core::imp::define_interface!(IDVB_RST, IDVB_RST_Vtbl, 0xf47dcd04_1e23_4fb7_9f96_b40eead10b2b);
windows_core::imp::interface_hierarchy!(IDVB_RST, windows_core::IUnknown);
impl IDVB_RST {
    pub unsafe fn Initialize<P0>(&self, psectionlist: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi()).ok() }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordTransportStreamId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordTransportStreamId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordOriginalNetworkId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordOriginalNetworkId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordServiceId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordServiceId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordEventId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordEventId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordRunningStatus(&self, dwrecordindex: u32) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordRunningStatus)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_RST_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRecordTransportStreamId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordOriginalNetworkId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordServiceId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordEventId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordRunningStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
}
pub trait IDVB_RST_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>) -> windows_core::Result<()>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u32>;
    fn GetRecordTransportStreamId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordOriginalNetworkId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordServiceId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordEventId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordRunningStatus(&self, dwrecordindex: u32) -> windows_core::Result<u8>;
}
impl IDVB_RST_Vtbl {
    pub const fn new<Identity: IDVB_RST_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDVB_RST_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_RST_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist)).into()
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDVB_RST_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_RST_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordTransportStreamId<Identity: IDVB_RST_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_RST_Impl::GetRecordTransportStreamId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordOriginalNetworkId<Identity: IDVB_RST_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_RST_Impl::GetRecordOriginalNetworkId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordServiceId<Identity: IDVB_RST_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_RST_Impl::GetRecordServiceId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordEventId<Identity: IDVB_RST_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_RST_Impl::GetRecordEventId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordRunningStatus<Identity: IDVB_RST_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_RST_Impl::GetRecordRunningStatus(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordTransportStreamId: GetRecordTransportStreamId::<Identity, OFFSET>,
            GetRecordOriginalNetworkId: GetRecordOriginalNetworkId::<Identity, OFFSET>,
            GetRecordServiceId: GetRecordServiceId::<Identity, OFFSET>,
            GetRecordEventId: GetRecordEventId::<Identity, OFFSET>,
            GetRecordRunningStatus: GetRecordRunningStatus::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_RST as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_RST {}
windows_core::imp::define_interface!(IDVB_SDT, IDVB_SDT_Vtbl, 0x02cad8d3_fe43_48e2_90bd_450ed9a8a5fd);
windows_core::imp::interface_hierarchy!(IDVB_SDT, windows_core::IUnknown);
impl IDVB_SDT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetVersionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTransportStreamId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTransportStreamId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetOriginalNetworkId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOriginalNetworkId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordServiceId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordServiceId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordEITScheduleFlag(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordEITScheduleFlag)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordEITPresentFollowingFlag(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordEITPresentFollowingFlag)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordRunningStatus(&self, dwrecordindex: u32) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordRunningStatus)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordFreeCAMode(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordFreeCAMode)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCountOfDescriptors)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordDescriptorByIndex)(windows_core::Interface::as_raw(self), dwrecordindex, dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: Option<*mut u32>, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordDescriptorByTag)(windows_core::Interface::as_raw(self), dwrecordindex, btag, pdwcookie.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForNextTable)(windows_core::Interface::as_raw(self), hnexttableavailable).ok() }
    }
    pub unsafe fn GetNextTable(&self) -> windows_core::Result<IDVB_SDT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNextTable)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForWhenCurrent)(windows_core::Interface::as_raw(self), hnexttableiscurrent).ok() }
    }
    pub unsafe fn ConvertNextToCurrent(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConvertNextToCurrent)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetVersionHash(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionHash)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_SDT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetTransportStreamId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetOriginalNetworkId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRecordServiceId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordEITScheduleFlag: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetRecordEITPresentFollowingFlag: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetRecordRunningStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
    pub GetRecordFreeCAMode: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetRecordCountOfDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRecordDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRecordDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub GetNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForWhenCurrent: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub ConvertNextToCurrent: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionHash: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IDVB_SDT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetVersionNumber(&self) -> windows_core::Result<u8>;
    fn GetTransportStreamId(&self) -> windows_core::Result<u16>;
    fn GetOriginalNetworkId(&self) -> windows_core::Result<u16>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u32>;
    fn GetRecordServiceId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordEITScheduleFlag(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL>;
    fn GetRecordEITPresentFollowingFlag(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL>;
    fn GetRecordRunningStatus(&self, dwrecordindex: u32) -> windows_core::Result<u8>;
    fn GetRecordFreeCAMode(&self, dwrecordindex: u32) -> windows_core::Result<windows_core::BOOL>;
    fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32>;
    fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn GetNextTable(&self) -> windows_core::Result<IDVB_SDT>;
    fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn ConvertNextToCurrent(&self) -> windows_core::Result<()>;
    fn GetVersionHash(&self) -> windows_core::Result<u32>;
}
impl IDVB_SDT_Vtbl {
    pub const fn new<Identity: IDVB_SDT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SDT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetVersionNumber<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetVersionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTransportStreamId<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetTransportStreamId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetOriginalNetworkId<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetOriginalNetworkId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordServiceId<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetRecordServiceId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordEITScheduleFlag<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetRecordEITScheduleFlag(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordEITPresentFollowingFlag<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetRecordEITPresentFollowingFlag(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordRunningStatus<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetRecordRunningStatus(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordFreeCAMode<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetRecordFreeCAMode(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCountOfDescriptors<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetRecordCountOfDescriptors(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByIndex<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetRecordDescriptorByIndex(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByTag<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SDT_Impl::GetRecordDescriptorByTag(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn RegisterForNextTable<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SDT_Impl::RegisterForNextTable(this, core::mem::transmute_copy(&hnexttableavailable)).into()
            }
        }
        unsafe extern "system" fn GetNextTable<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppsdt: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetNextTable(this) {
                    Ok(ok__) => {
                        ppsdt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RegisterForWhenCurrent<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SDT_Impl::RegisterForWhenCurrent(this, core::mem::transmute_copy(&hnexttableiscurrent)).into()
            }
        }
        unsafe extern "system" fn ConvertNextToCurrent<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SDT_Impl::ConvertNextToCurrent(this).into()
            }
        }
        unsafe extern "system" fn GetVersionHash<Identity: IDVB_SDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwversionhash: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SDT_Impl::GetVersionHash(this) {
                    Ok(ok__) => {
                        pdwversionhash.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetVersionNumber: GetVersionNumber::<Identity, OFFSET>,
            GetTransportStreamId: GetTransportStreamId::<Identity, OFFSET>,
            GetOriginalNetworkId: GetOriginalNetworkId::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordServiceId: GetRecordServiceId::<Identity, OFFSET>,
            GetRecordEITScheduleFlag: GetRecordEITScheduleFlag::<Identity, OFFSET>,
            GetRecordEITPresentFollowingFlag: GetRecordEITPresentFollowingFlag::<Identity, OFFSET>,
            GetRecordRunningStatus: GetRecordRunningStatus::<Identity, OFFSET>,
            GetRecordFreeCAMode: GetRecordFreeCAMode::<Identity, OFFSET>,
            GetRecordCountOfDescriptors: GetRecordCountOfDescriptors::<Identity, OFFSET>,
            GetRecordDescriptorByIndex: GetRecordDescriptorByIndex::<Identity, OFFSET>,
            GetRecordDescriptorByTag: GetRecordDescriptorByTag::<Identity, OFFSET>,
            RegisterForNextTable: RegisterForNextTable::<Identity, OFFSET>,
            GetNextTable: GetNextTable::<Identity, OFFSET>,
            RegisterForWhenCurrent: RegisterForWhenCurrent::<Identity, OFFSET>,
            ConvertNextToCurrent: ConvertNextToCurrent::<Identity, OFFSET>,
            GetVersionHash: GetVersionHash::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_SDT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_SDT {}
windows_core::imp::define_interface!(IDVB_SIT, IDVB_SIT_Vtbl, 0x68cdce53_8bea_45c2_9d9d_acf575a089b5);
windows_core::imp::interface_hierarchy!(IDVB_SIT, windows_core::IUnknown);
impl IDVB_SIT {
    pub unsafe fn Initialize<P0, P1>(&self, psectionlist: P0, pmpegdata: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
        P1: windows_core::Param<IMpeg2Data>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi(), pmpegdata.param().abi()).ok() }
    }
    pub unsafe fn GetVersionNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVersionNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfTableDescriptors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTableDescriptorByIndex)(windows_core::Interface::as_raw(self), dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: Option<*mut u32>, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTableDescriptorByTag)(windows_core::Interface::as_raw(self), btag, pdwcookie.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordServiceId(&self, dwrecordindex: u32) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordServiceId)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordRunningStatus(&self, dwrecordindex: u32) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordRunningStatus)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCountOfDescriptors)(windows_core::Interface::as_raw(self), dwrecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordDescriptorByIndex)(windows_core::Interface::as_raw(self), dwrecordindex, dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: Option<*mut u32>, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordDescriptorByTag)(windows_core::Interface::as_raw(self), dwrecordindex, btag, pdwcookie.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppdescriptor)).ok() }
    }
    pub unsafe fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForNextTable)(windows_core::Interface::as_raw(self), hnexttableavailable).ok() }
    }
    pub unsafe fn GetNextTable(&self, dwtimeout: u32) -> windows_core::Result<IDVB_SIT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNextTable)(windows_core::Interface::as_raw(self), dwtimeout, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForWhenCurrent)(windows_core::Interface::as_raw(self), hnexttableiscurrent).ok() }
    }
    pub unsafe fn ConvertNextToCurrent(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConvertNextToCurrent)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_SIT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVersionNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfTableDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTableDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTableDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRecordServiceId: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16) -> windows_core::HRESULT,
    pub GetRecordRunningStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
    pub GetRecordCountOfDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRecordDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRecordDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub GetNextTable: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterForWhenCurrent: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub ConvertNextToCurrent: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDVB_SIT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>, pmpegdata: windows_core::Ref<'_, IMpeg2Data>) -> windows_core::Result<()>;
    fn GetVersionNumber(&self) -> windows_core::Result<u8>;
    fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32>;
    fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u32>;
    fn GetRecordServiceId(&self, dwrecordindex: u32) -> windows_core::Result<u16>;
    fn GetRecordRunningStatus(&self, dwrecordindex: u32) -> windows_core::Result<u8>;
    fn GetRecordCountOfDescriptors(&self, dwrecordindex: u32) -> windows_core::Result<u32>;
    fn GetRecordDescriptorByIndex(&self, dwrecordindex: u32, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetRecordDescriptorByTag(&self, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
    fn RegisterForNextTable(&self, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn GetNextTable(&self, dwtimeout: u32) -> windows_core::Result<IDVB_SIT>;
    fn RegisterForWhenCurrent(&self, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn ConvertNextToCurrent(&self) -> windows_core::Result<()>;
}
impl IDVB_SIT_Vtbl {
    pub const fn new<Identity: IDVB_SIT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void, pmpegdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SIT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist), core::mem::transmute_copy(&pmpegdata)).into()
            }
        }
        unsafe extern "system" fn GetVersionNumber<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SIT_Impl::GetVersionNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfTableDescriptors<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SIT_Impl::GetCountOfTableDescriptors(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByIndex<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SIT_Impl::GetTableDescriptorByIndex(this, core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByTag<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SIT_Impl::GetTableDescriptorByTag(this, core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SIT_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordServiceId<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SIT_Impl::GetRecordServiceId(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordRunningStatus<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SIT_Impl::GetRecordRunningStatus(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCountOfDescriptors<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SIT_Impl::GetRecordCountOfDescriptors(this, core::mem::transmute_copy(&dwrecordindex)) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByIndex<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SIT_Impl::GetRecordDescriptorByIndex(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordDescriptorByTag<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordindex: u32, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SIT_Impl::GetRecordDescriptorByTag(this, core::mem::transmute_copy(&dwrecordindex), core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        unsafe extern "system" fn RegisterForNextTable<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableavailable: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SIT_Impl::RegisterForNextTable(this, core::mem::transmute_copy(&hnexttableavailable)).into()
            }
        }
        unsafe extern "system" fn GetNextTable<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtimeout: u32, ppsit: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_SIT_Impl::GetNextTable(this, core::mem::transmute_copy(&dwtimeout)) {
                    Ok(ok__) => {
                        ppsit.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RegisterForWhenCurrent<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hnexttableiscurrent: super::super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SIT_Impl::RegisterForWhenCurrent(this, core::mem::transmute_copy(&hnexttableiscurrent)).into()
            }
        }
        unsafe extern "system" fn ConvertNextToCurrent<Identity: IDVB_SIT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_SIT_Impl::ConvertNextToCurrent(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetVersionNumber: GetVersionNumber::<Identity, OFFSET>,
            GetCountOfTableDescriptors: GetCountOfTableDescriptors::<Identity, OFFSET>,
            GetTableDescriptorByIndex: GetTableDescriptorByIndex::<Identity, OFFSET>,
            GetTableDescriptorByTag: GetTableDescriptorByTag::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordServiceId: GetRecordServiceId::<Identity, OFFSET>,
            GetRecordRunningStatus: GetRecordRunningStatus::<Identity, OFFSET>,
            GetRecordCountOfDescriptors: GetRecordCountOfDescriptors::<Identity, OFFSET>,
            GetRecordDescriptorByIndex: GetRecordDescriptorByIndex::<Identity, OFFSET>,
            GetRecordDescriptorByTag: GetRecordDescriptorByTag::<Identity, OFFSET>,
            RegisterForNextTable: RegisterForNextTable::<Identity, OFFSET>,
            GetNextTable: GetNextTable::<Identity, OFFSET>,
            RegisterForWhenCurrent: RegisterForWhenCurrent::<Identity, OFFSET>,
            ConvertNextToCurrent: ConvertNextToCurrent::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_SIT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_SIT {}
windows_core::imp::define_interface!(IDVB_ST, IDVB_ST_Vtbl, 0x4d5b9f23_2a02_45de_bcda_5d5dbfbfbe62);
windows_core::imp::interface_hierarchy!(IDVB_ST, windows_core::IUnknown);
impl IDVB_ST {
    pub unsafe fn Initialize<P0>(&self, psectionlist: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi()).ok() }
    }
    pub unsafe fn GetDataLength(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDataLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetData(&self) -> windows_core::Result<*mut u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetData)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_ST_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetDataLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut u8) -> windows_core::HRESULT,
}
pub trait IDVB_ST_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>) -> windows_core::Result<()>;
    fn GetDataLength(&self) -> windows_core::Result<u16>;
    fn GetData(&self) -> windows_core::Result<*mut u8>;
}
impl IDVB_ST_Vtbl {
    pub const fn new<Identity: IDVB_ST_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDVB_ST_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_ST_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist)).into()
            }
        }
        unsafe extern "system" fn GetDataLength<Identity: IDVB_ST_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_ST_Impl::GetDataLength(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetData<Identity: IDVB_ST_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppdata: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_ST_Impl::GetData(this) {
                    Ok(ok__) => {
                        ppdata.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetDataLength: GetDataLength::<Identity, OFFSET>,
            GetData: GetData::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_ST as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_ST {}
windows_core::imp::define_interface!(IDVB_TDT, IDVB_TDT_Vtbl, 0x0780dc7d_d55c_4aef_97e6_6b75906e2796);
windows_core::imp::interface_hierarchy!(IDVB_TDT, windows_core::IUnknown);
impl IDVB_TDT {
    pub unsafe fn Initialize<P0>(&self, psectionlist: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi()).ok() }
    }
    pub unsafe fn GetUTCTime(&self) -> windows_core::Result<MPEG_DATE_AND_TIME> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetUTCTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_TDT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetUTCTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut MPEG_DATE_AND_TIME) -> windows_core::HRESULT,
}
pub trait IDVB_TDT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>) -> windows_core::Result<()>;
    fn GetUTCTime(&self) -> windows_core::Result<MPEG_DATE_AND_TIME>;
}
impl IDVB_TDT_Vtbl {
    pub const fn new<Identity: IDVB_TDT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDVB_TDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_TDT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist)).into()
            }
        }
        unsafe extern "system" fn GetUTCTime<Identity: IDVB_TDT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmdtval: *mut MPEG_DATE_AND_TIME) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_TDT_Impl::GetUTCTime(this) {
                    Ok(ok__) => {
                        pmdtval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetUTCTime: GetUTCTime::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_TDT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_TDT {}
windows_core::imp::define_interface!(IDVB_TOT, IDVB_TOT_Vtbl, 0x83295d6a_faba_4ee1_9b15_8067696910ae);
windows_core::imp::interface_hierarchy!(IDVB_TOT, windows_core::IUnknown);
impl IDVB_TOT {
    pub unsafe fn Initialize<P0>(&self, psectionlist: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ISectionList>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psectionlist.param().abi()).ok() }
    }
    pub unsafe fn GetUTCTime(&self) -> windows_core::Result<MPEG_DATE_AND_TIME> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetUTCTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfTableDescriptors)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTableDescriptorByIndex)(windows_core::Interface::as_raw(self), dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: Option<*mut u32>, ppdescriptor: *mut Option<IGenericDescriptor>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTableDescriptorByTag)(windows_core::Interface::as_raw(self), btag, pdwcookie.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppdescriptor)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVB_TOT_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetUTCTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut MPEG_DATE_AND_TIME) -> windows_core::HRESULT,
    pub GetCountOfTableDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTableDescriptorByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTableDescriptorByTag: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDVB_TOT_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psectionlist: windows_core::Ref<'_, ISectionList>) -> windows_core::Result<()>;
    fn GetUTCTime(&self) -> windows_core::Result<MPEG_DATE_AND_TIME>;
    fn GetCountOfTableDescriptors(&self) -> windows_core::Result<u32>;
    fn GetTableDescriptorByIndex(&self, dwindex: u32) -> windows_core::Result<IGenericDescriptor>;
    fn GetTableDescriptorByTag(&self, btag: u8, pdwcookie: *mut u32, ppdescriptor: windows_core::OutRef<'_, IGenericDescriptor>) -> windows_core::Result<()>;
}
impl IDVB_TOT_Vtbl {
    pub const fn new<Identity: IDVB_TOT_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDVB_TOT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psectionlist: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_TOT_Impl::Initialize(this, core::mem::transmute_copy(&psectionlist)).into()
            }
        }
        unsafe extern "system" fn GetUTCTime<Identity: IDVB_TOT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmdtval: *mut MPEG_DATE_AND_TIME) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_TOT_Impl::GetUTCTime(this) {
                    Ok(ok__) => {
                        pmdtval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfTableDescriptors<Identity: IDVB_TOT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_TOT_Impl::GetCountOfTableDescriptors(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByIndex<Identity: IDVB_TOT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDVB_TOT_Impl::GetTableDescriptorByIndex(this, core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTableDescriptorByTag<Identity: IDVB_TOT_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, btag: u8, pdwcookie: *mut u32, ppdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDVB_TOT_Impl::GetTableDescriptorByTag(this, core::mem::transmute_copy(&btag), core::mem::transmute_copy(&pdwcookie), core::mem::transmute_copy(&ppdescriptor)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetUTCTime: GetUTCTime::<Identity, OFFSET>,
            GetCountOfTableDescriptors: GetCountOfTableDescriptors::<Identity, OFFSET>,
            GetTableDescriptorByIndex: GetTableDescriptorByIndex::<Identity, OFFSET>,
            GetTableDescriptorByTag: GetTableDescriptorByTag::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDVB_TOT as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDVB_TOT {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDigitalCableLocator, IDigitalCableLocator_Vtbl, 0x48f66a11_171a_419a_9525_beeecd51584c);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDigitalCableLocator {
    type Target = IATSCLocator2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDigitalCableLocator, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ILocator, IDigitalLocator, IATSCLocator, IATSCLocator2);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDigitalCableLocator_Vtbl {
    pub base__: IATSCLocator2_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDigitalCableLocator_Impl: IATSCLocator2_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDigitalCableLocator_Vtbl {
    pub const fn new<Identity: IDigitalCableLocator_Impl, const OFFSET: isize>() -> Self {
        Self { base__: IATSCLocator2_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDigitalCableLocator as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ILocator as windows_core::Interface>::IID || iid == &<IDigitalLocator as windows_core::Interface>::IID || iid == &<IATSCLocator as windows_core::Interface>::IID || iid == &<IATSCLocator2 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDigitalCableLocator {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDigitalCableTuneRequest, IDigitalCableTuneRequest_Vtbl, 0xbad7753b_6b37_4810_ae57_3ce0c4a9e6cb);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDigitalCableTuneRequest {
    type Target = IATSCChannelTuneRequest;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDigitalCableTuneRequest, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuneRequest, IChannelTuneRequest, IATSCChannelTuneRequest);
#[cfg(feature = "Win32_System_Com")]
impl IDigitalCableTuneRequest {
    pub unsafe fn MajorChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MajorChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMajorChannel(&self, majorchannel: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMajorChannel)(windows_core::Interface::as_raw(self), majorchannel).ok() }
    }
    pub unsafe fn SourceID(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SourceID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetSourceID(&self, sourceid: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSourceID)(windows_core::Interface::as_raw(self), sourceid).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDigitalCableTuneRequest_Vtbl {
    pub base__: IATSCChannelTuneRequest_Vtbl,
    pub MajorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMajorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub SourceID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetSourceID: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDigitalCableTuneRequest_Impl: IATSCChannelTuneRequest_Impl {
    fn MajorChannel(&self) -> windows_core::Result<i32>;
    fn SetMajorChannel(&self, majorchannel: i32) -> windows_core::Result<()>;
    fn SourceID(&self) -> windows_core::Result<i32>;
    fn SetSourceID(&self, sourceid: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDigitalCableTuneRequest_Vtbl {
    pub const fn new<Identity: IDigitalCableTuneRequest_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn MajorChannel<Identity: IDigitalCableTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmajorchannel: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDigitalCableTuneRequest_Impl::MajorChannel(this) {
                    Ok(ok__) => {
                        pmajorchannel.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMajorChannel<Identity: IDigitalCableTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, majorchannel: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDigitalCableTuneRequest_Impl::SetMajorChannel(this, core::mem::transmute_copy(&majorchannel)).into()
            }
        }
        unsafe extern "system" fn SourceID<Identity: IDigitalCableTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psourceid: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDigitalCableTuneRequest_Impl::SourceID(this) {
                    Ok(ok__) => {
                        psourceid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetSourceID<Identity: IDigitalCableTuneRequest_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, sourceid: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDigitalCableTuneRequest_Impl::SetSourceID(this, core::mem::transmute_copy(&sourceid)).into()
            }
        }
        Self {
            base__: IATSCChannelTuneRequest_Vtbl::new::<Identity, OFFSET>(),
            MajorChannel: MajorChannel::<Identity, OFFSET>,
            SetMajorChannel: SetMajorChannel::<Identity, OFFSET>,
            SourceID: SourceID::<Identity, OFFSET>,
            SetSourceID: SetSourceID::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDigitalCableTuneRequest as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuneRequest as windows_core::Interface>::IID || iid == &<IChannelTuneRequest as windows_core::Interface>::IID || iid == &<IATSCChannelTuneRequest as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDigitalCableTuneRequest {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDigitalCableTuningSpace, IDigitalCableTuningSpace_Vtbl, 0x013f9f9c_b449_4ec7_a6d2_9d4f2fc70ae5);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDigitalCableTuningSpace {
    type Target = IATSCTuningSpace;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDigitalCableTuningSpace, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ITuningSpace, IAnalogTVTuningSpace, IATSCTuningSpace);
#[cfg(feature = "Win32_System_Com")]
impl IDigitalCableTuningSpace {
    pub unsafe fn MinMajorChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MinMajorChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMinMajorChannel(&self, newminmajorchannelval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMinMajorChannel)(windows_core::Interface::as_raw(self), newminmajorchannelval).ok() }
    }
    pub unsafe fn MaxMajorChannel(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MaxMajorChannel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMaxMajorChannel(&self, newmaxmajorchannelval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMaxMajorChannel)(windows_core::Interface::as_raw(self), newmaxmajorchannelval).ok() }
    }
    pub unsafe fn MinSourceID(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MinSourceID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMinSourceID(&self, newminsourceidval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMinSourceID)(windows_core::Interface::as_raw(self), newminsourceidval).ok() }
    }
    pub unsafe fn MaxSourceID(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MaxSourceID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMaxSourceID(&self, newmaxsourceidval: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMaxSourceID)(windows_core::Interface::as_raw(self), newmaxsourceidval).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDigitalCableTuningSpace_Vtbl {
    pub base__: IATSCTuningSpace_Vtbl,
    pub MinMajorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMinMajorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub MaxMajorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMaxMajorChannel: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub MinSourceID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMinSourceID: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub MaxSourceID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMaxSourceID: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDigitalCableTuningSpace_Impl: IATSCTuningSpace_Impl {
    fn MinMajorChannel(&self) -> windows_core::Result<i32>;
    fn SetMinMajorChannel(&self, newminmajorchannelval: i32) -> windows_core::Result<()>;
    fn MaxMajorChannel(&self) -> windows_core::Result<i32>;
    fn SetMaxMajorChannel(&self, newmaxmajorchannelval: i32) -> windows_core::Result<()>;
    fn MinSourceID(&self) -> windows_core::Result<i32>;
    fn SetMinSourceID(&self, newminsourceidval: i32) -> windows_core::Result<()>;
    fn MaxSourceID(&self) -> windows_core::Result<i32>;
    fn SetMaxSourceID(&self, newmaxsourceidval: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDigitalCableTuningSpace_Vtbl {
    pub const fn new<Identity: IDigitalCableTuningSpace_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn MinMajorChannel<Identity: IDigitalCableTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, minmajorchannelval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDigitalCableTuningSpace_Impl::MinMajorChannel(this) {
                    Ok(ok__) => {
                        minmajorchannelval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMinMajorChannel<Identity: IDigitalCableTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newminmajorchannelval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDigitalCableTuningSpace_Impl::SetMinMajorChannel(this, core::mem::transmute_copy(&newminmajorchannelval)).into()
            }
        }
        unsafe extern "system" fn MaxMajorChannel<Identity: IDigitalCableTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, maxmajorchannelval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDigitalCableTuningSpace_Impl::MaxMajorChannel(this) {
                    Ok(ok__) => {
                        maxmajorchannelval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMaxMajorChannel<Identity: IDigitalCableTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newmaxmajorchannelval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDigitalCableTuningSpace_Impl::SetMaxMajorChannel(this, core::mem::transmute_copy(&newmaxmajorchannelval)).into()
            }
        }
        unsafe extern "system" fn MinSourceID<Identity: IDigitalCableTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, minsourceidval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDigitalCableTuningSpace_Impl::MinSourceID(this) {
                    Ok(ok__) => {
                        minsourceidval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMinSourceID<Identity: IDigitalCableTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newminsourceidval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDigitalCableTuningSpace_Impl::SetMinSourceID(this, core::mem::transmute_copy(&newminsourceidval)).into()
            }
        }
        unsafe extern "system" fn MaxSourceID<Identity: IDigitalCableTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, maxsourceidval: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDigitalCableTuningSpace_Impl::MaxSourceID(this) {
                    Ok(ok__) => {
                        maxsourceidval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMaxSourceID<Identity: IDigitalCableTuningSpace_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newmaxsourceidval: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDigitalCableTuningSpace_Impl::SetMaxSourceID(this, core::mem::transmute_copy(&newmaxsourceidval)).into()
            }
        }
        Self {
            base__: IATSCTuningSpace_Vtbl::new::<Identity, OFFSET>(),
            MinMajorChannel: MinMajorChannel::<Identity, OFFSET>,
            SetMinMajorChannel: SetMinMajorChannel::<Identity, OFFSET>,
            MaxMajorChannel: MaxMajorChannel::<Identity, OFFSET>,
            SetMaxMajorChannel: SetMaxMajorChannel::<Identity, OFFSET>,
            MinSourceID: MinSourceID::<Identity, OFFSET>,
            SetMinSourceID: SetMinSourceID::<Identity, OFFSET>,
            MaxSourceID: MaxSourceID::<Identity, OFFSET>,
            SetMaxSourceID: SetMaxSourceID::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDigitalCableTuningSpace as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ITuningSpace as windows_core::Interface>::IID || iid == &<IAnalogTVTuningSpace as windows_core::Interface>::IID || iid == &<IATSCTuningSpace as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDigitalCableTuningSpace {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IDigitalLocator, IDigitalLocator_Vtbl, 0x19b595d8_839a_47f0_96df_4f194f3c768c);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IDigitalLocator {
    type Target = ILocator;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IDigitalLocator, windows_core::IUnknown, super::super::super::System::Com::IDispatch, ILocator);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDigitalLocator_Vtbl {
    pub base__: ILocator_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDigitalLocator_Impl: ILocator_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDigitalLocator_Vtbl {
    pub const fn new<Identity: IDigitalLocator_Impl, const OFFSET: isize>() -> Self {
        Self { base__: ILocator_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDigitalLocator as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<ILocator as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDigitalLocator {}
windows_core::imp::define_interface!(IDvbCableDeliverySystemDescriptor, IDvbCableDeliverySystemDescriptor_Vtbl, 0xdfb98e36_9e1a_4862_9946_993a4e59017b);
windows_core::imp::interface_hierarchy!(IDvbCableDeliverySystemDescriptor, windows_core::IUnknown);
impl IDvbCableDeliverySystemDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetFrequency(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFrequency)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetFECOuter(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFECOuter)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetModulation(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetModulation)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSymbolRate(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSymbolRate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetFECInner(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFECInner)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbCableDeliverySystemDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetFECOuter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetModulation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetSymbolRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetFECInner: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbCableDeliverySystemDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetFrequency(&self) -> windows_core::Result<u32>;
    fn GetFECOuter(&self) -> windows_core::Result<u8>;
    fn GetModulation(&self) -> windows_core::Result<u8>;
    fn GetSymbolRate(&self) -> windows_core::Result<u32>;
    fn GetFECInner(&self) -> windows_core::Result<u8>;
}
impl IDvbCableDeliverySystemDescriptor_Vtbl {
    pub const fn new<Identity: IDvbCableDeliverySystemDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbCableDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbCableDeliverySystemDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbCableDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbCableDeliverySystemDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFrequency<Identity: IDvbCableDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbCableDeliverySystemDescriptor_Impl::GetFrequency(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFECOuter<Identity: IDvbCableDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbCableDeliverySystemDescriptor_Impl::GetFECOuter(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetModulation<Identity: IDvbCableDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbCableDeliverySystemDescriptor_Impl::GetModulation(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSymbolRate<Identity: IDvbCableDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbCableDeliverySystemDescriptor_Impl::GetSymbolRate(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFECInner<Identity: IDvbCableDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbCableDeliverySystemDescriptor_Impl::GetFECInner(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetFrequency: GetFrequency::<Identity, OFFSET>,
            GetFECOuter: GetFECOuter::<Identity, OFFSET>,
            GetModulation: GetModulation::<Identity, OFFSET>,
            GetSymbolRate: GetSymbolRate::<Identity, OFFSET>,
            GetFECInner: GetFECInner::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbCableDeliverySystemDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbCableDeliverySystemDescriptor {}
windows_core::imp::define_interface!(IDvbComponentDescriptor, IDvbComponentDescriptor_Vtbl, 0x91e405cf_80e7_457f_9096_1b9d1ce32141);
windows_core::imp::interface_hierarchy!(IDvbComponentDescriptor, windows_core::IUnknown);
impl IDvbComponentDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetStreamContent(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetStreamContent)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetComponentType(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetComponentType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetComponentTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetComponentTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLanguageCode(&self, pszcode: &mut [u8; 4]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetLanguageCode)(windows_core::Interface::as_raw(self), core::mem::transmute(pszcode.as_ptr())).ok() }
    }
    pub unsafe fn GetTextW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTextW)(windows_core::Interface::as_raw(self), convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbComponentDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetStreamContent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetComponentType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetComponentTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLanguageCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetTextW: unsafe extern "system" fn(*mut core::ffi::c_void, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDvbComponentDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetStreamContent(&self) -> windows_core::Result<u8>;
    fn GetComponentType(&self) -> windows_core::Result<u8>;
    fn GetComponentTag(&self) -> windows_core::Result<u8>;
    fn GetLanguageCode(&self, pszcode: *mut u8) -> windows_core::Result<()>;
    fn GetTextW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
}
impl IDvbComponentDescriptor_Vtbl {
    pub const fn new<Identity: IDvbComponentDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbComponentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbComponentDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbComponentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbComponentDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetStreamContent<Identity: IDvbComponentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbComponentDescriptor_Impl::GetStreamContent(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetComponentType<Identity: IDvbComponentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbComponentDescriptor_Impl::GetComponentType(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetComponentTag<Identity: IDvbComponentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbComponentDescriptor_Impl::GetComponentTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLanguageCode<Identity: IDvbComponentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszcode: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbComponentDescriptor_Impl::GetLanguageCode(this, core::mem::transmute_copy(&pszcode)).into()
            }
        }
        unsafe extern "system" fn GetTextW<Identity: IDvbComponentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, convmode: DVB_STRCONV_MODE, pbstrtext: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbComponentDescriptor_Impl::GetTextW(this, core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrtext.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetStreamContent: GetStreamContent::<Identity, OFFSET>,
            GetComponentType: GetComponentType::<Identity, OFFSET>,
            GetComponentTag: GetComponentTag::<Identity, OFFSET>,
            GetLanguageCode: GetLanguageCode::<Identity, OFFSET>,
            GetTextW: GetTextW::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbComponentDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbComponentDescriptor {}
windows_core::imp::define_interface!(IDvbContentDescriptor, IDvbContentDescriptor_Vtbl, 0x2e883881_a467_412a_9d63_6f2b6da05bf0);
windows_core::imp::interface_hierarchy!(IDvbContentDescriptor, windows_core::IUnknown);
impl IDvbContentDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordContentNibbles(&self, brecordindex: u8, pbvallevel1: *mut u8, pbvallevel2: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordContentNibbles)(windows_core::Interface::as_raw(self), brecordindex, pbvallevel1 as _, pbvallevel2 as _).ok() }
    }
    pub unsafe fn GetRecordUserNibbles(&self, brecordindex: u8, pbval1: *mut u8, pbval2: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordUserNibbles)(windows_core::Interface::as_raw(self), brecordindex, pbval1 as _, pbval2 as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbContentDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordContentNibbles: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8, *mut u8) -> windows_core::HRESULT,
    pub GetRecordUserNibbles: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbContentDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordContentNibbles(&self, brecordindex: u8, pbvallevel1: *mut u8, pbvallevel2: *mut u8) -> windows_core::Result<()>;
    fn GetRecordUserNibbles(&self, brecordindex: u8, pbval1: *mut u8, pbval2: *mut u8) -> windows_core::Result<()>;
}
impl IDvbContentDescriptor_Vtbl {
    pub const fn new<Identity: IDvbContentDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbContentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbContentDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbContentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbContentDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbContentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbContentDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordContentNibbles<Identity: IDvbContentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pbvallevel1: *mut u8, pbvallevel2: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbContentDescriptor_Impl::GetRecordContentNibbles(this, core::mem::transmute_copy(&brecordindex), core::mem::transmute_copy(&pbvallevel1), core::mem::transmute_copy(&pbvallevel2)).into()
            }
        }
        unsafe extern "system" fn GetRecordUserNibbles<Identity: IDvbContentDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pbval1: *mut u8, pbval2: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbContentDescriptor_Impl::GetRecordUserNibbles(this, core::mem::transmute_copy(&brecordindex), core::mem::transmute_copy(&pbval1), core::mem::transmute_copy(&pbval2)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordContentNibbles: GetRecordContentNibbles::<Identity, OFFSET>,
            GetRecordUserNibbles: GetRecordUserNibbles::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbContentDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbContentDescriptor {}
windows_core::imp::define_interface!(IDvbContentIdentifierDescriptor, IDvbContentIdentifierDescriptor_Vtbl, 0x05e0c1ea_f661_4053_9fbf_d93b28359838);
windows_core::imp::interface_hierarchy!(IDvbContentIdentifierDescriptor, windows_core::IUnknown);
impl IDvbContentIdentifierDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCrid(&self, brecordindex: u8, pbtype: *mut u8, pblocation: *mut u8, pblength: *mut u8, ppbbytes: *mut *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordCrid)(windows_core::Interface::as_raw(self), brecordindex, pbtype as _, pblocation as _, pblength as _, ppbbytes as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbContentIdentifierDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordCrid: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8, *mut u8, *mut u8, *mut *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbContentIdentifierDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordCrid(&self, brecordindex: u8, pbtype: *mut u8, pblocation: *mut u8, pblength: *mut u8, ppbbytes: *mut *mut u8) -> windows_core::Result<()>;
}
impl IDvbContentIdentifierDescriptor_Vtbl {
    pub const fn new<Identity: IDvbContentIdentifierDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbContentIdentifierDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbContentIdentifierDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbContentIdentifierDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbContentIdentifierDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbContentIdentifierDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbContentIdentifierDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCrid<Identity: IDvbContentIdentifierDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pbtype: *mut u8, pblocation: *mut u8, pblength: *mut u8, ppbbytes: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbContentIdentifierDescriptor_Impl::GetRecordCrid(this, core::mem::transmute_copy(&brecordindex), core::mem::transmute_copy(&pbtype), core::mem::transmute_copy(&pblocation), core::mem::transmute_copy(&pblength), core::mem::transmute_copy(&ppbbytes)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordCrid: GetRecordCrid::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbContentIdentifierDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbContentIdentifierDescriptor {}
windows_core::imp::define_interface!(IDvbDataBroadcastDescriptor, IDvbDataBroadcastDescriptor_Vtbl, 0xd1ebc1d6_8b60_4c20_9caf_e59382e7c400);
windows_core::imp::interface_hierarchy!(IDvbDataBroadcastDescriptor, windows_core::IUnknown);
impl IDvbDataBroadcastDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDataBroadcastID(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDataBroadcastID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetComponentTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetComponentTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSelectorLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSelectorLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSelectorBytes(&self, pblen: *mut u8, pbval: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSelectorBytes)(windows_core::Interface::as_raw(self), pblen as _, pbval as _).ok() }
    }
    pub unsafe fn GetLangID(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLangID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTextLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTextLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetText(&self, pblen: *mut u8, pbval: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetText)(windows_core::Interface::as_raw(self), pblen as _, pbval as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbDataBroadcastDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetDataBroadcastID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetComponentTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetSelectorLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetSelectorBytes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8, *mut u8) -> windows_core::HRESULT,
    pub GetLangID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetTextLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetText: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbDataBroadcastDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetDataBroadcastID(&self) -> windows_core::Result<u16>;
    fn GetComponentTag(&self) -> windows_core::Result<u8>;
    fn GetSelectorLength(&self) -> windows_core::Result<u8>;
    fn GetSelectorBytes(&self, pblen: *mut u8, pbval: *mut u8) -> windows_core::Result<()>;
    fn GetLangID(&self) -> windows_core::Result<u32>;
    fn GetTextLength(&self) -> windows_core::Result<u8>;
    fn GetText(&self, pblen: *mut u8, pbval: *mut u8) -> windows_core::Result<()>;
}
impl IDvbDataBroadcastDescriptor_Vtbl {
    pub const fn new<Identity: IDvbDataBroadcastDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbDataBroadcastDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDataBroadcastDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbDataBroadcastDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDataBroadcastDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDataBroadcastID<Identity: IDvbDataBroadcastDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDataBroadcastDescriptor_Impl::GetDataBroadcastID(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetComponentTag<Identity: IDvbDataBroadcastDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDataBroadcastDescriptor_Impl::GetComponentTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSelectorLength<Identity: IDvbDataBroadcastDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDataBroadcastDescriptor_Impl::GetSelectorLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSelectorBytes<Identity: IDvbDataBroadcastDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pblen: *mut u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbDataBroadcastDescriptor_Impl::GetSelectorBytes(this, core::mem::transmute_copy(&pblen), core::mem::transmute_copy(&pbval)).into()
            }
        }
        unsafe extern "system" fn GetLangID<Identity: IDvbDataBroadcastDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDataBroadcastDescriptor_Impl::GetLangID(this) {
                    Ok(ok__) => {
                        pulval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTextLength<Identity: IDvbDataBroadcastDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDataBroadcastDescriptor_Impl::GetTextLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetText<Identity: IDvbDataBroadcastDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pblen: *mut u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbDataBroadcastDescriptor_Impl::GetText(this, core::mem::transmute_copy(&pblen), core::mem::transmute_copy(&pbval)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetDataBroadcastID: GetDataBroadcastID::<Identity, OFFSET>,
            GetComponentTag: GetComponentTag::<Identity, OFFSET>,
            GetSelectorLength: GetSelectorLength::<Identity, OFFSET>,
            GetSelectorBytes: GetSelectorBytes::<Identity, OFFSET>,
            GetLangID: GetLangID::<Identity, OFFSET>,
            GetTextLength: GetTextLength::<Identity, OFFSET>,
            GetText: GetText::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbDataBroadcastDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbDataBroadcastDescriptor {}
windows_core::imp::define_interface!(IDvbDataBroadcastIDDescriptor, IDvbDataBroadcastIDDescriptor_Vtbl, 0x5f26f518_65c8_4048_91f2_9290f59f7b90);
windows_core::imp::interface_hierarchy!(IDvbDataBroadcastIDDescriptor, windows_core::IUnknown);
impl IDvbDataBroadcastIDDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDataBroadcastID(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDataBroadcastID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetIDSelectorBytes(&self, pblen: *mut u8, pbval: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIDSelectorBytes)(windows_core::Interface::as_raw(self), pblen as _, pbval as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbDataBroadcastIDDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetDataBroadcastID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetIDSelectorBytes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbDataBroadcastIDDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetDataBroadcastID(&self) -> windows_core::Result<u16>;
    fn GetIDSelectorBytes(&self, pblen: *mut u8, pbval: *mut u8) -> windows_core::Result<()>;
}
impl IDvbDataBroadcastIDDescriptor_Vtbl {
    pub const fn new<Identity: IDvbDataBroadcastIDDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbDataBroadcastIDDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDataBroadcastIDDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbDataBroadcastIDDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDataBroadcastIDDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDataBroadcastID<Identity: IDvbDataBroadcastIDDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDataBroadcastIDDescriptor_Impl::GetDataBroadcastID(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetIDSelectorBytes<Identity: IDvbDataBroadcastIDDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pblen: *mut u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbDataBroadcastIDDescriptor_Impl::GetIDSelectorBytes(this, core::mem::transmute_copy(&pblen), core::mem::transmute_copy(&pbval)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetDataBroadcastID: GetDataBroadcastID::<Identity, OFFSET>,
            GetIDSelectorBytes: GetIDSelectorBytes::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbDataBroadcastIDDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbDataBroadcastIDDescriptor {}
windows_core::imp::define_interface!(IDvbDefaultAuthorityDescriptor, IDvbDefaultAuthorityDescriptor_Vtbl, 0x05ec24d1_3a31_44e7_b408_67c60a352276);
windows_core::imp::interface_hierarchy!(IDvbDefaultAuthorityDescriptor, windows_core::IUnknown);
impl IDvbDefaultAuthorityDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDefaultAuthority(&self, pblength: *mut u8, ppbbytes: *mut *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDefaultAuthority)(windows_core::Interface::as_raw(self), pblength as _, ppbbytes as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbDefaultAuthorityDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetDefaultAuthority: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8, *mut *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbDefaultAuthorityDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetDefaultAuthority(&self, pblength: *mut u8, ppbbytes: *mut *mut u8) -> windows_core::Result<()>;
}
impl IDvbDefaultAuthorityDescriptor_Vtbl {
    pub const fn new<Identity: IDvbDefaultAuthorityDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbDefaultAuthorityDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDefaultAuthorityDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbDefaultAuthorityDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbDefaultAuthorityDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDefaultAuthority<Identity: IDvbDefaultAuthorityDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pblength: *mut u8, ppbbytes: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbDefaultAuthorityDescriptor_Impl::GetDefaultAuthority(this, core::mem::transmute_copy(&pblength), core::mem::transmute_copy(&ppbbytes)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetDefaultAuthority: GetDefaultAuthority::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbDefaultAuthorityDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbDefaultAuthorityDescriptor {}
windows_core::imp::define_interface!(IDvbExtendedEventDescriptor, IDvbExtendedEventDescriptor_Vtbl, 0xc9b22eca_85f4_499f_b1db_efa93a91ee57);
windows_core::imp::interface_hierarchy!(IDvbExtendedEventDescriptor, windows_core::IUnknown);
impl IDvbExtendedEventDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDescriptorNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDescriptorNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLastDescriptorNumber(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLastDescriptorNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLanguageCode(&self, pszcode: &mut [u8; 4]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetLanguageCode)(windows_core::Interface::as_raw(self), core::mem::transmute(pszcode.as_ptr())).ok() }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordItemW(&self, brecordindex: u8, convmode: DVB_STRCONV_MODE, pbstrdesc: *mut windows_core::BSTR, pbstritem: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordItemW)(windows_core::Interface::as_raw(self), brecordindex, convmode, core::mem::transmute(pbstrdesc), core::mem::transmute(pbstritem)).ok() }
    }
    pub unsafe fn GetConcatenatedItemW<P0>(&self, pfollowingdescriptor: P0, convmode: DVB_STRCONV_MODE, pbstrdesc: *mut windows_core::BSTR, pbstritem: *mut windows_core::BSTR) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDvbExtendedEventDescriptor>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetConcatenatedItemW)(windows_core::Interface::as_raw(self), pfollowingdescriptor.param().abi(), convmode, core::mem::transmute(pbstrdesc), core::mem::transmute(pbstritem)).ok() }
    }
    pub unsafe fn GetTextW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTextW)(windows_core::Interface::as_raw(self), convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetConcatenatedTextW<P0>(&self, followingdescriptor: P0, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>
    where
        P0: windows_core::Param<IDvbExtendedEventDescriptor>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetConcatenatedTextW)(windows_core::Interface::as_raw(self), followingdescriptor.param().abi(), convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetRecordItemRawBytes(&self, brecordindex: u8, ppbrawitem: *mut *mut u8, pbitemlength: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordItemRawBytes)(windows_core::Interface::as_raw(self), brecordindex, ppbrawitem as _, pbitemlength as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbExtendedEventDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetDescriptorNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLastDescriptorNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLanguageCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordItemW: unsafe extern "system" fn(*mut core::ffi::c_void, u8, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetConcatenatedItemW: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTextW: unsafe extern "system" fn(*mut core::ffi::c_void, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetConcatenatedTextW: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRecordItemRawBytes: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut *mut u8, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbExtendedEventDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetDescriptorNumber(&self) -> windows_core::Result<u8>;
    fn GetLastDescriptorNumber(&self) -> windows_core::Result<u8>;
    fn GetLanguageCode(&self, pszcode: *mut u8) -> windows_core::Result<()>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordItemW(&self, brecordindex: u8, convmode: DVB_STRCONV_MODE, pbstrdesc: *mut windows_core::BSTR, pbstritem: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn GetConcatenatedItemW(&self, pfollowingdescriptor: windows_core::Ref<'_, IDvbExtendedEventDescriptor>, convmode: DVB_STRCONV_MODE, pbstrdesc: *mut windows_core::BSTR, pbstritem: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn GetTextW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
    fn GetConcatenatedTextW(&self, followingdescriptor: windows_core::Ref<'_, IDvbExtendedEventDescriptor>, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
    fn GetRecordItemRawBytes(&self, brecordindex: u8, ppbrawitem: *mut *mut u8, pbitemlength: *mut u8) -> windows_core::Result<()>;
}
impl IDvbExtendedEventDescriptor_Vtbl {
    pub const fn new<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbExtendedEventDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbExtendedEventDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDescriptorNumber<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbExtendedEventDescriptor_Impl::GetDescriptorNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLastDescriptorNumber<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbExtendedEventDescriptor_Impl::GetLastDescriptorNumber(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLanguageCode<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszcode: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbExtendedEventDescriptor_Impl::GetLanguageCode(this, core::mem::transmute_copy(&pszcode)).into()
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbExtendedEventDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordItemW<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, convmode: DVB_STRCONV_MODE, pbstrdesc: *mut *mut core::ffi::c_void, pbstritem: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbExtendedEventDescriptor_Impl::GetRecordItemW(this, core::mem::transmute_copy(&brecordindex), core::mem::transmute_copy(&convmode), core::mem::transmute_copy(&pbstrdesc), core::mem::transmute_copy(&pbstritem)).into()
            }
        }
        unsafe extern "system" fn GetConcatenatedItemW<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfollowingdescriptor: *mut core::ffi::c_void, convmode: DVB_STRCONV_MODE, pbstrdesc: *mut *mut core::ffi::c_void, pbstritem: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbExtendedEventDescriptor_Impl::GetConcatenatedItemW(this, core::mem::transmute_copy(&pfollowingdescriptor), core::mem::transmute_copy(&convmode), core::mem::transmute_copy(&pbstrdesc), core::mem::transmute_copy(&pbstritem)).into()
            }
        }
        unsafe extern "system" fn GetTextW<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, convmode: DVB_STRCONV_MODE, pbstrtext: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbExtendedEventDescriptor_Impl::GetTextW(this, core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrtext.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetConcatenatedTextW<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, followingdescriptor: *mut core::ffi::c_void, convmode: DVB_STRCONV_MODE, pbstrtext: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbExtendedEventDescriptor_Impl::GetConcatenatedTextW(this, core::mem::transmute_copy(&followingdescriptor), core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrtext.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordItemRawBytes<Identity: IDvbExtendedEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, ppbrawitem: *mut *mut u8, pbitemlength: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbExtendedEventDescriptor_Impl::GetRecordItemRawBytes(this, core::mem::transmute_copy(&brecordindex), core::mem::transmute_copy(&ppbrawitem), core::mem::transmute_copy(&pbitemlength)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetDescriptorNumber: GetDescriptorNumber::<Identity, OFFSET>,
            GetLastDescriptorNumber: GetLastDescriptorNumber::<Identity, OFFSET>,
            GetLanguageCode: GetLanguageCode::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordItemW: GetRecordItemW::<Identity, OFFSET>,
            GetConcatenatedItemW: GetConcatenatedItemW::<Identity, OFFSET>,
            GetTextW: GetTextW::<Identity, OFFSET>,
            GetConcatenatedTextW: GetConcatenatedTextW::<Identity, OFFSET>,
            GetRecordItemRawBytes: GetRecordItemRawBytes::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbExtendedEventDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbExtendedEventDescriptor {}
windows_core::imp::define_interface!(IDvbFrequencyListDescriptor, IDvbFrequencyListDescriptor_Vtbl, 0x1cadb613_e1dd_4512_afa8_bb7a007ef8b1);
windows_core::imp::interface_hierarchy!(IDvbFrequencyListDescriptor, windows_core::IUnknown);
impl IDvbFrequencyListDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCodingType(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCodingType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCentreFrequency(&self, brecordindex: u8) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCentreFrequency)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbFrequencyListDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCodingType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordCentreFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32) -> windows_core::HRESULT,
}
pub trait IDvbFrequencyListDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCodingType(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordCentreFrequency(&self, brecordindex: u8) -> windows_core::Result<u32>;
}
impl IDvbFrequencyListDescriptor_Vtbl {
    pub const fn new<Identity: IDvbFrequencyListDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbFrequencyListDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbFrequencyListDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbFrequencyListDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbFrequencyListDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCodingType<Identity: IDvbFrequencyListDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbFrequencyListDescriptor_Impl::GetCodingType(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbFrequencyListDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbFrequencyListDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCentreFrequency<Identity: IDvbFrequencyListDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbFrequencyListDescriptor_Impl::GetRecordCentreFrequency(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCodingType: GetCodingType::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordCentreFrequency: GetRecordCentreFrequency::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbFrequencyListDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbFrequencyListDescriptor {}
windows_core::imp::define_interface!(IDvbHDSimulcastLogicalChannelDescriptor, IDvbHDSimulcastLogicalChannelDescriptor_Vtbl, 0x1ea8b738_a307_4680_9e26_d0a908c824f4);
impl core::ops::Deref for IDvbHDSimulcastLogicalChannelDescriptor {
    type Target = IDvbLogicalChannelDescriptor2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDvbHDSimulcastLogicalChannelDescriptor, windows_core::IUnknown, IDvbLogicalChannelDescriptor, IDvbLogicalChannelDescriptor2);
#[repr(C)]
#[doc(hidden)]
pub struct IDvbHDSimulcastLogicalChannelDescriptor_Vtbl {
    pub base__: IDvbLogicalChannelDescriptor2_Vtbl,
}
pub trait IDvbHDSimulcastLogicalChannelDescriptor_Impl: IDvbLogicalChannelDescriptor2_Impl {}
impl IDvbHDSimulcastLogicalChannelDescriptor_Vtbl {
    pub const fn new<Identity: IDvbHDSimulcastLogicalChannelDescriptor_Impl, const OFFSET: isize>() -> Self {
        Self { base__: IDvbLogicalChannelDescriptor2_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbHDSimulcastLogicalChannelDescriptor as windows_core::Interface>::IID || iid == &<IDvbLogicalChannelDescriptor as windows_core::Interface>::IID || iid == &<IDvbLogicalChannelDescriptor2 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbHDSimulcastLogicalChannelDescriptor {}
windows_core::imp::define_interface!(IDvbLinkageDescriptor, IDvbLinkageDescriptor_Vtbl, 0x1cdf8b31_994a_46fc_acfd_6a6be8934dd5);
windows_core::imp::interface_hierarchy!(IDvbLinkageDescriptor, windows_core::IUnknown);
impl IDvbLinkageDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTSId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTSId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetONId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetONId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetServiceId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLinkageType(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLinkageType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetPrivateDataLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPrivateDataLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetPrivateData(&self, pblen: *mut u8, pbdata: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetPrivateData)(windows_core::Interface::as_raw(self), pblen as _, pbdata as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbLinkageDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetTSId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetONId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetServiceId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetLinkageType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetPrivateDataLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetPrivateData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbLinkageDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetTSId(&self) -> windows_core::Result<u16>;
    fn GetONId(&self) -> windows_core::Result<u16>;
    fn GetServiceId(&self) -> windows_core::Result<u16>;
    fn GetLinkageType(&self) -> windows_core::Result<u8>;
    fn GetPrivateDataLength(&self) -> windows_core::Result<u8>;
    fn GetPrivateData(&self, pblen: *mut u8, pbdata: *mut u8) -> windows_core::Result<()>;
}
impl IDvbLinkageDescriptor_Vtbl {
    pub const fn new<Identity: IDvbLinkageDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbLinkageDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLinkageDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbLinkageDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLinkageDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTSId<Identity: IDvbLinkageDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLinkageDescriptor_Impl::GetTSId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetONId<Identity: IDvbLinkageDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLinkageDescriptor_Impl::GetONId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetServiceId<Identity: IDvbLinkageDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLinkageDescriptor_Impl::GetServiceId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLinkageType<Identity: IDvbLinkageDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLinkageDescriptor_Impl::GetLinkageType(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPrivateDataLength<Identity: IDvbLinkageDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLinkageDescriptor_Impl::GetPrivateDataLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPrivateData<Identity: IDvbLinkageDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pblen: *mut u8, pbdata: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbLinkageDescriptor_Impl::GetPrivateData(this, core::mem::transmute_copy(&pblen), core::mem::transmute_copy(&pbdata)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetTSId: GetTSId::<Identity, OFFSET>,
            GetONId: GetONId::<Identity, OFFSET>,
            GetServiceId: GetServiceId::<Identity, OFFSET>,
            GetLinkageType: GetLinkageType::<Identity, OFFSET>,
            GetPrivateDataLength: GetPrivateDataLength::<Identity, OFFSET>,
            GetPrivateData: GetPrivateData::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbLinkageDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbLinkageDescriptor {}
windows_core::imp::define_interface!(IDvbLogicalChannel2Descriptor, IDvbLogicalChannel2Descriptor_Vtbl, 0xf69c3747_8a30_4980_998c_01fe7f0ba35a);
impl core::ops::Deref for IDvbLogicalChannel2Descriptor {
    type Target = IDvbLogicalChannelDescriptor2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDvbLogicalChannel2Descriptor, windows_core::IUnknown, IDvbLogicalChannelDescriptor, IDvbLogicalChannelDescriptor2);
impl IDvbLogicalChannel2Descriptor {
    pub unsafe fn GetCountOfLists(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfLists)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetListId(&self, blistindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetListId)(windows_core::Interface::as_raw(self), blistindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetListNameW(&self, blistindex: u8, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetListNameW)(windows_core::Interface::as_raw(self), blistindex, convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetListCountryCode(&self, blistindex: u8, pszcode: &mut [u8; 4]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetListCountryCode)(windows_core::Interface::as_raw(self), blistindex, core::mem::transmute(pszcode.as_ptr())).ok() }
    }
    pub unsafe fn GetListCountOfRecords(&self, bchannellistindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetListCountOfRecords)(windows_core::Interface::as_raw(self), bchannellistindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetListRecordServiceId(&self, blistindex: u8, brecordindex: u8) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetListRecordServiceId)(windows_core::Interface::as_raw(self), blistindex, brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetListRecordLogicalChannelNumber(&self, blistindex: u8, brecordindex: u8) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetListRecordLogicalChannelNumber)(windows_core::Interface::as_raw(self), blistindex, brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetListRecordLogicalChannelAndVisibility(&self, blistindex: u8, brecordindex: u8) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetListRecordLogicalChannelAndVisibility)(windows_core::Interface::as_raw(self), blistindex, brecordindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbLogicalChannel2Descriptor_Vtbl {
    pub base__: IDvbLogicalChannelDescriptor2_Vtbl,
    pub GetCountOfLists: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetListId: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetListNameW: unsafe extern "system" fn(*mut core::ffi::c_void, u8, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetListCountryCode: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetListCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetListRecordServiceId: unsafe extern "system" fn(*mut core::ffi::c_void, u8, u8, *mut u16) -> windows_core::HRESULT,
    pub GetListRecordLogicalChannelNumber: unsafe extern "system" fn(*mut core::ffi::c_void, u8, u8, *mut u16) -> windows_core::HRESULT,
    pub GetListRecordLogicalChannelAndVisibility: unsafe extern "system" fn(*mut core::ffi::c_void, u8, u8, *mut u16) -> windows_core::HRESULT,
}
pub trait IDvbLogicalChannel2Descriptor_Impl: IDvbLogicalChannelDescriptor2_Impl {
    fn GetCountOfLists(&self) -> windows_core::Result<u8>;
    fn GetListId(&self, blistindex: u8) -> windows_core::Result<u8>;
    fn GetListNameW(&self, blistindex: u8, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
    fn GetListCountryCode(&self, blistindex: u8, pszcode: *mut u8) -> windows_core::Result<()>;
    fn GetListCountOfRecords(&self, bchannellistindex: u8) -> windows_core::Result<u8>;
    fn GetListRecordServiceId(&self, blistindex: u8, brecordindex: u8) -> windows_core::Result<u16>;
    fn GetListRecordLogicalChannelNumber(&self, blistindex: u8, brecordindex: u8) -> windows_core::Result<u16>;
    fn GetListRecordLogicalChannelAndVisibility(&self, blistindex: u8, brecordindex: u8) -> windows_core::Result<u16>;
}
impl IDvbLogicalChannel2Descriptor_Vtbl {
    pub const fn new<Identity: IDvbLogicalChannel2Descriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetCountOfLists<Identity: IDvbLogicalChannel2Descriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannel2Descriptor_Impl::GetCountOfLists(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetListId<Identity: IDvbLogicalChannel2Descriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, blistindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannel2Descriptor_Impl::GetListId(this, core::mem::transmute_copy(&blistindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetListNameW<Identity: IDvbLogicalChannel2Descriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, blistindex: u8, convmode: DVB_STRCONV_MODE, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannel2Descriptor_Impl::GetListNameW(this, core::mem::transmute_copy(&blistindex), core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetListCountryCode<Identity: IDvbLogicalChannel2Descriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, blistindex: u8, pszcode: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbLogicalChannel2Descriptor_Impl::GetListCountryCode(this, core::mem::transmute_copy(&blistindex), core::mem::transmute_copy(&pszcode)).into()
            }
        }
        unsafe extern "system" fn GetListCountOfRecords<Identity: IDvbLogicalChannel2Descriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bchannellistindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannel2Descriptor_Impl::GetListCountOfRecords(this, core::mem::transmute_copy(&bchannellistindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetListRecordServiceId<Identity: IDvbLogicalChannel2Descriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, blistindex: u8, brecordindex: u8, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannel2Descriptor_Impl::GetListRecordServiceId(this, core::mem::transmute_copy(&blistindex), core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetListRecordLogicalChannelNumber<Identity: IDvbLogicalChannel2Descriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, blistindex: u8, brecordindex: u8, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannel2Descriptor_Impl::GetListRecordLogicalChannelNumber(this, core::mem::transmute_copy(&blistindex), core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetListRecordLogicalChannelAndVisibility<Identity: IDvbLogicalChannel2Descriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, blistindex: u8, brecordindex: u8, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannel2Descriptor_Impl::GetListRecordLogicalChannelAndVisibility(this, core::mem::transmute_copy(&blistindex), core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IDvbLogicalChannelDescriptor2_Vtbl::new::<Identity, OFFSET>(),
            GetCountOfLists: GetCountOfLists::<Identity, OFFSET>,
            GetListId: GetListId::<Identity, OFFSET>,
            GetListNameW: GetListNameW::<Identity, OFFSET>,
            GetListCountryCode: GetListCountryCode::<Identity, OFFSET>,
            GetListCountOfRecords: GetListCountOfRecords::<Identity, OFFSET>,
            GetListRecordServiceId: GetListRecordServiceId::<Identity, OFFSET>,
            GetListRecordLogicalChannelNumber: GetListRecordLogicalChannelNumber::<Identity, OFFSET>,
            GetListRecordLogicalChannelAndVisibility: GetListRecordLogicalChannelAndVisibility::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbLogicalChannel2Descriptor as windows_core::Interface>::IID || iid == &<IDvbLogicalChannelDescriptor as windows_core::Interface>::IID || iid == &<IDvbLogicalChannelDescriptor2 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbLogicalChannel2Descriptor {}
windows_core::imp::define_interface!(IDvbLogicalChannelDescriptor, IDvbLogicalChannelDescriptor_Vtbl, 0xcf1edaff_3ffd_4cf7_8201_35756acbf85f);
windows_core::imp::interface_hierarchy!(IDvbLogicalChannelDescriptor, windows_core::IUnknown);
impl IDvbLogicalChannelDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordServiceId(&self, brecordindex: u8) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordServiceId)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordLogicalChannelNumber(&self, brecordindex: u8) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordLogicalChannelNumber)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbLogicalChannelDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordServiceId: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u16) -> windows_core::HRESULT,
    pub GetRecordLogicalChannelNumber: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u16) -> windows_core::HRESULT,
}
pub trait IDvbLogicalChannelDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordServiceId(&self, brecordindex: u8) -> windows_core::Result<u16>;
    fn GetRecordLogicalChannelNumber(&self, brecordindex: u8) -> windows_core::Result<u16>;
}
impl IDvbLogicalChannelDescriptor_Vtbl {
    pub const fn new<Identity: IDvbLogicalChannelDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbLogicalChannelDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannelDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbLogicalChannelDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannelDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbLogicalChannelDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannelDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordServiceId<Identity: IDvbLogicalChannelDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannelDescriptor_Impl::GetRecordServiceId(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordLogicalChannelNumber<Identity: IDvbLogicalChannelDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannelDescriptor_Impl::GetRecordLogicalChannelNumber(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordServiceId: GetRecordServiceId::<Identity, OFFSET>,
            GetRecordLogicalChannelNumber: GetRecordLogicalChannelNumber::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbLogicalChannelDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbLogicalChannelDescriptor {}
windows_core::imp::define_interface!(IDvbLogicalChannelDescriptor2, IDvbLogicalChannelDescriptor2_Vtbl, 0x43aca974_4be8_4b98_bc17_9eafd788b1d7);
impl core::ops::Deref for IDvbLogicalChannelDescriptor2 {
    type Target = IDvbLogicalChannelDescriptor;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDvbLogicalChannelDescriptor2, windows_core::IUnknown, IDvbLogicalChannelDescriptor);
impl IDvbLogicalChannelDescriptor2 {
    pub unsafe fn GetRecordLogicalChannelAndVisibility(&self, brecordindex: u8) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordLogicalChannelAndVisibility)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbLogicalChannelDescriptor2_Vtbl {
    pub base__: IDvbLogicalChannelDescriptor_Vtbl,
    pub GetRecordLogicalChannelAndVisibility: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u16) -> windows_core::HRESULT,
}
pub trait IDvbLogicalChannelDescriptor2_Impl: IDvbLogicalChannelDescriptor_Impl {
    fn GetRecordLogicalChannelAndVisibility(&self, brecordindex: u8) -> windows_core::Result<u16>;
}
impl IDvbLogicalChannelDescriptor2_Vtbl {
    pub const fn new<Identity: IDvbLogicalChannelDescriptor2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetRecordLogicalChannelAndVisibility<Identity: IDvbLogicalChannelDescriptor2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbLogicalChannelDescriptor2_Impl::GetRecordLogicalChannelAndVisibility(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IDvbLogicalChannelDescriptor_Vtbl::new::<Identity, OFFSET>(),
            GetRecordLogicalChannelAndVisibility: GetRecordLogicalChannelAndVisibility::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbLogicalChannelDescriptor2 as windows_core::Interface>::IID || iid == &<IDvbLogicalChannelDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbLogicalChannelDescriptor2 {}
windows_core::imp::define_interface!(IDvbMultilingualServiceNameDescriptor, IDvbMultilingualServiceNameDescriptor_Vtbl, 0x2d80433b_b32c_47ef_987f_e78ebb773e34);
windows_core::imp::interface_hierarchy!(IDvbMultilingualServiceNameDescriptor, windows_core::IUnknown);
impl IDvbMultilingualServiceNameDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordLangId(&self, brecordindex: u8) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordLangId)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordServiceProviderNameW(&self, brecordindex: u8, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordServiceProviderNameW)(windows_core::Interface::as_raw(self), brecordindex, convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetRecordServiceNameW(&self, brecordindex: u8, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordServiceNameW)(windows_core::Interface::as_raw(self), brecordindex, convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbMultilingualServiceNameDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordLangId: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32) -> windows_core::HRESULT,
    pub GetRecordServiceProviderNameW: unsafe extern "system" fn(*mut core::ffi::c_void, u8, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRecordServiceNameW: unsafe extern "system" fn(*mut core::ffi::c_void, u8, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDvbMultilingualServiceNameDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordLangId(&self, brecordindex: u8) -> windows_core::Result<u32>;
    fn GetRecordServiceProviderNameW(&self, brecordindex: u8, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
    fn GetRecordServiceNameW(&self, brecordindex: u8, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
}
impl IDvbMultilingualServiceNameDescriptor_Vtbl {
    pub const fn new<Identity: IDvbMultilingualServiceNameDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbMultilingualServiceNameDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbMultilingualServiceNameDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbMultilingualServiceNameDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbMultilingualServiceNameDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbMultilingualServiceNameDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbMultilingualServiceNameDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordLangId<Identity: IDvbMultilingualServiceNameDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, ulval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbMultilingualServiceNameDescriptor_Impl::GetRecordLangId(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        ulval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordServiceProviderNameW<Identity: IDvbMultilingualServiceNameDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, convmode: DVB_STRCONV_MODE, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbMultilingualServiceNameDescriptor_Impl::GetRecordServiceProviderNameW(this, core::mem::transmute_copy(&brecordindex), core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordServiceNameW<Identity: IDvbMultilingualServiceNameDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, convmode: DVB_STRCONV_MODE, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbMultilingualServiceNameDescriptor_Impl::GetRecordServiceNameW(this, core::mem::transmute_copy(&brecordindex), core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordLangId: GetRecordLangId::<Identity, OFFSET>,
            GetRecordServiceProviderNameW: GetRecordServiceProviderNameW::<Identity, OFFSET>,
            GetRecordServiceNameW: GetRecordServiceNameW::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbMultilingualServiceNameDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbMultilingualServiceNameDescriptor {}
windows_core::imp::define_interface!(IDvbNetworkNameDescriptor, IDvbNetworkNameDescriptor_Vtbl, 0x5b2a80cf_35b9_446c_b3e4_048b761dbc51);
windows_core::imp::interface_hierarchy!(IDvbNetworkNameDescriptor, windows_core::IUnknown);
impl IDvbNetworkNameDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNetworkName(&self) -> windows_core::Result<*mut u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNetworkName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNetworkNameW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNetworkNameW)(windows_core::Interface::as_raw(self), convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbNetworkNameDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetNetworkName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut u8) -> windows_core::HRESULT,
    pub GetNetworkNameW: unsafe extern "system" fn(*mut core::ffi::c_void, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDvbNetworkNameDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetNetworkName(&self) -> windows_core::Result<*mut u8>;
    fn GetNetworkNameW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
}
impl IDvbNetworkNameDescriptor_Vtbl {
    pub const fn new<Identity: IDvbNetworkNameDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbNetworkNameDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbNetworkNameDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbNetworkNameDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbNetworkNameDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNetworkName<Identity: IDvbNetworkNameDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszname: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbNetworkNameDescriptor_Impl::GetNetworkName(this) {
                    Ok(ok__) => {
                        pszname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNetworkNameW<Identity: IDvbNetworkNameDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, convmode: DVB_STRCONV_MODE, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbNetworkNameDescriptor_Impl::GetNetworkNameW(this, core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetNetworkName: GetNetworkName::<Identity, OFFSET>,
            GetNetworkNameW: GetNetworkNameW::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbNetworkNameDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbNetworkNameDescriptor {}
windows_core::imp::define_interface!(IDvbParentalRatingDescriptor, IDvbParentalRatingDescriptor_Vtbl, 0x3ad9dde1_fb1b_4186_937f_22e6b5a72a10);
windows_core::imp::interface_hierarchy!(IDvbParentalRatingDescriptor, windows_core::IUnknown);
impl IDvbParentalRatingDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordRating(&self, brecordindex: u8, pszcountrycode: &mut [u8; 4], pbval: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecordRating)(windows_core::Interface::as_raw(self), brecordindex, core::mem::transmute(pszcountrycode.as_ptr()), pbval as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbParentalRatingDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordRating: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbParentalRatingDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordRating(&self, brecordindex: u8, pszcountrycode: *mut u8, pbval: *mut u8) -> windows_core::Result<()>;
}
impl IDvbParentalRatingDescriptor_Vtbl {
    pub const fn new<Identity: IDvbParentalRatingDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbParentalRatingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbParentalRatingDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbParentalRatingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbParentalRatingDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbParentalRatingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbParentalRatingDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordRating<Identity: IDvbParentalRatingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pszcountrycode: *mut u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbParentalRatingDescriptor_Impl::GetRecordRating(this, core::mem::transmute_copy(&brecordindex), core::mem::transmute_copy(&pszcountrycode), core::mem::transmute_copy(&pbval)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordRating: GetRecordRating::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbParentalRatingDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbParentalRatingDescriptor {}
windows_core::imp::define_interface!(IDvbPrivateDataSpecifierDescriptor, IDvbPrivateDataSpecifierDescriptor_Vtbl, 0x5660a019_e75a_4b82_9b4c_ed2256d165a2);
windows_core::imp::interface_hierarchy!(IDvbPrivateDataSpecifierDescriptor, windows_core::IUnknown);
impl IDvbPrivateDataSpecifierDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetPrivateDataSpecifier(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPrivateDataSpecifier)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbPrivateDataSpecifierDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetPrivateDataSpecifier: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IDvbPrivateDataSpecifierDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetPrivateDataSpecifier(&self) -> windows_core::Result<u32>;
}
impl IDvbPrivateDataSpecifierDescriptor_Vtbl {
    pub const fn new<Identity: IDvbPrivateDataSpecifierDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbPrivateDataSpecifierDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbPrivateDataSpecifierDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbPrivateDataSpecifierDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbPrivateDataSpecifierDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPrivateDataSpecifier<Identity: IDvbPrivateDataSpecifierDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbPrivateDataSpecifierDescriptor_Impl::GetPrivateDataSpecifier(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetPrivateDataSpecifier: GetPrivateDataSpecifier::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbPrivateDataSpecifierDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbPrivateDataSpecifierDescriptor {}
windows_core::imp::define_interface!(IDvbSatelliteDeliverySystemDescriptor, IDvbSatelliteDeliverySystemDescriptor_Vtbl, 0x02f2225a_805b_4ec5_a9a6_f9b5913cd470);
windows_core::imp::interface_hierarchy!(IDvbSatelliteDeliverySystemDescriptor, windows_core::IUnknown);
impl IDvbSatelliteDeliverySystemDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetFrequency(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFrequency)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetOrbitalPosition(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOrbitalPosition)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetWestEastFlag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetWestEastFlag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetPolarization(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPolarization)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetModulation(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetModulation)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSymbolRate(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSymbolRate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetFECInner(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFECInner)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbSatelliteDeliverySystemDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetOrbitalPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetWestEastFlag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetPolarization: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetModulation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetSymbolRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetFECInner: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbSatelliteDeliverySystemDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetFrequency(&self) -> windows_core::Result<u32>;
    fn GetOrbitalPosition(&self) -> windows_core::Result<u16>;
    fn GetWestEastFlag(&self) -> windows_core::Result<u8>;
    fn GetPolarization(&self) -> windows_core::Result<u8>;
    fn GetModulation(&self) -> windows_core::Result<u8>;
    fn GetSymbolRate(&self) -> windows_core::Result<u32>;
    fn GetFECInner(&self) -> windows_core::Result<u8>;
}
impl IDvbSatelliteDeliverySystemDescriptor_Vtbl {
    pub const fn new<Identity: IDvbSatelliteDeliverySystemDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbSatelliteDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSatelliteDeliverySystemDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbSatelliteDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSatelliteDeliverySystemDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFrequency<Identity: IDvbSatelliteDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSatelliteDeliverySystemDescriptor_Impl::GetFrequency(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetOrbitalPosition<Identity: IDvbSatelliteDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSatelliteDeliverySystemDescriptor_Impl::GetOrbitalPosition(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetWestEastFlag<Identity: IDvbSatelliteDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSatelliteDeliverySystemDescriptor_Impl::GetWestEastFlag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPolarization<Identity: IDvbSatelliteDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSatelliteDeliverySystemDescriptor_Impl::GetPolarization(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetModulation<Identity: IDvbSatelliteDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSatelliteDeliverySystemDescriptor_Impl::GetModulation(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSymbolRate<Identity: IDvbSatelliteDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSatelliteDeliverySystemDescriptor_Impl::GetSymbolRate(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFECInner<Identity: IDvbSatelliteDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSatelliteDeliverySystemDescriptor_Impl::GetFECInner(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetFrequency: GetFrequency::<Identity, OFFSET>,
            GetOrbitalPosition: GetOrbitalPosition::<Identity, OFFSET>,
            GetWestEastFlag: GetWestEastFlag::<Identity, OFFSET>,
            GetPolarization: GetPolarization::<Identity, OFFSET>,
            GetModulation: GetModulation::<Identity, OFFSET>,
            GetSymbolRate: GetSymbolRate::<Identity, OFFSET>,
            GetFECInner: GetFECInner::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbSatelliteDeliverySystemDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbSatelliteDeliverySystemDescriptor {}
windows_core::imp::define_interface!(IDvbServiceAttributeDescriptor, IDvbServiceAttributeDescriptor_Vtbl, 0x0f37bd92_d6a1_4854_b950_3a969d27f30e);
windows_core::imp::interface_hierarchy!(IDvbServiceAttributeDescriptor, windows_core::IUnknown);
impl IDvbServiceAttributeDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordServiceId(&self, brecordindex: u8) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordServiceId)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordNumericSelectionFlag(&self, brecordindex: u8) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordNumericSelectionFlag)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordVisibleServiceFlag(&self, brecordindex: u8) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordVisibleServiceFlag)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbServiceAttributeDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordServiceId: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u16) -> windows_core::HRESULT,
    pub GetRecordNumericSelectionFlag: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetRecordVisibleServiceFlag: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut windows_core::BOOL) -> windows_core::HRESULT,
}
pub trait IDvbServiceAttributeDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordServiceId(&self, brecordindex: u8) -> windows_core::Result<u16>;
    fn GetRecordNumericSelectionFlag(&self, brecordindex: u8) -> windows_core::Result<windows_core::BOOL>;
    fn GetRecordVisibleServiceFlag(&self, brecordindex: u8) -> windows_core::Result<windows_core::BOOL>;
}
impl IDvbServiceAttributeDescriptor_Vtbl {
    pub const fn new<Identity: IDvbServiceAttributeDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbServiceAttributeDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceAttributeDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbServiceAttributeDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceAttributeDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbServiceAttributeDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceAttributeDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordServiceId<Identity: IDvbServiceAttributeDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceAttributeDescriptor_Impl::GetRecordServiceId(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordNumericSelectionFlag<Identity: IDvbServiceAttributeDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceAttributeDescriptor_Impl::GetRecordNumericSelectionFlag(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordVisibleServiceFlag<Identity: IDvbServiceAttributeDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pfval: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceAttributeDescriptor_Impl::GetRecordVisibleServiceFlag(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pfval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordServiceId: GetRecordServiceId::<Identity, OFFSET>,
            GetRecordNumericSelectionFlag: GetRecordNumericSelectionFlag::<Identity, OFFSET>,
            GetRecordVisibleServiceFlag: GetRecordVisibleServiceFlag::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbServiceAttributeDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbServiceAttributeDescriptor {}
windows_core::imp::define_interface!(IDvbServiceDescriptor, IDvbServiceDescriptor_Vtbl, 0xf9c7fbcf_e2d6_464d_b32d_2ef526e49290);
windows_core::imp::interface_hierarchy!(IDvbServiceDescriptor, windows_core::IUnknown);
impl IDvbServiceDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetServiceType(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetServiceProviderName(&self) -> windows_core::Result<*mut u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceProviderName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetServiceProviderNameW(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceProviderNameW)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetServiceName(&self) -> windows_core::Result<*mut u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetProcessedServiceName(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProcessedServiceName)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetServiceNameEmphasized(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceNameEmphasized)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbServiceDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetServiceType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetServiceProviderName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut u8) -> windows_core::HRESULT,
    pub GetServiceProviderNameW: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetServiceName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut u8) -> windows_core::HRESULT,
    pub GetProcessedServiceName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetServiceNameEmphasized: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDvbServiceDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetServiceType(&self) -> windows_core::Result<u8>;
    fn GetServiceProviderName(&self) -> windows_core::Result<*mut u8>;
    fn GetServiceProviderNameW(&self) -> windows_core::Result<windows_core::BSTR>;
    fn GetServiceName(&self) -> windows_core::Result<*mut u8>;
    fn GetProcessedServiceName(&self) -> windows_core::Result<windows_core::BSTR>;
    fn GetServiceNameEmphasized(&self) -> windows_core::Result<windows_core::BSTR>;
}
impl IDvbServiceDescriptor_Vtbl {
    pub const fn new<Identity: IDvbServiceDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetServiceType<Identity: IDvbServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceDescriptor_Impl::GetServiceType(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetServiceProviderName<Identity: IDvbServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszname: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceDescriptor_Impl::GetServiceProviderName(this) {
                    Ok(ok__) => {
                        pszname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetServiceProviderNameW<Identity: IDvbServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceDescriptor_Impl::GetServiceProviderNameW(this) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetServiceName<Identity: IDvbServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszname: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceDescriptor_Impl::GetServiceName(this) {
                    Ok(ok__) => {
                        pszname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetProcessedServiceName<Identity: IDvbServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceDescriptor_Impl::GetProcessedServiceName(this) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetServiceNameEmphasized<Identity: IDvbServiceDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceDescriptor_Impl::GetServiceNameEmphasized(this) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetServiceType: GetServiceType::<Identity, OFFSET>,
            GetServiceProviderName: GetServiceProviderName::<Identity, OFFSET>,
            GetServiceProviderNameW: GetServiceProviderNameW::<Identity, OFFSET>,
            GetServiceName: GetServiceName::<Identity, OFFSET>,
            GetProcessedServiceName: GetProcessedServiceName::<Identity, OFFSET>,
            GetServiceNameEmphasized: GetServiceNameEmphasized::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbServiceDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbServiceDescriptor {}
windows_core::imp::define_interface!(IDvbServiceDescriptor2, IDvbServiceDescriptor2_Vtbl, 0xd6c76506_85ab_487c_9b2b_36416511e4a2);
impl core::ops::Deref for IDvbServiceDescriptor2 {
    type Target = IDvbServiceDescriptor;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDvbServiceDescriptor2, windows_core::IUnknown, IDvbServiceDescriptor);
impl IDvbServiceDescriptor2 {
    pub unsafe fn GetServiceProviderNameW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceProviderNameW)(windows_core::Interface::as_raw(self), convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetServiceNameW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceNameW)(windows_core::Interface::as_raw(self), convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbServiceDescriptor2_Vtbl {
    pub base__: IDvbServiceDescriptor_Vtbl,
    pub GetServiceProviderNameW: unsafe extern "system" fn(*mut core::ffi::c_void, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetServiceNameW: unsafe extern "system" fn(*mut core::ffi::c_void, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDvbServiceDescriptor2_Impl: IDvbServiceDescriptor_Impl {
    fn GetServiceProviderNameW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
    fn GetServiceNameW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
}
impl IDvbServiceDescriptor2_Vtbl {
    pub const fn new<Identity: IDvbServiceDescriptor2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetServiceProviderNameW<Identity: IDvbServiceDescriptor2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, convmode: DVB_STRCONV_MODE, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceDescriptor2_Impl::GetServiceProviderNameW(this, core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetServiceNameW<Identity: IDvbServiceDescriptor2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, convmode: DVB_STRCONV_MODE, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceDescriptor2_Impl::GetServiceNameW(this, core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IDvbServiceDescriptor_Vtbl::new::<Identity, OFFSET>(),
            GetServiceProviderNameW: GetServiceProviderNameW::<Identity, OFFSET>,
            GetServiceNameW: GetServiceNameW::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbServiceDescriptor2 as windows_core::Interface>::IID || iid == &<IDvbServiceDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbServiceDescriptor2 {}
windows_core::imp::define_interface!(IDvbServiceListDescriptor, IDvbServiceListDescriptor_Vtbl, 0x05db0d8f_6008_491a_acd3_7090952707d0);
windows_core::imp::interface_hierarchy!(IDvbServiceListDescriptor, windows_core::IUnknown);
impl IDvbServiceListDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordServiceId(&self, brecordindex: u8) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordServiceId)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordServiceType(&self, brecordindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordServiceType)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbServiceListDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordServiceId: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u16) -> windows_core::HRESULT,
    pub GetRecordServiceType: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbServiceListDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordServiceId(&self, brecordindex: u8) -> windows_core::Result<u16>;
    fn GetRecordServiceType(&self, brecordindex: u8) -> windows_core::Result<u8>;
}
impl IDvbServiceListDescriptor_Vtbl {
    pub const fn new<Identity: IDvbServiceListDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbServiceListDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceListDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbServiceListDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceListDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbServiceListDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceListDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordServiceId<Identity: IDvbServiceListDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceListDescriptor_Impl::GetRecordServiceId(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordServiceType<Identity: IDvbServiceListDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbServiceListDescriptor_Impl::GetRecordServiceType(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordServiceId: GetRecordServiceId::<Identity, OFFSET>,
            GetRecordServiceType: GetRecordServiceType::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbServiceListDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbServiceListDescriptor {}
windows_core::imp::define_interface!(IDvbShortEventDescriptor, IDvbShortEventDescriptor_Vtbl, 0xb170be92_5b75_458e_9c6e_b0008231491a);
windows_core::imp::interface_hierarchy!(IDvbShortEventDescriptor, windows_core::IUnknown);
impl IDvbShortEventDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLanguageCode(&self, pszcode: &mut [u8; 4]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetLanguageCode)(windows_core::Interface::as_raw(self), core::mem::transmute(pszcode.as_ptr())).ok() }
    }
    pub unsafe fn GetEventNameW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventNameW)(windows_core::Interface::as_raw(self), convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetTextW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTextW)(windows_core::Interface::as_raw(self), convmode, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbShortEventDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLanguageCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetEventNameW: unsafe extern "system" fn(*mut core::ffi::c_void, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTextW: unsafe extern "system" fn(*mut core::ffi::c_void, DVB_STRCONV_MODE, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDvbShortEventDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetLanguageCode(&self, pszcode: *mut u8) -> windows_core::Result<()>;
    fn GetEventNameW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
    fn GetTextW(&self, convmode: DVB_STRCONV_MODE) -> windows_core::Result<windows_core::BSTR>;
}
impl IDvbShortEventDescriptor_Vtbl {
    pub const fn new<Identity: IDvbShortEventDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbShortEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbShortEventDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbShortEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbShortEventDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLanguageCode<Identity: IDvbShortEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszcode: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbShortEventDescriptor_Impl::GetLanguageCode(this, core::mem::transmute_copy(&pszcode)).into()
            }
        }
        unsafe extern "system" fn GetEventNameW<Identity: IDvbShortEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, convmode: DVB_STRCONV_MODE, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbShortEventDescriptor_Impl::GetEventNameW(this, core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTextW<Identity: IDvbShortEventDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, convmode: DVB_STRCONV_MODE, pbstrtext: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbShortEventDescriptor_Impl::GetTextW(this, core::mem::transmute_copy(&convmode)) {
                    Ok(ok__) => {
                        pbstrtext.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetLanguageCode: GetLanguageCode::<Identity, OFFSET>,
            GetEventNameW: GetEventNameW::<Identity, OFFSET>,
            GetTextW: GetTextW::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbShortEventDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbShortEventDescriptor {}
windows_core::imp::define_interface!(IDvbSiParser, IDvbSiParser_Vtbl, 0xb758a7bd_14dc_449d_b828_35909acb3b1e);
windows_core::imp::interface_hierarchy!(IDvbSiParser, windows_core::IUnknown);
impl IDvbSiParser {
    pub unsafe fn Initialize<P0>(&self, punkmpeg2data: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), punkmpeg2data.param().abi()).ok() }
    }
    pub unsafe fn GetPAT(&self) -> windows_core::Result<IPAT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPAT)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetCAT(&self, dwtimeout: u32) -> windows_core::Result<ICAT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCAT)(windows_core::Interface::as_raw(self), dwtimeout, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetPMT(&self, pid: u16, pwprogramnumber: Option<*const u16>) -> windows_core::Result<IPMT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPMT)(windows_core::Interface::as_raw(self), pid, pwprogramnumber.unwrap_or(core::mem::zeroed()) as _, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTSDT(&self) -> windows_core::Result<ITSDT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTSDT)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetNIT(&self, tableid: u8, pwnetworkid: Option<*const u16>) -> windows_core::Result<IDVB_NIT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNIT)(windows_core::Interface::as_raw(self), tableid, pwnetworkid.unwrap_or(core::mem::zeroed()) as _, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetSDT(&self, tableid: u8, pwtransportstreamid: Option<*const u16>) -> windows_core::Result<IDVB_SDT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSDT)(windows_core::Interface::as_raw(self), tableid, pwtransportstreamid.unwrap_or(core::mem::zeroed()) as _, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetEIT(&self, tableid: u8, pwserviceid: Option<*const u16>) -> windows_core::Result<IDVB_EIT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEIT)(windows_core::Interface::as_raw(self), tableid, pwserviceid.unwrap_or(core::mem::zeroed()) as _, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetBAT(&self, pwbouquetid: Option<*const u16>) -> windows_core::Result<IDVB_BAT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetBAT)(windows_core::Interface::as_raw(self), pwbouquetid.unwrap_or(core::mem::zeroed()) as _, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetRST(&self, dwtimeout: u32) -> windows_core::Result<IDVB_RST> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRST)(windows_core::Interface::as_raw(self), dwtimeout, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetST(&self, pid: u16, dwtimeout: u32) -> windows_core::Result<IDVB_ST> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetST)(windows_core::Interface::as_raw(self), pid, dwtimeout, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTDT(&self) -> windows_core::Result<IDVB_TDT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTDT)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTOT(&self) -> windows_core::Result<IDVB_TOT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTOT)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetDIT(&self, dwtimeout: u32) -> windows_core::Result<IDVB_DIT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDIT)(windows_core::Interface::as_raw(self), dwtimeout, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetSIT(&self, dwtimeout: u32) -> windows_core::Result<IDVB_SIT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSIT)(windows_core::Interface::as_raw(self), dwtimeout, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbSiParser_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetPAT: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCAT: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetPMT: unsafe extern "system" fn(*mut core::ffi::c_void, u16, *const u16, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTSDT: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetNIT: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *const u16, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetSDT: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *const u16, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetEIT: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *const u16, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetBAT: unsafe extern "system" fn(*mut core::ffi::c_void, *const u16, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRST: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetST: unsafe extern "system" fn(*mut core::ffi::c_void, u16, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTDT: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTOT: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetDIT: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetSIT: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDvbSiParser_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, punkmpeg2data: windows_core::Ref<'_, windows_core::IUnknown>) -> windows_core::Result<()>;
    fn GetPAT(&self) -> windows_core::Result<IPAT>;
    fn GetCAT(&self, dwtimeout: u32) -> windows_core::Result<ICAT>;
    fn GetPMT(&self, pid: u16, pwprogramnumber: *const u16) -> windows_core::Result<IPMT>;
    fn GetTSDT(&self) -> windows_core::Result<ITSDT>;
    fn GetNIT(&self, tableid: u8, pwnetworkid: *const u16) -> windows_core::Result<IDVB_NIT>;
    fn GetSDT(&self, tableid: u8, pwtransportstreamid: *const u16) -> windows_core::Result<IDVB_SDT>;
    fn GetEIT(&self, tableid: u8, pwserviceid: *const u16) -> windows_core::Result<IDVB_EIT>;
    fn GetBAT(&self, pwbouquetid: *const u16) -> windows_core::Result<IDVB_BAT>;
    fn GetRST(&self, dwtimeout: u32) -> windows_core::Result<IDVB_RST>;
    fn GetST(&self, pid: u16, dwtimeout: u32) -> windows_core::Result<IDVB_ST>;
    fn GetTDT(&self) -> windows_core::Result<IDVB_TDT>;
    fn GetTOT(&self) -> windows_core::Result<IDVB_TOT>;
    fn GetDIT(&self, dwtimeout: u32) -> windows_core::Result<IDVB_DIT>;
    fn GetSIT(&self, dwtimeout: u32) -> windows_core::Result<IDVB_SIT>;
}
impl IDvbSiParser_Vtbl {
    pub const fn new<Identity: IDvbSiParser_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, punkmpeg2data: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDvbSiParser_Impl::Initialize(this, core::mem::transmute_copy(&punkmpeg2data)).into()
            }
        }
        unsafe extern "system" fn GetPAT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pppat: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetPAT(this) {
                    Ok(ok__) => {
                        pppat.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCAT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtimeout: u32, ppcat: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetCAT(this, core::mem::transmute_copy(&dwtimeout)) {
                    Ok(ok__) => {
                        ppcat.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPMT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pid: u16, pwprogramnumber: *const u16, pppmt: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetPMT(this, core::mem::transmute_copy(&pid), core::mem::transmute_copy(&pwprogramnumber)) {
                    Ok(ok__) => {
                        pppmt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTSDT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pptsdt: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetTSDT(this) {
                    Ok(ok__) => {
                        pptsdt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNIT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tableid: u8, pwnetworkid: *const u16, ppnit: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetNIT(this, core::mem::transmute_copy(&tableid), core::mem::transmute_copy(&pwnetworkid)) {
                    Ok(ok__) => {
                        ppnit.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSDT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tableid: u8, pwtransportstreamid: *const u16, ppsdt: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetSDT(this, core::mem::transmute_copy(&tableid), core::mem::transmute_copy(&pwtransportstreamid)) {
                    Ok(ok__) => {
                        ppsdt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetEIT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tableid: u8, pwserviceid: *const u16, ppeit: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetEIT(this, core::mem::transmute_copy(&tableid), core::mem::transmute_copy(&pwserviceid)) {
                    Ok(ok__) => {
                        ppeit.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetBAT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwbouquetid: *const u16, ppbat: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetBAT(this, core::mem::transmute_copy(&pwbouquetid)) {
                    Ok(ok__) => {
                        ppbat.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRST<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtimeout: u32, pprst: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetRST(this, core::mem::transmute_copy(&dwtimeout)) {
                    Ok(ok__) => {
                        pprst.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetST<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pid: u16, dwtimeout: u32, ppst: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetST(this, core::mem::transmute_copy(&pid), core::mem::transmute_copy(&dwtimeout)) {
                    Ok(ok__) => {
                        ppst.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTDT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pptdt: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetTDT(this) {
                    Ok(ok__) => {
                        pptdt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTOT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pptot: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetTOT(this) {
                    Ok(ok__) => {
                        pptot.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDIT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtimeout: u32, ppdit: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetDIT(this, core::mem::transmute_copy(&dwtimeout)) {
                    Ok(ok__) => {
                        ppdit.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSIT<Identity: IDvbSiParser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtimeout: u32, ppsit: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser_Impl::GetSIT(this, core::mem::transmute_copy(&dwtimeout)) {
                    Ok(ok__) => {
                        ppsit.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetPAT: GetPAT::<Identity, OFFSET>,
            GetCAT: GetCAT::<Identity, OFFSET>,
            GetPMT: GetPMT::<Identity, OFFSET>,
            GetTSDT: GetTSDT::<Identity, OFFSET>,
            GetNIT: GetNIT::<Identity, OFFSET>,
            GetSDT: GetSDT::<Identity, OFFSET>,
            GetEIT: GetEIT::<Identity, OFFSET>,
            GetBAT: GetBAT::<Identity, OFFSET>,
            GetRST: GetRST::<Identity, OFFSET>,
            GetST: GetST::<Identity, OFFSET>,
            GetTDT: GetTDT::<Identity, OFFSET>,
            GetTOT: GetTOT::<Identity, OFFSET>,
            GetDIT: GetDIT::<Identity, OFFSET>,
            GetSIT: GetSIT::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbSiParser as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbSiParser {}
windows_core::imp::define_interface!(IDvbSiParser2, IDvbSiParser2_Vtbl, 0x0ac5525f_f816_42f4_93ba_4c0f32f46e54);
impl core::ops::Deref for IDvbSiParser2 {
    type Target = IDvbSiParser;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDvbSiParser2, windows_core::IUnknown, IDvbSiParser);
impl IDvbSiParser2 {
    pub unsafe fn GetEIT2(&self, tableid: u8, pwserviceid: Option<*const u16>, pbsegment: Option<*const u8>) -> windows_core::Result<IDVB_EIT2> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEIT2)(windows_core::Interface::as_raw(self), tableid, pwserviceid.unwrap_or(core::mem::zeroed()) as _, pbsegment.unwrap_or(core::mem::zeroed()) as _, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbSiParser2_Vtbl {
    pub base__: IDvbSiParser_Vtbl,
    pub GetEIT2: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *const u16, *const u8, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDvbSiParser2_Impl: IDvbSiParser_Impl {
    fn GetEIT2(&self, tableid: u8, pwserviceid: *const u16, pbsegment: *const u8) -> windows_core::Result<IDVB_EIT2>;
}
impl IDvbSiParser2_Vtbl {
    pub const fn new<Identity: IDvbSiParser2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetEIT2<Identity: IDvbSiParser2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tableid: u8, pwserviceid: *const u16, pbsegment: *const u8, ppeit: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSiParser2_Impl::GetEIT2(this, core::mem::transmute_copy(&tableid), core::mem::transmute_copy(&pwserviceid), core::mem::transmute_copy(&pbsegment)) {
                    Ok(ok__) => {
                        ppeit.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: IDvbSiParser_Vtbl::new::<Identity, OFFSET>(), GetEIT2: GetEIT2::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbSiParser2 as windows_core::Interface>::IID || iid == &<IDvbSiParser as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbSiParser2 {}
windows_core::imp::define_interface!(IDvbSubtitlingDescriptor, IDvbSubtitlingDescriptor_Vtbl, 0x9b25fe1d_fa23_4e50_9784_6df8b26f8a49);
windows_core::imp::interface_hierarchy!(IDvbSubtitlingDescriptor, windows_core::IUnknown);
impl IDvbSubtitlingDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordLangId(&self, brecordindex: u8) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordLangId)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordSubtitlingType(&self, brecordindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordSubtitlingType)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordCompositionPageID(&self, brecordindex: u8) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCompositionPageID)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordAncillaryPageID(&self, brecordindex: u8) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordAncillaryPageID)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbSubtitlingDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordLangId: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32) -> windows_core::HRESULT,
    pub GetRecordSubtitlingType: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetRecordCompositionPageID: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u16) -> windows_core::HRESULT,
    pub GetRecordAncillaryPageID: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u16) -> windows_core::HRESULT,
}
pub trait IDvbSubtitlingDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordLangId(&self, brecordindex: u8) -> windows_core::Result<u32>;
    fn GetRecordSubtitlingType(&self, brecordindex: u8) -> windows_core::Result<u8>;
    fn GetRecordCompositionPageID(&self, brecordindex: u8) -> windows_core::Result<u16>;
    fn GetRecordAncillaryPageID(&self, brecordindex: u8) -> windows_core::Result<u16>;
}
impl IDvbSubtitlingDescriptor_Vtbl {
    pub const fn new<Identity: IDvbSubtitlingDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbSubtitlingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSubtitlingDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbSubtitlingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSubtitlingDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbSubtitlingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSubtitlingDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordLangId<Identity: IDvbSubtitlingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pulval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSubtitlingDescriptor_Impl::GetRecordLangId(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pulval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordSubtitlingType<Identity: IDvbSubtitlingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSubtitlingDescriptor_Impl::GetRecordSubtitlingType(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordCompositionPageID<Identity: IDvbSubtitlingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSubtitlingDescriptor_Impl::GetRecordCompositionPageID(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordAncillaryPageID<Identity: IDvbSubtitlingDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbSubtitlingDescriptor_Impl::GetRecordAncillaryPageID(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordLangId: GetRecordLangId::<Identity, OFFSET>,
            GetRecordSubtitlingType: GetRecordSubtitlingType::<Identity, OFFSET>,
            GetRecordCompositionPageID: GetRecordCompositionPageID::<Identity, OFFSET>,
            GetRecordAncillaryPageID: GetRecordAncillaryPageID::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbSubtitlingDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbSubtitlingDescriptor {}
windows_core::imp::define_interface!(IDvbTeletextDescriptor, IDvbTeletextDescriptor_Vtbl, 0x9cd29d47_69c6_4f92_98a9_210af1b7303a);
windows_core::imp::interface_hierarchy!(IDvbTeletextDescriptor, windows_core::IUnknown);
impl IDvbTeletextDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCountOfRecords(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCountOfRecords)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordLangId(&self, brecordindex: u8) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordLangId)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordTeletextType(&self, brecordindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordTeletextType)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordMagazineNumber(&self, brecordindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordMagazineNumber)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRecordPageNumber(&self, brecordindex: u8) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordPageNumber)(windows_core::Interface::as_raw(self), brecordindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbTeletextDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCountOfRecords: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetRecordLangId: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u32) -> windows_core::HRESULT,
    pub GetRecordTeletextType: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetRecordMagazineNumber: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
    pub GetRecordPageNumber: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbTeletextDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCountOfRecords(&self) -> windows_core::Result<u8>;
    fn GetRecordLangId(&self, brecordindex: u8) -> windows_core::Result<u32>;
    fn GetRecordTeletextType(&self, brecordindex: u8) -> windows_core::Result<u8>;
    fn GetRecordMagazineNumber(&self, brecordindex: u8) -> windows_core::Result<u8>;
    fn GetRecordPageNumber(&self, brecordindex: u8) -> windows_core::Result<u8>;
}
impl IDvbTeletextDescriptor_Vtbl {
    pub const fn new<Identity: IDvbTeletextDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbTeletextDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTeletextDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbTeletextDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTeletextDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCountOfRecords<Identity: IDvbTeletextDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTeletextDescriptor_Impl::GetCountOfRecords(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordLangId<Identity: IDvbTeletextDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pulval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTeletextDescriptor_Impl::GetRecordLangId(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pulval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordTeletextType<Identity: IDvbTeletextDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTeletextDescriptor_Impl::GetRecordTeletextType(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordMagazineNumber<Identity: IDvbTeletextDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTeletextDescriptor_Impl::GetRecordMagazineNumber(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRecordPageNumber<Identity: IDvbTeletextDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, brecordindex: u8, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTeletextDescriptor_Impl::GetRecordPageNumber(this, core::mem::transmute_copy(&brecordindex)) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCountOfRecords: GetCountOfRecords::<Identity, OFFSET>,
            GetRecordLangId: GetRecordLangId::<Identity, OFFSET>,
            GetRecordTeletextType: GetRecordTeletextType::<Identity, OFFSET>,
            GetRecordMagazineNumber: GetRecordMagazineNumber::<Identity, OFFSET>,
            GetRecordPageNumber: GetRecordPageNumber::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbTeletextDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbTeletextDescriptor {}
windows_core::imp::define_interface!(IDvbTerrestrial2DeliverySystemDescriptor, IDvbTerrestrial2DeliverySystemDescriptor_Vtbl, 0x20ee9be9_cd57_49ab_8f6e_1d07aeb8e482);
windows_core::imp::interface_hierarchy!(IDvbTerrestrial2DeliverySystemDescriptor, windows_core::IUnknown);
impl IDvbTerrestrial2DeliverySystemDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTagExtension(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTagExtension)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCentreFrequency(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCentreFrequency)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetPLPId(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPLPId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetT2SystemId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetT2SystemId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetMultipleInputMode(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMultipleInputMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetBandwidth(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetBandwidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetGuardInterval(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetGuardInterval)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTransmissionMode(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTransmissionMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCellId(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCellId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetOtherFrequencyFlag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOtherFrequencyFlag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTFSFlag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTFSFlag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbTerrestrial2DeliverySystemDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetTagExtension: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCentreFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetPLPId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetT2SystemId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetMultipleInputMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetBandwidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetGuardInterval: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetTransmissionMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCellId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
    pub GetOtherFrequencyFlag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetTFSFlag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbTerrestrial2DeliverySystemDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetTagExtension(&self) -> windows_core::Result<u8>;
    fn GetCentreFrequency(&self) -> windows_core::Result<u32>;
    fn GetPLPId(&self) -> windows_core::Result<u8>;
    fn GetT2SystemId(&self) -> windows_core::Result<u16>;
    fn GetMultipleInputMode(&self) -> windows_core::Result<u8>;
    fn GetBandwidth(&self) -> windows_core::Result<u8>;
    fn GetGuardInterval(&self) -> windows_core::Result<u8>;
    fn GetTransmissionMode(&self) -> windows_core::Result<u8>;
    fn GetCellId(&self) -> windows_core::Result<u16>;
    fn GetOtherFrequencyFlag(&self) -> windows_core::Result<u8>;
    fn GetTFSFlag(&self) -> windows_core::Result<u8>;
}
impl IDvbTerrestrial2DeliverySystemDescriptor_Vtbl {
    pub const fn new<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTagExtension<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetTagExtension(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCentreFrequency<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetCentreFrequency(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPLPId<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetPLPId(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetT2SystemId<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetT2SystemId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetMultipleInputMode<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetMultipleInputMode(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetBandwidth<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetBandwidth(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetGuardInterval<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetGuardInterval(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTransmissionMode<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetTransmissionMode(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCellId<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetCellId(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetOtherFrequencyFlag<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetOtherFrequencyFlag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTFSFlag<Identity: IDvbTerrestrial2DeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrial2DeliverySystemDescriptor_Impl::GetTFSFlag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetTagExtension: GetTagExtension::<Identity, OFFSET>,
            GetCentreFrequency: GetCentreFrequency::<Identity, OFFSET>,
            GetPLPId: GetPLPId::<Identity, OFFSET>,
            GetT2SystemId: GetT2SystemId::<Identity, OFFSET>,
            GetMultipleInputMode: GetMultipleInputMode::<Identity, OFFSET>,
            GetBandwidth: GetBandwidth::<Identity, OFFSET>,
            GetGuardInterval: GetGuardInterval::<Identity, OFFSET>,
            GetTransmissionMode: GetTransmissionMode::<Identity, OFFSET>,
            GetCellId: GetCellId::<Identity, OFFSET>,
            GetOtherFrequencyFlag: GetOtherFrequencyFlag::<Identity, OFFSET>,
            GetTFSFlag: GetTFSFlag::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbTerrestrial2DeliverySystemDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbTerrestrial2DeliverySystemDescriptor {}
windows_core::imp::define_interface!(IDvbTerrestrialDeliverySystemDescriptor, IDvbTerrestrialDeliverySystemDescriptor_Vtbl, 0xed7e1b91_d12e_420c_b41d_a49d84fe1823);
windows_core::imp::interface_hierarchy!(IDvbTerrestrialDeliverySystemDescriptor, windows_core::IUnknown);
impl IDvbTerrestrialDeliverySystemDescriptor {
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCentreFrequency(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCentreFrequency)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetBandwidth(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetBandwidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetConstellation(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetConstellation)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetHierarchyInformation(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetHierarchyInformation)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCodeRateHPStream(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCodeRateHPStream)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCodeRateLPStream(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCodeRateLPStream)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetGuardInterval(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetGuardInterval)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTransmissionMode(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTransmissionMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetOtherFrequencyFlag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOtherFrequencyFlag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvbTerrestrialDeliverySystemDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCentreFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetBandwidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetConstellation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetHierarchyInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCodeRateHPStream: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetCodeRateLPStream: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetGuardInterval: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetTransmissionMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetOtherFrequencyFlag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
}
pub trait IDvbTerrestrialDeliverySystemDescriptor_Impl: windows_core::IUnknownImpl {
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetCentreFrequency(&self) -> windows_core::Result<u32>;
    fn GetBandwidth(&self) -> windows_core::Result<u8>;
    fn GetConstellation(&self) -> windows_core::Result<u8>;
    fn GetHierarchyInformation(&self) -> windows_core::Result<u8>;
    fn GetCodeRateHPStream(&self) -> windows_core::Result<u8>;
    fn GetCodeRateLPStream(&self) -> windows_core::Result<u8>;
    fn GetGuardInterval(&self) -> windows_core::Result<u8>;
    fn GetTransmissionMode(&self) -> windows_core::Result<u8>;
    fn GetOtherFrequencyFlag(&self) -> windows_core::Result<u8>;
}
impl IDvbTerrestrialDeliverySystemDescriptor_Vtbl {
    pub const fn new<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTag<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCentreFrequency<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetCentreFrequency(this) {
                    Ok(ok__) => {
                        pdwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetBandwidth<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetBandwidth(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetConstellation<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetConstellation(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetHierarchyInformation<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetHierarchyInformation(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCodeRateHPStream<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetCodeRateHPStream(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCodeRateLPStream<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetCodeRateLPStream(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetGuardInterval<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetGuardInterval(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTransmissionMode<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetTransmissionMode(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetOtherFrequencyFlag<Identity: IDvbTerrestrialDeliverySystemDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDvbTerrestrialDeliverySystemDescriptor_Impl::GetOtherFrequencyFlag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetCentreFrequency: GetCentreFrequency::<Identity, OFFSET>,
            GetBandwidth: GetBandwidth::<Identity, OFFSET>,
            GetConstellation: GetConstellation::<Identity, OFFSET>,
            GetHierarchyInformation: GetHierarchyInformation::<Identity, OFFSET>,
            GetCodeRateHPStream: GetCodeRateHPStream::<Identity, OFFSET>,
            GetCodeRateLPStream: GetCodeRateLPStream::<Identity, OFFSET>,
            GetGuardInterval: GetGuardInterval::<Identity, OFFSET>,
            GetTransmissionMode: GetTransmissionMode::<Identity, OFFSET>,
            GetOtherFrequencyFlag: GetOtherFrequencyFlag::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDvbTerrestrialDeliverySystemDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDvbTerrestrialDeliverySystemDescriptor {}
windows_core::imp::define_interface!(IESCloseMmiEvent, IESCloseMmiEvent_Vtbl, 0x6b80e96f_55e2_45aa_b754_0c23c8e7d5c1);
impl core::ops::Deref for IESCloseMmiEvent {
    type Target = super::IESEvent;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IESCloseMmiEvent, windows_core::IUnknown, super::IESEvent);
impl IESCloseMmiEvent {
    pub unsafe fn GetDialogNumber(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDialogNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IESCloseMmiEvent_Vtbl {
    pub base__: super::IESEvent_Vtbl,
    pub GetDialogNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IESCloseMmiEvent_Impl: super::IESEvent_Impl {
    fn GetDialogNumber(&self) -> windows_core::Result<u32>;
}
#[cfg(feature = "Win32_System_Com")]
impl IESCloseMmiEvent_Vtbl {
    pub const fn new<Identity: IESCloseMmiEvent_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDialogNumber<Identity: IESCloseMmiEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdialognumber: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESCloseMmiEvent_Impl::GetDialogNumber(this) {
                    Ok(ok__) => {
                        pdialognumber.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: super::IESEvent_Vtbl::new::<Identity, OFFSET>(), GetDialogNumber: GetDialogNumber::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IESCloseMmiEvent as windows_core::Interface>::IID || iid == &<super::IESEvent as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IESCloseMmiEvent {}
windows_core::imp::define_interface!(IESEventFactory, IESEventFactory_Vtbl, 0x506a09b8_7f86_4e04_ac05_3303bfe8fc49);
windows_core::imp::interface_hierarchy!(IESEventFactory, windows_core::IUnknown);
impl IESEventFactory {
    pub unsafe fn CreateESEvent<P0, P6>(&self, pserviceprovider: P0, dweventid: u32, guideventtype: windows_core::GUID, peventdata: &[u8], bstrbaseurl: &windows_core::BSTR, pinitcontext: P6) -> windows_core::Result<super::IESEvent>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
        P6: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateESEvent)(windows_core::Interface::as_raw(self), pserviceprovider.param().abi(), dweventid, core::mem::transmute(guideventtype), peventdata.len().try_into().unwrap(), core::mem::transmute(peventdata.as_ptr()), core::mem::transmute_copy(bstrbaseurl), pinitcontext.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IESEventFactory_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CreateESEvent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, windows_core::GUID, u32, *const u8, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IESEventFactory_Impl: windows_core::IUnknownImpl {
    fn CreateESEvent(&self, pserviceprovider: windows_core::Ref<'_, windows_core::IUnknown>, dweventid: u32, guideventtype: &windows_core::GUID, dweventdatalength: u32, peventdata: *const u8, bstrbaseurl: &windows_core::BSTR, pinitcontext: windows_core::Ref<'_, windows_core::IUnknown>) -> windows_core::Result<super::IESEvent>;
}
impl IESEventFactory_Vtbl {
    pub const fn new<Identity: IESEventFactory_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CreateESEvent<Identity: IESEventFactory_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pserviceprovider: *mut core::ffi::c_void, dweventid: u32, guideventtype: windows_core::GUID, dweventdatalength: u32, peventdata: *const u8, bstrbaseurl: *mut core::ffi::c_void, pinitcontext: *mut core::ffi::c_void, ppesevent: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESEventFactory_Impl::CreateESEvent(this, core::mem::transmute_copy(&pserviceprovider), core::mem::transmute_copy(&dweventid), core::mem::transmute(&guideventtype), core::mem::transmute_copy(&dweventdatalength), core::mem::transmute_copy(&peventdata), core::mem::transmute(&bstrbaseurl), core::mem::transmute_copy(&pinitcontext)) {
                    Ok(ok__) => {
                        ppesevent.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), CreateESEvent: CreateESEvent::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IESEventFactory as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IESEventFactory {}
windows_core::imp::define_interface!(IESEventService, IESEventService_Vtbl, 0xed89a619_4c06_4b2f_99eb_c7669b13047c);
windows_core::imp::interface_hierarchy!(IESEventService, windows_core::IUnknown);
impl IESEventService {
    pub unsafe fn FireESEvent<P0>(&self, pesevent: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::IESEvent>,
    {
        unsafe { (windows_core::Interface::vtable(self).FireESEvent)(windows_core::Interface::as_raw(self), pesevent.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IESEventService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub FireESEvent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IESEventService_Impl: windows_core::IUnknownImpl {
    fn FireESEvent(&self, pesevent: windows_core::Ref<'_, super::IESEvent>) -> windows_core::Result<()>;
}
impl IESEventService_Vtbl {
    pub const fn new<Identity: IESEventService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn FireESEvent<Identity: IESEventService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pesevent: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IESEventService_Impl::FireESEvent(this, core::mem::transmute_copy(&pesevent)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), FireESEvent: FireESEvent::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IESEventService as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IESEventService {}
windows_core::imp::define_interface!(IESEventServiceConfiguration, IESEventServiceConfiguration_Vtbl, 0x33b9daae_9309_491d_a051_bcad2a70cd66);
windows_core::imp::interface_hierarchy!(IESEventServiceConfiguration, windows_core::IUnknown);
impl IESEventServiceConfiguration {
    pub unsafe fn SetParent<P0>(&self, peventservice: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IESEventService>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetParent)(windows_core::Interface::as_raw(self), peventservice.param().abi()).ok() }
    }
    pub unsafe fn RemoveParent(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveParent)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn SetOwner<P0>(&self, pesevents: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::IESEvents>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOwner)(windows_core::Interface::as_raw(self), pesevents.param().abi()).ok() }
    }
    pub unsafe fn RemoveOwner(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveOwner)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn SetGraph<P0>(&self, pgraph: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::IFilterGraph>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetGraph)(windows_core::Interface::as_raw(self), pgraph.param().abi()).ok() }
    }
    pub unsafe fn RemoveGraph<P0>(&self, pgraph: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::IFilterGraph>,
    {
        unsafe { (windows_core::Interface::vtable(self).RemoveGraph)(windows_core::Interface::as_raw(self), pgraph.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IESEventServiceConfiguration_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetParent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveParent: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOwner: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveOwner: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetGraph: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveGraph: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IESEventServiceConfiguration_Impl: windows_core::IUnknownImpl {
    fn SetParent(&self, peventservice: windows_core::Ref<'_, IESEventService>) -> windows_core::Result<()>;
    fn RemoveParent(&self) -> windows_core::Result<()>;
    fn SetOwner(&self, pesevents: windows_core::Ref<'_, super::IESEvents>) -> windows_core::Result<()>;
    fn RemoveOwner(&self) -> windows_core::Result<()>;
    fn SetGraph(&self, pgraph: windows_core::Ref<'_, super::IFilterGraph>) -> windows_core::Result<()>;
    fn RemoveGraph(&self, pgraph: windows_core::Ref<'_, super::IFilterGraph>) -> windows_core::Result<()>;
}
impl IESEventServiceConfiguration_Vtbl {
    pub const fn new<Identity: IESEventServiceConfiguration_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetParent<Identity: IESEventServiceConfiguration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, peventservice: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IESEventServiceConfiguration_Impl::SetParent(this, core::mem::transmute_copy(&peventservice)).into()
            }
        }
        unsafe extern "system" fn RemoveParent<Identity: IESEventServiceConfiguration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IESEventServiceConfiguration_Impl::RemoveParent(this).into()
            }
        }
        unsafe extern "system" fn SetOwner<Identity: IESEventServiceConfiguration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pesevents: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IESEventServiceConfiguration_Impl::SetOwner(this, core::mem::transmute_copy(&pesevents)).into()
            }
        }
        unsafe extern "system" fn RemoveOwner<Identity: IESEventServiceConfiguration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IESEventServiceConfiguration_Impl::RemoveOwner(this).into()
            }
        }
        unsafe extern "system" fn SetGraph<Identity: IESEventServiceConfiguration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pgraph: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IESEventServiceConfiguration_Impl::SetGraph(this, core::mem::transmute_copy(&pgraph)).into()
            }
        }
        unsafe extern "system" fn RemoveGraph<Identity: IESEventServiceConfiguration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pgraph: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IESEventServiceConfiguration_Impl::RemoveGraph(this, core::mem::transmute_copy(&pgraph)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetParent: SetParent::<Identity, OFFSET>,
            RemoveParent: RemoveParent::<Identity, OFFSET>,
            SetOwner: SetOwner::<Identity, OFFSET>,
            RemoveOwner: RemoveOwner::<Identity, OFFSET>,
            SetGraph: SetGraph::<Identity, OFFSET>,
            RemoveGraph: RemoveGraph::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IESEventServiceConfiguration as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IESEventServiceConfiguration {}
windows_core::imp::define_interface!(IESFileExpiryDateEvent, IESFileExpiryDateEvent_Vtbl, 0xba9edcb6_4d36_4cfe_8c56_87a6b0ca48e1);
impl core::ops::Deref for IESFileExpiryDateEvent {
    type Target = super::IESEvent;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IESFileExpiryDateEvent, windows_core::IUnknown, super::IESEvent);
impl IESFileExpiryDateEvent {
    pub unsafe fn GetTunerId(&self) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTunerId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetExpiryDate(&self) -> windows_core::Result<u64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetExpiryDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetFinalExpiryDate(&self) -> windows_core::Result<u64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFinalExpiryDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetMaxRenewalCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMaxRenewalCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn IsEntitlementTokenPresent(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsEntitlementTokenPresent)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DoesExpireAfterFirstUse(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).DoesExpireAfterFirstUse)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IESFileExpiryDateEvent_Vtbl {
    pub base__: super::IESEvent_Vtbl,
    pub GetTunerId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub GetExpiryDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub GetFinalExpiryDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub GetMaxRenewalCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub IsEntitlementTokenPresent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub DoesExpireAfterFirstUse: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IESFileExpiryDateEvent_Impl: super::IESEvent_Impl {
    fn GetTunerId(&self) -> windows_core::Result<windows_core::GUID>;
    fn GetExpiryDate(&self) -> windows_core::Result<u64>;
    fn GetFinalExpiryDate(&self) -> windows_core::Result<u64>;
    fn GetMaxRenewalCount(&self) -> windows_core::Result<u32>;
    fn IsEntitlementTokenPresent(&self) -> windows_core::Result<windows_core::BOOL>;
    fn DoesExpireAfterFirstUse(&self) -> windows_core::Result<windows_core::BOOL>;
}
#[cfg(feature = "Win32_System_Com")]
impl IESFileExpiryDateEvent_Vtbl {
    pub const fn new<Identity: IESFileExpiryDateEvent_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTunerId<Identity: IESFileExpiryDateEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguidtunerid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESFileExpiryDateEvent_Impl::GetTunerId(this) {
                    Ok(ok__) => {
                        pguidtunerid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetExpiryDate<Identity: IESFileExpiryDateEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqwexpirydate: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESFileExpiryDateEvent_Impl::GetExpiryDate(this) {
                    Ok(ok__) => {
                        pqwexpirydate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFinalExpiryDate<Identity: IESFileExpiryDateEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqwexpirydate: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESFileExpiryDateEvent_Impl::GetFinalExpiryDate(this) {
                    Ok(ok__) => {
                        pqwexpirydate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetMaxRenewalCount<Identity: IESFileExpiryDateEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwmaxrenewalcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESFileExpiryDateEvent_Impl::GetMaxRenewalCount(this) {
                    Ok(ok__) => {
                        dwmaxrenewalcount.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn IsEntitlementTokenPresent<Identity: IESFileExpiryDateEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfenttokenpresent: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESFileExpiryDateEvent_Impl::IsEntitlementTokenPresent(this) {
                    Ok(ok__) => {
                        pfenttokenpresent.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DoesExpireAfterFirstUse<Identity: IESFileExpiryDateEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfexpireafterfirstuse: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESFileExpiryDateEvent_Impl::DoesExpireAfterFirstUse(this) {
                    Ok(ok__) => {
                        pfexpireafterfirstuse.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::IESEvent_Vtbl::new::<Identity, OFFSET>(),
            GetTunerId: GetTunerId::<Identity, OFFSET>,
            GetExpiryDate: GetExpiryDate::<Identity, OFFSET>,
            GetFinalExpiryDate: GetFinalExpiryDate::<Identity, OFFSET>,
            GetMaxRenewalCount: GetMaxRenewalCount::<Identity, OFFSET>,
            IsEntitlementTokenPresent: IsEntitlementTokenPresent::<Identity, OFFSET>,
            DoesExpireAfterFirstUse: DoesExpireAfterFirstUse::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IESFileExpiryDateEvent as windows_core::Interface>::IID || iid == &<super::IESEvent as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IESFileExpiryDateEvent {}
windows_core::imp::define_interface!(IESIsdbCasResponseEvent, IESIsdbCasResponseEvent_Vtbl, 0x2017cb03_dc0f_4c24_83ca_36307b2cd19f);
impl core::ops::Deref for IESIsdbCasResponseEvent {
    type Target = super::IESEvent;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IESIsdbCasResponseEvent, windows_core::IUnknown, super::IESEvent);
impl IESIsdbCasResponseEvent {
    pub unsafe fn GetRequestId(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRequestId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetStatus(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDataLength(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDataLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetResponseData(&self) -> windows_core::Result<*mut super::super::super::System::Com::SAFEARRAY> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetResponseData)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IESIsdbCasResponseEvent_Vtbl {
    pub base__: super::IESEvent_Vtbl,
    pub GetRequestId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDataLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetResponseData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut super::super::super::System::Com::SAFEARRAY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetResponseData: usize,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IESIsdbCasResponseEvent_Impl: super::IESEvent_Impl {
    fn GetRequestId(&self) -> windows_core::Result<u32>;
    fn GetStatus(&self) -> windows_core::Result<u32>;
    fn GetDataLength(&self) -> windows_core::Result<u32>;
    fn GetResponseData(&self) -> windows_core::Result<*mut super::super::super::System::Com::SAFEARRAY>;
}
#[cfg(feature = "Win32_System_Com")]
impl IESIsdbCasResponseEvent_Vtbl {
    pub const fn new<Identity: IESIsdbCasResponseEvent_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetRequestId<Identity: IESIsdbCasResponseEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prequestid: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESIsdbCasResponseEvent_Impl::GetRequestId(this) {
                    Ok(ok__) => {
                        prequestid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetStatus<Identity: IESIsdbCasResponseEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstatus: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESIsdbCasResponseEvent_Impl::GetStatus(this) {
                    Ok(ok__) => {
                        pstatus.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDataLength<Identity: IESIsdbCasResponseEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prequestlength: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESIsdbCasResponseEvent_Impl::GetDataLength(this) {
                    Ok(ok__) => {
                        prequestlength.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetResponseData<Identity: IESIsdbCasResponseEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbdata: *mut *mut super::super::super::System::Com::SAFEARRAY) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESIsdbCasResponseEvent_Impl::GetResponseData(this) {
                    Ok(ok__) => {
                        pbdata.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::IESEvent_Vtbl::new::<Identity, OFFSET>(),
            GetRequestId: GetRequestId::<Identity, OFFSET>,
            GetStatus: GetStatus::<Identity, OFFSET>,
            GetDataLength: GetDataLength::<Identity, OFFSET>,
            GetResponseData: GetResponseData::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IESIsdbCasResponseEvent as windows_core::Interface>::IID || iid == &<super::IESEvent as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IESIsdbCasResponseEvent {}
windows_core::imp::define_interface!(IESLicenseRenewalResultEvent, IESLicenseRenewalResultEvent_Vtbl, 0xd5a48ef5_a81b_4df0_acaa_5e35e7ea45d4);
impl core::ops::Deref for IESLicenseRenewalResultEvent {
    type Target = super::IESEvent;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IESLicenseRenewalResultEvent, windows_core::IUnknown, super::IESEvent);
impl IESLicenseRenewalResultEvent {
    pub unsafe fn GetCallersId(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCallersId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetFileName(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFileName)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn IsRenewalSuccessful(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsRenewalSuccessful)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn IsCheckEntitlementCallRequired(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsCheckEntitlementCallRequired)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDescrambledStatus(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDescrambledStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRenewalResultCode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRenewalResultCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCASFailureCode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCASFailureCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRenewalHResult(&self) -> windows_core::Result<windows_core::HRESULT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRenewalHResult)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetEntitlementTokenLength(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEntitlementTokenLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetEntitlementToken(&self) -> windows_core::Result<*mut super::super::super::System::Com::SAFEARRAY> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEntitlementToken)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetExpiryDate(&self) -> windows_core::Result<u64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetExpiryDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IESLicenseRenewalResultEvent_Vtbl {
    pub base__: super::IESEvent_Vtbl,
    pub GetCallersId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetFileName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub IsRenewalSuccessful: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub IsCheckEntitlementCallRequired: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetDescrambledStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRenewalResultCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCASFailureCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRenewalHResult: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::HRESULT) -> windows_core::HRESULT,
    pub GetEntitlementTokenLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetEntitlementToken: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut super::super::super::System::Com::SAFEARRAY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetEntitlementToken: usize,
    pub GetExpiryDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IESLicenseRenewalResultEvent_Impl: super::IESEvent_Impl {
    fn GetCallersId(&self) -> windows_core::Result<u32>;
    fn GetFileName(&self) -> windows_core::Result<windows_core::BSTR>;
    fn IsRenewalSuccessful(&self) -> windows_core::Result<windows_core::BOOL>;
    fn IsCheckEntitlementCallRequired(&self) -> windows_core::Result<windows_core::BOOL>;
    fn GetDescrambledStatus(&self) -> windows_core::Result<u32>;
    fn GetRenewalResultCode(&self) -> windows_core::Result<u32>;
    fn GetCASFailureCode(&self) -> windows_core::Result<u32>;
    fn GetRenewalHResult(&self) -> windows_core::Result<windows_core::HRESULT>;
    fn GetEntitlementTokenLength(&self) -> windows_core::Result<u32>;
    fn GetEntitlementToken(&self) -> windows_core::Result<*mut super::super::super::System::Com::SAFEARRAY>;
    fn GetExpiryDate(&self) -> windows_core::Result<u64>;
}
#[cfg(feature = "Win32_System_Com")]
impl IESLicenseRenewalResultEvent_Vtbl {
    pub const fn new<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetCallersId<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwcallersid: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::GetCallersId(this) {
                    Ok(ok__) => {
                        pdwcallersid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFileName<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrfilename: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::GetFileName(this) {
                    Ok(ok__) => {
                        pbstrfilename.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn IsRenewalSuccessful<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfrenewalsuccessful: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::IsRenewalSuccessful(this) {
                    Ok(ok__) => {
                        pfrenewalsuccessful.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn IsCheckEntitlementCallRequired<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfcheckenttokencallneeded: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::IsCheckEntitlementCallRequired(this) {
                    Ok(ok__) => {
                        pfcheckenttokencallneeded.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDescrambledStatus<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdescrambledstatus: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::GetDescrambledStatus(this) {
                    Ok(ok__) => {
                        pdescrambledstatus.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRenewalResultCode<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwrenewalresultcode: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::GetRenewalResultCode(this) {
                    Ok(ok__) => {
                        pdwrenewalresultcode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCASFailureCode<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwcasfailurecode: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::GetCASFailureCode(this) {
                    Ok(ok__) => {
                        pdwcasfailurecode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRenewalHResult<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, phr: *mut windows_core::HRESULT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::GetRenewalHResult(this) {
                    Ok(ok__) => {
                        phr.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetEntitlementTokenLength<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwlength: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::GetEntitlementTokenLength(this) {
                    Ok(ok__) => {
                        pdwlength.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetEntitlementToken<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbdata: *mut *mut super::super::super::System::Com::SAFEARRAY) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::GetEntitlementToken(this) {
                    Ok(ok__) => {
                        pbdata.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetExpiryDate<Identity: IESLicenseRenewalResultEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqwexpirydate: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESLicenseRenewalResultEvent_Impl::GetExpiryDate(this) {
                    Ok(ok__) => {
                        pqwexpirydate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::IESEvent_Vtbl::new::<Identity, OFFSET>(),
            GetCallersId: GetCallersId::<Identity, OFFSET>,
            GetFileName: GetFileName::<Identity, OFFSET>,
            IsRenewalSuccessful: IsRenewalSuccessful::<Identity, OFFSET>,
            IsCheckEntitlementCallRequired: IsCheckEntitlementCallRequired::<Identity, OFFSET>,
            GetDescrambledStatus: GetDescrambledStatus::<Identity, OFFSET>,
            GetRenewalResultCode: GetRenewalResultCode::<Identity, OFFSET>,
            GetCASFailureCode: GetCASFailureCode::<Identity, OFFSET>,
            GetRenewalHResult: GetRenewalHResult::<Identity, OFFSET>,
            GetEntitlementTokenLength: GetEntitlementTokenLength::<Identity, OFFSET>,
            GetEntitlementToken: GetEntitlementToken::<Identity, OFFSET>,
            GetExpiryDate: GetExpiryDate::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IESLicenseRenewalResultEvent as windows_core::Interface>::IID || iid == &<super::IESEvent as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IESLicenseRenewalResultEvent {}
windows_core::imp::define_interface!(IESOpenMmiEvent, IESOpenMmiEvent_Vtbl, 0xba4b6526_1a35_4635_8b56_3ec612746a8c);
impl core::ops::Deref for IESOpenMmiEvent {
    type Target = super::IESEvent;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IESOpenMmiEvent, windows_core::IUnknown, super::IESEvent);
impl IESOpenMmiEvent {
    pub unsafe fn GetDialogNumber(&self, pdialogrequest: *mut u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDialogNumber)(windows_core::Interface::as_raw(self), pdialogrequest as _, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDialogType(&self) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDialogType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetDialogData(&self) -> windows_core::Result<*mut super::super::super::System::Com::SAFEARRAY> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDialogData)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDialogStringData(&self, pbstrbaseurl: *mut windows_core::BSTR) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDialogStringData)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrbaseurl), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IESOpenMmiEvent_Vtbl {
    pub base__: super::IESEvent_Vtbl,
    pub GetDialogNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetDialogType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetDialogData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut super::super::super::System::Com::SAFEARRAY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetDialogData: usize,
    pub GetDialogStringData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IESOpenMmiEvent_Impl: super::IESEvent_Impl {
    fn GetDialogNumber(&self, pdialogrequest: *mut u32) -> windows_core::Result<u32>;
    fn GetDialogType(&self) -> windows_core::Result<windows_core::GUID>;
    fn GetDialogData(&self) -> windows_core::Result<*mut super::super::super::System::Com::SAFEARRAY>;
    fn GetDialogStringData(&self, pbstrbaseurl: *mut windows_core::BSTR) -> windows_core::Result<windows_core::BSTR>;
}
#[cfg(feature = "Win32_System_Com")]
impl IESOpenMmiEvent_Vtbl {
    pub const fn new<Identity: IESOpenMmiEvent_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDialogNumber<Identity: IESOpenMmiEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdialogrequest: *mut u32, pdialognumber: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESOpenMmiEvent_Impl::GetDialogNumber(this, core::mem::transmute_copy(&pdialogrequest)) {
                    Ok(ok__) => {
                        pdialognumber.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDialogType<Identity: IESOpenMmiEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guiddialogtype: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESOpenMmiEvent_Impl::GetDialogType(this) {
                    Ok(ok__) => {
                        guiddialogtype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDialogData<Identity: IESOpenMmiEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbdata: *mut *mut super::super::super::System::Com::SAFEARRAY) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESOpenMmiEvent_Impl::GetDialogData(this) {
                    Ok(ok__) => {
                        pbdata.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDialogStringData<Identity: IESOpenMmiEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrbaseurl: *mut *mut core::ffi::c_void, pbstrdata: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESOpenMmiEvent_Impl::GetDialogStringData(this, core::mem::transmute_copy(&pbstrbaseurl)) {
                    Ok(ok__) => {
                        pbstrdata.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::IESEvent_Vtbl::new::<Identity, OFFSET>(),
            GetDialogNumber: GetDialogNumber::<Identity, OFFSET>,
            GetDialogType: GetDialogType::<Identity, OFFSET>,
            GetDialogData: GetDialogData::<Identity, OFFSET>,
            GetDialogStringData: GetDialogStringData::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IESOpenMmiEvent as windows_core::Interface>::IID || iid == &<super::IESEvent as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IESOpenMmiEvent {}
windows_core::imp::define_interface!(IESRequestTunerEvent, IESRequestTunerEvent_Vtbl, 0x54c7a5e8_c3bb_4f51_af14_e0e2c0e34c6d);
impl core::ops::Deref for IESRequestTunerEvent {
    type Target = super::IESEvent;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IESRequestTunerEvent, windows_core::IUnknown, super::IESEvent);
impl IESRequestTunerEvent {
    pub unsafe fn GetPriority(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPriority)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetReason(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetReason)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetConsequences(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetConsequences)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetEstimatedTime(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEstimatedTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IESRequestTunerEvent_Vtbl {
    pub base__: super::IESEvent_Vtbl,
    pub GetPriority: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetReason: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetConsequences: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetEstimatedTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IESRequestTunerEvent_Impl: super::IESEvent_Impl {
    fn GetPriority(&self) -> windows_core::Result<u8>;
    fn GetReason(&self) -> windows_core::Result<u8>;
    fn GetConsequences(&self) -> windows_core::Result<u8>;
    fn GetEstimatedTime(&self) -> windows_core::Result<u32>;
}
#[cfg(feature = "Win32_System_Com")]
impl IESRequestTunerEvent_Vtbl {
    pub const fn new<Identity: IESRequestTunerEvent_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetPriority<Identity: IESRequestTunerEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbypriority: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESRequestTunerEvent_Impl::GetPriority(this) {
                    Ok(ok__) => {
                        pbypriority.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetReason<Identity: IESRequestTunerEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbyreason: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESRequestTunerEvent_Impl::GetReason(this) {
                    Ok(ok__) => {
                        pbyreason.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetConsequences<Identity: IESRequestTunerEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbyconsequences: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESRequestTunerEvent_Impl::GetConsequences(this) {
                    Ok(ok__) => {
                        pbyconsequences.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetEstimatedTime<Identity: IESRequestTunerEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwestimatedtime: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESRequestTunerEvent_Impl::GetEstimatedTime(this) {
                    Ok(ok__) => {
                        pdwestimatedtime.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::IESEvent_Vtbl::new::<Identity, OFFSET>(),
            GetPriority: GetPriority::<Identity, OFFSET>,
            GetReason: GetReason::<Identity, OFFSET>,
            GetConsequences: GetConsequences::<Identity, OFFSET>,
            GetEstimatedTime: GetEstimatedTime::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IESRequestTunerEvent as windows_core::Interface>::IID || iid == &<super::IESEvent as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IESRequestTunerEvent {}
windows_core::imp::define_interface!(IESValueUpdatedEvent, IESValueUpdatedEvent_Vtbl, 0x8a24c46e_bb63_4664_8602_5d9c718c146d);
impl core::ops::Deref for IESValueUpdatedEvent {
    type Target = super::IESEvent;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IESValueUpdatedEvent, windows_core::IUnknown, super::IESEvent);
impl IESValueUpdatedEvent {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetValueNames(&self) -> windows_core::Result<*mut super::super::super::System::Com::SAFEARRAY> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetValueNames)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IESValueUpdatedEvent_Vtbl {
    pub base__: super::IESEvent_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetValueNames: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut super::super::super::System::Com::SAFEARRAY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetValueNames: usize,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IESValueUpdatedEvent_Impl: super::IESEvent_Impl {
    fn GetValueNames(&self) -> windows_core::Result<*mut super::super::super::System::Com::SAFEARRAY>;
}
#[cfg(feature = "Win32_System_Com")]
impl IESValueUpdatedEvent_Vtbl {
    pub const fn new<Identity: IESValueUpdatedEvent_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetValueNames<Identity: IESValueUpdatedEvent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrnames: *mut *mut super::super::super::System::Com::SAFEARRAY) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IESValueUpdatedEvent_Impl::GetValueNames(this) {
                    Ok(ok__) => {
                        pbstrnames.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: super::IESEvent_Vtbl::new::<Identity, OFFSET>(), GetValueNames: GetValueNames::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IESValueUpdatedEvent as windows_core::Interface>::IID || iid == &<super::IESEvent as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IESValueUpdatedEvent {}
windows_core::imp::define_interface!(IETFilter, IETFilter_Vtbl, 0xc4c4c4b1_0049_4e2b_98fb_9537f6ce516d);
windows_core::imp::interface_hierarchy!(IETFilter, windows_core::IUnknown);
impl IETFilter {
    pub unsafe fn EvalRatObjOK(&self) -> windows_core::Result<windows_core::HRESULT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EvalRatObjOK)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCurrRating(&self, pensystem: *mut EnTvRat_System, penrating: *mut EnTvRat_GenericLevel, plbfenattr: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCurrRating)(windows_core::Interface::as_raw(self), pensystem as _, penrating as _, plbfenattr as _).ok() }
    }
    pub unsafe fn GetCurrLicenseExpDate(&self, prottype: *const ProtType) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCurrLicenseExpDate)(windows_core::Interface::as_raw(self), prottype, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLastErrorCode(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetLastErrorCode)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn SetRecordingOn(&self, frecstate: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetRecordingOn)(windows_core::Interface::as_raw(self), frecstate.into()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IETFilter_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub EvalRatObjOK: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::HRESULT) -> windows_core::HRESULT,
    pub GetCurrRating: unsafe extern "system" fn(*mut core::ffi::c_void, *mut EnTvRat_System, *mut EnTvRat_GenericLevel, *mut i32) -> windows_core::HRESULT,
    pub GetCurrLicenseExpDate: unsafe extern "system" fn(*mut core::ffi::c_void, *const ProtType, *mut i32) -> windows_core::HRESULT,
    pub GetLastErrorCode: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetRecordingOn: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
}
pub trait IETFilter_Impl: windows_core::IUnknownImpl {
    fn EvalRatObjOK(&self) -> windows_core::Result<windows_core::HRESULT>;
    fn GetCurrRating(&self, pensystem: *mut EnTvRat_System, penrating: *mut EnTvRat_GenericLevel, plbfenattr: *mut i32) -> windows_core::Result<()>;
    fn GetCurrLicenseExpDate(&self, prottype: *const ProtType) -> windows_core::Result<i32>;
    fn GetLastErrorCode(&self) -> windows_core::Result<()>;
    fn SetRecordingOn(&self, frecstate: windows_core::BOOL) -> windows_core::Result<()>;
}
impl IETFilter_Vtbl {
    pub const fn new<Identity: IETFilter_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn EvalRatObjOK<Identity: IETFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, phrcocreateretval: *mut windows_core::HRESULT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IETFilter_Impl::EvalRatObjOK(this) {
                    Ok(ok__) => {
                        phrcocreateretval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCurrRating<Identity: IETFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pensystem: *mut EnTvRat_System, penrating: *mut EnTvRat_GenericLevel, plbfenattr: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IETFilter_Impl::GetCurrRating(this, core::mem::transmute_copy(&pensystem), core::mem::transmute_copy(&penrating), core::mem::transmute_copy(&plbfenattr)).into()
            }
        }
        unsafe extern "system" fn GetCurrLicenseExpDate<Identity: IETFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prottype: *const ProtType, lpdatetime: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IETFilter_Impl::GetCurrLicenseExpDate(this, core::mem::transmute_copy(&prottype)) {
                    Ok(ok__) => {
                        lpdatetime.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLastErrorCode<Identity: IETFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IETFilter_Impl::GetLastErrorCode(this).into()
            }
        }
        unsafe extern "system" fn SetRecordingOn<Identity: IETFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, frecstate: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IETFilter_Impl::SetRecordingOn(this, core::mem::transmute_copy(&frecstate)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            EvalRatObjOK: EvalRatObjOK::<Identity, OFFSET>,
            GetCurrRating: GetCurrRating::<Identity, OFFSET>,
            GetCurrLicenseExpDate: GetCurrLicenseExpDate::<Identity, OFFSET>,
            GetLastErrorCode: GetLastErrorCode::<Identity, OFFSET>,
            SetRecordingOn: SetRecordingOn::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IETFilter as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IETFilter {}
windows_core::imp::define_interface!(IETFilterConfig, IETFilterConfig_Vtbl, 0xc4c4c4d1_0049_4e2b_98fb_9537f6ce516d);
windows_core::imp::interface_hierarchy!(IETFilterConfig, windows_core::IUnknown);
impl IETFilterConfig {
    pub unsafe fn InitLicense(&self, licenseid: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).InitLicense)(windows_core::Interface::as_raw(self), licenseid).ok() }
    }
    pub unsafe fn GetSecureChannelObject(&self) -> windows_core::Result<windows_core::IUnknown> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSecureChannelObject)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IETFilterConfig_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub InitLicense: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub GetSecureChannelObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IETFilterConfig_Impl: windows_core::IUnknownImpl {
    fn InitLicense(&self, licenseid: i32) -> windows_core::Result<()>;
    fn GetSecureChannelObject(&self) -> windows_core::Result<windows_core::IUnknown>;
}
impl IETFilterConfig_Vtbl {
    pub const fn new<Identity: IETFilterConfig_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn InitLicense<Identity: IETFilterConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, licenseid: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IETFilterConfig_Impl::InitLicense(this, core::mem::transmute_copy(&licenseid)).into()
            }
        }
        unsafe extern "system" fn GetSecureChannelObject<Identity: IETFilterConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppunkdrmsecurechannel: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IETFilterConfig_Impl::GetSecureChannelObject(this) {
                    Ok(ok__) => {
                        ppunkdrmsecurechannel.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            InitLicense: InitLicense::<Identity, OFFSET>,
            GetSecureChannelObject: GetSecureChannelObject::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IETFilterConfig as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IETFilterConfig {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IETFilterEvents, IETFilterEvents_Vtbl, 0xc4c4c4c1_0049_4e2b_98fb_9537f6ce516d);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IETFilterEvents {
    type Target = super::super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IETFilterEvents, windows_core::IUnknown, super::super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IETFilterEvents_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IETFilterEvents_Impl: super::super::super::System::Com::IDispatch_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IETFilterEvents_Vtbl {
    pub const fn new<Identity: IETFilterEvents_Impl, const OFFSET: isize>() -> Self {
        Self { base__: super::super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IETFilterEvents as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IETFilterEvents {}
windows_core::imp::define_interface!(IEnumComponentTypes, IEnumComponentTypes_Vtbl, 0x8a674b4a_1f63_11d3_b64c_00c04f79498e);
windows_core::imp::interface_hierarchy!(IEnumComponentTypes, windows_core::IUnknown);
impl IEnumComponentTypes {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Next(&self, rgelt: &mut [Option<IComponentType>], pceltfetched: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), pceltfetched as _).ok() }
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok() }
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumComponentTypes> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumComponentTypes_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IEnumComponentTypes_Impl: windows_core::IUnknownImpl {
    fn Next(&self, celt: u32, rgelt: *mut Option<IComponentType>, pceltfetched: *mut u32) -> windows_core::Result<()>;
    fn Skip(&self, celt: u32) -> windows_core::Result<()>;
    fn Reset(&self) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IEnumComponentTypes>;
}
#[cfg(feature = "Win32_System_Com")]
impl IEnumComponentTypes_Vtbl {
    pub const fn new<Identity: IEnumComponentTypes_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Next<Identity: IEnumComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32, rgelt: *mut *mut core::ffi::c_void, pceltfetched: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumComponentTypes_Impl::Next(this, core::mem::transmute_copy(&celt), core::mem::transmute_copy(&rgelt), core::mem::transmute_copy(&pceltfetched)).into()
            }
        }
        unsafe extern "system" fn Skip<Identity: IEnumComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumComponentTypes_Impl::Skip(this, core::mem::transmute_copy(&celt)).into()
            }
        }
        unsafe extern "system" fn Reset<Identity: IEnumComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumComponentTypes_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IEnumComponentTypes_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEnumComponentTypes_Impl::Clone(this) {
                    Ok(ok__) => {
                        ppenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Next: Next::<Identity, OFFSET>,
            Skip: Skip::<Identity, OFFSET>,
            Reset: Reset::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEnumComponentTypes as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IEnumComponentTypes {}
windows_core::imp::define_interface!(IEnumComponents, IEnumComponents_Vtbl, 0x2a6e2939_2595_11d3_b64c_00c04f79498e);
windows_core::imp::interface_hierarchy!(IEnumComponents, windows_core::IUnknown);
impl IEnumComponents {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Next(&self, rgelt: &mut [Option<IComponent>], pceltfetched: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), pceltfetched as _).ok() }
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok() }
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumComponents> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumComponents_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IEnumComponents_Impl: windows_core::IUnknownImpl {
    fn Next(&self, celt: u32, rgelt: *mut Option<IComponent>, pceltfetched: *mut u32) -> windows_core::Result<()>;
    fn Skip(&self, celt: u32) -> windows_core::Result<()>;
    fn Reset(&self) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IEnumComponents>;
}
#[cfg(feature = "Win32_System_Com")]
impl IEnumComponents_Vtbl {
    pub const fn new<Identity: IEnumComponents_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Next<Identity: IEnumComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32, rgelt: *mut *mut core::ffi::c_void, pceltfetched: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumComponents_Impl::Next(this, core::mem::transmute_copy(&celt), core::mem::transmute_copy(&rgelt), core::mem::transmute_copy(&pceltfetched)).into()
            }
        }
        unsafe extern "system" fn Skip<Identity: IEnumComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumComponents_Impl::Skip(this, core::mem::transmute_copy(&celt)).into()
            }
        }
        unsafe extern "system" fn Reset<Identity: IEnumComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumComponents_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IEnumComponents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEnumComponents_Impl::Clone(this) {
                    Ok(ok__) => {
                        ppenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Next: Next::<Identity, OFFSET>,
            Skip: Skip::<Identity, OFFSET>,
            Reset: Reset::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEnumComponents as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IEnumComponents {}
windows_core::imp::define_interface!(IEnumGuideDataProperties, IEnumGuideDataProperties_Vtbl, 0xae44423b_4571_475c_ad2c_f40a771d80ef);
windows_core::imp::interface_hierarchy!(IEnumGuideDataProperties, windows_core::IUnknown);
impl IEnumGuideDataProperties {
    pub unsafe fn Next(&self, celt: u32, ppprop: *mut Option<IGuideDataProperty>, pcelt: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), celt, core::mem::transmute(ppprop), pcelt as _).ok() }
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok() }
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumGuideDataProperties> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumGuideDataProperties_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IEnumGuideDataProperties_Impl: windows_core::IUnknownImpl {
    fn Next(&self, celt: u32, ppprop: windows_core::OutRef<'_, IGuideDataProperty>, pcelt: *mut u32) -> windows_core::Result<()>;
    fn Skip(&self, celt: u32) -> windows_core::Result<()>;
    fn Reset(&self) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IEnumGuideDataProperties>;
}
impl IEnumGuideDataProperties_Vtbl {
    pub const fn new<Identity: IEnumGuideDataProperties_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Next<Identity: IEnumGuideDataProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32, ppprop: *mut *mut core::ffi::c_void, pcelt: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumGuideDataProperties_Impl::Next(this, core::mem::transmute_copy(&celt), core::mem::transmute_copy(&ppprop), core::mem::transmute_copy(&pcelt)).into()
            }
        }
        unsafe extern "system" fn Skip<Identity: IEnumGuideDataProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumGuideDataProperties_Impl::Skip(this, core::mem::transmute_copy(&celt)).into()
            }
        }
        unsafe extern "system" fn Reset<Identity: IEnumGuideDataProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumGuideDataProperties_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IEnumGuideDataProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEnumGuideDataProperties_Impl::Clone(this) {
                    Ok(ok__) => {
                        ppenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Next: Next::<Identity, OFFSET>,
            Skip: Skip::<Identity, OFFSET>,
            Reset: Reset::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEnumGuideDataProperties as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IEnumGuideDataProperties {}
windows_core::imp::define_interface!(IEnumMSVidGraphSegment, IEnumMSVidGraphSegment_Vtbl, 0x3dd2903e_e0aa_11d2_b63a_00c04f79498e);
windows_core::imp::interface_hierarchy!(IEnumMSVidGraphSegment, windows_core::IUnknown);
impl IEnumMSVidGraphSegment {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Next(&self, celt: u32, rgelt: *mut Option<IMSVidGraphSegment>, pceltfetched: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), celt, core::mem::transmute(rgelt), pceltfetched as _).ok() }
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok() }
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumMSVidGraphSegment> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumMSVidGraphSegment_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IEnumMSVidGraphSegment_Impl: windows_core::IUnknownImpl {
    fn Next(&self, celt: u32, rgelt: windows_core::OutRef<'_, IMSVidGraphSegment>, pceltfetched: *mut u32) -> windows_core::Result<()>;
    fn Skip(&self, celt: u32) -> windows_core::Result<()>;
    fn Reset(&self) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IEnumMSVidGraphSegment>;
}
#[cfg(feature = "Win32_System_Com")]
impl IEnumMSVidGraphSegment_Vtbl {
    pub const fn new<Identity: IEnumMSVidGraphSegment_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Next<Identity: IEnumMSVidGraphSegment_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32, rgelt: *mut *mut core::ffi::c_void, pceltfetched: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumMSVidGraphSegment_Impl::Next(this, core::mem::transmute_copy(&celt), core::mem::transmute_copy(&rgelt), core::mem::transmute_copy(&pceltfetched)).into()
            }
        }
        unsafe extern "system" fn Skip<Identity: IEnumMSVidGraphSegment_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumMSVidGraphSegment_Impl::Skip(this, core::mem::transmute_copy(&celt)).into()
            }
        }
        unsafe extern "system" fn Reset<Identity: IEnumMSVidGraphSegment_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumMSVidGraphSegment_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IEnumMSVidGraphSegment_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEnumMSVidGraphSegment_Impl::Clone(this) {
                    Ok(ok__) => {
                        ppenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Next: Next::<Identity, OFFSET>,
            Skip: Skip::<Identity, OFFSET>,
            Reset: Reset::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEnumMSVidGraphSegment as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IEnumMSVidGraphSegment {}
windows_core::imp::define_interface!(IEnumStreamBufferRecordingAttrib, IEnumStreamBufferRecordingAttrib_Vtbl, 0xc18a9162_1e82_4142_8c73_5690fa62fe33);
windows_core::imp::interface_hierarchy!(IEnumStreamBufferRecordingAttrib, windows_core::IUnknown);
impl IEnumStreamBufferRecordingAttrib {
    pub unsafe fn Next(&self, pstreambufferattribute: &mut [STREAMBUFFER_ATTRIBUTE], pcreceived: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), pstreambufferattribute.len().try_into().unwrap(), core::mem::transmute(pstreambufferattribute.as_ptr()), pcreceived as _).ok() }
    }
    pub unsafe fn Skip(&self, crecords: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), crecords).ok() }
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumStreamBufferRecordingAttrib> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumStreamBufferRecordingAttrib_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut STREAMBUFFER_ATTRIBUTE, *mut u32) -> windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IEnumStreamBufferRecordingAttrib_Impl: windows_core::IUnknownImpl {
    fn Next(&self, crequest: u32, pstreambufferattribute: *mut STREAMBUFFER_ATTRIBUTE, pcreceived: *mut u32) -> windows_core::Result<()>;
    fn Skip(&self, crecords: u32) -> windows_core::Result<()>;
    fn Reset(&self) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IEnumStreamBufferRecordingAttrib>;
}
impl IEnumStreamBufferRecordingAttrib_Vtbl {
    pub const fn new<Identity: IEnumStreamBufferRecordingAttrib_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Next<Identity: IEnumStreamBufferRecordingAttrib_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, crequest: u32, pstreambufferattribute: *mut STREAMBUFFER_ATTRIBUTE, pcreceived: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumStreamBufferRecordingAttrib_Impl::Next(this, core::mem::transmute_copy(&crequest), core::mem::transmute_copy(&pstreambufferattribute), core::mem::transmute_copy(&pcreceived)).into()
            }
        }
        unsafe extern "system" fn Skip<Identity: IEnumStreamBufferRecordingAttrib_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, crecords: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumStreamBufferRecordingAttrib_Impl::Skip(this, core::mem::transmute_copy(&crecords)).into()
            }
        }
        unsafe extern "system" fn Reset<Identity: IEnumStreamBufferRecordingAttrib_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumStreamBufferRecordingAttrib_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IEnumStreamBufferRecordingAttrib_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppienumstreambufferattrib: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEnumStreamBufferRecordingAttrib_Impl::Clone(this) {
                    Ok(ok__) => {
                        ppienumstreambufferattrib.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Next: Next::<Identity, OFFSET>,
            Skip: Skip::<Identity, OFFSET>,
            Reset: Reset::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEnumStreamBufferRecordingAttrib as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IEnumStreamBufferRecordingAttrib {}
windows_core::imp::define_interface!(IEnumTuneRequests, IEnumTuneRequests_Vtbl, 0x1993299c_ced6_4788_87a3_420067dce0c7);
windows_core::imp::interface_hierarchy!(IEnumTuneRequests, windows_core::IUnknown);
impl IEnumTuneRequests {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Next(&self, celt: u32, ppprop: *mut Option<ITuneRequest>, pcelt: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), celt, core::mem::transmute(ppprop), pcelt as _).ok() }
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok() }
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumTuneRequests> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumTuneRequests_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IEnumTuneRequests_Impl: windows_core::IUnknownImpl {
    fn Next(&self, celt: u32, ppprop: windows_core::OutRef<'_, ITuneRequest>, pcelt: *mut u32) -> windows_core::Result<()>;
    fn Skip(&self, celt: u32) -> windows_core::Result<()>;
    fn Reset(&self) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IEnumTuneRequests>;
}
#[cfg(feature = "Win32_System_Com")]
impl IEnumTuneRequests_Vtbl {
    pub const fn new<Identity: IEnumTuneRequests_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Next<Identity: IEnumTuneRequests_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32, ppprop: *mut *mut core::ffi::c_void, pcelt: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumTuneRequests_Impl::Next(this, core::mem::transmute_copy(&celt), core::mem::transmute_copy(&ppprop), core::mem::transmute_copy(&pcelt)).into()
            }
        }
        unsafe extern "system" fn Skip<Identity: IEnumTuneRequests_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumTuneRequests_Impl::Skip(this, core::mem::transmute_copy(&celt)).into()
            }
        }
        unsafe extern "system" fn Reset<Identity: IEnumTuneRequests_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumTuneRequests_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IEnumTuneRequests_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEnumTuneRequests_Impl::Clone(this) {
                    Ok(ok__) => {
                        ppenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Next: Next::<Identity, OFFSET>,
            Skip: Skip::<Identity, OFFSET>,
            Reset: Reset::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEnumTuneRequests as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IEnumTuneRequests {}
windows_core::imp::define_interface!(IEnumTuningSpaces, IEnumTuningSpaces_Vtbl, 0x8b8eb248_fc2b_11d2_9d8c_00c04f72d980);
windows_core::imp::interface_hierarchy!(IEnumTuningSpaces, windows_core::IUnknown);
impl IEnumTuningSpaces {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Next(&self, rgelt: &mut [Option<ITuningSpace>], pceltfetched: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Next)(windows_core::Interface::as_raw(self), rgelt.len().try_into().unwrap(), core::mem::transmute(rgelt.as_ptr()), pceltfetched as _).ok() }
    }
    pub unsafe fn Skip(&self, celt: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Skip)(windows_core::Interface::as_raw(self), celt).ok() }
    }
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IEnumTuningSpaces> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumTuningSpaces_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Next: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IEnumTuningSpaces_Impl: windows_core::IUnknownImpl {
    fn Next(&self, celt: u32, rgelt: *mut Option<ITuningSpace>, pceltfetched: *mut u32) -> windows_core::Result<()>;
    fn Skip(&self, celt: u32) -> windows_core::Result<()>;
    fn Reset(&self) -> windows_core::Result<()>;
    fn Clone(&self) -> windows_core::Result<IEnumTuningSpaces>;
}
#[cfg(feature = "Win32_System_Com")]
impl IEnumTuningSpaces_Vtbl {
    pub const fn new<Identity: IEnumTuningSpaces_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Next<Identity: IEnumTuningSpaces_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32, rgelt: *mut *mut core::ffi::c_void, pceltfetched: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumTuningSpaces_Impl::Next(this, core::mem::transmute_copy(&celt), core::mem::transmute_copy(&rgelt), core::mem::transmute_copy(&pceltfetched)).into()
            }
        }
        unsafe extern "system" fn Skip<Identity: IEnumTuningSpaces_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, celt: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumTuningSpaces_Impl::Skip(this, core::mem::transmute_copy(&celt)).into()
            }
        }
        unsafe extern "system" fn Reset<Identity: IEnumTuningSpaces_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEnumTuningSpaces_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn Clone<Identity: IEnumTuningSpaces_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEnumTuningSpaces_Impl::Clone(this) {
                    Ok(ok__) => {
                        ppenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Next: Next::<Identity, OFFSET>,
            Skip: Skip::<Identity, OFFSET>,
            Reset: Reset::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEnumTuningSpaces as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IEnumTuningSpaces {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IEvalRat, IEvalRat_Vtbl, 0xc5c5c5b1_3abc_11d6_b25b_00c04fa0c026);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IEvalRat {
    type Target = super::super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IEvalRat, windows_core::IUnknown, super::super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IEvalRat {
    pub unsafe fn get_BlockedRatingAttributes(&self, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).get_BlockedRatingAttributes)(windows_core::Interface::as_raw(self), ensystem, enlevel, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn put_BlockedRatingAttributes(&self, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel, lbfattrs: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).put_BlockedRatingAttributes)(windows_core::Interface::as_raw(self), ensystem, enlevel, lbfattrs).ok() }
    }
    pub unsafe fn BlockUnRated(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).BlockUnRated)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetBlockUnRated(&self, fblockunratedshows: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBlockUnRated)(windows_core::Interface::as_raw(self), fblockunratedshows.into()).ok() }
    }
    pub unsafe fn MostRestrictiveRating(&self, ensystem1: EnTvRat_System, enenlevel1: EnTvRat_GenericLevel, lbfenattr1: i32, ensystem2: EnTvRat_System, enenlevel2: EnTvRat_GenericLevel, lbfenattr2: i32, pensystem: *mut EnTvRat_System, penenlevel: *mut EnTvRat_GenericLevel, plbfenattr: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).MostRestrictiveRating)(windows_core::Interface::as_raw(self), ensystem1, enenlevel1, lbfenattr1, ensystem2, enenlevel2, lbfenattr2, pensystem as _, penenlevel as _, plbfenattr as _).ok() }
    }
    pub unsafe fn TestRating(&self, enshowsystem: EnTvRat_System, enshowlevel: EnTvRat_GenericLevel, lbfenshowattributes: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TestRating)(windows_core::Interface::as_raw(self), enshowsystem, enshowlevel, lbfenshowattributes).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IEvalRat_Vtbl {
    pub base__: super::super::super::System::Com::IDispatch_Vtbl,
    pub get_BlockedRatingAttributes: unsafe extern "system" fn(*mut core::ffi::c_void, EnTvRat_System, EnTvRat_GenericLevel, *mut i32) -> windows_core::HRESULT,
    pub put_BlockedRatingAttributes: unsafe extern "system" fn(*mut core::ffi::c_void, EnTvRat_System, EnTvRat_GenericLevel, i32) -> windows_core::HRESULT,
    pub BlockUnRated: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetBlockUnRated: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub MostRestrictiveRating: unsafe extern "system" fn(*mut core::ffi::c_void, EnTvRat_System, EnTvRat_GenericLevel, i32, EnTvRat_System, EnTvRat_GenericLevel, i32, *mut EnTvRat_System, *mut EnTvRat_GenericLevel, *mut i32) -> windows_core::HRESULT,
    pub TestRating: unsafe extern "system" fn(*mut core::ffi::c_void, EnTvRat_System, EnTvRat_GenericLevel, i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IEvalRat_Impl: super::super::super::System::Com::IDispatch_Impl {
    fn get_BlockedRatingAttributes(&self, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel) -> windows_core::Result<i32>;
    fn put_BlockedRatingAttributes(&self, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel, lbfattrs: i32) -> windows_core::Result<()>;
    fn BlockUnRated(&self) -> windows_core::Result<windows_core::BOOL>;
    fn SetBlockUnRated(&self, fblockunratedshows: windows_core::BOOL) -> windows_core::Result<()>;
    fn MostRestrictiveRating(&self, ensystem1: EnTvRat_System, enenlevel1: EnTvRat_GenericLevel, lbfenattr1: i32, ensystem2: EnTvRat_System, enenlevel2: EnTvRat_GenericLevel, lbfenattr2: i32, pensystem: *mut EnTvRat_System, penenlevel: *mut EnTvRat_GenericLevel, plbfenattr: *mut i32) -> windows_core::Result<()>;
    fn TestRating(&self, enshowsystem: EnTvRat_System, enshowlevel: EnTvRat_GenericLevel, lbfenshowattributes: i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IEvalRat_Vtbl {
    pub const fn new<Identity: IEvalRat_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn get_BlockedRatingAttributes<Identity: IEvalRat_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel, plbfattrs: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEvalRat_Impl::get_BlockedRatingAttributes(this, core::mem::transmute_copy(&ensystem), core::mem::transmute_copy(&enlevel)) {
                    Ok(ok__) => {
                        plbfattrs.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn put_BlockedRatingAttributes<Identity: IEvalRat_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ensystem: EnTvRat_System, enlevel: EnTvRat_GenericLevel, lbfattrs: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEvalRat_Impl::put_BlockedRatingAttributes(this, core::mem::transmute_copy(&ensystem), core::mem::transmute_copy(&enlevel), core::mem::transmute_copy(&lbfattrs)).into()
            }
        }
        unsafe extern "system" fn BlockUnRated<Identity: IEvalRat_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfblockunratedshows: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEvalRat_Impl::BlockUnRated(this) {
                    Ok(ok__) => {
                        pfblockunratedshows.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetBlockUnRated<Identity: IEvalRat_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fblockunratedshows: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEvalRat_Impl::SetBlockUnRated(this, core::mem::transmute_copy(&fblockunratedshows)).into()
            }
        }
        unsafe extern "system" fn MostRestrictiveRating<Identity: IEvalRat_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ensystem1: EnTvRat_System, enenlevel1: EnTvRat_GenericLevel, lbfenattr1: i32, ensystem2: EnTvRat_System, enenlevel2: EnTvRat_GenericLevel, lbfenattr2: i32, pensystem: *mut EnTvRat_System, penenlevel: *mut EnTvRat_GenericLevel, plbfenattr: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEvalRat_Impl::MostRestrictiveRating(this, core::mem::transmute_copy(&ensystem1), core::mem::transmute_copy(&enenlevel1), core::mem::transmute_copy(&lbfenattr1), core::mem::transmute_copy(&ensystem2), core::mem::transmute_copy(&enenlevel2), core::mem::transmute_copy(&lbfenattr2), core::mem::transmute_copy(&pensystem), core::mem::transmute_copy(&penenlevel), core::mem::transmute_copy(&plbfenattr)).into()
            }
        }
        unsafe extern "system" fn TestRating<Identity: IEvalRat_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, enshowsystem: EnTvRat_System, enshowlevel: EnTvRat_GenericLevel, lbfenshowattributes: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEvalRat_Impl::TestRating(this, core::mem::transmute_copy(&enshowsystem), core::mem::transmute_copy(&enshowlevel), core::mem::transmute_copy(&lbfenshowattributes)).into()
            }
        }
        Self {
            base__: super::super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            get_BlockedRatingAttributes: get_BlockedRatingAttributes::<Identity, OFFSET>,
            put_BlockedRatingAttributes: put_BlockedRatingAttributes::<Identity, OFFSET>,
            BlockUnRated: BlockUnRated::<Identity, OFFSET>,
            SetBlockUnRated: SetBlockUnRated::<Identity, OFFSET>,
            MostRestrictiveRating: MostRestrictiveRating::<Identity, OFFSET>,
            TestRating: TestRating::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEvalRat as windows_core::Interface>::IID || iid == &<super::super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IEvalRat {}
windows_core::imp::define_interface!(IGenericDescriptor, IGenericDescriptor_Vtbl, 0x6a5918f8_a77a_4f61_aed0_5702bdcda3e6);
windows_core::imp::interface_hierarchy!(IGenericDescriptor, windows_core::IUnknown);
impl IGenericDescriptor {
    pub unsafe fn Initialize(&self, pbdesc: *const u8, bcount: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), pbdesc, bcount).ok() }
    }
    pub unsafe fn GetTag(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTag)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetBody(&self) -> windows_core::Result<*mut u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetBody)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IGenericDescriptor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *const u8, i32) -> windows_core::HRESULT,
    pub GetTag: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub GetBody: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut u8) -> windows_core::HRESULT,
}
pub trait IGenericDescriptor_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, pbdesc: *const u8, bcount: i32) -> windows_core::Result<()>;
    fn GetTag(&self) -> windows_core::Result<u8>;
    fn GetLength(&self) -> windows_core::Result<u8>;
    fn GetBody(&self) -> windows_core::Result<*mut u8>;
}
impl IGenericDescriptor_Vtbl {
    pub const fn new<Identity: IGenericDescriptor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IGenericDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbdesc: *const u8, bcount: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IGenericDescriptor_Impl::Initialize(this, core::mem::transmute_copy(&pbdesc), core::mem::transmute_copy(&bcount)).into()
            }
        }
        unsafe extern "system" fn GetTag<Identity: IGenericDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IGenericDescriptor_Impl::GetTag(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLength<Identity: IGenericDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbval: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IGenericDescriptor_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetBody<Identity: IGenericDescriptor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppbval: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IGenericDescriptor_Impl::GetBody(this) {
                    Ok(ok__) => {
                        ppbval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetTag: GetTag::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            GetBody: GetBody::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IGenericDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IGenericDescriptor {}
windows_core::imp::define_interface!(IGenericDescriptor2, IGenericDescriptor2_Vtbl, 0xbf02fb7e_9792_4e10_a68d_033a2cc246a5);
impl core::ops::Deref for IGenericDescriptor2 {
    type Target = IGenericDescriptor;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IGenericDescriptor2, windows_core::IUnknown, IGenericDescriptor);
impl IGenericDescriptor2 {
    pub unsafe fn Initialize(&self, pbdesc: *const u8, wcount: u16) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), pbdesc, wcount).ok() }
    }
    pub unsafe fn GetLength(&self) -> windows_core::Result<u16> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IGenericDescriptor2_Vtbl {
    pub base__: IGenericDescriptor_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *const u8, u16) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u16) -> windows_core::HRESULT,
}
pub trait IGenericDescriptor2_Impl: IGenericDescriptor_Impl {
    fn Initialize(&self, pbdesc: *const u8, wcount: u16) -> windows_core::Result<()>;
    fn GetLength(&self) -> windows_core::Result<u16>;
}
impl IGenericDescriptor2_Vtbl {
    pub const fn new<Identity: IGenericDescriptor2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IGenericDescriptor2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbdesc: *const u8, wcount: u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IGenericDescriptor2_Impl::Initialize(this, core::mem::transmute_copy(&pbdesc), core::mem::transmute_copy(&wcount)).into()
            }
        }
        unsafe extern "system" fn GetLength<Identity: IGenericDescriptor2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwval: *mut u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IGenericDescriptor2_Impl::GetLength(this) {
                    Ok(ok__) => {
                        pwval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: IGenericDescriptor_Vtbl::new::<Identity, OFFSET>(), Initialize: Initialize::<Identity, OFFSET>, GetLength: GetLength::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IGenericDescriptor2 as windows_core::Interface>::IID || iid == &<IGenericDescriptor as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IGenericDescriptor2 {}
windows_core::imp::define_interface!(IGpnvsCommonBase, IGpnvsCommonBase_Vtbl, 0x907e0b5c_e42d_4f04_91f0_26f401f36907);
windows_core::imp::interface_hierarchy!(IGpnvsCommonBase, windows_core::IUnknown);
impl IGpnvsCommonBase {
    pub unsafe fn GetValueUpdateName(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetValueUpdateName)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IGpnvsCommonBase_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetValueUpdateName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IGpnvsCommonBase_Impl: windows_core::IUnknownImpl {
    fn GetValueUpdateName(&self) -> windows_core::Result<windows_core::BSTR>;
}
impl IGpnvsCommonBase_Vtbl {
    pub const fn new<Identity: IGpnvsCommonBase_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetValueUpdateName<Identity: IGpnvsCommonBase_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IGpnvsCommonBase_Impl::GetValueUpdateName(this) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetValueUpdateName: GetValueUpdateName::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IGpnvsCommonBase as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IGpnvsCommonBase {}
windows_core::imp::define_interface!(IGuideData, IGuideData_Vtbl, 0x61571138_5b01_43cd_aeaf_60b784a0bf93);
windows_core::imp::interface_hierarchy!(IGuideData, windows_core::IUnknown);
impl IGuideData {
    pub unsafe fn GetServices(&self) -> windows_core::Result<IEnumTuneRequests> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServices)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetServiceProperties<P0>(&self, ptunerequest: P0) -> windows_core::Result<IEnumGuideDataProperties>
    where
        P0: windows_core::Param<ITuneRequest>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceProperties)(windows_core::Interface::as_raw(self), ptunerequest.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetGuideProgramIDs(&self) -> windows_core::Result<super::super::super::System::Ole::IEnumVARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetGuideProgramIDs)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetProgramProperties(&self, varprogramdescriptionid: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<IEnumGuideDataProperties> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProgramProperties)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(varprogramdescriptionid), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetScheduleEntryIDs(&self) -> windows_core::Result<super::super::super::System::Ole::IEnumVARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetScheduleEntryIDs)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetScheduleEntryProperties(&self, varscheduleentrydescriptionid: &super::super::super::System::Variant::VARIANT) -> windows_core::Result<IEnumGuideDataProperties> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetScheduleEntryProperties)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(varscheduleentrydescriptionid), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IGuideData_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetServices: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetServiceProperties: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetServiceProperties: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetGuideProgramIDs: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetGuideProgramIDs: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetProgramProperties: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Variant::VARIANT, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetProgramProperties: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetScheduleEntryIDs: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetScheduleEntryIDs: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetScheduleEntryProperties: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::super::System::Variant::VARIANT, *mut *mut cor