/*
 * Copyright (C) 2002 Paul Martin <pm@debian.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string.h>
#include <time.h>
#include <unistd.h>
#include "liblcd.h"

char **messages;

void put_time(void)
{
    static char **message = NULL;
    char str[40];
    struct tm *tm;
    time_t tt;
    
    time(&tt);
    tm = localtime(&tt);
    strftime(str, sizeof(str), "%a %d %b %H:%M", tm);
    put_lcd(str,NULL);

    /* Rotating message */
    if ((message == NULL) || (*message == NULL))
      message = messages;
    if (*message != NULL)
      if (tm->tm_sec % 5 == 0) {
	  put_lcd(NULL,*message);
	  message++;
      }
}

enum {
    MENU_Exit = 0, 
      MENU_Halt, 
      MENU_Reboot, 
      MENU_MAX 
};

const char *menu[] = {
/*    "-------8------16"  (\177 is left arrow, ~ is right arrow */
      " \177 EXIT MENU ~",
      " \177   HALT    ~",
      " \177  REBOOT   ~"
};

const char *queries[] = {
/*    "-------8------16"  */      
    "",
      "     Halt?",
      "    Reboot?"
};

int main(int argc, char **argv)
{
    struct lcd_display savedisp;
    int state, selected;
    int i;
    unsigned long button;
    char **message;
        
    messages = message = malloc(sizeof(char *)*argc);
    *message = NULL;
    
    for (i=1; i<argc; i++) {
	*message = strdup(argv[i]);
	message++;
	*message = NULL;
    }
	
    save_lcd(&savedisp);
    unset_cursor();

    while (1) { /* loop forever */
	restore_lcd(&savedisp);
	
	wait_for_select(&put_time);
	put_lcd("   Admin Menu","");

	state = 0;
	selected = 0;
	while (!selected) {
	    put_lcd(NULL, menu[state]);
	    wait_for_no_button();
	    button=wait_for_button();
	    switch (button) {
	     case BUTTON_Left:
	     case BUTTON_Left_B:
		state--;
		if (state < 0) state = MENU_MAX - 1;
		break;
	     case BUTTON_Right:
	     case BUTTON_Right_B:
		state++;
		if (state >= MENU_MAX) state = 0;
		break;
	     case BUTTON_Enter:
	     case BUTTON_Enter_B:
		selected = 1;
		break;
	     case 0: /* timeout */
		selected = 1;
		state = MENU_Exit;
		break;
	    }
	}
	switch (state) {
	 case MENU_Halt:
	 case MENU_Reboot:
	    if (ask_yes_no(queries[state])) {
		if (state == MENU_Halt) {
		put_lcd("Shutting down...","...for HALT");
		    execl("/sbin/halt",
			  "halt",
			  NULL);
		} else {
		put_lcd("Shutting down...","...for REBOOT");
		    execl("/sbin/reboot",
			  "reboot",
			  NULL);
		}
		exit(0);
	    }
	}
    }
}
