#ifndef __HEADER_H_
 #define __HEADER_H_

typedef struct __atom_ {
  unsigned char *name, *data;
  struct __atom_ *next;
} atom_t;

typedef struct __header_ {
  struct __atom_ *atoms, *atail;
  unsigned char *name, *data, *orig;
} header_t;

struct i_header_t {
  unsigned char *name;
  void (*func)(struct __eps_ *, struct __header_ *, void *);
};

header_t *header_parse(unsigned char *);
void header_kill(header_t *);
unsigned char *header_fetch_atom(header_t *, unsigned char *);

#ifdef HEADER_DEBUG
void header_show(header_t *);
#endif

#endif
