-- Copyright 2023 Stanford University
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

-- fails-with:
-- privilege_array_access1.rg:28: invalid privilege writes($r.x) for dereference of ptr(test(), $r)

import "regent"

fspace test {
  x : double[2],
}

task foo(r : region(test))
where
  reads(r)
do
  r[0].x[0] = 1
end

task main()
  var r = region(ispace(ptr, 5), test)
  fill(r.x, array(0.0, 0.0))
  foo(r)
end
regentlib.start(main)
