/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBGrant;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBPrivilege;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBRelationalUser;
import org.jkiss.dbeaver.ext.iotdb.ui.config.IoTDBCommandGrantPrivilege;
import org.jkiss.dbeaver.ext.iotdb.ui.controls.PrivilegeTableControl;
import org.jkiss.dbeaver.ext.iotdb.ui.editors.IoTDBUserEditorAbstract;
import org.jkiss.dbeaver.ext.iotdb.ui.internal.IoTDBUiMessages;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;

public class IoTDBUserEditorGeneral
extends IoTDBUserEditorAbstract {
    private PageControl pageControl;
    private boolean isLoaded;
    private PrivilegeTableControl privilegesTable;

    public void createPartControl(Composite parent) {
        this.pageControl = new PageControl(parent);
        Composite container = UIUtils.createPlaceholder((Composite)this.pageControl, (int)2, (int)5);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Group loginGroup = UIUtils.createControlGroup((Composite)container, (String)IoTDBUiMessages.editors_user_editor_general_group_login, (int)2, (int)768, (int)0);
        Text userNameText = UIUtils.createLabelText((Composite)loginGroup, (String)IoTDBUiMessages.editors_user_editor_general_label_user_name, (String)((IoTDBRelationalUser)this.getDatabaseObject()).getName());
        userNameText.setEditable(false);
        this.privilegesTable = new PrivilegeTableControl(container, IoTDBUiMessages.editors_user_editor_general_control_dba_privileges);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.privilegesTable.setLayoutData(gd);
        this.privilegesTable.addListener(24, event -> {
            IoTDBPrivilege privilege = (IoTDBPrivilege)event.data;
            int type = event.detail;
            this.addChangeCommand((DBECommand)new IoTDBCommandGrantPrivilege((IoTDBRelationalUser)this.getDatabaseObject(), type, "", "", privilege), (DBECommandReflector)new DBECommandReflector<IoTDBRelationalUser, IoTDBCommandGrantPrivilege>(){

                public void redoCommand(IoTDBCommandGrantPrivilege command) {
                }

                public void undoCommand(IoTDBCommandGrantPrivilege command) {
                }
            });
        });
        this.pageControl.createProgressPanel();
    }

    public void activatePart() {
        if (this.isLoaded) {
            return;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            return;
        }
        this.isLoaded = true;
        LoadingJob.createService((ILoadService)new DatabaseLoadService<List<IoTDBPrivilege>>(IoTDBUiMessages.editors_user_editor_general_service_load_catalog_privileges, executionContext){

            public List<IoTDBPrivilege> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException {
                IoTDBRelationalUser user = (IoTDBRelationalUser)IoTDBUserEditorGeneral.this.getDatabaseObject();
                if (user == null) {
                    IoTDBUserEditorGeneral.this.isLoaded = false;
                    return null;
                }
                return user.getDataSource().getPrivilegesByKind(true).stream().toList();
            }
        }, this.pageControl.createLoadVisualizer()).schedule();
    }

    @Override
    protected PageControl getPageControl() {
        return this.pageControl;
    }

    @Override
    protected void processGrants(List<IoTDBGrant> grants) {
        this.privilegesTable.fillGrants(grants);
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        if (force || source instanceof DBNEvent && ((DBNEvent)source).getSource() == DBNEvent.UPDATE_ON_SAVE || !this.isLoaded) {
            this.isLoaded = false;
            this.activatePart();
            return IRefreshablePart.RefreshResult.REFRESHED;
        }
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    private class PageControl
    extends IoTDBUserEditorAbstract.UserPageControl {
        public PageControl(Composite parent) {
            super(IoTDBUserEditorGeneral.this, parent);
        }

        public ProgressPageControl.ProgressVisualizer<List<IoTDBPrivilege>> createLoadVisualizer() {
            return new ProgressPageControl.ProgressVisualizer<List<IoTDBPrivilege>>((ProgressPageControl)this){

                public void completeLoading(List<IoTDBPrivilege> privileges) {
                    super.completeLoading(privileges);
                    ((PageControl)PageControl.this).IoTDBUserEditorGeneral.this.privilegesTable.fillPrivileges(privileges);
                    IoTDBUserEditorGeneral.this.loadGrants();
                }
            };
        }
    }
}

