# This file contains function which extracts version information from rpmbuild's spec-file.

# Find packaging/*.spec file and extract version from it ("Version:" entry),
# file should be unique, empty string will be returned in case of error.
function(RPMVersion result)
    set(pkg_path "${PROJECT_SOURCE_DIR}/packaging")
    set(version "")
    if (IS_DIRECTORY "${pkg_path}")
    file(GLOB spec_files RELATIVE "${pkg_path}" "${pkg_path}/*.spec")
        list(LENGTH spec_files n_spec)
        if (n_spec GREATER 1)
            message(WARNING "too many *.spec files found")
        elseif(NOT spec_files)
            message(WARNING "no *.spec file found in '${pkg_path}'.")
        else()
            set(specfile "${pkg_path}/${spec_files}")
            file(STRINGS ${specfile} ver REGEX "^Version:")
            if (NOT ver)
                message(WARNING "no Version in '${specfile}'.")
            else()
                string(REGEX REPLACE "^Version:[ \t]+([^[ \t\r\n]+).*" "\\1" version "${ver}")
            endif()
	    file(STRINGS ${specfile} rel REGEX "^Release:")
            if (NOT rel)
                message(WARNING "no Release in '${specfile}'.")
            else()
                string(REGEX REPLACE "^Release:[ \t]+([^[ \t\r\n]+).*" "\\1" release "${rel}")
                set(version "${version}-${release}")
            endif()
        endif()
    else()
        message(WARNING "no '${pkg_path}' directory found!")
    endif()
    set(${result} "${version}" PARENT_SCOPE)
endfunction(RPMVersion)
