/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.piped;

import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.piped.PipeOperator;
import net.sf.jsqlparser.statement.piped.PipeOperatorVisitor;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;

public class PivotPipeOperator
extends PipeOperator {
    private Function aggregateExpression;
    private Column inputColumn;
    private List<SelectItem<?>> pivotColumns;
    private Alias alias = null;

    public PivotPipeOperator(Function aggregateExpression, Column inputColumn, List<SelectItem<?>> pivotColumns, Alias alias) {
        this.aggregateExpression = aggregateExpression;
        this.inputColumn = inputColumn;
        this.pivotColumns = pivotColumns;
        this.alias = alias;
    }

    public Function getAggregateExpression() {
        return this.aggregateExpression;
    }

    public PivotPipeOperator setAggregateExpression(Function aggregateExpression) {
        this.aggregateExpression = aggregateExpression;
        return this;
    }

    public Column getInputColumn() {
        return this.inputColumn;
    }

    public PivotPipeOperator setInputColumn(Column inputColumn) {
        this.inputColumn = inputColumn;
        return this;
    }

    public List<SelectItem<?>> getPivotColumns() {
        return this.pivotColumns;
    }

    public PivotPipeOperator setPivotColumns(List<SelectItem<?>> pivotColumns) {
        this.pivotColumns = pivotColumns;
        return this;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public PivotPipeOperator setAlias(Alias alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("|> ").append("PIVOT( ").append(this.aggregateExpression).append(" FOR ").append(this.inputColumn).append(" IN (").append(Select.getStringList(this.pivotColumns)).append("))");
        if (this.alias != null) {
            builder.append(" ").append(this.alias);
        }
        builder.append("\n");
        return builder;
    }

    @Override
    public <T, S> T accept(PipeOperatorVisitor<T, S> visitor, S context) {
        return visitor.visit(this, context);
    }
}

