/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.provider;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.provider.ContainerIntentException;

public class ContainerInstantiatorUtils {
    public static final String PRIVATE_INTENT = "osgi.private";

    public static String[] getContainerIntents(Map<String, ?> properties) {
        return ContainerInstantiatorUtils.getStringArrayProperty(properties, "service.intents");
    }

    public static boolean containsIntent(String[] intents, String intent) {
        if (intents == null) {
            return false;
        }
        return Arrays.asList(intents).contains(intent);
    }

    public static boolean containsPrivateIntent(String[] intents) {
        return ContainerInstantiatorUtils.containsIntent(intents, PRIVATE_INTENT);
    }

    public static boolean containsPrivateIntent(Map<String, ?> properties) {
        return ContainerInstantiatorUtils.containsPrivateIntent(ContainerInstantiatorUtils.getContainerIntents(properties));
    }

    public static String[] getStringArrayProperty(Map properties, String key) {
        Object values;
        if (properties == null) {
            return null;
        }
        Object value = properties.get(key);
        List<Object> r = new ArrayList();
        if (value == null) {
            r = Collections.EMPTY_LIST;
        }
        if (value instanceof String) {
            r = Collections.singletonList((String)value);
        }
        if (value instanceof String[]) {
            values = (String[])value;
            int i = 0;
            while (i < ((String[])values).length) {
                if (values[i] != null) {
                    r.add(values[i]);
                }
                ++i;
            }
        }
        if (value instanceof Collection) {
            values = (Collection)value;
            ArrayList result = new ArrayList(values.size());
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Object v = iter.next();
                if (!(v instanceof String)) continue;
                result.add(v);
            }
        }
        return r.size() == 0 ? null : r.toArray(new String[r.size()]);
    }

    public static void checkPrivate(InetAddress inetAddress) throws ContainerIntentException {
        if (!inetAddress.isSiteLocalAddress()) {
            throw new ContainerIntentException(PRIVATE_INTENT, "Address " + String.valueOf(inetAddress) + " is not private");
        }
    }

    public static void checkPrivate(String hostname) throws ContainerIntentException {
        if (hostname == null) {
            throw new ContainerIntentException(PRIVATE_INTENT, "Null hostname cannot be private");
        }
        InetAddress ia = null;
        if (hostname.equals("localhost") || hostname.equals("127.0.0.1")) {
            try {
                ia = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new ContainerIntentException(PRIVATE_INTENT, "Could not get localhost inetaddress", e);
            }
        }
        try {
            ia = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            throw new ContainerIntentException(PRIVATE_INTENT, "Could not get address for hostname: " + hostname);
        }
        ContainerInstantiatorUtils.checkPrivate(ia);
    }

    public static void checkPrivate(ID serverID) throws ContainerIntentException {
        String name = serverID.getName();
        try {
            ContainerInstantiatorUtils.checkPrivate(new URI(name).getHost());
        }
        catch (URISyntaxException e) {
            throw new ContainerIntentException(PRIVATE_INTENT, "Could not get hostname for serverID name: " + name);
        }
    }
}

