/** VSys:$thr.cc:0.0.3-023$ **/
/*
 *  Transfered by VSys script on   11 17:05:09 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: thr.cc; File version: 0.0.3-023
 */
#ifdef WIN32
//#include <winsock.h>
#define strncasecmp strnicmp
#else
#include <sys/types.h>
#include <arpa/inet.h>
#include <unistd.h>
#include "config.h"
#endif

#include <time.h>

#include "pcap.local.h"
#include "config_ndsad.h"
#include "thr.h"
#include "iflist.h"
#include "handlers.h"
//#include <pthread.h>
#include "debug.h"
#include "logger.h"

pthread_t scaner_pid;

extern pthread_mutex_t __mutex_findalldevs;

void * if_worker( void * _dev ) {
	/*
	 * INIT section - initialization
	 */
	/*
	 * PRE subsection - initialization, ifl_add call and so on
	 */
	pthread_setcanceltype( PTHREAD_CANCEL_ASYNCHRONOUS, 0 );
	static pthread_mutex_t race;
	char * dev = (char *) _dev;
	int dummy = 0, promisc = 0, flag = 0;
	pcap_handler handler = 0;
	pcap_t *pc = 0;
	char buf[256], *ebuf = buf;
	pthread_mutex_init( &race, 0 );

	if( !dev ) return 0;
	

	// To prevent race - otherwise two threads may start on same device
	pthread_mutex_lock( &race );
	 if_list * iface = ifl_iface( dev );
	if( iface ) {
		snprintf( buf, 256, "IFace node found for %s\n", dev );
		writelog(buf);
		delete dev;
		pthread_mutex_unlock( &race );
	   	return 0;
	} else
		iface = ifl_add( dev );
	pthread_mutex_unlock( &race );


	if( !iface ) {
		snprintf(buf, 256, "Cannot create IFace node for `%s' device\n", dev );
		writelog(buf);
		delete dev;
	   	return 0;
	}

	iface->ifl_pid = new pthread_t;
	*(iface->ifl_pid) = pthread_self();

	snprintf( buf, 256, "`%s' thread started successfully.", dev );
	writelog( buf );
	/*
	 * PRE subsection end
	 */

	/*
	 * FLAG subsection: flag processing, iface dummyness resolution.
	 * part of INIT section
	 */
	iff_list *  face = ifl_family( dev );

	// get the list of all ifaces with IP addresses and
	// pick up our iface from the list
#ifdef WIN32
	__LOCK(findalldevs);
	//DEB(printf( "%s thread: findalldevs: if_worker", dev ));
	
	pcap_if_t * alldevsp = 0;
	pcap_if_t * alldevsp_orig = 0;
    char errbuf[PCAP_ERRBUF_SIZE];
    if(pcap_findalldevs(&alldevsp_orig, errbuf) == 0){
		alldevsp = alldevsp_orig;
		while(alldevsp) 
		{
			if (strcmp(alldevsp->name,dev) == 0 ) break;
			alldevsp = alldevsp->next;
		}
	}
	else alldevsp_orig = 0;
	__UNLOCK(findalldevs);

#endif	
	/*
	 * Priority of iface `dummyness':
	 *    if we can not handle it - it have to be dummy
	 *    else if it's forced - it's not dummy
	 *    else if it marked as dummy or dummy mode is on - it's dummy
	 */
#ifdef WIN32
	if( !face || !face->iff_h ) {
		dummy = 1;
	} else 
		if( cfl_find( dev, cfg.force ) || 
			(alldevsp && cfl_find_address(alldevsp->addresses,cfg.force)) || 
			face->iff_force) {
		dummy = 0;
	} else 
		if( cfg.dummy_mode || face->iff_dummy || 
			cfl_find(dev, cfg.dummy) ||
			(alldevsp && cfl_find_address(alldevsp->addresses,cfg.dummy))) {
		dummy = 1;
	}
	//if (strcmp("\\Device\\NPF_GenericNdisWanAdapter",dev) == 0)
	//{
	//	dummy = 1;
	//}
#else
	if( !face || !face->iff_h ) {
        	dummy = 1;
	} else if( cfl_find( dev, cfg.force ) || face->iff_force) {
		dummy = 0;
	} else if(cfg.dummy_mode || face->iff_dummy || cfl_find(dev, cfg.dummy)) {
		dummy = 1;
	}
#endif		
	if( !dummy ) handler = face->iff_h;

#ifdef WIN32
	// free the struct previously got from PCAP
	pcap_freealldevs(alldevsp_orig);
#endif

	// Skip PCAP_INIT section for dummy faces
	if(dummy) goto call_sec;
	
	promisc = cfl_find( dev, cfg.promisc );

	/*
	 * FLAG subsection end
	 * INIT section end
	 */

	/*
	 * PCAP_INIT section - pcap_open, dummy loop for unconfigured and so on...
	 */
#ifndef WIN32
pcap_init_sec:
#endif

	flag=0;
#ifndef WIN32 // dummy mode not supported on win32
	snprintf( buf, 256, "`%s' thread is entering dummy mode due to error:\n\tinterface is not configured or down", dev );
	while( ifi_ifvalid( dev ) ) {
		if( (ifi_ipv4( dev ) != IFI_IP_FATAL) && ifi_up( dev ) ) break;
		sleep( _DELAY_ );
		if( !flag ) { 
			flag = 1; 
			writelog( buf );
		}
	}
#endif
	if( flag ) {
		snprintf( buf, 256, "`%s' thread has left dummy mode", dev );
		writelog( buf );
	}

#ifndef WIN32
	if( !ifi_ifvalid( dev ) ) {
		DEB( fprintf( stderr, "Device `%s' lost!\n", dev ));
		snprintf( buf, 256, "`%s' thread is going down due to error:\n\tiface is lost", dev );
		writelog( buf );
		goto post_sec;
	}
#endif

	pc = pcap_open_live(dev, 68, promisc, 1000, ebuf);
	if( !pc ) {
		DEB(fprintf( stderr, "`%s': Error in `pcap_open_live': `%s'\n", dev, ebuf));
		buf[127] = 0;
		snprintf(buf+128,128,"`%s' thread is going down due to PCAP error:\n\t%s", dev, ebuf );
		writelog( buf+128 );
		goto post_sec;
	}

	
	/*
	 * PCAP_INIT section end
	 */

	/*
	 * CALL section - worker part, calls to *_loop routines,
	 * reincarnation jump...
	 */
call_sec:
	DEB(printf( "Preparing to %s call for `%s' device\n",
				(dummy)?"dummy":"pcap_loop", dev ));
	if( dummy ) {
		snprintf( buf, 256, "`%s' thread is preparing for dummy loop call", dev );
		writelog( buf );
		dummy_loop( dev );
		snprintf( buf, 256, "`%s' thread dummy call fails.", dev );
		writelog( buf );
	} else {
		snprintf(buf, 256, "`%s' thread is preparing for PCAP loop call", dev);
		writelog(buf);

		/// Set filters from config
		// char filter_app[] = "port 2222";
		std::map<std::string, std::string>::iterator iter = cfg.rules.find((std::string)dev);
		if(iter != cfg.rules.end()){
			struct bpf_program filter;
			pcap_compile(pc, &filter, (char*)(*iter).second.c_str(), 0, 0);
			if(!pcap_setfilter(pc, &filter)){
				snprintf( buf, 256, "Applying filter:%s to device:%s", (char*)(*iter).second.c_str(), dev );
			} else{
				snprintf( buf, 256, "Applying filter:%s to device:%s error:<%s>", (char*)(*iter).second.c_str(), dev, pcap_geterr(pc) );
			};
			writelog( buf );
		};

#ifndef WIN32
		// PCAP call
		//handler = (void (*) (u_char *, const pcap_pkthdr *, const u_char *)) 1;
		{
			int type = pcap_datalink(pc);
			snprintf( buf, 256, "pcap_datalink(%s) = %d", dev, type );
			writelog( buf );
			if (type == DLT_LINUX_SLL) {
				iface->ifl_ppp_offset = 16;
				writelog( "Set ppp offset = 16" );
			} else {
				iface->ifl_ppp_offset = 4;
				writelog( "Set ppp offset = 4" );
			}
		}
#endif
		pcap_loop( pc, -1, handler, (u_char *) iface );

		snprintf(buf, 256, "`%s' thread PCAP call fails due to error:\n\t%s", 
				dev, pcap_geterr( pc ));
		writelog(buf);
		pcap_close( pc );
		pc = 0;
#ifndef WIN32
		/*
		 * Reincarnation - if device is not lost, try to save this thread for
		 * further usage. Important for dynamic devices. Device and PCAP 
		 * behaviour is system specific and have to be sudied accurately.
		 */
		if( ifi_ifvalid( dev ) ) {
			snprintf( buf, 256, "`%s' thread is preparing for reincarnation", dev );
			writelog( buf );
			goto pcap_init_sec;
		}
#endif
	}
	snprintf(buf, 256, "`%s' thread is going down due to error:\n\tiface is lost", dev);
	writelog(buf);
	/* 
	 * CALL section end
	 */

	/*
	 * POST section - clean up and logging
	 */
post_sec:
	iface->ifl_nfc->update( time(0) );
	delete iface->ifl_pid;
	iface->ifl_pid = 0;
	if( !ifl_remove(dev) ) {
		snprintf(buf, 256, "Unable to unload `%s' thread!!!\n", dev);
		writelog(buf);
	}
	snprintf(buf, 256, "`%s' thread is terminating", dev);
	//snprintf(buf, 256, "`%s' thread is terminating due to iface is lost", dev);
	writelog(buf);
	delete dev;
	return 0;
	/*
	 * POST section end
	 */
}

inline
void dummy_loop( char * dev ) {
//	u_int32_t addr = ifi_ipv4( dev );
//	while( addr != IFI_IP_FATAL && addr != IFI_IP_BAD )  {
	while( ifi_ifvalid( dev ) )  {
#ifdef WIN32
		Sleep( _DELAY_ * 1000 * 30);
#else
		sleep( _DELAY_ );
#endif
//		addr = ifi_ipv4( dev );
//		DEB( printf( "Device `%s' with ip:%s\n", dev, inet_ntoa( *(in_addr *)(&addr))));
	}
}

void * nf_scaner( void * ) {
	pthread_setcanceltype( PTHREAD_CANCEL_ASYNCHRONOUS, 0 );
	while( 1 ) {
#ifdef WIN32
		Sleep( _DELAY_ * 1000 );
#else
		sleep( _DELAY_ );
#endif
		ifi_update();
	}
	return 0;
}

void   init_worker( char * dname ) {
	pthread_t th;
	char * buf = new char[IFN_SIZE];
	strncpy( buf, dname, IFN_SIZE );

	/// don't start worker for reserved names!
	if (strncasecmp( buf, "bsd_divert_iface", 16 ) && strncasecmp( buf, "ulog_iface", 10 ) ){
		char logbuf[128];
		snprintf(logbuf, 128, "Starting worker thread for device <%s>", dname);
		writelog(logbuf);

		pthread_create( &th, 0, if_worker, ( void * ) buf );
		pthread_detach( th );
	};
}

void init_scaner() {
	pthread_create( &scaner_pid, 0, nf_scaner, 0 );
	pthread_join( scaner_pid, 0 );
}
