/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"
        #include <wx/html/helpdata.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxHtmlHelpData_AddBook, "AddBook(book_url) -> bool\n"
"\n"
"Adds new book.");

extern "C" {static PyObject *meth_wxHtmlHelpData_AddBook(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_AddBook(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* book_url;
        int book_urlState = 0;
        ::wxHtmlHelpData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_book_url,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxHtmlHelpData, &sipCpp, sipType_wxString, &book_url, &book_urlState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AddBook(*book_url);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(book_url), sipType_wxString, book_urlState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_AddBook, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_FindPageById, "FindPageById(id) -> str\n"
"\n"
"Returns page's URL based on integer ID stored in project.");

extern "C" {static PyObject *meth_wxHtmlHelpData_FindPageById(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_FindPageById(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        ::wxHtmlHelpData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxHtmlHelpData, &sipCpp, &id))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->FindPageById(id));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_FindPageById, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_FindPageByName, "FindPageByName(page) -> str\n"
"\n"
"Returns page's URL based on its (file)name.");

extern "C" {static PyObject *meth_wxHtmlHelpData_FindPageByName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_FindPageByName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* page;
        int pageState = 0;
        ::wxHtmlHelpData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_page,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxHtmlHelpData, &sipCpp, sipType_wxString, &page, &pageState))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->FindPageByName(*page));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(page), sipType_wxString, pageState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_FindPageByName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_GetBookRecArray, "GetBookRecArray() -> HtmlBookRecArray\n"
"\n"
"Returns array with help books info.");

extern "C" {static PyObject *meth_wxHtmlHelpData_GetBookRecArray(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_GetBookRecArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlHelpData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlHelpData, &sipCpp))
        {
            ::wxHtmlBookRecArray*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxHtmlBookRecArray(sipCpp->GetBookRecArray());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxHtmlBookRecArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_GetBookRecArray, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_GetContentsArray, "GetContentsArray() -> HtmlHelpDataItems\n"
"\n"
"Returns reference to array with contents entries.");

extern "C" {static PyObject *meth_wxHtmlHelpData_GetContentsArray(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_GetContentsArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlHelpData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlHelpData, &sipCpp))
        {
            ::wxHtmlHelpDataItems*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxHtmlHelpDataItems(sipCpp->GetContentsArray());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxHtmlHelpDataItems, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_GetContentsArray, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_GetIndexArray, "GetIndexArray() -> HtmlHelpDataItems\n"
"\n"
"Returns reference to array with index entries.");

extern "C" {static PyObject *meth_wxHtmlHelpData_GetIndexArray(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_GetIndexArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlHelpData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlHelpData, &sipCpp))
        {
            ::wxHtmlHelpDataItems*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxHtmlHelpDataItems(sipCpp->GetIndexArray());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxHtmlHelpDataItems, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_GetIndexArray, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlHelpData_SetTempDir, "SetTempDir(path) -> None\n"
"\n"
"Sets the temporary directory where binary cached versions of MS HTML\n"
"Workshop files will be stored.");

extern "C" {static PyObject *meth_wxHtmlHelpData_SetTempDir(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlHelpData_SetTempDir(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* path;
        int pathState = 0;
        ::wxHtmlHelpData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_path,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxHtmlHelpData, &sipCpp, sipType_wxString, &path, &pathState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTempDir(*path);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(path), sipType_wxString, pathState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlHelpData, sipName_SetTempDir, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHtmlHelpData(void *, const sipTypeDef *);}
static void *cast_wxHtmlHelpData(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxHtmlHelpData *sipCpp = reinterpret_cast< ::wxHtmlHelpData *>(sipCppV);

    if (targetType == sipType_wxHtmlHelpData)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlHelpData(void *, int);}
static void release_wxHtmlHelpData(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxHtmlHelpData *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxHtmlHelpData(Py_ssize_t);}
static void *array_wxHtmlHelpData(Py_ssize_t sipNrElem)
{
    return new ::wxHtmlHelpData[sipNrElem];
}


extern "C" {static void array_delete_wxHtmlHelpData(void *);}
static void array_delete_wxHtmlHelpData(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxHtmlHelpData *>(sipCpp);
}


extern "C" {static void dealloc_wxHtmlHelpData(sipSimpleWrapper *);}
static void dealloc_wxHtmlHelpData(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlHelpData(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxHtmlHelpData(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHtmlHelpData(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxHtmlHelpData *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxHtmlHelpData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHtmlHelpData[] = {{25, 0, 1}};


static PyMethodDef methods_wxHtmlHelpData[] = {
    {sipName_AddBook, SIP_MLMETH_CAST(meth_wxHtmlHelpData_AddBook), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlHelpData_AddBook},
    {sipName_FindPageById, SIP_MLMETH_CAST(meth_wxHtmlHelpData_FindPageById), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlHelpData_FindPageById},
    {sipName_FindPageByName, SIP_MLMETH_CAST(meth_wxHtmlHelpData_FindPageByName), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlHelpData_FindPageByName},
    {sipName_GetBookRecArray, meth_wxHtmlHelpData_GetBookRecArray, METH_VARARGS, doc_wxHtmlHelpData_GetBookRecArray},
    {sipName_GetContentsArray, meth_wxHtmlHelpData_GetContentsArray, METH_VARARGS, doc_wxHtmlHelpData_GetContentsArray},
    {sipName_GetIndexArray, meth_wxHtmlHelpData_GetIndexArray, METH_VARARGS, doc_wxHtmlHelpData_GetIndexArray},
    {sipName_SetTempDir, SIP_MLMETH_CAST(meth_wxHtmlHelpData_SetTempDir), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlHelpData_SetTempDir}
};

sipVariableDef variables_wxHtmlHelpData[] = {
    {PropertyVariable, sipName_IndexArray, &methods_wxHtmlHelpData[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ContentsArray, &methods_wxHtmlHelpData[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BookRecArray, &methods_wxHtmlHelpData[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxHtmlHelpData, "HtmlHelpData() -> None\n"
"\n"
"This class is used by wxHtmlHelpController and wxHtmlHelpFrame to\n"
"access HTML help items.");


sipClassTypeDef sipTypeDef__html_wxHtmlHelpData = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxHtmlHelpData,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_HtmlHelpData,
        {0, 0, 1},
        7, methods_wxHtmlHelpData,
        0, SIP_NULLPTR,
        3, variables_wxHtmlHelpData,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxHtmlHelpData,
    -1,
    -1,
    supers_wxHtmlHelpData,
    SIP_NULLPTR,
    init_type_wxHtmlHelpData,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxHtmlHelpData,
    SIP_NULLPTR,
    array_wxHtmlHelpData,
    SIP_NULLPTR,
    release_wxHtmlHelpData,
    cast_wxHtmlHelpData,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxHtmlHelpData,
    sizeof (::wxHtmlHelpData),
};
