// bbacpi.hh for bbacpi - an tool to display the battery level in X11
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//


#ifndef __MAIN_HH
#define __MAIN_HH

#include "Image.hh"
#include "Basewindow.hh"
#include "menu.hh"
#include "resource.hh"
#include "Timer.hh"
#include <dirent.h>
#include <fstream>
#include <iostream>

#ifdef __IMLIB
#include <Imlib.h>
#endif

#define LEFT_BUTTON 1
#define MIDDLE_BUTTON 2
#define RIGHT_BUTTON 3
#define ACPI_PATH   "/proc/acpi"
//#define ACPI_PATH   "/home/max/programs/acpi_simulation"

class Resource;
class Menu;
class Basemenu;
class BaseResource;
class Basewindow;
class ToolWindow;

struct PIXMAP {
  Pixmap  frame;
  Pixmap  label;
#ifdef __IMLIB
  Pixmap  graphics;
#endif
  Pixmap  loadbar_active;
  Pixmap  loadbar_inactive;
  Pixmap  loadbar_background;
};

struct LABELSIZE {
  int separator_width;
  int space_width;
  int width[19];
  int total_width;
  int height;
};

struct FRAMESIZE {
  int x;
  int y;
  int height;
  int width;
};

struct GEOM {
    int x;
    int y;
    int width;
    int height;
    double level;
};

/*  Battery structure */
struct BATTERYINFO {
  /* Static infos */
  bool present;
  unsigned int design_capacity;
  unsigned int full_capacity;
  char battery_technology[20];
  unsigned int design_voltage;
  unsigned int capacity_warning;
  unsigned int capacity_low;
  char model[20];
  char serial[20];
  char type[20];
  char OEM_info[20];

  /* Dynamic infos */
  char state[12];
  unsigned int present_rate;
  unsigned int remaining_capacity;
  unsigned int present_voltage;
};

struct USERINFO {
  int delay;
  int xmessage_delay;
  unsigned int minlim;
};
  

/* Adapter structure */
struct ADAPTERINFO {
  char state[10];
};

/* Temperature structure */
struct TEMPINFO {
  unsigned int celcius;
  unsigned int critical;
  unsigned int passive;
  char state[10];
};

struct TASK {
  int running;
  int total;
};

/* ACPI file names & path */
struct NAMES {
  char battery1state[100];
  char battery1info[100];
  char battery2state[100];
  char battery2info[100];
  char adapter[100];
  char temperature[100];
  char temptrip[100];
};

class CheckLoad : public TimeoutHandler {
public:
  CheckLoad(ToolWindow *);
  
  struct TASK getTask(void) { return(task); }
  void getBattery1 (struct BATTERYINFO *);
  void getBattery2 (struct BATTERYINFO *);
  struct BATTERYINFO _getBattery1 (void) {return battery1;}
  struct BATTERYINFO _getBattery2 (void) {return battery2;}
  struct ADAPTERINFO getAdapter (void) { return(adapter); }
  struct TEMPINFO getTemperature (void) { return(temperature); }
  struct USERINFO getUser (void) { return(user); }
  
  void Reconfigure(void);
  void GetFileNames(void);
  bool checkfile (char*,char*);
  bool checkbatteryfile (char*,char*);
  int GetName(char*, char*, char*, int);
  int ignore_directory_entry(struct dirent*);
  void ReadStaticInfo(void);
  
private:
  char *acpi_path;
  void timeout(void);
  struct BATTERYINFO battery1;
  struct BATTERYINFO battery2;
  struct ADAPTERINFO adapter;
  struct TEMPINFO temperature;
  struct USERINFO user;
  struct TASK task;
  struct NAMES names;
  ToolWindow *bbtool;
  BTimer *timer;
};

class ToolWindow : public Basewindow 
{
public:
  ToolWindow(int argc,char **argv,struct CMDOPTIONS *);
  ~ToolWindow(void);
  
  Window framewin;
  Window labelwin;
  Window loadwin;
    
  void MakeWindow (bool);
  void printBattery1 (void);
  void printBattery2 (void);
  void printTemperature (void);
  void printAdapter (void);
  void printACPI (void);
  void ReadLoad (void);
  void Redraw (void);
  void EventLoop (void);
  void reconfigure (void);
  void CheckConfig (void);
  void RedrawGauge (double,int,bool);
  void RedrawLabel (char *,BColor,bool);
  Resource *getResource (void) { return(resource); }
  void hide1Battery (void);
  void hideBattery (void);
  void hideAdapter (void);
  void hideTemperature (void);

  bool raised;
  int xmessageCount;
  Menu *mbmenu;
  void saveMenuSearch(Window,Basemenu *);
  void removeMenuSearch(Window window);
  GC getMenuTitleGC(void) { return NULL;/*menuTitleGC;*/ }
  GC getMenuHiBGGC(void) { return menuHiBGGC; }
  GC getMenuHiGC(void) { return menuHiGC; }
  GC getMenuFrameGC(void) { return menuFrameGC; }

  enum { AlignDontCare = 1, AlignTop, AlignBottom };
  enum { Right = 1, Left };
  enum { Empty = 0, Round, Square, Triangle, Diamond };

#ifdef __IMLIB
  Window graphicswin;
  void ReDrawGraphics (bool);
#endif

protected:
  virtual void process_event(XEvent *);
  
private:
  Window menuwin;
  Basemenu* basemenu;

  GC menuGC;
  GC menuHiBGGC;
  GC menuHiGC;
  GC menuFrameGC;

  XGCValues gcv;
  GC frameGC;
  Resource *resource;
  struct LABELSIZE label;
  struct FRAMESIZE frame;
  struct GEOM *load;
  int loadbar_height;
  int gauge_height;
  int xposition;
  int offset2;
  int chargingCount1;
  int chargingCount2;
  bool motion;
  bool first_motion;
  int motion_x, motion_y;
  int last_x, last_y;
  int offset_x;
  int offset_y;

#ifdef __IMLIB
  bool gfx_adapter;
  bool gfx_battery;
  ImlibData *id;
  ImlibImage *im;
  Pixmap p,m;
#endif  
  
  bool mapped;
  XPoint points[11];
  struct PIXMAP pixmap;
  CheckLoad *check_load;
};

#endif /* __MAIN_HH */
