!****************************************************************************
!**   bbacpi.bb -- Style and configuration file for bbacpi               **
!****************************************************************************
! If lefted commented, the option will have a default value.

!** Auto reconfigure when .blackboxrc changes
bbacpi.autoConfig:                      True

!****************** How and where to display ********************

!** Screen position to start at
bbacpi.position:			+0-0

!** place bbdate in the slit **
!bbacpi.withdrawn:			True

!** don't show frame **
!bbacpi.shape:				True

!** delay between updates
!bbacpi.checkDelay:			10

!bbacpi.bevelWidth:			4

!** How many bars to draw
bbacpi.gauge.numberOf.bars:		6

!** show seperate lines in gauge
bbacpi.gauge.tickmarks:               	True


!****************** What and how to display *****************************
!** gauges and labels are displayed in this sequence                   **

!** if true the labels are shown below the gauges 
!bbacpi.show.vertical:			False
!bbacpi.show.battery.gauge:          	True
!bbacpi.show.temperature.gauge:       	False

!bbacpi.show.label_battery.label:	False
!bbacpi.show.label_time.label:		True
!bbacpi.show.label_temperature.label:	False
!bbacpi.show.label_adapter.label:	False

!** this option is only available when Imlib library is installed
!bbacpi.show.graphics.adapter:		False


!****************** Reverse display of gauge ****************************
!** In the place of going from green to red, its going opposit         **
!bbacpi.gauge.battery.reverse:		True
!bbacpi.gauge.temperature.reverse:	False


!****************** Special display of gauge when charging **************
!** Mimic mobile when charging, the loadbar is filled little by little **
!** until it reaches the actual level of the battery                   **
!** Better not set this option if you choose a low refresh rate        **
!bbacpi.gauge.battery.special_charging:False


!****************** Display order of the components *********************
!** Gauge and label are separate                                       **
!** Gauges                                                             **
!bbacpi.gauge.order.battery:		1
!bbacpi.gauge.order.temperature:	2

!** Labels                                                             **
!bbacpi.label.order.battery:		1
!bbacpi.label.order.temperature:	2		
!bbacpi.label.order.time:		3
!bbacpi.label.order.adapter:		4


!****************** Number of battery  **********************************
!bbacpi.battery_number:		1


!****************** Display Warning when battery low ********************
!**  delay in seconds
!bbacpi.show.xmessage.label:		False
!bbacpi.xmessageDelay:			60


!****************** Type of display of the temperature ******************
!bbacpi.label.temperature.degree:	Celcius


!****************** Gauge style *****************************************
!** define active gauge style
bbacpi.gauge.active:      		Vertical Gradient Flat Bevel2
bbacpi.gauge.active.color:      	red1
bbacpi.gauge.active.colorTo:    	green

!** define inactive gauge style
bbacpi.gauge.inactive:      		Solid Flat Bevel2
bbacpi.gauge.inactive.color:    	grey18
bbacpi.gauge.inactive.colorTo:  	grey18

!** define background gauge style
!bbacpi.gauge.background:      	Solid Flat Bevel2
!bbacpi.gauge.background.color:    	grey18
!bbacpi.gauge.background.colorTo:  	grey18

!** define the colors in stead of gradient
!bbacpi.gauge.multiColor:		False

!** define the colors for the segment of the gauge
!bbacpi.gauge.segment.1.color:		green
!bbacpi.gauge.segment.2.color:		green
!bbacpi.gauge.segment.3.color:		yellow
!bbacpi.gauge.segment.4.color:		yellow
!bbacpi.gauge.segment.5.color:		red1
!bbacpi.gauge.segment.6.color:		red1

!** define maximum load
!bbacpi.gauge.maximum.load:		1.0

!** define load-level of the different segments
!** max load is ignored
!bbacpi.gauge.segment.1.scale:		0.1
!bbacpi.gauge.segment.2.scale:		0.2
!bbacpi.gauge.segment.3.scale:		0.4
!bbacpi.gauge.segment.4.scale:		0.6
!bbacpi.gauge.segment.5.scale:		0.8
!bbacpi.gauge.segment.6.scale:		1.0


!** bbacpi on top of other windows?
bbacpi.raised:  True

!** pixel width of the graph area
!bbacpi.gauge.width:			20

!** number of pixels the bars decrease in width each level
!** on left and right side
!bbacpi.gauge.left.stepWidth:		2
!bbacpi.gauge.right.stepWidth:		0

! *************************************************************
! ** By default the values below this point are taken from   **
! ** the Blackbox style.                                     **
! ** If you want to override something just uncomment it     **
! ** and change the value                                    **
! *************************************************************

!***************** Define display style *************************

!** define frame style
bbacpi.frame:          		Raised Gradient Vertical   Bevel1
bbacpi.frame.color:    		gray45
bbacpi.frame.colorTo:  		gray21

!** define label style
!bbacpi.label:          		Sunken Gradient Vertical   Bevel1
!bbacpi.label.color:    		gray45
!bbacpi.label.colorTo:  		gray21

!************ fonts and text colors ******************************

!** label font
!bbacpi.labelFont:     			-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*

!** font which determines the height (compatible with blackbox)
!bbacpi.heightBy.font: 			-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*

!** text colors
!bbacpi.taskCounter.label.textColor:	#cccccc
!bbacpi.runningCounter.label.textColor:	#cccccc
!bbacpi.separator.label.textColor:	#cccccc

!bbacpi.battery.label.textColor:	#cccccc
!bbacpi.temperature.label.textColor:	#cccccc
!bbacpi.time.label.textColor:		#cccccc
!bbacpi.adapter.label.textColor:	#cccccc

!** Color of text when critical level of battery
!bbacpi.time_short.label.textColor:	#cccccc


!************ Menu ***********************************************
!** menu font **
!bbacpi.menuFont:			-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*

!** menu justify
!bbacpi.menu.justify:			CenterJustify

!** menu bullet style
!bbacpi.menu.bulletStyle:		diamond

!** bullet position
!bbacpi.menu.bulletPosition:		left

!** menu style
!bbacpi.menu:				Raised Gradient Vertical   Bevel1
!bbacpi.menu.color:			gray45
!bbacpi.menu.colorTo:			gray21

!** text color menu
!bbacpi.menu.textColor:			lightgrey
!bbacpi.menu.higlight.textColor: 	white

!** menu highlight color
!bbacpi.menu.highlight.color: 		sienna4