/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;

public class BAMwindow
extends JFrame
implements PropertyChangeListener {
    PageControl pages = null;
    PagingModel pm = null;
    JTable table = null;
    JTextArea header = null;
    JSplitPane jsp = null;
    String pwd = null;
    ProgressMonitor progressMonitor = null;
    Task task = null;

    protected void openData(String string) {
        this.progressMonitor = new ProgressMonitor(this, "Indexing file.  You may cancel to view the first few lines.", "", 0, 100);
        this.progressMonitor.setProgress(0);
        this.task = new Task(string);
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("progress" == propertyChangeEvent.getPropertyName()) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.progressMonitor.setProgress(n);
            String string = String.format("Completed %d%%.\n", n);
            this.progressMonitor.setNote(string);
            if (this.progressMonitor.isCanceled()) {
                this.task.cancel(true);
            }
        }
    }

    BAMwindow() {
        super("BAMseek: Large BAM/SAM/FASTQ/VCF/SFF File Viewer");
        this.setDefaultCloseOperation(2);
        this.initMenu();
        this.table = new JTable(this.pm){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnAtPoint(point);
                int n2 = this.rowAtPoint(point);
                int n3 = this.convertColumnIndexToModel(n);
                int n4 = this.convertRowIndexToModel(n2);
                return BAMwindow.this.pm.getToolTip(n4, n3);
            }
        };
        this.table.getTableHeader().setForeground(Color.blue);
        this.table.setAutoResizeMode(0);
        RowNumberTable rowNumberTable = new RowNumberTable(this.table);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.header = new JTextArea("Welcome!\n\nBAMseek allows you to scroll through large SAM/BAM, FASTQ, VCF and SFF files.  Please go to 'File > Open File ...' to get started.\n\nFor updates, visit http://code.google.com/p/bamseek/");
        this.header.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.header);
        JScrollPane jScrollPane2 = new JScrollPane(this.table);
        jScrollPane2.setRowHeaderView(rowNumberTable);
        jScrollPane2.setCorner("UPPER_LEFT_CORNER", rowNumberTable.getTableHeader());
        jPanel.add((Component)jScrollPane, "Center");
        ImageIcon imageIcon = this.createImageIcon("images/BAMseek.png", "bamicon");
        JLabel jLabel = new JLabel(imageIcon);
        jPanel.add((Component)jLabel, "West");
        this.jsp = new JSplitPane(0, jPanel, jScrollPane2);
        this.getContentPane().add((Component)this.jsp, "Center");
        this.pack();
        this.setVisible(true);
    }

    protected ImageIcon createImageIcon(String string, String string2) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL, string2);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private void initMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open File...");
        jMenuItem.addActionListener(new OpenAction());
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Help");
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem2 = new JMenuItem("Show splash screen");
        jMenuItem2.addActionListener(new ShowSplash());
        jMenu2.add(jMenuItem2);
        this.setJMenuBar(jMenuBar);
    }

    class OpenAction
    implements ActionListener {
        OpenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BAMwindow.this.pwd == null ? new JFileChooser() : new JFileChooser(BAMwindow.this.pwd);
            if (jFileChooser.showOpenDialog(BAMwindow.this) == 0) {
                try {
                    final String string = jFileChooser.getSelectedFile().getCanonicalPath();
                    if (BAMwindow.this.pm == null || BAMwindow.this.pm.filename.equals("") || BAMwindow.this.pm.getHeader() == null) {
                        BAMwindow.this.openData(string);
                        BAMwindow.this.pwd = string;
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BAMwindow bAMwindow = new BAMwindow();
                                bAMwindow.openData(string);
                                bAMwindow.pwd = string;
                            }
                        });
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    class OpenBAM
    implements ActionListener {
        String pathname = "";

        OpenBAM(String string) {
            try {
                this.pathname = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BAMwindow.this.pm == null || BAMwindow.this.pm.filename.equals("") || BAMwindow.this.pm.getHeader() == null) {
                BAMwindow.this.openData(this.pathname);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BAMwindow bAMwindow = new BAMwindow();
                        bAMwindow.openData(OpenBAM.this.pathname);
                    }
                });
            }
        }
    }

    class ShowSplash
    implements ActionListener {
        ShowSplash() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = new JFrame("About BAMseek");
            JPanel jPanel = new JPanel();
            ImageIcon imageIcon = BAMwindow.this.createImageIcon("images/logo.png", "logo");
            JLabel jLabel = new JLabel(imageIcon);
            jPanel.add(jLabel);
            jFrame.getContentPane().add(jPanel);
            jFrame.pack();
            jFrame.setVisible(true);
        }
    }

    class PageControl
    extends JPanel
    implements ChangeListener {
        JSpinner spin = null;
        JSlider slide = null;
        Label numpages = null;
        SpinnerNumberModel spinmodel = null;
        BoundedRangeModel slidemodel = null;
        int page_no = 0;

        PageControl() {
            this.add(new Label("Page Number "));
            this.spinmodel = new SpinnerNumberModel(1, 1, Math.max(1, BAMwindow.this.pm.numPages()), 1);
            this.spin = new JSpinner(this.spinmodel);
            this.spinmodel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PageControl.this.page_no = PageControl.this.spinmodel.getNumber().intValue();
                    PageControl.this.slide.setValue(PageControl.this.page_no);
                }
            });
            this.add(this.spin);
            this.numpages = new Label(" / " + BAMwindow.this.pm.numPages());
            this.add(this.numpages);
            this.slide = new JSlider(0, 1, Math.max(1, BAMwindow.this.pm.numPages()), 1);
            this.slidemodel = this.slide.getModel();
            this.slidemodel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PageControl.this.page_no = PageControl.this.slidemodel.getValue();
                    PageControl.this.spin.setValue(new Integer(PageControl.this.page_no));
                }
            });
            this.add(this.slide);
            this.slide.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting()) {
                BAMwindow.this.pm.jumpToPage(this.page_no);
            }
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        String file = null;

        Task(String string) {
            this.file = string;
        }

        @Override
        public Void doInBackground() {
            boolean bl = false;
            this.setProgress(0);
            BAMwindow.this.pm = new PagingModel(this.file);
            while (!this.isCancelled() && BAMwindow.this.pm.update()) {
                this.setProgress(BAMwindow.this.pm.progress());
            }
            return null;
        }

        @Override
        public void done() {
            BAMwindow.this.pm.finish();
            BAMwindow.this.pages = new PageControl();
            BAMwindow.this.getContentPane().removeAll();
            BAMwindow.this.getContentPane().add((Component)BAMwindow.this.jsp, "Center");
            BAMwindow.this.getContentPane().add((Component)BAMwindow.this.pages, "South");
            String string = BAMwindow.this.pm.getHeader();
            if (string != null) {
                BAMwindow.this.header.setText(string);
            }
            BAMwindow.this.header.setCaretPosition(0);
            BAMwindow.this.table.setModel(BAMwindow.this.pm);
            BAMwindow.this.setTitle(this.file);
            for (int i = 0; i < BAMwindow.this.pm.col_sizes.length; ++i) {
                if (BAMwindow.this.pm.col_sizes[i] <= 0) continue;
                TableColumn tableColumn = BAMwindow.this.table.getColumnModel().getColumn(i);
                tableColumn.setPreferredWidth(BAMwindow.this.pm.col_sizes[i] * 8 + 10);
            }
            BAMwindow.this.setVisible(true);
            BAMwindow.this.progressMonitor.setProgress(100);
            if (string == null) {
                JOptionPane.showMessageDialog(BAMwindow.this, "Error: Unable to recognize file as BAM/SAM/FASTQ/VCF/SFF.");
            }
        }
    }
}

