/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class PageReader {
    public boolean invalid = true;
    private int line_count = 0;
    private BaseParse parser = null;
    private PageIndexer index = null;

    public PageReader(String string) {
        this.index = new PageIndexer(string);
        this.parser = ParseFactory.NewParse(string);
    }

    public boolean update() {
        return this.index.update();
    }

    public int progress() {
        return this.index.progress();
    }

    public void finish() {
        this.index.finish();
        this.invalid = this.index.invalid;
    }

    public String getColumnName(int n) {
        if (this.invalid) {
            return "";
        }
        return this.parser.getColumnName(n);
    }

    public int getNumColumnLabels() {
        if (this.invalid) {
            return 0;
        }
        return this.parser.getNumColumnLabels();
    }

    public String getToolTip(String string, int n, int n2, String[] stringArray) {
        if (this.invalid) {
            return "";
        }
        return this.parser.getToolTip(string, n, n2, stringArray);
    }

    public int getNumPages() {
        if (this.index.invalid) {
            return 0;
        }
        return this.index.numPages();
    }

    public void jumpToPage(int n) throws IOException {
        this.line_count = 0;
        if (this.parser == null) {
            throw new IOException("Page out of bounds");
        }
        this.parser.seek(this.index.pageToOffset(n));
    }

    public String getHeader() {
        if (this.parser == null) {
            return "";
        }
        return this.parser.getHeader();
    }

    public String getFilename() {
        if (this.parser == null) {
            return "";
        }
        return this.parser.getFilename();
    }

    public String[] getNextRecord() {
        if (this.parser != null && this.line_count < 1000) {
            ++this.line_count;
            return this.parser.getNextRecord();
        }
        return null;
    }

    private class PageIndexer {
        public static final int PAGE_SIZE = 1000;
        BaseParse parser = null;
        File indexfile = null;
        DataOutputStream dos = null;
        boolean writableIndex = true;
        boolean already_recorded = false;
        String magic = "";
        public boolean invalid = true;
        private boolean done = false;
        public ArrayList<Long> pages = new ArrayList();

        public PageIndexer(String string) {
            this.indexfile = new File(string + ".lfidx");
            boolean bl = this.readCurrentIndex(string);
            this.parser = ParseFactory.NewParse(string);
            this.done = false;
            this.invalid = this.parser == null;
            try {
                if (!this.invalid) {
                    if (bl) {
                        if (this.indexfile.canWrite()) {
                            this.dos = new DataOutputStream(new FileOutputStream(this.indexfile, true));
                        } else {
                            this.writableIndex = false;
                        }
                    } else {
                        int n = 0;
                        if (this.indexfile.exists() && !this.magic.startsWith("LFIDX")) {
                            n = JOptionPane.showConfirmDialog(null, "You are about to overwrite a LFIDX file that does not appear to be a Large File Index.\nWould you like to overwrite the file?", "Create New Index File", 0, 2);
                        }
                        if (n == 0) {
                            this.dos = new DataOutputStream(new FileOutputStream(this.indexfile, false));
                            this.dos.writeBytes("LFIDX001");
                        } else {
                            this.writableIndex = false;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                this.writableIndex = false;
            }
            try {
                if (this.pages.size() > 0) {
                    this.parser.seek(this.pages.get(this.pages.size() - 1));
                    this.already_recorded = true;
                }
            }
            catch (IOException iOException) {
                this.pages.clear();
                this.already_recorded = false;
            }
        }

        private boolean readCurrentIndex(String string) {
            boolean bl = false;
            this.pages.clear();
            if (!this.indexfile.exists()) {
                return bl;
            }
            boolean bl2 = false;
            if (this.indexfile.lastModified() <= new File(string).lastModified()) {
                bl2 = true;
            }
            try {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.indexfile));
                byte[] byArray = new byte[8];
                dataInputStream.readFully(byArray);
                this.magic = new String(byArray);
                if (!bl2 && this.magic.equals("LFIDX001")) {
                    long l;
                    bl = true;
                    long l2 = 0L;
                    while ((l = dataInputStream.readLong()) >= l2) {
                        l2 = l;
                        this.pages.add(l2);
                    }
                    bl = false;
                }
                dataInputStream.close();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                bl = false;
            }
            if (!bl) {
                this.pages.clear();
            }
            return bl;
        }

        public boolean update() {
            if (this.invalid) {
                return false;
            }
            if (this.done) {
                return false;
            }
            long l = 0L;
            for (int i = 0; i < 1000; ++i) {
                l = this.parser.getNextRecordIndex();
                if (l >= 0L) {
                    if (i != 0) continue;
                    if (!this.already_recorded) {
                        this.pages.add(l);
                        try {
                            if (this.dos != null && this.writableIndex) {
                                this.dos.writeLong(l);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.already_recorded = false;
                    continue;
                }
                this.done = true;
                return false;
            }
            return true;
        }

        public int progress() {
            return (int)(100.0 * this.parser.getProgress());
        }

        public void finish() {
            try {
                if (this.dos != null) {
                    this.dos.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.done = true;
            this.parser = null;
        }

        public long pageToOffset(int n) {
            if (this.numPages() < 1) {
                return -1L;
            }
            if (n > this.numPages()) {
                n = this.numPages();
            }
            return this.pages.get(n - 1);
        }

        public int numPages() {
            return this.pages.size();
        }
    }
}

