/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef js_PrefsGenerated_h
#define js_PrefsGenerated_h

/* This file is generated by js/src/GeneratePrefs.py. Do not edit! */

#include "mozilla/Atomics.h"

#include <stdint.h>

#define JS_PREF_CLASS_FIELDS \
  static bool array_grouping_;\
  static bool arraybuffer_transfer_;\
  static bool destructuring_fuse_;\
  static bool experimental_arraybuffer_resizable_;\
  static bool experimental_new_set_methods_;\
  static mozilla::Atomic<bool, mozilla::Relaxed> experimental_shadow_realms_;\
  static bool experimental_sharedarraybuffer_growable_;\
  static bool experimental_weakrefs_expose_cleanupSome_;\
  static bool property_error_message_fix_;\
  static bool site_based_pretenuring_;\
  static mozilla::Atomic<uint32_t, mozilla::Relaxed> tests_uint32_pref_;\
  static bool use_emulates_undefined_fuse_;\
  static mozilla::Atomic<bool, mozilla::Relaxed> use_fdlibm_for_sin_cos_tan_;\
  static bool wasm_branch_hinting_;\
  static bool wasm_exnref_;\
  static bool wasm_gc_;\
  static bool wasm_js_promise_integration_;\
  static bool wasm_js_string_builtins_;\
  static bool wasm_memory64_;\
  static bool wasm_memory_control_;\
  static bool wasm_moz_intgemm_;\
  static bool wasm_multi_memory_;\
  static bool wasm_relaxed_simd_;\
  static bool wasm_tail_calls_;\
  static bool wasm_test_serialization_;\
  static bool weakrefs_;\
  static bool well_formed_unicode_strings_;\


#define JS_PREF_CLASS_FIELDS_INIT \
  bool JS::Prefs::array_grouping_{true};\
  bool JS::Prefs::arraybuffer_transfer_{true};\
  bool JS::Prefs::destructuring_fuse_{true};\
  bool JS::Prefs::experimental_arraybuffer_resizable_{true};\
  bool JS::Prefs::experimental_new_set_methods_{true};\
  mozilla::Atomic<bool, mozilla::Relaxed> JS::Prefs::experimental_shadow_realms_{false};\
  bool JS::Prefs::experimental_sharedarraybuffer_growable_{true};\
  bool JS::Prefs::experimental_weakrefs_expose_cleanupSome_{false};\
  bool JS::Prefs::property_error_message_fix_{false};\
  bool JS::Prefs::site_based_pretenuring_{true};\
  mozilla::Atomic<uint32_t, mozilla::Relaxed> JS::Prefs::tests_uint32_pref_{1};\
  bool JS::Prefs::use_emulates_undefined_fuse_{true};\
  mozilla::Atomic<bool, mozilla::Relaxed> JS::Prefs::use_fdlibm_for_sin_cos_tan_{false};\
  bool JS::Prefs::wasm_branch_hinting_{false};\
  bool JS::Prefs::wasm_exnref_{false};\
  bool JS::Prefs::wasm_gc_{true};\
  bool JS::Prefs::wasm_js_promise_integration_{false};\
  bool JS::Prefs::wasm_js_string_builtins_{false};\
  bool JS::Prefs::wasm_memory64_{false};\
  bool JS::Prefs::wasm_memory_control_{false};\
  bool JS::Prefs::wasm_moz_intgemm_{false};\
  bool JS::Prefs::wasm_multi_memory_{true};\
  bool JS::Prefs::wasm_relaxed_simd_{false};\
  bool JS::Prefs::wasm_tail_calls_{true};\
  bool JS::Prefs::wasm_test_serialization_{false};\
  bool JS::Prefs::weakrefs_{true};\
  bool JS::Prefs::well_formed_unicode_strings_{true};\


#define FOR_EACH_JS_PREF(MACRO) \
  MACRO("array_grouping", array_grouping, bool, setAtStartup_array_grouping, true)\
  MACRO("arraybuffer_transfer", arraybuffer_transfer, bool, setAtStartup_arraybuffer_transfer, true)\
  MACRO("destructuring_fuse", destructuring_fuse, bool, setAtStartup_destructuring_fuse, true)\
  MACRO("experimental.arraybuffer_resizable", experimental_arraybuffer_resizable, bool, setAtStartup_experimental_arraybuffer_resizable, true)\
  MACRO("experimental.new_set_methods", experimental_new_set_methods, bool, setAtStartup_experimental_new_set_methods, true)\
  MACRO("experimental.shadow_realms", experimental_shadow_realms, bool, set_experimental_shadow_realms, false)\
  MACRO("experimental.sharedarraybuffer_growable", experimental_sharedarraybuffer_growable, bool, setAtStartup_experimental_sharedarraybuffer_growable, true)\
  MACRO("experimental.weakrefs.expose_cleanupSome", experimental_weakrefs_expose_cleanupSome, bool, setAtStartup_experimental_weakrefs_expose_cleanupSome, true)\
  MACRO("property_error_message_fix", property_error_message_fix, bool, setAtStartup_property_error_message_fix, true)\
  MACRO("site_based_pretenuring", site_based_pretenuring, bool, setAtStartup_site_based_pretenuring, true)\
  MACRO("tests.uint32-pref", tests_uint32_pref, uint32_t, set_tests_uint32_pref, false)\
  MACRO("use_emulates_undefined_fuse", use_emulates_undefined_fuse, bool, setAtStartup_use_emulates_undefined_fuse, true)\
  MACRO("use_fdlibm_for_sin_cos_tan", use_fdlibm_for_sin_cos_tan, bool, set_use_fdlibm_for_sin_cos_tan, false)\
  MACRO("wasm_branch_hinting", wasm_branch_hinting, bool, setAtStartup_wasm_branch_hinting, true)\
  MACRO("wasm_exnref", wasm_exnref, bool, setAtStartup_wasm_exnref, true)\
  MACRO("wasm_gc", wasm_gc, bool, setAtStartup_wasm_gc, true)\
  MACRO("wasm_js_promise_integration", wasm_js_promise_integration, bool, setAtStartup_wasm_js_promise_integration, true)\
  MACRO("wasm_js_string_builtins", wasm_js_string_builtins, bool, setAtStartup_wasm_js_string_builtins, true)\
  MACRO("wasm_memory64", wasm_memory64, bool, setAtStartup_wasm_memory64, true)\
  MACRO("wasm_memory_control", wasm_memory_control, bool, setAtStartup_wasm_memory_control, true)\
  MACRO("wasm_moz_intgemm", wasm_moz_intgemm, bool, setAtStartup_wasm_moz_intgemm, true)\
  MACRO("wasm_multi_memory", wasm_multi_memory, bool, setAtStartup_wasm_multi_memory, true)\
  MACRO("wasm_relaxed_simd", wasm_relaxed_simd, bool, setAtStartup_wasm_relaxed_simd, true)\
  MACRO("wasm_tail_calls", wasm_tail_calls, bool, setAtStartup_wasm_tail_calls, true)\
  MACRO("wasm_test_serialization", wasm_test_serialization, bool, setAtStartup_wasm_test_serialization, true)\
  MACRO("weakrefs", weakrefs, bool, setAtStartup_weakrefs, true)\
  MACRO("well_formed_unicode_strings", well_formed_unicode_strings, bool, setAtStartup_well_formed_unicode_strings, true)\


#define SET_JS_PREFS_FROM_BROWSER_PREFS \
  JS::Prefs::setAtStartup_array_grouping(mozilla::StaticPrefs::javascript_options_array_grouping());\
  JS::Prefs::setAtStartup_arraybuffer_transfer(mozilla::StaticPrefs::javascript_options_arraybuffer_transfer());\
  JS::Prefs::setAtStartup_destructuring_fuse(mozilla::StaticPrefs::javascript_options_destructuring_fuse());\
  JS::Prefs::setAtStartup_experimental_arraybuffer_resizable(mozilla::StaticPrefs::javascript_options_experimental_arraybuffer_resizable());\
  JS::Prefs::setAtStartup_experimental_new_set_methods(mozilla::StaticPrefs::javascript_options_experimental_new_set_methods());\
  JS::Prefs::set_experimental_shadow_realms(mozilla::StaticPrefs::javascript_options_experimental_shadow_realms());\
  JS::Prefs::setAtStartup_experimental_sharedarraybuffer_growable(mozilla::StaticPrefs::javascript_options_experimental_sharedarraybuffer_growable());\
  JS::Prefs::setAtStartup_experimental_weakrefs_expose_cleanupSome(mozilla::StaticPrefs::javascript_options_experimental_weakrefs_expose_cleanupSome());\
  JS::Prefs::setAtStartup_property_error_message_fix(mozilla::StaticPrefs::javascript_options_property_error_message_fix());\
  JS::Prefs::setAtStartup_site_based_pretenuring(mozilla::StaticPrefs::javascript_options_site_based_pretenuring_DoNotUseDirectly());\
  JS::Prefs::set_tests_uint32_pref(mozilla::StaticPrefs::javascript_options_tests_uint32_pref());\
  JS::Prefs::setAtStartup_use_emulates_undefined_fuse(mozilla::StaticPrefs::javascript_options_use_emulates_undefined_fuse_DoNotUseDirectly());\
  JS::Prefs::set_use_fdlibm_for_sin_cos_tan(mozilla::StaticPrefs::javascript_options_use_fdlibm_for_sin_cos_tan());\
  JS::Prefs::setAtStartup_wasm_branch_hinting(mozilla::StaticPrefs::javascript_options_wasm_branch_hinting());\
  JS::Prefs::setAtStartup_wasm_exnref(mozilla::StaticPrefs::javascript_options_wasm_exnref());\
  JS::Prefs::setAtStartup_wasm_gc(mozilla::StaticPrefs::javascript_options_wasm_gc());\
  JS::Prefs::setAtStartup_wasm_js_promise_integration(mozilla::StaticPrefs::javascript_options_wasm_js_promise_integration());\
  JS::Prefs::setAtStartup_wasm_js_string_builtins(mozilla::StaticPrefs::javascript_options_wasm_js_string_builtins());\
  JS::Prefs::setAtStartup_wasm_memory64(mozilla::StaticPrefs::javascript_options_wasm_memory64());\
  JS::Prefs::setAtStartup_wasm_memory_control(mozilla::StaticPrefs::javascript_options_wasm_memory_control());\
  JS::Prefs::setAtStartup_wasm_moz_intgemm(mozilla::StaticPrefs::javascript_options_wasm_moz_intgemm());\
  JS::Prefs::setAtStartup_wasm_multi_memory(mozilla::StaticPrefs::javascript_options_wasm_multi_memory());\
  JS::Prefs::setAtStartup_wasm_relaxed_simd(mozilla::StaticPrefs::javascript_options_wasm_relaxed_simd());\
  JS::Prefs::setAtStartup_wasm_tail_calls(mozilla::StaticPrefs::javascript_options_wasm_tail_calls());\
  JS::Prefs::setAtStartup_wasm_test_serialization(mozilla::StaticPrefs::javascript_options_wasm_test_serialization());\
  JS::Prefs::setAtStartup_weakrefs(mozilla::StaticPrefs::javascript_options_weakrefs());\
  JS::Prefs::setAtStartup_well_formed_unicode_strings(mozilla::StaticPrefs::javascript_options_well_formed_unicode_strings());\


#define SET_NON_STARTUP_JS_PREFS_FROM_BROWSER_PREFS \
  JS::Prefs::set_experimental_shadow_realms(mozilla::StaticPrefs::javascript_options_experimental_shadow_realms());\
  JS::Prefs::set_tests_uint32_pref(mozilla::StaticPrefs::javascript_options_tests_uint32_pref());\
  JS::Prefs::set_use_fdlibm_for_sin_cos_tan(mozilla::StaticPrefs::javascript_options_use_fdlibm_for_sin_cos_tan());\




#endif // js_PrefsGenerated_h
