/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import java.util.List;
import org.jupnp.UpnpService;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.IncomingSubscribeResponseMessage;
import org.jupnp.model.message.gena.OutgoingSubscribeRequestMessage;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.protocol.SendingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingSubscribe
extends SendingSync<OutgoingSubscribeRequestMessage, IncomingSubscribeResponseMessage> {
    private final Logger logger = LoggerFactory.getLogger(SendingSubscribe.class);
    protected final RemoteGENASubscription subscription;

    public SendingSubscribe(UpnpService upnpService, RemoteGENASubscription subscription, List<NetworkAddress> activeStreamServers) {
        super(upnpService, new OutgoingSubscribeRequestMessage(subscription, subscription.getEventCallbackURLs(activeStreamServers, upnpService.getConfiguration().getNamespace()), upnpService.getConfiguration().getEventSubscriptionHeaders((RemoteService)subscription.getService())));
        this.subscription = subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IncomingSubscribeResponseMessage executeSync() throws RouterException {
        if (!((OutgoingSubscribeRequestMessage)this.getInputMessage()).hasCallbackURLs()) {
            this.logger.trace("Subscription failed, no active local callback URLs available (network disabled?)");
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.fail(null));
            return null;
        }
        this.logger.trace("Sending subscription request: {}", this.getInputMessage());
        try {
            StreamResponseMessage response;
            this.getUpnpService().getRegistry().registerPendingRemoteSubscription(this.subscription);
            try {
                response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
            }
            catch (RouterException e) {
                this.onSubscriptionFailure();
                IncomingSubscribeResponseMessage incomingSubscribeResponseMessage = null;
                this.getUpnpService().getRegistry().unregisterPendingRemoteSubscription(this.subscription);
                return incomingSubscribeResponseMessage;
            }
            if (response == null) {
                this.onSubscriptionFailure();
                IncomingSubscribeResponseMessage e = null;
                return e;
            }
            IncomingSubscribeResponseMessage responseMessage = new IncomingSubscribeResponseMessage(response);
            if (((UpnpResponse)response.getOperation()).isFailed()) {
                this.logger.trace("Subscription failed, response was: {}", (Object)responseMessage);
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.fail((UpnpResponse)responseMessage.getOperation()));
            } else if (!responseMessage.isValidHeaders()) {
                this.logger.error("Subscription failed, invalid or missing (SID, Timeout) response headers");
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.fail((UpnpResponse)responseMessage.getOperation()));
            } else {
                this.logger.trace("Subscription established, adding to registry, response was: {}", (Object)response);
                this.subscription.setSubscriptionId(responseMessage.getSubscriptionId());
                this.subscription.setActualSubscriptionDurationSeconds(responseMessage.getSubscriptionDurationSeconds());
                this.getUpnpService().getRegistry().addRemoteSubscription(this.subscription);
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(this.subscription::establish);
            }
            IncomingSubscribeResponseMessage incomingSubscribeResponseMessage = responseMessage;
            return incomingSubscribeResponseMessage;
        }
        finally {
            this.getUpnpService().getRegistry().unregisterPendingRemoteSubscription(this.subscription);
        }
    }

    protected void onSubscriptionFailure() {
        this.logger.trace("Subscription failed");
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.fail(null));
    }
}

